/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.world.gen;

import com.github.alexthe666.iceandfire.block.IafBlockRegistry;
import com.github.alexthe666.iceandfire.entity.EntityIceDragon;
import com.github.alexthe666.iceandfire.event.WorldGenEvents;
import com.github.alexthe666.iceandfire.world.gen.WorldGenIceDragonCave;
import com.github.alexthe666.iceandfire.world.gen.WorldGenRoostArch;
import com.github.alexthe666.iceandfire.world.gen.WorldGenRoostBoulder;
import com.github.alexthe666.iceandfire.world.gen.WorldGenRoostGoldPile;
import com.github.alexthe666.iceandfire.world.gen.WorldGenRoostPile;
import java.util.Random;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenIceDragonRoosts
extends WorldGenerator {
    private static boolean isMale;

    public boolean func_180709_b(World worldIn, Random rand, BlockPos position) {
        int radius;
        isMale = rand.nextBoolean();
        boolean boulders = false;
        int j = radius = 12 + rand.nextInt(8);
        int k = 2;
        int l = radius;
        float f = (float)(j + k + l) * 0.333f + 0.5f;
        for (Object blockpos : BlockPos.func_177980_a((BlockPos)position.func_177982_a(-j, k, -l), (BlockPos)position.func_177982_a(j, 0, l))) {
            int yAdd = blockpos.func_177956_o() - position.func_177956_o();
            if (!(blockpos.func_177951_i((Vec3i)position) <= (double)(f * f)) || yAdd >= 2 + rand.nextInt(k) || worldIn.func_175623_d(blockpos.func_177977_b())) continue;
            worldIn.func_175656_a((BlockPos)blockpos, IafBlockRegistry.frozenGrass.func_176223_P());
        }
        for (Object blockpos : BlockPos.func_177980_a((BlockPos)position.func_177982_a(-j, k, -l), (BlockPos)position.func_177982_a(j, 0, l))) {
            if (worldIn.func_180495_p((BlockPos)blockpos).func_177230_c() != IafBlockRegistry.frozenGrass || worldIn.func_175623_d(blockpos.func_177984_a())) continue;
            worldIn.func_175656_a((BlockPos)blockpos, IafBlockRegistry.frozenDirt.func_176223_P());
        }
        j = radius;
        k = radius / 5;
        l = radius;
        f = (float)(j + k + l) * 0.333f + 0.5f;
        for (Object blockpos : BlockPos.func_177980_a((BlockPos)position.func_177982_a(-j, -k, -l), (BlockPos)position.func_177982_a(j, 0, l))) {
            if (blockpos.func_177951_i((Vec3i)position) < (double)(f * f)) {
                worldIn.func_175656_a((BlockPos)blockpos, rand.nextBoolean() ? IafBlockRegistry.frozenGravel.func_176223_P() : IafBlockRegistry.frozenDirt.func_176223_P());
            }
            if (blockpos.func_177951_i((Vec3i)position) != (double)(f * f)) continue;
            worldIn.func_175656_a((BlockPos)blockpos, rand.nextBoolean() ? IafBlockRegistry.frozenCobblestone.func_176223_P() : IafBlockRegistry.frozenCobblestone.func_176223_P());
        }
        j = radius -= 2;
        k = 2;
        l = radius;
        f = (float)(j + k + l) * 0.333f + 0.5f;
        BlockPos up = position.func_177981_b(k - 1);
        for (BlockPos blockpos : BlockPos.func_177980_a((BlockPos)up.func_177982_a(-j, -k + 2, -l), (BlockPos)up.func_177982_a(j, k, l))) {
            if (!(blockpos.func_177951_i((Vec3i)position) <= (double)(f * f))) continue;
            worldIn.func_175656_a(blockpos, Blocks.field_150350_a.func_176223_P());
        }
        j = radius += 15;
        k = radius / 5;
        l = radius;
        f = (float)(j + k + l) * 0.333f + 0.5f;
        for (Object blockpos : BlockPos.func_177980_a((BlockPos)position.func_177982_a(-j, -k, -l), (BlockPos)position.func_177982_a(j, k, l))) {
            BlockPos height;
            if (!(blockpos.func_177951_i((Vec3i)position) <= (double)(f * f))) continue;
            double dist = blockpos.func_177951_i((Vec3i)position) / (double)(f * f);
            if (!worldIn.func_175623_d(position) && rand.nextDouble() > dist * 0.5) {
                this.transformState(worldIn, (BlockPos)blockpos, worldIn.func_180495_p((BlockPos)blockpos));
            }
            if (dist > 0.5 && rand.nextInt(1000) == 0) {
                height = worldIn.func_175645_m((BlockPos)blockpos);
                new WorldGenRoostBoulder(IafBlockRegistry.frozenCobblestone, rand.nextInt(3), true).func_180709_b(worldIn, rand, height);
            }
            if (rand.nextInt(1000) == 0) {
                height = worldIn.func_175645_m((BlockPos)blockpos);
                new WorldGenRoostPile(IafBlockRegistry.dragon_ice).generate(worldIn, rand, height);
            }
            if (dist < 0.3 && rand.nextInt(isMale ? 250 : 400) == 0) {
                height = WorldGenEvents.degradeSurface(worldIn, worldIn.func_175645_m((BlockPos)blockpos));
                new WorldGenRoostGoldPile(IafBlockRegistry.silverPile).generate(worldIn, rand, height);
            }
            if (dist < 0.3 && rand.nextInt(isMale ? 500 : 700) == 0) {
                TileEntity tileentity1;
                height = WorldGenEvents.degradeSurface(worldIn, worldIn.func_175645_m((BlockPos)blockpos));
                worldIn.func_180501_a(height, Blocks.field_150486_ae.func_176223_P().func_177226_a((IProperty)BlockChest.field_176459_a, (Comparable)EnumFacing.field_176754_o[new Random().nextInt(3)]), 2);
                if (worldIn.func_180495_p(height).func_177230_c() instanceof BlockChest && (tileentity1 = worldIn.func_175625_s(height)) instanceof TileEntityChest && !tileentity1.func_145837_r()) {
                    ((TileEntityChest)tileentity1).func_189404_a(WorldGenIceDragonCave.ICEDRAGON_CHEST, new Random().nextLong());
                }
            }
            if (rand.nextInt(5000) != 0) continue;
            height = worldIn.func_175645_m((BlockPos)blockpos);
            new WorldGenRoostArch(IafBlockRegistry.frozenCobblestone).generate(worldIn, rand, height);
        }
        EntityIceDragon dragon = new EntityIceDragon(worldIn);
        dragon.setGender(isMale);
        dragon.growDragon(40 + radius);
        dragon.setAgingDisabled(true);
        dragon.func_70606_j(dragon.func_110138_aP());
        dragon.setVariant(new Random().nextInt(4));
        dragon.func_70080_a((double)position.func_177958_n() + 0.5, (double)worldIn.func_175645_m(position).func_177956_o() + 1.5, (double)position.func_177952_p() + 0.5, rand.nextFloat() * 360.0f, 0.0f);
        dragon.homePos = position;
        dragon.hasHomePosition = true;
        dragon.setHunger(50);
        worldIn.func_72838_d((Entity)dragon);
        return false;
    }

    private void transformState(World world, BlockPos blockpos, IBlockState state) {
        float hardness = state.func_177230_c().func_176195_g(state, world, blockpos);
        if (hardness != -1.0f) {
            if (state.func_177230_c() instanceof BlockContainer) {
                return;
            }
            if (state.func_185904_a() == Material.field_151577_b) {
                world.func_175656_a(blockpos, IafBlockRegistry.frozenGrass.func_176223_P());
            } else if (state.func_185904_a() == Material.field_151578_c && state.func_177230_c() == Blocks.field_150346_d) {
                world.func_175656_a(blockpos, IafBlockRegistry.frozenDirt.func_176223_P());
            } else if (state.func_185904_a() == Material.field_151578_c && state.func_177230_c() == Blocks.field_150351_n) {
                world.func_175656_a(blockpos, IafBlockRegistry.frozenGravel.func_176223_P());
            } else if (state.func_185904_a() == Material.field_151576_e && (state.func_177230_c() == Blocks.field_150347_e || state.func_177230_c().func_149739_a().contains("cobblestone"))) {
                world.func_175656_a(blockpos, IafBlockRegistry.frozenCobblestone.func_176223_P());
            } else if (state.func_185904_a() == Material.field_151576_e && state.func_177230_c() != IafBlockRegistry.frozenCobblestone) {
                world.func_175656_a(blockpos, IafBlockRegistry.frozenStone.func_176223_P());
            } else if (state.func_177230_c() == Blocks.field_185774_da) {
                world.func_175656_a(blockpos, IafBlockRegistry.frozenGrassPath.func_176223_P());
            } else if (state.func_185904_a() == Material.field_151575_d) {
                world.func_175656_a(blockpos, IafBlockRegistry.frozenSplinters.func_176223_P());
            } else if (state.func_185904_a() == Material.field_151584_j || state.func_185904_a() == Material.field_151585_k) {
                world.func_175656_a(blockpos, Blocks.field_150350_a.func_176223_P());
            }
        }
    }
}

