/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.atlas.api.block;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.smileycorp.atlas.api.block.BlockBase;
import net.smileycorp.atlas.api.block.PropertyString;

public class BlockMetaBase
extends BlockBase {
    protected static PropertyString staticProp;
    protected PropertyString prop;

    protected BlockMetaBase(String name, String modid, Material material, SoundType sound, float h, float r, String tool, int level, CreativeTabs tab, List<String> variants) {
        super(name, modid, material, sound, h, r, tool, level, tab);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)this.prop, (Comparable)((Object)variants.get(0))));
    }

    public static BlockMetaBase create(String name, String modid, Material material, SoundType sound, float h, float r, String tool, int level, CreativeTabs tab, List<String> variants) {
        staticProp = new PropertyString("property", variants);
        return new BlockMetaBase(name, modid, material, sound, h, r, tool, level, tab, variants);
    }

    public static BlockMetaBase create(String name, String modid, Material material, SoundType sound, float h, float r, int level, CreativeTabs tab, List<String> variants) {
        return BlockMetaBase.create(name, modid, material, sound, h, r, "pickaxe", level, tab, variants);
    }

    public PropertyString getProperty() {
        return this.prop;
    }

    protected BlockStateContainer func_180661_e() {
        this.prop = staticProp;
        return new BlockStateContainer((Block)this, new IProperty[]{this.prop});
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176203_a(placer.func_184586_b(hand).func_77960_j());
    }

    public IBlockState func_176203_a(int meta) {
        List<String> variants = this.prop.getAllowedValues();
        if (meta > variants.size() - 1) {
            meta = 0;
        }
        return this.func_176223_P().func_177226_a((IProperty)this.prop, (Comparable)((Object)variants.get(meta)));
    }

    public int func_176201_c(IBlockState state) {
        String variant = (String)state.func_177228_b().get((Object)this.prop);
        List<String> variants = this.prop.getAllowedValues();
        if (variants.contains(variant)) {
            return variants.indexOf(variant);
        }
        return 0;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((Block)this, 1, this.func_176201_c(state));
    }

    @Override
    public int getMaxMeta() {
        return this.prop.getAllowedValues().size();
    }
}

