/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.atlas.api.block;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.IFuelHandler;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.smileycorp.atlas.api.util.RecipeUtils;

public class FuelHandler
implements IFuelHandler {
    private static FuelHandler INSTANCE = null;
    private Map<ItemStack, Integer> FUEL_MAP = new HashMap<ItemStack, Integer>();

    public ItemStack registerFuel(Item fuel, int burnTime) {
        return this.registerFuel(new ItemStack(fuel), burnTime);
    }

    public ItemStack registerFuel(Block fuel, int burnTime) {
        return this.registerFuel(new ItemStack(fuel), burnTime);
    }

    public ItemStack registerFuel(ItemStack fuel, int burnTime) {
        this.FUEL_MAP.put(fuel, burnTime);
        return fuel;
    }

    public int getBurnTime(ItemStack fuel) {
        for (Map.Entry<ItemStack, Integer> entry : this.FUEL_MAP.entrySet()) {
            if (!RecipeUtils.compareItemStacks(fuel, entry.getKey(), false)) continue;
            return entry.getValue();
        }
        return 0;
    }

    public static FuelHandler getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new FuelHandler();
            GameRegistry.registerFuelHandler((IFuelHandler)INSTANCE);
        }
        return INSTANCE;
    }
}

