/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.atlas.api.block;

import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemSlab;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.smileycorp.atlas.api.block.BlockBase;
import net.smileycorp.atlas.api.block.BlockSlabBase;
import net.smileycorp.atlas.api.block.BlockStairsBase;
import net.smileycorp.atlas.api.client.CustomStateMapper;
import net.smileycorp.atlas.api.client.SlabStateMapper;

public class ShapedBlock {
    final String name;
    final String modid;
    final BlockBase base;
    final BlockStairsBase stairs;
    final BlockSlabBase slab;
    final BlockSlabBase doubleSlab;
    Block[] blocks;

    public ShapedBlock(String name, String modid, Material material, SoundType sound, float h, float r, String tool, int level, CreativeTabs tab) {
        this.name = name;
        this.modid = modid;
        this.base = new BlockBase(name, modid, material, sound, h, r, tool, level, tab);
        this.stairs = new BlockStairsBase(this.base);
        this.slab = new BlockSlabBase(this.base, h, r, tool, level, false);
        this.doubleSlab = new BlockSlabBase(this.base, h, r, tool, level, true);
        this.blocks = new Block[]{this.base, this.stairs, this.slab, this.doubleSlab};
    }

    public ShapedBlock(String name, String modid, Material material, SoundType sound, float h, float r, int level, CreativeTabs tab) {
        this(name, modid, material, sound, h, r, "pickaxe", level, tab);
    }

    public Block getBase() {
        return this.base;
    }

    public Block getStairs() {
        return this.stairs;
    }

    public Block getSlab() {
        return this.getSlab(false);
    }

    public Block getSlab(boolean getFull) {
        return getFull ? this.doubleSlab : this.slab;
    }

    public void registerBlocks(IForgeRegistry<Block> registry) {
        this.slab.half = this.slab;
        this.doubleSlab.half = this.slab;
        registry.registerAll((IForgeRegistryEntry[])this.blocks);
    }

    public void registerItems(IForgeRegistry<Item> registry) {
        for (Block block : this.blocks) {
            if (block instanceof BlockSlabBase) continue;
            ItemBlock item = new ItemBlock(block);
            item.setRegistryName(block.getRegistryName());
            item.func_77655_b(block.func_149739_a());
            registry.register((IForgeRegistryEntry)item);
        }
        ItemSlab item = new ItemSlab((Block)this.slab, (BlockSlab)this.slab, (BlockSlab)this.doubleSlab);
        item.setRegistryName(this.slab.getRegistryName());
        item.func_77655_b(this.slab.func_149739_a());
        registry.register((IForgeRegistryEntry)item);
    }

    public void registerModels() {
        for (Block block : this.blocks) {
            if (block == this.doubleSlab) continue;
            ResourceLocation loc = ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)block);
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)block), (int)0, (ModelResourceLocation)new ModelResourceLocation(loc, "normal"));
        }
        ModelLoader.setCustomStateMapper((Block)this.slab, (IStateMapper)new SlabStateMapper(this.slab));
        ModelLoader.setCustomStateMapper((Block)this.doubleSlab, (IStateMapper)new CustomStateMapper(this.modid, this.name, "normal"));
    }

    public void registerRecipes() {
        GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation(this.modid, this.name + "_stairs"), (ResourceLocation)new ResourceLocation(this.modid, this.name), (ItemStack)new ItemStack((Block)this.stairs, 4), (Object[])new Object[]{"  #", " ##", "###", Character.valueOf('#'), new ItemStack((Block)this.base)});
        GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation(this.modid, this.name + "_slab"), (ResourceLocation)new ResourceLocation(this.modid, this.name), (ItemStack)new ItemStack((Block)this.slab, 6), (Object[])new Object[]{"###", Character.valueOf('#'), new ItemStack((Block)this.base)});
    }
}

