/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.atlas.api.block.wood;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLog;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.smileycorp.atlas.api.block.IBlockProperties;
import net.smileycorp.atlas.api.block.PropertyString;

public class BlockBaseLog
extends BlockLog
implements IBlockProperties {
    protected static PropertyString staticProp;
    protected PropertyString prop;
    public boolean isFlamable;

    protected BlockBaseLog(String name, String modid, CreativeTabs tab, List<String> variants, boolean isFlamable) {
        name = name.isEmpty() ? "Log" : "Log_" + name;
        this.func_149647_a(tab);
        this.setRegistryName(new ResourceLocation(modid, name.toLowerCase()));
        this.func_149663_c(modid + "." + name.replace("_", ""));
        this.isFlamable = isFlamable;
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_176299_a, (Comparable)BlockLog.EnumAxis.Y).func_177226_a((IProperty)this.prop, (Comparable)((Object)variants.get(0))));
    }

    public static BlockBaseLog create(String name, String modid, CreativeTabs tab, List<String> variants, boolean isFlamable) {
        staticProp = new PropertyString("property", variants);
        return new BlockBaseLog(name, modid, tab, variants, isFlamable);
    }

    public PropertyString getProperty() {
        return this.prop;
    }

    protected BlockStateContainer func_180661_e() {
        this.prop = staticProp;
        return new BlockStateContainer((Block)this, new IProperty[]{this.prop, field_176299_a});
    }

    public IBlockState func_176203_a(int meta) {
        List<String> variants = this.prop.getAllowedValues();
        IBlockState state = this.func_176223_P();
        int varMeta = meta % 4;
        int dirMeta = meta - meta % 4;
        if (varMeta > variants.size() - 1) {
            varMeta = 0;
        }
        switch (dirMeta) {
            case 0: {
                BlockLog.EnumAxis enumAxis = BlockLog.EnumAxis.Y;
            }
            case 4: {
                BlockLog.EnumAxis enumAxis = BlockLog.EnumAxis.X;
            }
            case 8: {
                BlockLog.EnumAxis enumAxis = BlockLog.EnumAxis.Z;
            }
        }
        BlockLog.EnumAxis axis = BlockLog.EnumAxis.NONE;
        return state.func_177226_a((IProperty)this.prop, (Comparable)((Object)variants.get(varMeta))).func_177226_a((IProperty)field_176299_a, (Comparable)axis);
    }

    public int func_176201_c(IBlockState state) {
        String variant = (String)state.func_177228_b().get((Object)this.prop);
        List<String> variants = this.prop.getAllowedValues();
        int varMeta = variants.contains(variant) ? variants.indexOf(variant) : 0;
        switch ((BlockLog.EnumAxis)state.func_177229_b((IProperty)field_176299_a)) {
            case Y: {
                return varMeta;
            }
            case X: {
                return varMeta + 4;
            }
            case Z: {
                return varMeta + 8;
            }
        }
        return varMeta + 12;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((Block)this, 1, this.func_176201_c(state));
    }

    @Override
    public int getMaxMeta() {
        return this.prop.getAllowedValues().size();
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        return this.isFlamable ? 20 : super.getFlammability(world, pos, facing);
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        return this.isFlamable ? 5 : super.getFireSpreadSpeed(world, pos, facing);
    }
}

