/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.atlas.api.block.wood;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.smileycorp.atlas.api.block.BlockMetaBase;
import net.smileycorp.atlas.api.block.BlockStairsBase;
import net.smileycorp.atlas.api.block.wood.BlockBaseLeaves;
import net.smileycorp.atlas.api.block.wood.BlockBaseLog;
import net.smileycorp.atlas.api.item.ItemBlockMeta;

public class WoodBlock {
    final List<String> variants;
    final List<List<String>> subvariants;
    final String name;
    final String modid;
    final BlockMetaBase plank;
    final List<BlockBaseLog> logs = new ArrayList<BlockBaseLog>();
    final Map<String, BlockStairsBase> stairs = new HashMap<String, BlockStairsBase>();
    final List<BlockBaseLeaves> leaves = new ArrayList<BlockBaseLeaves>();
    final List<Block> blocks = new ArrayList<Block>();

    public WoodBlock(String name, String modid, CreativeTabs tab, Map<String, ItemStack> metaDefinitions, boolean isFlamable) {
        this.variants = new ArrayList<String>(metaDefinitions.keySet());
        this.subvariants = Lists.partition(this.variants, (int)4);
        List sapLists = Lists.partition(new ArrayList<ItemStack>(metaDefinitions.values()), (int)4);
        this.name = name;
        this.modid = modid;
        this.plank = BlockMetaBase.create(name.isEmpty() ? "Plank" : "Plank_" + name, modid, Material.field_151575_d, SoundType.field_185848_a, 2.0f, 5.0f, "axe", 0, tab, this.variants);
        this.plank.isFlamable = isFlamable;
        for (List<String> localVariants : this.subvariants) {
            int i = this.subvariants.indexOf(localVariants);
            String suffix = i == 1 ? "" : "_" + i;
            this.logs.add(BlockBaseLog.create(name + suffix, modid, tab, localVariants, isFlamable));
            this.leaves.add(BlockBaseLeaves.create(name + suffix, modid, tab, localVariants, (List)sapLists.get(i), isFlamable));
        }
        for (int i = 0; i < this.variants.size(); ++i) {
            this.stairs.put(this.variants.get(i), new BlockStairsBase(this.variants.get(i) + "_Plank", this.plank.func_176203_a(i)));
        }
        this.blocks.add(this.plank);
        this.blocks.addAll(this.logs);
        this.blocks.addAll(this.stairs.values());
        this.blocks.addAll(this.leaves);
    }

    public Block getPlank() {
        return this.plank;
    }

    public Block getStairs(String variant) {
        return (Block)this.stairs.get(variant);
    }

    public void registerBlocks(IForgeRegistry<Block> registry) {
        registry.registerAll((IForgeRegistryEntry[])this.blocks.toArray(new Block[0]));
    }

    public void registerItems(IForgeRegistry<Item> registry) {
        registry.register(new ItemBlockMeta<String>(this.plank, this.plank.getProperty(), "Plank"));
        for (BlockBaseLog blockBaseLog : this.logs) {
            registry.register(new ItemBlockMeta<String>((Block)blockBaseLog, blockBaseLog.getProperty(), "Log"));
        }
        for (BlockBaseLeaves blockBaseLeaves : this.leaves) {
            registry.register(new ItemBlockMeta<String>((Block)blockBaseLeaves, blockBaseLeaves.getProperty(), "Leaves"));
        }
        for (Block block : this.stairs.values()) {
            ItemBlock item = new ItemBlock(block);
            item.setRegistryName(block.getRegistryName());
            item.func_77655_b(block.func_149739_a());
            registry.register((IForgeRegistryEntry)item);
        }
    }

    public void registerModels() {
        for (Block block : this.blocks) {
            ResourceLocation loc = ForgeRegistries.BLOCKS.getKey((IForgeRegistryEntry)block);
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)block), (int)0, (ModelResourceLocation)new ModelResourceLocation(loc, "normal"));
        }
    }

    public void registerRecipes() {
        for (Block block : this.logs) {
            OreDictionary.registerOre((String)"logWood", (Block)block);
        }
        OreDictionary.registerOre((String)"plankWood", (Block)this.plank);
        for (Block block : this.stairs.values()) {
            OreDictionary.registerOre((String)"stairWood", (Block)block);
        }
        int i = 0;
        while (i < 4) {
            String string = this.variants.get(i);
            GameRegistry.addShapelessRecipe((ResourceLocation)new ResourceLocation(this.modid, string + "_plank"), (ResourceLocation)new ResourceLocation(this.modid, string), (ItemStack)new ItemStack((Block)this.plank, 4, i), (Ingredient[])new Ingredient[]{Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((Block)this.logs.get((int)Math.floor(i / 4)), 1, i % 4)})});
            GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation(this.modid, string + "_stairs"), (ResourceLocation)new ResourceLocation(this.modid, string), (ItemStack)new ItemStack((Block)this.stairs.get(string), 4, i), (Object[])new Object[]{"  #", " ##", "###", Character.valueOf('#'), new ItemStack((Block)this.plank, 1, i)});
        }
    }
}

