/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.atlas.api.client;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockFaceUV;
import net.minecraft.client.renderer.block.model.BlockPartFace;
import net.minecraft.client.renderer.block.model.FaceBakery;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.registry.IRegistry;
import net.minecraft.world.World;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.smileycorp.atlas.api.item.IMetaItem;
import org.lwjgl.util.vector.Vector3f;
import org.lwjgl.util.vector.Vector4f;

@SideOnly(value=Side.CLIENT)
public class RenderingUtils {
    public static final Function<ResourceLocation, TextureAtlasSprite> defaultTextureGetter = resource -> Minecraft.func_71410_x().func_147117_R().func_110572_b(resource.toString());

    public static void setMetaModel(String modid, Item item, int meta) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(modid + ":items/" + item.getRegistryName().toString().substring(modid.length() + 1), ((IMetaItem)item).byMeta(meta)));
    }

    public static void replaceRegisteredModel(ModelResourceLocation location, IRegistry<ModelResourceLocation, IBakedModel> registry, Class<? extends IBakedModel> clazz) {
        try {
            IModel model = ModelLoaderRegistry.getModel((ResourceLocation)location);
            IBakedModel baked = (IBakedModel)registry.func_82594_a((Object)location);
            IBakedModel finalModel = (IBakedModel)ReflectionHelper.findConstructor(clazz, (Class[])new Class[]{IBakedModel.class, IModel.class}).newInstance(baked, model);
            registry.func_82595_a((Object)location, (Object)finalModel);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void renderCubeQuad(BufferBuilder buffer, double x, double y, double z, int layer, Color colour, TextureAtlasSprite texture, World world, int luminance, BlockPos pos) {
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            RenderingUtils.renderPlanarQuad(buffer, facing, x, y, z, layer, colour, texture, world, luminance, pos);
        }
    }

    public static void renderPlanarQuad(BufferBuilder buffer, EnumFacing facing, double x, double y, double z, int layer, Color colour, TextureAtlasSprite texture, World world, int luminance, BlockPos pos) {
        Vector4f[] plane = PlanarQuadRenderer.getQuadsFor(facing);
        Vector3f offset = layer == 0 ? new Vector3f(0.0f, 0.0f, 0.0f) : PlanarQuadRenderer.getOffsetFor(facing, x, y, z, layer);
        int rgba = colour.getRGB();
        for (int i = 0; i < 4; ++i) {
            Vector4f quadPos = plane[i];
            float r = (float)((rgba & 0xFF0000) >> 16) / 255.0f;
            float g = (float)((rgba & 0xFF00) >> 8) / 255.0f;
            float b = (float)(rgba & 0xFF) / 255.0f;
            float a = (float)((rgba & 0xFF000000) >> 24) / 255.0f;
            float u = i < 2 ? texture.func_94212_f() - 6.25E-6f : texture.func_94209_e() + 6.25E-6f;
            float v = i == 1 || i == 2 ? texture.func_94210_h() - 6.25E-6f : texture.func_94206_g() + 6.25E-6f;
            int light = world.func_175626_b(pos.func_177972_a(facing), luminance);
            buffer.func_181662_b((double)(quadPos.x + offset.x), (double)(quadPos.y + offset.y), (double)(quadPos.z + offset.z)).func_181666_a(r, g, b, a).func_187315_a((double)u, (double)v).func_187314_a(light >> 16 & 0xFFFF, light & 0xFFFF).func_181675_d();
        }
    }

    public static List<BakedQuad> getQuadsForCube(Color colour, String spritename) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            quads.addAll(RenderingUtils.getQuadsForPlane(facing, colour, spritename));
        }
        return quads;
    }

    public static List<BakedQuad> getQuadsForPlane(EnumFacing facing, Color colour, String spritename) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        FaceBakery bakery = new FaceBakery();
        Vector3f[] vecs = PlanarQuadRenderer.get3FQuadsFor(facing);
        TextureAtlasSprite sprite = Minecraft.func_71410_x().func_147117_R().func_110572_b(spritename);
        BlockPartFace face = new BlockPartFace(null, 0, spritename, new BlockFaceUV(new float[]{0.0f, 0.0f, 16.0f, 16.0f}, 0));
        quads.add(bakery.func_178414_a(vecs[0], vecs[1], face, sprite, facing.func_176734_d(), ModelRotation.X0_Y0, null, true, true));
        return quads;
    }

    public static void drawQuad(Vec3d start, Vec3d end, ResourceLocation texture, int textureSize, Color colour, Vector3f normalStart, Vector3f normalEnd) {
        int r = colour.getRed();
        int g = colour.getGreen();
        int b = colour.getBlue();
        int a = colour.getAlpha();
        float f = 0.0f;
        double xf = 2.0 * (end.field_72450_a - start.field_72450_a) - (double)f;
        double zf = 2.0 * (end.field_72449_c - start.field_72449_c) - (double)f;
        double dy = end.field_72448_b - start.field_72448_b / 2.0;
        float ndy = normalEnd.y - normalStart.y / 2.0f;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(texture);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181712_l);
        buffer.func_181662_b(start.field_72450_a, start.field_72448_b, start.field_72449_c).func_187315_a(0.0, 0.0).func_181669_b(r, g, b, a).func_181663_c(normalStart.x, normalStart.y, normalStart.z).func_181675_d();
        buffer.func_181662_b(start.field_72450_a, start.field_72448_b + dy, end.field_72449_c).func_187315_a(0.0, zf).func_181669_b(r, g, b, a).func_181663_c(normalStart.x, normalStart.y + ndy, normalEnd.z).func_181675_d();
        buffer.func_181662_b(end.field_72450_a, end.field_72448_b, end.field_72449_c).func_187315_a(xf, xf).func_181669_b(r, g, b, a).func_181663_c(normalEnd.x, normalEnd.y, normalEnd.z).func_181675_d();
        buffer.func_181662_b(end.field_72450_a, start.field_72448_b + dy, start.field_72449_c).func_187315_a(xf, 0.0).func_181669_b(r, g, b, a).func_181663_c(normalEnd.x, normalStart.y + ndy, normalStart.z).func_181675_d();
        tessellator.func_78381_a();
    }

    private static class PlanarQuadRenderer {
        private PlanarQuadRenderer() {
        }

        private static Vector3f getOffsetFor(EnumFacing facing, double x, double y, double z, int layer) {
            Vector3f vector = new Vector3f((float)x, (float)y, (float)z);
            switch (facing) {
                case UP: {
                    vector.translate(0.0f, PlanarQuadRenderer.offsetLayer(1.0f, layer), 0.0f);
                    break;
                }
                case DOWN: {
                    vector.translate(0.0f, PlanarQuadRenderer.offsetLayer(0.0f, -layer), 0.0f);
                    break;
                }
                case NORTH: {
                    vector.translate(0.0f, 0.0f, PlanarQuadRenderer.offsetLayer(0.0f, -layer));
                    break;
                }
                case SOUTH: {
                    vector.translate(0.0f, 0.0f, PlanarQuadRenderer.offsetLayer(1.0f, layer));
                    break;
                }
                case EAST: {
                    vector.translate(PlanarQuadRenderer.offsetLayer(1.0f, layer), 0.0f, 0.0f);
                    break;
                }
                case WEST: {
                    vector.translate(PlanarQuadRenderer.offsetLayer(0.0f, -layer), 0.0f, 0.0f);
                }
            }
            return vector;
        }

        public static Vector3f[] get3FQuadsFor(EnumFacing facing) {
            if (facing != null) {
                switch (facing) {
                    case DOWN: {
                        return new Vector3f[]{new Vector3f(0.0f, 0.0f, 16.0f), new Vector3f(16.0f, 0.0f, 0.0f)};
                    }
                    case NORTH: {
                        return new Vector3f[]{new Vector3f(16.0f, 0.0f, 0.0f), new Vector3f(0.0f, 16.0f, 0.0f)};
                    }
                    case SOUTH: {
                        return new Vector3f[]{new Vector3f(16.0f, 0.0f, 16.0f), new Vector3f(0.0f, 16.0f, 16.0f)};
                    }
                    case EAST: {
                        return new Vector3f[]{new Vector3f(16.0f, 0.0f, 16.0f), new Vector3f(16.0f, 16.0f, 0.0f)};
                    }
                    case WEST: {
                        return new Vector3f[]{new Vector3f(0.0f, 0.0f, 16.0f), new Vector3f(0.0f, 16.0f, 0.0f)};
                    }
                }
                return new Vector3f[]{new Vector3f(0.0f, 16.0f, 16.0f), new Vector3f(16.0f, 16.0f, 0.0f)};
            }
            return new Vector3f[]{new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f)};
        }

        private static float offsetLayer(float offset, int layer) {
            float layerOffset = 0.001f * (float)layer;
            return offset + layerOffset;
        }

        private static Vector4f[] getQuadsFor(EnumFacing facing) {
            if (facing != null) {
                switch (facing) {
                    case DOWN: {
                        return new Vector4f[]{new Vector4f(1.0f, 0.0f, 1.0f, 0.0f), new Vector4f(1.0f, 0.0f, 0.0f, 0.0f), new Vector4f(0.0f, 0.0f, 0.0f, 0.0f), new Vector4f(0.0f, 0.0f, 1.0f, 0.0f)};
                    }
                    case NORTH: {
                        return new Vector4f[]{new Vector4f(0.0f, 1.0f, 0.0f, 0.0f), new Vector4f(0.0f, 0.0f, 0.0f, 0.0f), new Vector4f(1.0f, 0.0f, 0.0f, 0.0f), new Vector4f(1.0f, 1.0f, 0.0f, 0.0f)};
                    }
                    case SOUTH: {
                        return new Vector4f[]{new Vector4f(1.0f, 1.0f, 0.0f, 0.0f), new Vector4f(1.0f, 0.0f, 0.0f, 0.0f), new Vector4f(0.0f, 0.0f, 0.0f, 0.0f), new Vector4f(0.0f, 1.0f, 0.0f, 0.0f)};
                    }
                    case EAST: {
                        return new Vector4f[]{new Vector4f(0.0f, 1.0f, 0.0f, 0.0f), new Vector4f(0.0f, 0.0f, 0.0f, 0.0f), new Vector4f(0.0f, 0.0f, 1.0f, 0.0f), new Vector4f(0.0f, 1.0f, 1.0f, 0.0f)};
                    }
                    case WEST: {
                        return new Vector4f[]{new Vector4f(0.0f, 1.0f, 1.0f, 0.0f), new Vector4f(0.0f, 0.0f, 1.0f, 0.0f), new Vector4f(0.0f, 0.0f, 0.0f, 0.0f), new Vector4f(0.0f, 1.0f, 0.0f, 0.0f)};
                    }
                }
                return new Vector4f[]{new Vector4f(1.0f, 0.0f, 0.0f, 0.0f), new Vector4f(1.0f, 0.0f, 1.0f, 0.0f), new Vector4f(0.0f, 0.0f, 1.0f, 0.0f), new Vector4f(0.0f, 0.0f, 0.0f, 0.0f)};
            }
            return new Vector4f[]{new Vector4f(0.0f, 0.0f, 0.0f, 0.0f), new Vector4f(0.0f, 0.0f, 0.0f, 0.0f), new Vector4f(0.0f, 0.0f, 0.0f, 0.0f), new Vector4f(0.0f, 0.0f, 0.0f, 0.0f)};
        }
    }
}

