/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.atlas.api.util;

import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class DirectionUtils {
    public static RayTraceResult getPlayerRayTrace(World world, EntityPlayer player, float blockReach) {
        Vec3d eyepos = player.func_174824_e(1.0f);
        Vec3d lookangle = player.func_70676_i(1.0f);
        Vec3d lastVec = eyepos.func_72441_c(lookangle.field_72450_a, lookangle.field_72448_b, lookangle.field_72449_c);
        RayTraceResult blockRay = world.func_147447_a(eyepos, eyepos.func_72441_c(lookangle.field_72450_a * (double)blockReach, lookangle.field_72448_b * (double)blockReach, lookangle.field_72449_c * (double)blockReach), false, false, true);
        int x = 0;
        while ((float)x < 16.0f * blockReach) {
            float reach = (float)x / 16.0f;
            Vec3d vec = eyepos.func_72441_c(lookangle.field_72450_a * (double)reach, lookangle.field_72448_b * (double)reach, lookangle.field_72449_c * (double)reach);
            if (blockRay == null || blockRay.field_72307_f == null) {
                return new RayTraceResult(lookangle, null);
            }
            if (blockRay.field_72307_f.func_72438_d(eyepos) < vec.func_72438_d(eyepos)) break;
            AxisAlignedBB AABB = new AxisAlignedBB(lastVec.field_72450_a, lastVec.field_72448_b, lastVec.field_72449_c, vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
            List entities = world.func_72839_b((Entity)player, AABB);
            if (!entities.isEmpty()) {
                return new RayTraceResult((Entity)entities.get(0), lookangle);
            }
            lastVec = vec;
            ++x;
        }
        return blockRay;
    }

    public static EnumFacing getFacing(Vec3d vec) {
        return EnumFacing.func_176737_a((float)((float)vec.field_72450_a), (float)((float)vec.field_72448_b), (float)((float)vec.field_72449_c));
    }

    public static EnumFacing getRandomDirectionXZ(Random rand) {
        return DirectionUtils.getXZDirection(rand.nextInt(4));
    }

    public static EnumFacing getXZDirection(int direction) {
        switch (direction) {
            case 1: {
                return EnumFacing.SOUTH;
            }
            case 2: {
                return EnumFacing.EAST;
            }
            case 3: {
                return EnumFacing.WEST;
            }
        }
        return EnumFacing.NORTH;
    }

    public static int getXZMeta(EnumFacing facing) {
        if (facing == EnumFacing.UP || facing == EnumFacing.DOWN) {
            return facing.func_176745_a() + 4;
        }
        return facing.func_176745_a() - 2;
    }

    public static Vec3d getDirectionVecXZ(Vec3i startpos, Vec3i endpos) {
        return DirectionUtils.getDirectionVecXZ(new Vec3d(startpos), new Vec3d(endpos));
    }

    public static Vec3d getDirectionVecXZ(Vec3d startpos, Vec3d endpos) {
        double dx = endpos.field_72450_a - startpos.field_72450_a;
        double dz = endpos.field_72449_c - startpos.field_72449_c;
        double angle = Math.atan2(dz, dx);
        return DirectionUtils.getDirectionVecXZ(angle);
    }

    public static Vec3d getDirectionVecXZ(Entity entity1, Entity entity2) {
        Vec3d startpos = entity1.func_174791_d();
        Vec3d endpos = entity2.func_174791_d();
        return DirectionUtils.getDirectionVecXZ(startpos, endpos);
    }

    public static Vec3d getDirectionVecXZDegrees(double angle) {
        double rad = Math.toRadians(angle);
        return DirectionUtils.getDirectionVecXZ(rad);
    }

    public static Vec3d getDirectionVecXZ(double angle) {
        double x = Math.cos(angle);
        double z = Math.sin(angle);
        return new Vec3d(x, 0.0, z);
    }

    public static Vec3d getRandomDirectionVecXZ(Random rand) {
        int angle = rand.nextInt(360);
        return DirectionUtils.getDirectionVecXZDegrees(angle);
    }

    public static Vec3d getDirectionVec(Entity entity1, Entity entity2) {
        Vec3d startpos = entity1.func_174791_d();
        Vec3d endpos = entity2.func_174791_d();
        return DirectionUtils.getDirectionVec(startpos, endpos);
    }

    public static Vec3d getDirectionVec(Vec3i startpos, Vec3i endpos) {
        return DirectionUtils.getDirectionVec(new Vec3d(startpos), new Vec3d(endpos));
    }

    public static Vec3d getDirectionVec(Vec3d startpos, Vec3d endpos) {
        if (startpos.equals((Object)endpos)) {
            return new Vec3d(0.0, 0.0, 0.0);
        }
        double dx = endpos.field_72450_a - startpos.field_72450_a;
        double dy = endpos.field_72448_b - startpos.field_72448_b;
        double dz = endpos.field_72449_c - startpos.field_72449_c;
        double magnitude = Math.sqrt(Math.pow(dx, 2.0) + Math.pow(dy, 2.0) + Math.pow(dz, 2.0));
        double mx = (endpos.field_72450_a - startpos.field_72450_a) / magnitude;
        double my = (endpos.field_72448_b - startpos.field_72448_b) / magnitude;
        double mz = (endpos.field_72449_c - startpos.field_72449_c) / magnitude;
        return new Vec3d(mx, my, mz);
    }

    public static double dotProduct(Vec3i vec1, Vec3i vec2) {
        return DirectionUtils.dotProduct(new Vec3d(vec1), new Vec3d(vec2));
    }

    public static double dotProduct(Vec3d vec1, Vec3d vec2) {
        double x = vec1.field_72450_a * vec2.field_72450_a;
        double y = vec1.field_72448_b * vec2.field_72448_b;
        double z = vec1.field_72449_c * vec2.field_72449_c;
        return x + y + z;
    }

    public static BlockPos getClosestLoadedPos(World world, BlockPos basepos, Vec3d direction, double radius) {
        BlockPos pos = world.func_175672_r(basepos.func_177963_a(direction.field_72450_a * radius, 0.0, direction.field_72449_c * radius));
        while (!world.func_175726_f(pos).func_177410_o()) {
            if (radius == 0.0) {
                return basepos;
            }
            pos = world.func_175672_r(basepos.func_177963_a(direction.field_72450_a * (radius -= 1.0), 0.0, direction.field_72449_c * radius));
        }
        return pos;
    }

    public static BlockPos getClosestLoadedPos(World world, BlockPos basepos, Vec3d direction, double radius, int maxlight, int minlight) {
        BlockPos pos = world.func_175672_r(basepos.func_177963_a(direction.field_72450_a * radius, 0.0, direction.field_72449_c * radius));
        while (!world.func_175726_f(pos).func_177410_o() || !DirectionUtils.isBrightnessAllowed(world, basepos, maxlight, minlight)) {
            if (radius == 0.0) {
                return basepos;
            }
            pos = world.func_175672_r(basepos.func_177963_a(direction.field_72450_a * (radius -= 1.0), 0.0, direction.field_72449_c * radius));
        }
        return pos;
    }

    public static boolean isBrightnessAllowed(World world, BlockPos pos, int maxlight, int minlight) {
        int blocklight = world.func_175671_l(pos);
        if (blocklight > maxlight) {
            return false;
        }
        return blocklight >= minlight;
    }
}

