/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.atlas.api.util.recipe;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.item.ItemStack;

public class WeightedOutputs {
    private final List<Map.Entry<ItemStack, Integer>> entries;
    private final int deafaultTries;

    public WeightedOutputs(int deafultTries, Map<ItemStack, Integer> entries) {
        this(deafultTries, new ArrayList<Map.Entry<ItemStack, Integer>>(entries.entrySet()));
    }

    public WeightedOutputs(int deafaultTries, List<Map.Entry<ItemStack, Integer>> entries) {
        this.deafaultTries = deafaultTries;
        this.entries = entries;
        System.out.println(deafaultTries);
    }

    public int getAmount() {
        return this.deafaultTries;
    }

    public List<Map.Entry<ItemStack, Integer>> getTable() {
        return new ArrayList<Map.Entry<ItemStack, Integer>>(this.entries);
    }

    public List<ItemStack> getResults(Random rand) {
        return this.getResults(rand, 1);
    }

    private List<ItemStack> getResults(Random rand, int tries) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        ArrayList<AbstractMap.SimpleEntry<ItemStack, Integer>> mappedEntries = new ArrayList<AbstractMap.SimpleEntry<ItemStack, Integer>>();
        int max = 0;
        for (Map.Entry<ItemStack, Integer> entry : this.entries) {
            mappedEntries.add(new AbstractMap.SimpleEntry<ItemStack, Integer>(entry.getKey(), max));
            max += entry.getValue().intValue();
        }
        Collections.reverse(mappedEntries);
        block1: for (int i = 0; i < tries * this.deafaultTries; ++i) {
            int result = rand.nextInt(max);
            for (Map.Entry entry : mappedEntries) {
                if (result < (Integer)entry.getValue()) continue;
                stacks.add(((ItemStack)entry.getKey()).func_77946_l());
                continue block1;
            }
        }
        System.out.println(stacks);
        return stacks;
    }
}

