/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.blocks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFenceGate;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import wile.engineersdecor.blocks.BlockDecorDirectedHorizontal;
import wile.engineersdecor.detail.ModAuxiliaries;

public class BlockDecorDoubleGate
extends BlockDecorDirectedHorizontal {
    private static final AxisAlignedBB AABB_EMPTY = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.1);
    public static final PropertyInteger SEGMENT = PropertyInteger.func_177719_a((String)"segment", (int)0, (int)1);
    public static final PropertyBool OPEN = BlockFenceGate.field_176466_a;
    public static final int SEGMENT_LOWER = 0;
    public static final int SEGMENT_UPPER = 1;
    private final ArrayList<AxisAlignedBB> collision_shapes_;
    private final ArrayList<AxisAlignedBB> shapes_;

    public BlockDecorDoubleGate(@Nonnull String registryName, long config, @Nullable Material material, float hardness, float resistance, @Nullable SoundType sound, @Nonnull AxisAlignedBB unrotatedAABB) {
        super(registryName, config, material, hardness, resistance, sound, unrotatedAABB);
        AxisAlignedBB caabb = unrotatedAABB.func_72321_a(0.0, 0.5, 0.0);
        this.collision_shapes_ = new ArrayList<AxisAlignedBB>(Arrays.asList(field_185506_k, field_185506_k, ModAuxiliaries.getRotatedAABB(caabb, EnumFacing.NORTH, true), ModAuxiliaries.getRotatedAABB(caabb, EnumFacing.SOUTH, true), ModAuxiliaries.getRotatedAABB(caabb, EnumFacing.WEST, true), ModAuxiliaries.getRotatedAABB(caabb, EnumFacing.EAST, true), field_185506_k, field_185506_k));
        this.shapes_ = new ArrayList<AxisAlignedBB>(Arrays.asList(AABB_EMPTY, AABB_EMPTY, ModAuxiliaries.getRotatedAABB(unrotatedAABB, EnumFacing.NORTH, true), ModAuxiliaries.getRotatedAABB(unrotatedAABB, EnumFacing.SOUTH, true), ModAuxiliaries.getRotatedAABB(unrotatedAABB, EnumFacing.WEST, true), ModAuxiliaries.getRotatedAABB(unrotatedAABB, EnumFacing.EAST, true), AABB_EMPTY, AABB_EMPTY));
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return super.func_176203_a(meta).func_177226_a((IProperty)OPEN, (Comparable)Boolean.valueOf((meta & 4) != 0)).func_177226_a((IProperty)SEGMENT, (Comparable)Integer.valueOf((meta & 8) != 0 ? 1 : 0));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return super.func_176201_c(state) | ((Boolean)state.func_177229_b((IProperty)OPEN) != false ? 4 : 0) | ((Integer)state.func_177229_b((IProperty)SEGMENT) == 1 ? 8 : 0);
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, OPEN, SEGMENT});
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return this.shapes_.get(((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a() & 7);
    }

    @Override
    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return (Boolean)state.func_177229_b((IProperty)OPEN) != false ? field_185506_k : this.collision_shapes_.get(((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a() & 7);
    }

    @Override
    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        if (!((Boolean)state.func_177229_b((IProperty)OPEN)).booleanValue()) {
            BlockDecorDoubleGate.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)this.collision_shapes_.get(((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a() & 7));
        }
    }

    @Override
    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.getInitialState(super.getStateForPlacement(world, pos, facing, hitX, hitY, hitZ, meta, placer, hand), (IBlockAccess)world, pos);
    }

    public boolean func_176205_b(IBlockAccess world, BlockPos pos) {
        return (Boolean)world.func_180495_p(pos).func_177229_b((IProperty)OPEN);
    }

    public PathNodeType getAiPathNodeType(IBlockState state, IBlockAccess world, BlockPos pos) {
        return (Boolean)state.func_177229_b((IProperty)OPEN) != false ? PathNodeType.OPEN : PathNodeType.FENCE;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing face, float hitX, float hitY, float hitZ) {
        if (face == EnumFacing.UP || face == EnumFacing.DOWN && player.func_184586_b(hand).func_77973_b() == Item.func_150898_a((Block)this)) {
            return false;
        }
        if (world.field_72995_K) {
            return true;
        }
        boolean open = (Boolean)state.func_177229_b((IProperty)OPEN) == false;
        world.func_180501_a(pos, state.func_177226_a((IProperty)OPEN, (Comparable)Boolean.valueOf(open)), 26);
        if ((Integer)state.func_177229_b((IProperty)SEGMENT) == 1) {
            IBlockState adjacent = world.func_180495_p(pos.func_177977_b());
            if (adjacent.func_177230_c() == this) {
                world.func_180501_a(pos.func_177977_b(), adjacent.func_177226_a((IProperty)OPEN, (Comparable)Boolean.valueOf(open)), 26);
            }
        } else {
            IBlockState adjacent = world.func_180495_p(pos.func_177984_a());
            if (adjacent.func_177230_c() == this) {
                world.func_180501_a(pos.func_177984_a(), adjacent.func_177226_a((IProperty)OPEN, (Comparable)Boolean.valueOf(open)), 26);
            }
        }
        world.func_184133_a(null, pos, open ? SoundEvents.field_187611_cI : SoundEvents.field_187608_cH, SoundCategory.BLOCKS, 0.7f, 1.4f);
        return true;
    }

    @Override
    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        IBlockState adjacent;
        BlockPos adjacent_pos;
        if (world.field_72995_K) {
            return;
        }
        boolean powered = false;
        if ((Integer)state.func_177229_b((IProperty)SEGMENT) == 1) {
            adjacent_pos = pos.func_177977_b();
            adjacent = world.func_180495_p(adjacent_pos);
            if (adjacent.func_177230_c() != this) {
                adjacent = null;
            }
            if (world.func_175651_c(pos.func_177984_a(), EnumFacing.UP) > 0) {
                powered = true;
            } else if (adjacent != null && world.func_175640_z(pos.func_177979_c(2))) {
                powered = true;
            }
        } else {
            adjacent_pos = pos.func_177984_a();
            adjacent = world.func_180495_p(adjacent_pos);
            if (adjacent.func_177230_c() != this) {
                adjacent = null;
            }
            if (world.func_175640_z(pos)) {
                powered = true;
            } else if (adjacent != null && world.func_175651_c(pos.func_177981_b(2), EnumFacing.UP) > 0) {
                powered = true;
            }
        }
        boolean sound = false;
        if (powered != (Boolean)state.func_177229_b((IProperty)OPEN)) {
            world.func_180501_a(pos, state.func_177226_a((IProperty)OPEN, (Comparable)Boolean.valueOf(powered)), 26);
            sound = true;
        }
        if (adjacent != null && powered != (Boolean)adjacent.func_177229_b((IProperty)OPEN)) {
            world.func_180501_a(adjacent_pos, adjacent.func_177226_a((IProperty)OPEN, (Comparable)Boolean.valueOf(powered)), 26);
            sound = true;
        }
        if (sound) {
            world.func_184133_a(null, pos, powered ? SoundEvents.field_187611_cI : SoundEvents.field_187608_cH, SoundCategory.BLOCKS, 0.7f, 1.4f);
        }
    }

    private IBlockState getInitialState(IBlockState state, IBlockAccess world, BlockPos pos) {
        IBlockState down = world.func_180495_p(pos.func_177977_b());
        if (down.func_177230_c() == this) {
            return state.func_177226_a((IProperty)SEGMENT, (Comparable)Integer.valueOf(1)).func_177226_a((IProperty)OPEN, down.func_177229_b((IProperty)OPEN)).func_177226_a((IProperty)FACING, down.func_177229_b((IProperty)FACING));
        }
        IBlockState up = world.func_180495_p(pos.func_177984_a());
        if (up.func_177230_c() == this) {
            return state.func_177226_a((IProperty)SEGMENT, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)OPEN, up.func_177229_b((IProperty)OPEN)).func_177226_a((IProperty)FACING, up.func_177229_b((IProperty)FACING));
        }
        return state.func_177226_a((IProperty)SEGMENT, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)OPEN, (Comparable)Boolean.valueOf(false));
    }
}

