/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.blocks;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import wile.engineersdecor.blocks.BlockDecorDirected;
import wile.engineersdecor.blocks.BlockDecorPipeValve;
import wile.engineersdecor.detail.ModAuxiliaries;

public class BlockDecorPassiveFluidAccumulator
extends BlockDecorDirected {
    public BlockDecorPassiveFluidAccumulator(@Nonnull String registryName, long config, @Nullable Material material, float hardness, float resistance, @Nullable SoundType sound, @Nonnull AxisAlignedBB unrotatedAABB) {
        super(registryName, config, material, hardness, resistance, sound, unrotatedAABB);
    }

    @Override
    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new BTileEntity();
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof BTileEntity)) {
            return true;
        }
        ((BTileEntity)te).send_device_stats(player);
        return true;
    }

    @Override
    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof BlockDecorPipeValve.BTileEntity) {
            ((BTileEntity)te).block_changed();
        }
    }

    public static class BTileEntity
    extends TileEntity
    implements IFluidHandler,
    IFluidTankProperties,
    ICapabilityProvider,
    ITickable {
        protected static int tick_idle_interval = 20;
        protected static int max_flowrate = 1000;
        private final IFluidTankProperties[] fluid_props_ = new IFluidTankProperties[]{this};
        private final InputFillHandler fill_handler_ = new InputFillHandler(this);
        private EnumFacing block_facing_ = EnumFacing.NORTH;
        private FluidStack tank_ = null;
        private int last_drain_request_amount_ = 0;
        private int vacuum_ = 0;
        private int tick_timer_ = 0;
        private int round_robin_ = 0;
        private boolean initialized_ = false;
        private int total_volume_filled_ = 0;
        private int total_volume_drained_ = 0;

        public void send_device_stats(EntityPlayer player) {
            int t_vol = this.tank_ == null ? 0 : this.tank_.amount;
            ModAuxiliaries.playerChatMessage(player, "" + t_vol + "mB");
        }

        public void block_changed() {
            this.initialized_ = false;
            this.tick_timer_ = MathHelper.func_76125_a((int)this.tick_timer_, (int)0, (int)tick_idle_interval);
        }

        public boolean shouldRefresh(World world, BlockPos pos, IBlockState os, IBlockState ns) {
            this.block_changed();
            return os.func_177230_c() != ns.func_177230_c() || !(ns.func_177230_c() instanceof BlockDecorPassiveFluidAccumulator);
        }

        public void func_145839_a(NBTTagCompound nbt) {
            super.func_145839_a(nbt);
            this.tank_ = !nbt.func_74764_b("tank") ? null : FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt.func_74775_l("tank"));
        }

        public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
            super.func_189515_b(nbt);
            if (this.tank_ != null) {
                nbt.func_74782_a("tank", (NBTBase)this.tank_.writeToNBT(new NBTTagCompound()));
            }
            return nbt;
        }

        public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
            return this.initialized_ && capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
        }

        @Nullable
        public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
            if (capability != CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
                return (T)super.getCapability(capability, facing);
            }
            return (T)(facing == this.block_facing_ ? this : this.fill_handler_);
        }

        public IFluidTankProperties[] getTankProperties() {
            return this.fluid_props_;
        }

        public int fill(FluidStack resource, boolean doFill) {
            return 0;
        }

        @Nullable
        public FluidStack drain(FluidStack resource, boolean doDrain) {
            if (resource == null || this.tank_ == null) {
                return null;
            }
            return !this.tank_.isFluidEqual(resource) ? null : this.drain(resource.amount, doDrain);
        }

        @Nullable
        public FluidStack drain(int maxDrain, boolean doDrain) {
            if (!this.initialized_) {
                return null;
            }
            if (doDrain && maxDrain > 0) {
                this.last_drain_request_amount_ = maxDrain;
            }
            if (this.tank_ == null) {
                return null;
            }
            maxDrain = MathHelper.func_76125_a((int)maxDrain, (int)0, (int)this.tank_.amount);
            if (!doDrain) {
                return this.tank_.copy();
            }
            FluidStack res = this.tank_.copy();
            res.amount = maxDrain;
            this.tank_.amount -= maxDrain;
            if (this.tank_.amount <= 0) {
                this.tank_ = null;
            }
            this.total_volume_drained_ += res.amount;
            return res;
        }

        @Nullable
        public FluidStack getContents() {
            return this.tank_ == null ? null : this.tank_.copy();
        }

        public int getCapacity() {
            return max_flowrate;
        }

        public boolean canFill() {
            return false;
        }

        public boolean canDrain() {
            return true;
        }

        public boolean canFillFluidType(FluidStack fluidStack) {
            return false;
        }

        public boolean canDrainFluidType(FluidStack fluidStack) {
            return true;
        }

        public void func_73660_a() {
            if (this.field_145850_b.field_72995_K || --this.tick_timer_ > 0) {
                return;
            }
            this.tick_timer_ = tick_idle_interval;
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (!(state.func_177230_c() instanceof BlockDecorPassiveFluidAccumulator)) {
                return;
            }
            if (!this.initialized_) {
                this.initialized_ = true;
                this.block_facing_ = (EnumFacing)state.func_177229_b((IProperty)BlockDecorDirected.FACING);
            }
            int n_requested = this.last_drain_request_amount_;
            this.last_drain_request_amount_ = 0;
            if (n_requested > 0) {
                this.vacuum_ += 2;
                if (this.vacuum_ > 5) {
                    this.vacuum_ = 5;
                }
            } else if (--this.vacuum_ <= 0) {
                this.vacuum_ = 0;
                if (this.tank_ != null) {
                    return;
                }
                n_requested = 10;
            }
            boolean has_refilled = false;
            int tank_buffer_needed = n_requested += this.vacuum_ * 50;
            if (tank_buffer_needed > max_flowrate) {
                tank_buffer_needed = max_flowrate;
            }
            for (int i = 0; i < 6; ++i) {
                IFluidHandler fh;
                TileEntity te;
                if (++this.round_robin_ > 5) {
                    this.round_robin_ = 0;
                }
                if (n_requested <= 0 || this.tank_ != null && this.tank_.amount >= tank_buffer_needed) break;
                EnumFacing f = EnumFacing.func_82600_a((int)this.round_robin_);
                if (f == this.block_facing_ || (te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(f))) == null || te instanceof BTileEntity || !te.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, f.func_176734_d()) || (fh = (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, f.func_176734_d())) == null) continue;
                if (this.tank_ == null) {
                    FluidStack res = fh.drain(n_requested, true);
                    if (res == null || res.amount == 0) continue;
                    this.total_volume_filled_ += res.amount;
                    this.tank_ = res.copy();
                    has_refilled = true;
                    continue;
                }
                if (this.tank_.amount + n_requested > max_flowrate) {
                    n_requested = max_flowrate - this.tank_.amount;
                }
                FluidStack rq = this.tank_.copy();
                rq.amount = n_requested;
                FluidStack res = fh.drain(rq, true);
                if (res == null) continue;
                this.tank_.amount += res.amount;
                this.total_volume_filled_ += res.amount;
                has_refilled = true;
                if (this.tank_.amount >= max_flowrate) break;
            }
            if (has_refilled) {
                this.tick_timer_ = 0;
            }
        }

        private static class InputFillHandler
        implements IFluidHandler,
        IFluidTankProperties {
            private final BTileEntity parent_;
            private final IFluidTankProperties[] props_ = new IFluidTankProperties[]{this};

            InputFillHandler(BTileEntity parent) {
                this.parent_ = parent;
            }

            public int fill(FluidStack resource, boolean doFill) {
                return 0;
            }

            @Nullable
            public FluidStack drain(FluidStack resource, boolean doDrain) {
                return null;
            }

            @Nullable
            public FluidStack drain(int maxDrain, boolean doDrain) {
                return null;
            }

            @Nullable
            public FluidStack getContents() {
                return null;
            }

            public IFluidTankProperties[] getTankProperties() {
                return this.props_;
            }

            public int getCapacity() {
                return max_flowrate;
            }

            public boolean canFill() {
                return true;
            }

            public boolean canDrain() {
                return false;
            }

            public boolean canFillFluidType(FluidStack fluidStack) {
                return true;
            }

            public boolean canDrainFluidType(FluidStack fluidStack) {
                return false;
            }
        }
    }
}

