/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.blocks;

import blusunrize.immersiveengineering.api.fluid.IFluidPipe;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import wile.engineersdecor.ModEngineersDecor;
import wile.engineersdecor.blocks.BlockDecorDirected;

public class BlockDecorPipeValve
extends BlockDecorDirected {
    private static int fluid_maxflow_mb = 1000;
    private static int redstone_flow_slope_mb = 66;
    public static final PropertyInteger RS_CONNECTION_DIR = PropertyInteger.func_177719_a((String)"rsdir", (int)0, (int)4);
    private static final int[][] rsconnectors = new int[][]{{0, 0, 1, 3, 4, 2}, {0, 0, 3, 1, 4, 2}, {3, 1, 0, 0, 4, 2}, {3, 1, 0, 0, 2, 4}, {3, 1, 2, 4, 0, 0}, {3, 1, 4, 2, 0, 0}};

    public static void on_config(int container_size_decl, int redstone_slope) {
        fluid_maxflow_mb = MathHelper.func_76125_a((int)container_size_decl, (int)1, (int)10000);
        redstone_flow_slope_mb = MathHelper.func_76125_a((int)redstone_slope, (int)1, (int)10000);
        ModEngineersDecor.logger.info("Config pipe valve: maxflow:" + fluid_maxflow_mb + "mb, redstone amp:" + redstone_flow_slope_mb + "mb/sig");
    }

    public BlockDecorPipeValve(@Nonnull String registryName, long config, @Nullable Material material, float hardness, float resistance, @Nullable SoundType sound, @Nonnull AxisAlignedBB unrotatedAABB) {
        super(registryName, config, material, hardness, resistance, sound, unrotatedAABB);
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, RS_CONNECTION_DIR});
    }

    @Override
    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return super.getStateForPlacement(world, pos, facing, hitX, hitY, hitZ, meta, placer, hand).func_177226_a((IProperty)RS_CONNECTION_DIR, (Comparable)Integer.valueOf(0));
    }

    @Override
    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        if ((this.config & 0x20000L) == 0L) {
            return state;
        }
        EnumFacing.Axis bfa = ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176740_k();
        int bfi = ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
        for (EnumFacing f : EnumFacing.field_82609_l) {
            BlockPos nbp;
            IBlockState nbs;
            if (f.func_176740_k() == bfa || !(nbs = world.func_180495_p(nbp = pos.func_177972_a(f))).func_185897_m()) continue;
            return state.func_177226_a((IProperty)RS_CONNECTION_DIR, (Comparable)Integer.valueOf(rsconnectors[((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a()][f.func_176745_a()]));
        }
        return state.func_177226_a((IProperty)RS_CONNECTION_DIR, (Comparable)Integer.valueOf(0));
    }

    @Override
    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos fromPos) {
        EnumFacing fc = (EnumFacing)state.func_177229_b((IProperty)FACING);
        if (fromPos.equals((Object)pos.func_177972_a(fc)) || fromPos.equals((Object)pos.func_177972_a(fc.func_176734_d()))) {
            this.update_te(world, state, pos);
        }
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        this.update_te(world, state, pos);
        world.func_175685_c(pos, (Block)this, true);
    }

    @Override
    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.SOLID;
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, @Nullable EnumFacing side) {
        return side != null && side != state.func_177229_b((IProperty)FACING) && side != ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176734_d();
    }

    @Override
    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new BTileEntity();
    }

    private void update_te(World world, IBlockState state, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof BTileEntity) {
            ((BTileEntity)te).block_reconfigure((EnumFacing)state.func_177229_b((IProperty)FACING), this.config);
        }
    }

    public static class BTileEntity
    extends TileEntity
    implements IFluidHandler,
    IFluidTankProperties,
    ICapabilityProvider,
    IFluidPipe {
        private static final BackFlowHandler back_flow_handler_ = new BackFlowHandler();
        private final IFluidTankProperties[] fluid_props_ = new IFluidTankProperties[]{this};
        private EnumFacing block_facing_ = EnumFacing.NORTH;
        private boolean filling_ = false;
        private boolean getlocked_ = false;
        private boolean filling_enabled_ = true;
        private long block_config_ = 0L;

        public void block_reconfigure(EnumFacing facing, long block_config) {
            this.block_facing_ = facing;
            this.block_config_ = block_config;
            this.filling_enabled_ = false;
            IFluidHandler fh = this.forward_fluid_handler();
            if (fh != null) {
                if (fh.getTankProperties().length == 0) {
                    this.filling_enabled_ = true;
                } else {
                    for (IFluidTankProperties fp : fh.getTankProperties()) {
                        if (fp == null || !fp.canFill()) continue;
                        this.filling_enabled_ = true;
                        break;
                    }
                }
            }
        }

        public boolean shouldRefresh(World world, BlockPos pos, IBlockState os, IBlockState ns) {
            return os.func_177230_c() != ns.func_177230_c() || !(ns.func_177230_c() instanceof BlockDecorPipeValve);
        }

        public void onLoad() {
            if (!this.func_145830_o()) {
                return;
            }
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (!(state.func_177230_c() instanceof BlockDecorPipeValve)) {
                return;
            }
            this.block_reconfigure((EnumFacing)state.func_177229_b((IProperty)BlockDecorDirected.FACING), this.block_config_);
            this.field_145850_b.func_175685_c(this.field_174879_c, state.func_177230_c(), false);
        }

        public void func_145839_a(NBTTagCompound nbt) {
            super.func_145839_a(nbt);
            int i = nbt.func_74762_e("facing");
            if (i >= 0 || i < 6) {
                this.block_facing_ = EnumFacing.func_82600_a((int)i);
            }
            this.block_config_ = nbt.func_74763_f("conf");
        }

        public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
            super.func_189515_b(nbt);
            nbt.func_74768_a("facing", this.block_facing_.func_176745_a());
            nbt.func_74772_a("conf", this.block_config_);
            return nbt;
        }

        public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
            return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && (facing == this.block_facing_ || facing == this.block_facing_.func_176734_d());
        }

        @Nullable
        public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
            if (capability != CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
                return (T)super.getCapability(capability, facing);
            }
            return (T)(facing == this.block_facing_ ? back_flow_handler_ : this);
        }

        @Nullable
        private IFluidHandler forward_fluid_handler() {
            TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(this.block_facing_));
            if (te == null) {
                return null;
            }
            return (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, this.block_facing_.func_176734_d());
        }

        public int fill(FluidStack resource, boolean doFill) {
            TileEntity te;
            IFluidHandler fh;
            if (this.filling_ || !this.filling_enabled_) {
                return 0;
            }
            if ((this.block_config_ & 0x20000L) != 0L) {
                int rs = this.field_145850_b.func_175687_A(this.field_174879_c);
                if (rs <= 0) {
                    return 0;
                }
                if ((this.block_config_ & 0x40000L) != 0L && rs < 15) {
                    resource.amount = MathHelper.func_76125_a((int)(rs * redstone_flow_slope_mb), (int)1, (int)resource.amount);
                }
            }
            FluidStack res = resource.copy();
            if (res.amount > fluid_maxflow_mb) {
                res.amount = fluid_maxflow_mb;
            }
            if ((fh = this.forward_fluid_handler()) == null) {
                return 0;
            }
            this.filling_ = true;
            if (res.amount > 50 && (te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(this.block_facing_))) instanceof IFluidPipe) {
                if (res.tag == null) {
                    res.tag = new NBTTagCompound();
                }
                res.tag.func_74757_a("pressurized", true);
            }
            int n_filled = this.forward_fluid_handler().fill(res, doFill);
            this.filling_ = false;
            return n_filled;
        }

        @Nullable
        public FluidStack drain(FluidStack resource, boolean doDrain) {
            return null;
        }

        @Nullable
        public FluidStack drain(int maxDrain, boolean doDrain) {
            return null;
        }

        public IFluidTankProperties[] getTankProperties() {
            return this.fluid_props_;
        }

        @Nullable
        public FluidStack getContents() {
            return null;
        }

        public int getCapacity() {
            return 1000;
        }

        public boolean canFill() {
            return true;
        }

        public boolean canDrain() {
            return false;
        }

        public boolean canFillFluidType(FluidStack fluidStack) {
            return true;
        }

        public boolean canDrainFluidType(FluidStack fluidStack) {
            return false;
        }

        @Override
        public boolean hasOutputConnection(EnumFacing side) {
            return side == this.block_facing_;
        }

        @Override
        public boolean canOutputPressurized(boolean consumePower) {
            if (this.getlocked_ || !this.filling_enabled_) {
                return false;
            }
            TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(this.block_facing_));
            if (!(te instanceof IFluidPipe)) {
                return false;
            }
            this.getlocked_ = true;
            boolean r = ((IFluidPipe)te).canOutputPressurized(consumePower);
            this.getlocked_ = false;
            return r;
        }

        private static class BackFlowHandler
        implements IFluidHandler,
        IFluidTankProperties {
            private final IFluidTankProperties[] props_ = new IFluidTankProperties[]{this};

            private BackFlowHandler() {
            }

            public IFluidTankProperties[] getTankProperties() {
                return this.props_;
            }

            public int fill(FluidStack resource, boolean doFill) {
                return 0;
            }

            @Nullable
            public FluidStack drain(FluidStack resource, boolean doDrain) {
                return null;
            }

            @Nullable
            public FluidStack drain(int maxDrain, boolean doDrain) {
                return null;
            }

            @Nullable
            public FluidStack getContents() {
                return null;
            }

            public int getCapacity() {
                return 0;
            }

            public boolean canFill() {
                return false;
            }

            public boolean canDrain() {
                return false;
            }

            public boolean canFillFluidType(FluidStack fluidStack) {
                return false;
            }

            public boolean canDrainFluidType(FluidStack fluidStack) {
                return false;
            }
        }
    }
}

