/*
 * Decompiled with CFR 0.152.
 */
package red.jad.sandbag.registry;

import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityEntryBuilder;
import net.minecraftforge.registries.IForgeRegistryEntry;
import red.jad.sandbag.entity.EntitySandbag;
import red.jad.sandbag.registry.ItemRegistry;
import red.jad.sandbag.registry.RenderHandler;

@Mod.EventBusSubscriber
public class RegistryHandler {
    @SubscribeEvent
    public static void onItemRegister(RegistryEvent.Register<Item> e) {
        e.getRegistry().registerAll((IForgeRegistryEntry[])ItemRegistry.ITEMS.toArray(new Item[0]));
    }

    @SubscribeEvent
    public static void onModelRegister(ModelRegistryEvent e) {
        for (Item item : ItemRegistry.ITEMS) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(item.getRegistryName(), "normal"));
        }
        RenderHandler.registerEntityRenderers();
    }

    @SubscribeEvent
    public static void registerEntities(RegistryEvent.Register<EntityEntry> e) {
        EntityEntry sandbag = EntityEntryBuilder.create().entity(EntitySandbag.class).id(new ResourceLocation("sandbag:sandbag"), 0).name("sandbag").tracker(50, 3, false).build();
        e.getRegistry().register((IForgeRegistryEntry)sandbag);
    }
}

