/*
 * Decompiled with CFR 0.152.
 */
package nc.container.processor;

import nc.container.ContainerTile;
import nc.init.NCItems;
import nc.recipe.BasicRecipeHandler;
import nc.tile.ITileGui;
import nc.tile.processor.IItemProcessor;
import nc.tile.processor.IUpgradable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public abstract class ContainerItemProcessor<PROCESSOR extends IItemProcessor & ITileGui>
extends ContainerTile<PROCESSOR> {
    protected final PROCESSOR tile;
    protected final BasicRecipeHandler recipeHandler;
    protected static final ItemStack SPEED_UPGRADE = new ItemStack(NCItems.upgrade, 1, 0);
    protected static final ItemStack ENERGY_UPGRADE = new ItemStack(NCItems.upgrade, 1, 1);

    public ContainerItemProcessor(EntityPlayer player, PROCESSOR tileEntity, BasicRecipeHandler recipeHandler) {
        super((ITileGui)tileEntity);
        this.tile = tileEntity;
        this.recipeHandler = recipeHandler;
        ((ITileGui)tileEntity).beginUpdatingPlayer(player);
    }

    @Override
    public boolean func_75145_c(EntityPlayer player) {
        return this.tile.func_70300_a(player);
    }

    public void func_75134_a(EntityPlayer player) {
        super.func_75134_a(player);
        ((ITileGui)this.tile).stopUpdatingPlayer(player);
    }

    public ItemStack func_82846_b(EntityPlayer player, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        boolean hasUpgrades = this.tile instanceof IUpgradable && ((IUpgradable)this.tile).hasUpgrades();
        int upgrades = hasUpgrades ? ((IUpgradable)this.tile).getNumberOfUpgrades() : 0;
        int invStart = this.tile.getItemInputSize() + this.tile.getItemOutputSize() + upgrades;
        int speedUpgradeSlot = this.tile.getItemInputSize() + this.tile.getItemOutputSize();
        int otherUpgradeSlot = this.tile.getItemInputSize() + this.tile.getItemOutputSize() + 1;
        int invEnd = this.tile.getItemInputSize() + this.tile.getItemOutputSize() + 36 + upgrades;
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (index >= this.tile.getItemInputSize() && index < invStart) {
                if (!this.func_75135_a(itemstack1, invStart, invEnd, false)) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(itemstack1, itemstack);
            } else if (index >= invStart) {
                if (hasUpgrades && itemstack1.func_77973_b() == NCItems.upgrade && (this.tile.func_94041_b(speedUpgradeSlot, itemstack1) ? !this.func_75135_a(itemstack1, speedUpgradeSlot, speedUpgradeSlot + 1, false) : this.tile.func_94041_b(otherUpgradeSlot, itemstack1) && !this.func_75135_a(itemstack1, otherUpgradeSlot, otherUpgradeSlot + 1, false))) {
                    return ItemStack.field_190927_a;
                }
                if (this.recipeHandler.isValidItemInput(itemstack1) ? !this.func_75135_a(itemstack1, 0, this.tile.getItemInputSize(), false) : (index >= invStart && index < invEnd - 9 ? !this.func_75135_a(itemstack1, invEnd - 9, invEnd, false) : index >= invEnd - 9 && index < invEnd && !this.func_75135_a(itemstack1, invStart, invEnd - 9, false))) {
                    return ItemStack.field_190927_a;
                }
            } else if (!this.func_75135_a(itemstack1, invStart, invEnd, false)) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(player, itemstack1);
        }
        return itemstack;
    }
}

