/*
 * Decompiled with CFR 0.152.
 */
package nc.gui;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import nc.container.slot.SlotFiltered;
import nc.gui.element.NCButton;
import nc.tile.energy.ITileEnergy;
import nc.tile.internal.fluid.Tank;
import nc.util.Lang;
import nc.util.SoundHelper;
import nc.util.UnitHelper;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public abstract class NCGui
extends GuiContainer {
    public NCGui(Container inventory) {
        super(inventory);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
        this.renderTooltips(mouseX, mouseY);
    }

    protected void func_191948_b(int x, int y) {
        Slot slot = this.getSlotUnderMouse();
        if (slot != null && this.field_146297_k.field_71439_g.field_71071_by.func_70445_o().func_190926_b()) {
            if (slot instanceof SlotFiltered && ((SlotFiltered)slot).hasStackForRender()) {
                this.func_146285_a(((SlotFiltered)slot).getStackForRender(), x, y);
            } else if (slot.func_75216_d()) {
                this.func_146285_a(slot.func_75211_c(), x, y);
            }
        }
    }

    public void renderTooltips(int mouseX, int mouseY) {
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (mouseButton == 1 || mouseButton == 2) {
            for (int i = 0; i < this.field_146292_n.size(); ++i) {
                boolean mousePressed;
                GuiButton guibutton = (GuiButton)this.field_146292_n.get(i);
                boolean bl = mousePressed = guibutton instanceof NCButton ? ((NCButton)guibutton).mousePressed(this.field_146297_k, mouseX, mouseY, mouseButton) : false;
                if (!mousePressed) continue;
                GuiScreenEvent.ActionPerformedEvent.Pre event = new GuiScreenEvent.ActionPerformedEvent.Pre((GuiScreen)this, guibutton, this.field_146292_n);
                if (MinecraftForge.EVENT_BUS.post((Event)event)) break;
                this.field_146290_a = guibutton = event.getButton();
                float soundPitch = 1.0f;
                if (mouseButton == 1) {
                    this.actionPerformedRight(guibutton);
                    soundPitch = SoundHelper.getPitch(1.0);
                } else if (mouseButton == 2) {
                    this.actionPerformedMiddle(guibutton);
                }
                this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)soundPitch));
                if (!((Object)((Object)this)).equals(this.field_146297_k.field_71462_r)) continue;
                MinecraftForge.EVENT_BUS.post((Event)new GuiScreenEvent.ActionPerformedEvent.Post((GuiScreen)this, event.getButton(), this.field_146292_n));
            }
        }
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    protected void actionPerformedRight(GuiButton guiButton) {
    }

    protected void actionPerformedMiddle(GuiButton guiButton) {
    }

    protected boolean isEscapeKeyDown(int keyCode) {
        return keyCode == 1 || this.field_146297_k.field_71474_y.field_151445_Q.isActiveAndMatches(keyCode);
    }

    protected void drawTooltip(List<String> text, int mouseX, int mouseY, int x, int y, int width, int height) {
        int xPos = x + this.field_147003_i;
        int yPos = y + this.field_147009_r;
        if (mouseX >= xPos && mouseY >= yPos && mouseX < xPos + width && mouseY < yPos + height) {
            this.func_146283_a(text, mouseX, mouseY);
        }
    }

    protected void drawTooltip(String text, int mouseX, int mouseY, int x, int y, int width, int height) {
        this.drawTooltip(Lists.newArrayList((Object[])new String[]{text}), mouseX, mouseY, x, y, width, height);
    }

    protected List<String> fluidInfo(Tank tank) {
        String fluidName = tank.getFluidLocalizedName();
        String fluidAmount = UnitHelper.prefix(tank.getFluidAmount(), tank.getCapacity(), 5, "B", -1);
        return Lists.newArrayList((Object[])new String[]{TextFormatting.GREEN + fluidName + TextFormatting.WHITE + " [" + fluidAmount + "]", TextFormatting.ITALIC + Lang.localise("gui.nc.container.shift_clear_tank")});
    }

    protected List<String> fluidFilterInfo(Tank tank) {
        String fluidName = tank.getFluidLocalizedName();
        return Lists.newArrayList((Object[])new String[]{TextFormatting.GREEN + fluidName + TextFormatting.WHITE, TextFormatting.ITALIC + Lang.localise("gui.nc.container.shift_clear_filter")});
    }

    protected void drawFluidTooltip(Tank tank, int mouseX, int mouseY, int x, int y, int width, int height) {
        if (!tank.isEmpty()) {
            this.drawTooltip(this.fluidInfo(tank), mouseX, mouseY, x, y, width, height + 1);
        }
    }

    protected void drawFilteredFluidTooltip(Tank tank, Tank filterTank, int mouseX, int mouseY, int x, int y, int width, int height) {
        if (tank.isEmpty()) {
            if (!filterTank.isEmpty()) {
                this.drawTooltip(this.fluidFilterInfo(filterTank), mouseX, mouseY, x, y, width, height + 1);
            }
        } else {
            this.drawTooltip(this.fluidInfo(tank), mouseX, mouseY, x, y, width, height + 1);
        }
    }

    protected List<String> energyInfo(ITileEnergy tile) {
        String energy = UnitHelper.prefix((long)tile.getEnergyStorage().getEnergyStored(), (long)tile.getEnergyStorage().getMaxEnergyStored(), 5, "RF");
        return Lists.newArrayList((Object[])new String[]{TextFormatting.LIGHT_PURPLE + Lang.localise("gui.container.energy_stored") + TextFormatting.WHITE + " " + energy});
    }

    protected List<String> noEnergyInfo() {
        return Lists.newArrayList((Object[])new String[]{TextFormatting.RED + Lang.localise("gui.nc.container.no_energy")});
    }

    protected void drawEnergyTooltip(ITileEnergy tile, int mouseX, int mouseY, int x, int y, int width, int height) {
        this.drawTooltip(this.energyInfo(tile), mouseX, mouseY, x, y, width, height);
    }

    protected void drawNoEnergyTooltip(int mouseX, int mouseY, int x, int y, int width, int height) {
        this.drawTooltip(this.noEnergyInfo(), mouseX, mouseY, x, y, width, height);
    }

    protected int width(String string) {
        return this.field_146289_q.func_78256_a(string);
    }
}

