/*
 * Decompiled with CFR 0.152.
 */
package nc.gui.element;

import java.awt.Color;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.common.ForgeModContainer;

public class GuiItemRenderer {
    protected static final Minecraft MC = Minecraft.func_71410_x();
    @Nonnull
    protected final ItemStack stack;
    protected final int x;
    protected final int y;
    protected final float alpha;
    protected int width = 16;
    protected int height = 16;

    public GuiItemRenderer(@Nonnull ItemStack stack, int x, int y, float alpha) {
        this.stack = stack;
        this.x = x;
        this.y = y;
        this.alpha = alpha;
    }

    public GuiItemRenderer(@Nonnull Item item, int meta, int x, int y, float alpha) {
        this(new ItemStack(item, 1, meta), x, y, alpha);
    }

    public GuiItemRenderer size(int width, int height) {
        this.width = width;
        this.height = height;
        return this;
    }

    public void draw() {
        if (!this.stack.func_190926_b()) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)this.alpha);
            this.renderItem();
            this.renderItemOverlays();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    protected void renderItem() {
        GuiItemRenderer.MC.func_175599_af().field_77023_b += 50.0f;
        GlStateManager.func_179094_E();
        MC.func_110434_K().func_110577_a(TextureMap.field_110575_b);
        MC.func_110434_K().func_110581_b(TextureMap.field_110575_b).func_174936_b(false, false);
        GlStateManager.func_179091_B();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)this.alpha);
        IBakedModel model = MC.func_175599_af().func_184393_a(this.stack, null, null);
        this.setupGuiTransform(this.x, this.y, model.func_177556_c());
        model = ForgeHooksClient.handleCameraTransforms((IBakedModel)model, (ItemCameraTransforms.TransformType)ItemCameraTransforms.TransformType.GUI, (boolean)false);
        this.renderModelAndEffect(this.stack, model);
        GlStateManager.func_179101_C();
        GlStateManager.func_179140_f();
        GlStateManager.func_179121_F();
        MC.func_110434_K().func_110577_a(TextureMap.field_110575_b);
        MC.func_110434_K().func_110581_b(TextureMap.field_110575_b).func_174935_a();
        GuiItemRenderer.MC.func_175599_af().field_77023_b -= 50.0f;
    }

    protected void setupGuiTransform(int x, int y, boolean isGui3d) {
        GlStateManager.func_179109_b((float)x, (float)y, (float)(100.0f + GuiItemRenderer.MC.func_175599_af().field_77023_b));
        GlStateManager.func_179109_b((float)8.0f, (float)8.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)1.0f);
        GlStateManager.func_179152_a((float)this.width, (float)16.0f, (float)this.height);
        if (isGui3d) {
            GlStateManager.func_179145_e();
        } else {
            GlStateManager.func_179140_f();
        }
    }

    protected void renderModelAndEffect(ItemStack stack, IBakedModel model) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)-0.5f, (float)-0.5f, (float)-0.5f);
        if (model.func_188618_c()) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)this.alpha);
            GlStateManager.func_179091_B();
            stack.func_77973_b().getTileEntityItemStackRenderer().func_179022_a(stack);
        } else {
            this.renderModel(model, new Color(1.0f, 1.0f, 1.0f, this.alpha).getRGB(), stack);
            if (stack.func_77962_s()) {
                this.renderEffect(model);
            }
        }
        GlStateManager.func_179121_F();
    }

    protected void renderEffect(IBakedModel model) {
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179143_c((int)514);
        GlStateManager.func_179140_f();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
        MC.func_110434_K().func_110577_a(new ResourceLocation("textures/misc/enchanted_item_glint.png"));
        GlStateManager.func_179128_n((int)5890);
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)8.0f, (float)8.0f, (float)8.0f);
        float f = (float)(Minecraft.func_71386_F() % 3000L) / 24000.0f;
        GlStateManager.func_179109_b((float)f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)-50.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        this.renderModel(model, -8372020, ItemStack.field_190927_a);
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)8.0f, (float)8.0f, (float)8.0f);
        float f1 = (float)(Minecraft.func_71386_F() % 4873L) / 38984.0f;
        GlStateManager.func_179109_b((float)(-f1), (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)10.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        this.renderModel(model, -8372020, ItemStack.field_190927_a);
        GlStateManager.func_179121_F();
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179145_e();
        GlStateManager.func_179143_c((int)515);
        GlStateManager.func_179132_a((boolean)true);
        MC.func_110434_K().func_110577_a(TextureMap.field_110575_b);
    }

    protected void renderModel(IBakedModel model, int color, ItemStack stack) {
        if (ForgeModContainer.allowEmissiveItems) {
            ForgeHooksClient.renderLitItem((RenderItem)MC.func_175599_af(), (IBakedModel)model, (int)color, (ItemStack)stack);
            return;
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_176599_b);
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            MC.func_175599_af().func_191970_a(bufferbuilder, model.func_188616_a(null, facing, 0L), color, stack);
        }
        MC.func_175599_af().func_191970_a(bufferbuilder, model.func_188616_a(null, null, 0L), color, stack);
        tessellator.func_78381_a();
    }

    protected void renderItemOverlays() {
        if (!this.stack.func_190926_b()) {
            EntityPlayerSP player;
            float partialTicks;
            BufferBuilder bufferbuilder = Tessellator.func_178181_a().func_178180_c();
            GlStateManager.func_179140_f();
            GlStateManager.func_179097_i();
            GlStateManager.func_179090_x();
            if (this.stack.func_77973_b().showDurabilityBar(this.stack)) {
                GlStateManager.func_179084_k();
                int i = Math.round(13.0f * (1.0f - (float)this.stack.func_77973_b().getDurabilityForDisplay(this.stack)));
                int j = this.stack.func_77973_b().getRGBDurabilityForDisplay(this.stack);
                this.draw(bufferbuilder, this.x + 2, this.y + 13, 13, 2, 0, 0, 0, (int)(255.0 * (double)this.alpha));
                this.draw(bufferbuilder, this.x + 2, this.y + 13, i, 1, j >> 16 & 0xFF, j >> 8 & 0xFF, j & 0xFF, (int)(255.0 * (double)this.alpha));
                GlStateManager.func_179147_l();
            }
            float f = partialTicks = (player = Minecraft.func_71410_x().field_71439_g) == null ? 0.0f : player.func_184811_cZ().func_185143_a(this.stack.func_77973_b(), Minecraft.func_71410_x().func_184121_ak());
            if (partialTicks > 0.0f) {
                this.draw(bufferbuilder, this.x, this.y + MathHelper.func_76141_d((float)(16.0f * (1.0f - partialTicks))), 16, MathHelper.func_76123_f((float)(16.0f * partialTicks)), 255, 255, 255, (int)(127.0 * (double)this.alpha));
            }
            GlStateManager.func_179098_w();
            GlStateManager.func_179145_e();
            GlStateManager.func_179126_j();
        }
    }

    protected void draw(BufferBuilder bufferbuilder, int x, int y, int width, int height, int red, int green, int blue, int alpha) {
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        bufferbuilder.func_181662_b((double)x, (double)y, 0.0).func_181669_b(red, green, blue, alpha).func_181675_d();
        bufferbuilder.func_181662_b((double)x, (double)(y + height), 0.0).func_181669_b(red, green, blue, alpha).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_181669_b(red, green, blue, alpha).func_181675_d();
        bufferbuilder.func_181662_b((double)(x + width), (double)y, 0.0).func_181669_b(red, green, blue, alpha).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
    }
}

