/*
 * Decompiled with CFR 0.152.
 */
package nc.init;

import java.util.ArrayList;
import java.util.List;
import nc.ModCheck;
import nc.NuclearCraft;
import nc.block.fluid.NCBlockFluid;
import nc.block.item.NCItemBlock;
import nc.config.NCConfig;
import nc.enumm.FluidType;
import nc.util.ColorHelper;
import nc.util.NCUtil;
import net.minecraft.block.Block;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.tuple.Pair;

public class NCFluids {
    public static List<Pair<Fluid, NCBlockFluid>> fluidPairList = new ArrayList<Pair<Fluid, NCBlockFluid>>();

    public static void init() {
        NCFluids.addFluidPair(FluidType.GAS, "oxygen", 8293576);
        NCFluids.addFluidPair(FluidType.GAS, "hydrogen", 11762372);
        NCFluids.addFluidPair(FluidType.GAS, "deuterium", 10383343);
        NCFluids.addFluidPair(FluidType.GAS, "tritium", 6142934);
        NCFluids.addFluidPair(FluidType.GAS, "helium_3", 13351783);
        NCFluids.addFluidPair(FluidType.GAS, "helium", 12942209);
        NCFluids.addFluidPair(FluidType.MOLTEN, "boron_10", 0x7D7D7D);
        NCFluids.addFluidPair(FluidType.MOLTEN, "boron_11", 0x7D7D7D);
        NCFluids.addFluidPair(FluidType.MOLTEN, "lithium_6", 0xEFEFEF);
        NCFluids.addFluidPair(FluidType.MOLTEN, "lithium_7", 0xEFEFEF);
        NCFluids.addFluidPair(FluidType.MOLTEN, "steel", 0x7B7B7B);
        NCFluids.addFluidPair(FluidType.MOLTEN, "ferroboron", 0x4A4A4A);
        NCFluids.addFluidPair(FluidType.MOLTEN, "tough", 1380129);
        NCFluids.addFluidPair(FluidType.MOLTEN, "hard_carbon", 1661296);
        if (NCFluids.registerCoFHAlt()) {
            NCFluids.addFluidPair(FluidType.MOLTEN, "coal", 0x202020);
        }
        NCFluids.addFluidPair(FluidType.MOLTEN, "beryllium", 13949890);
        NCFluids.addFluidPair(FluidType.MOLTEN, "zirconium", 14737592);
        NCFluids.addFluidPair(FluidType.MOLTEN, "manganese_dioxide", 2629918);
        NCFluids.addFluidPair(FluidType.MOLTEN, "sulfur", 14605946);
        NCFluids.addFluidPair(FluidType.SUPERFLUID, "liquid_helium");
        NCFluids.addFluidPair(FluidType.LIQUID, "liquid_nitrogen", false, 3260986, 810, 70, 170, 0);
        NCFluids.addFluidPair(FluidType.LIQUID, "heavy_water");
        if (NCFluids.registerCoFHAlt()) {
            NCFluids.addFluidPair(FluidType.LIQUID, "ender", true, 1333325, 4000, 300, 2500, 3);
        }
        NCFluids.addFluidPair(FluidType.MOLTEN, "lead_platinum", 4283232);
        NCFluids.addFluidPair(FluidType.MOLTEN, "enderium", 744284);
        if (NCFluids.registerCoFHAlt()) {
            NCFluids.addFluidPair(FluidType.CRYOTHEUM, "cryotheum", 39361);
        }
        NCFluids.addFluidPair(FluidType.PLASMA, "plasma");
        NCFluids.addFluidPair(FluidType.FLAMMABLE, "ethanol", 6639936);
        NCFluids.addFluidPair(FluidType.FLAMMABLE, "methanol", 7426636);
        NCFluids.addFluidPair(FluidType.LIQUID, "radaway");
        NCFluids.addFluidPair(FluidType.LIQUID, "radaway_slow");
        NCFluids.addFluidPair(FluidType.LIQUID, "redstone_ethanol");
        NCFluids.addFluidPair(FluidType.GAS, "nitrogen", 8176507);
        NCFluids.addFluidPair(FluidType.GAS, "fluorine", 13879133);
        NCFluids.addFluidPair(FluidType.GAS, "carbon_dioxide", 6054746);
        NCFluids.addFluidPair(FluidType.GAS, "carbon_monoxide", 5002825);
        NCFluids.addFluidPair(FluidType.GAS, "ethene", 16770211);
        NCFluids.addFluidPair(FluidType.GAS, "fluoromethane", 4344837);
        NCFluids.addFluidPair(FluidType.GAS, "ammonia", 8045472);
        NCFluids.addFluidPair(FluidType.GAS, "oxygen_difluoride", 15342337);
        NCFluids.addFluidPair(FluidType.GAS, "diborane", 13397644);
        NCFluids.addFluidPair(FluidType.GAS, "sulfur_dioxide", 12827770);
        NCFluids.addFluidPair(FluidType.GAS, "sulfur_trioxide", 13872733);
        NCFluids.addFluidPair(FluidType.ACID, "hydrofluoric_acid", 19461);
        NCFluids.addFluidPair(FluidType.ACID, "boric_acid", 0x696939);
        NCFluids.addFluidPair(FluidType.ACID, "sulfuric_acid", 0x454500);
        NCFluids.addFluidPair(FluidType.SALT_SOLUTION, "boron_nitride_solution", ColorHelper.waterBlend(7310940, 0.5f));
        NCFluids.addFluidPair(FluidType.SALT_SOLUTION, "fluorite_water", ColorHelper.waterBlend(9090194, 0.5f));
        NCFluids.addFluidPair(FluidType.SALT_SOLUTION, "calcium_sulfate_solution", ColorHelper.waterBlend(12103846, 0.5f));
        NCFluids.addFluidPair(FluidType.SALT_SOLUTION, "sodium_fluoride_solution", ColorHelper.waterBlend(12759457, 0.5f));
        NCFluids.addFluidPair(FluidType.SALT_SOLUTION, "potassium_fluoride_solution", ColorHelper.waterBlend(12700061, 0.5f));
        NCFluids.addFluidPair(FluidType.SALT_SOLUTION, "sodium_hydroxide_solution", ColorHelper.waterBlend(12761019, 0.5f));
        NCFluids.addFluidPair(FluidType.SALT_SOLUTION, "potassium_hydroxide_solution", ColorHelper.waterBlend(12109488, 0.5f));
        NCFluids.addFluidPair(FluidType.SALT_SOLUTION, "borax_solution", ColorHelper.waterBlend(0xEEEEEE, 0.5f));
        NCFluids.addFluidPair(FluidType.SALT_SOLUTION, "irradiated_borax_solution", ColorHelper.waterBlend(16765091, 0.5f));
        NCFluids.addFluidPair(FluidType.CORIUM, "corium", 8158319);
        NCFluids.addFluidPair(FluidType.LIQUID, "ice", false, 0xAFF1FF, 1000, 250, 2000, 0);
        NCFluids.addFluidPair(FluidType.LIQUID, "slurry_ice", false, 8302263, 950, 270, 4000, 0);
        NCFluids.addFluidPair(FluidType.CHOCOLATE, "chocolate_liquor", 4269084);
        NCFluids.addFluidPair(FluidType.CHOCOLATE, "cocoa_butter", 16182975);
        NCFluids.addFluidPair(FluidType.CHOCOLATE, "unsweetened_chocolate", 2886152);
        NCFluids.addFluidPair(FluidType.CHOCOLATE, "dark_chocolate", 2886406);
        NCFluids.addFluidPair(FluidType.CHOCOLATE, "milk_chocolate", 8929569);
        NCFluids.addFluidPair(FluidType.SUGAR, "sugar", 16766362);
        NCFluids.addFluidPair(FluidType.SUGAR, "gelatin", 14536860);
        NCFluids.addFluidPair(FluidType.SUGAR, "hydrated_gelatin", ColorHelper.waterBlend(14536860, 0.8f));
        NCFluids.addFluidPair(FluidType.CHOCOLATE, "marshmallow", 0xE1E1E3);
        NCFluids.addFluidPair(FluidType.LIQUID, "milk");
        NCFluids.addFluidPair(FluidType.MOLTEN, "lif", 0xCDCDCB);
        NCFluids.addFluidPair(FluidType.MOLTEN, "bef2", 12502698);
        NCFluids.addFluidPair(FluidType.MOLTEN, "flibe", 12699824);
        NCFluids.addFluidPair(FluidType.MOLTEN, "naoh", 12761019);
        NCFluids.addFluidPair(FluidType.MOLTEN, "koh", 12109488);
        if (NCFluids.registerCoFHAlt()) {
            NCFluids.addFluidPair(FluidType.STEAM, "steam", 0x929292, 800);
        }
        NCFluids.addFluidPair(FluidType.STEAM, "high_pressure_steam", 0xBDBDBD, 1200);
        NCFluids.addFluidPair(FluidType.STEAM, "exhaust_steam", 0x7E7E7E, 500);
        NCFluids.addFluidPair(FluidType.STEAM, "low_pressure_steam", 0xA8A8A8, 800);
        NCFluids.addFluidPair(FluidType.STEAM, "low_quality_steam", 0x828282, 350);
        NCFluids.addFluidPair(FluidType.LIQUID, "preheated_water", false, 3097588, 1000, 400, 250, 0);
        NCFluids.addFluidPair(FluidType.LIQUID, "condensate_water", false, 3097588, 1000, 300, 850, 0);
        NCFluids.addFluidPair(FluidType.MOLTEN, "sodium", 12683660);
        NCFluids.addFluidPair(FluidType.MOLTEN, "potassium", 12109059);
        NCFluids.addFluidPair(FluidType.COOLANT, "nak", 16770492);
        NCFluids.addFluidPair(FluidType.HOT_COOLANT, "nak_hot", 16766380);
        NCFluids.addFluidPair(FluidType.LIQUID, "emergency_coolant", true, 7196903, 2000, 100, 2000, 3);
        NCFluids.addFluidPair(FluidType.LIQUID, "emergency_coolant_heated", true, 13483751, 2000, 300, 1500, 9);
        NCFluids.addFluidPair(FluidType.HOT_GAS, "arsenic", 8488053);
        NCFluids.addFluidPair(FluidType.MOLTEN, "bas", 0x9B9B89);
        NCFluids.addFluidPair(FluidType.HOT_GAS, "sic_vapor", 7894122);
        NCFluids.addFluidPair(FluidType.MOLTEN, "alugentum", 11913675);
        NCFluids.addFluidPair(FluidType.MOLTEN, "alumina", 9541760);
        NCFluids.addFluidPair(FluidType.FISSION, "strontium_90", 0xB8BE88);
        NCFluids.addFluidPair(FluidType.FISSION, "molybdenum", 12371428);
        NCFluids.addFluidPair(FluidType.FISSION, "ruthenium_106", 0xA3A3A3);
        NCFluids.addFluidPair(FluidType.FISSION, "caesium_137", 0xADADAD);
        NCFluids.addFluidPair(FluidType.FISSION, "promethium_147", 9879961);
        NCFluids.addFluidPair(FluidType.FISSION, "europium_155", 7628362);
    }

    private static <T extends Fluid, V extends NCBlockFluid> void addFluidPair(FluidType fluidType, Object ... fluidArgs) {
        try {
            Fluid fluid = (Fluid)NCUtil.newInstance(fluidType.getFluidClass(), fluidArgs);
            NCBlockFluid block = (NCBlockFluid)((Object)NCUtil.newInstance(fluidType.getBlockClass(), fluid));
            fluidPairList.add((Pair<Fluid, NCBlockFluid>)Pair.of((Object)fluid, (Object)((Object)block)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void register() {
        for (Pair<Fluid, NCBlockFluid> fluidPair : fluidPairList) {
            Fluid fluid = (Fluid)fluidPair.getLeft();
            if (!FluidRegistry.registerFluid((Fluid)fluid)) {
                fluid = FluidRegistry.getFluid((String)fluid.getName());
            }
            FluidRegistry.addBucketForFluid((Fluid)fluid);
            NCBlockFluid fluidBlock = (NCBlockFluid)((Object)fluidPair.getRight());
            if (fluidBlock == null) continue;
            NCFluids.registerBlock(fluidBlock);
        }
    }

    private static void registerBlock(NCBlockFluid block) {
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)NCFluids.withName(block));
        ForgeRegistries.ITEMS.register(new NCItemBlock((Block)block, TextFormatting.AQUA, new String[0]).setRegistryName(block.getRegistryName()));
        NuclearCraft.proxy.registerFluidBlockRendering((Block)block, block.name);
    }

    private static <T extends NCBlockFluid> Block withName(T block) {
        return (Block)block.func_149663_c("nuclearcraft." + block.name).setRegistryName(new ResourceLocation("nuclearcraft", block.name));
    }

    private static boolean registerCoFHAlt() {
        return NCConfig.register_cofh_fluids || !ModCheck.thermalFoundationLoaded();
    }
}

