/*
 * Decompiled with CFR 0.152.
 */
package nc.integration.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import java.util.ArrayList;
import java.util.List;
import nc.integration.crafttweaker.CTHelper;
import nc.recipe.BasicRecipe;
import nc.recipe.BasicRecipeHandler;
import nc.recipe.RecipeHelper;
import nc.recipe.ingredient.IFluidIngredient;
import nc.recipe.ingredient.IIngredient;
import nc.recipe.ingredient.IItemIngredient;
import net.minecraft.item.ItemStack;

public class CTAddRecipe
implements IAction {
    protected static boolean errored = false;
    protected final BasicRecipeHandler recipeHandler;
    protected BasicRecipe recipe;
    protected final List<IItemIngredient> itemIngredients = new ArrayList<IItemIngredient>();
    protected final List<IFluidIngredient> fluidIngredients = new ArrayList<IFluidIngredient>();
    protected final List<IItemIngredient> itemProducts = new ArrayList<IItemIngredient>();
    protected final List<IFluidIngredient> fluidProducts = new ArrayList<IFluidIngredient>();
    protected final List extras = new ArrayList();
    protected boolean nullInputs = true;
    protected boolean nullIngredient;
    protected boolean nullRecipe;
    protected boolean wrongSize;

    public CTAddRecipe(BasicRecipeHandler recipeHandler, List objects) {
        this.recipeHandler = recipeHandler;
        for (int count = 0; count < objects.size(); ++count) {
            IIngredient<ItemStack> ingredient;
            Object object = objects.get(count);
            if (count < recipeHandler.getItemInputSize()) {
                if (object != null) {
                    if (!(object instanceof crafttweaker.api.item.IIngredient)) {
                        this.nullIngredient = true;
                        return;
                    }
                    this.nullInputs = false;
                }
                if ((ingredient = CTHelper.buildAdditionItemIngredient((crafttweaker.api.item.IIngredient)object)) == null) {
                    this.nullIngredient = true;
                    return;
                }
                this.itemIngredients.add((IItemIngredient)ingredient);
                continue;
            }
            if (count < recipeHandler.getItemInputSize() + recipeHandler.getFluidInputSize()) {
                if (object != null) {
                    if (!(object instanceof crafttweaker.api.item.IIngredient)) {
                        this.nullIngredient = true;
                        return;
                    }
                    this.nullInputs = false;
                }
                if ((ingredient = CTHelper.buildAdditionFluidIngredient((crafttweaker.api.item.IIngredient)object)) == null) {
                    this.nullIngredient = true;
                    return;
                }
                this.fluidIngredients.add((IFluidIngredient)ingredient);
                continue;
            }
            if (count < recipeHandler.getItemInputSize() + recipeHandler.getFluidInputSize() + recipeHandler.getItemOutputSize()) {
                if (object != null && !(object instanceof crafttweaker.api.item.IIngredient)) {
                    this.nullIngredient = true;
                    return;
                }
                ingredient = CTHelper.buildAdditionItemIngredient((crafttweaker.api.item.IIngredient)object);
                if (ingredient == null) {
                    this.nullIngredient = true;
                    return;
                }
                this.itemProducts.add((IItemIngredient)ingredient);
                continue;
            }
            if (count < recipeHandler.getItemInputSize() + recipeHandler.getFluidInputSize() + recipeHandler.getItemOutputSize() + recipeHandler.getFluidOutputSize()) {
                if (object != null && !(object instanceof crafttweaker.api.item.IIngredient)) {
                    this.nullIngredient = true;
                    return;
                }
                ingredient = CTHelper.buildAdditionFluidIngredient((crafttweaker.api.item.IIngredient)object);
                if (ingredient == null) {
                    this.nullIngredient = true;
                    return;
                }
                this.fluidProducts.add((IFluidIngredient)ingredient);
                continue;
            }
            this.extras.add(object);
        }
        if (this.itemIngredients.size() != recipeHandler.getItemInputSize() || this.fluidIngredients.size() != recipeHandler.getFluidInputSize() || this.itemProducts.size() != recipeHandler.getItemOutputSize() || this.fluidProducts.size() != recipeHandler.getFluidOutputSize()) {
            CraftTweakerAPI.logError((String)("A " + recipeHandler.getName() + " recipe addition had the wrong size: " + RecipeHelper.getRecipeString(this.itemIngredients, this.fluidIngredients, this.itemProducts, this.fluidProducts)));
            this.wrongSize = true;
            return;
        }
        this.recipe = recipeHandler.buildRecipe(this.itemIngredients, this.fluidIngredients, this.itemProducts, this.fluidProducts, this.extras, recipeHandler.isShapeless());
        if (this.recipe == null) {
            this.nullRecipe = true;
        }
    }

    public void apply() {
        if (!this.isError()) {
            this.recipeHandler.addRecipe(this.recipe);
        }
    }

    public String describe() {
        String recipeString = RecipeHelper.getRecipeString(this.itemIngredients, this.fluidIngredients, this.itemProducts, this.fluidProducts);
        if (!this.isError()) {
            return "Adding " + this.recipeHandler.getName() + " recipe: " + recipeString;
        }
        CTAddRecipe.callError();
        String out = "Failed to add " + this.recipeHandler.getName() + " recipe " + recipeString;
        if (this.nullInputs) {
            return out + " as all ingredients were null";
        }
        if (this.nullIngredient) {
            return out + " as one or more ingredients had no match";
        }
        return out;
    }

    protected boolean isError() {
        return this.nullInputs || this.nullIngredient || this.nullRecipe || this.wrongSize;
    }

    protected static void callError() {
        if (!errored) {
            errored = true;
            CraftTweakerAPI.logError((String)"At least one NuclearCraft recipe addition method has errored. Check the log for more details");
        }
    }
}

