/*
 * Decompiled with CFR 0.152.
 */
package nc.integration.crafttweaker;

import com.google.common.collect.Lists;
import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import nc.integration.crafttweaker.CTAddRecipe;
import nc.integration.crafttweaker.CTClearRecipes;
import nc.integration.crafttweaker.CTRemoveRecipe;
import nc.recipe.BasicRecipeHandler;
import nc.recipe.IngredientSorption;
import nc.recipe.NCRecipes;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

public class CTRecipes {

    @ZenClass(value="mods.nuclearcraft.RadiationBlockPurification")
    @ZenRegister
    public static class RadiationBlockPurificationMethods {
        @ZenMethod
        public static BasicRecipeHandler getRecipeHandler() {
            return NCRecipes.radiation_block_purification;
        }

        @ZenMethod
        public static void addRecipe(IIngredient input, IIngredient output, double radiationThreshold) {
            CraftTweakerAPI.apply((IAction)new CTAddRecipe(NCRecipes.radiation_block_purification, Lists.newArrayList((Object[])new Object[]{input, output, radiationThreshold})));
        }

        @ZenMethod
        public static void removeRecipeWithInput(IIngredient input) {
            CraftTweakerAPI.apply((IAction)new CTRemoveRecipe(NCRecipes.radiation_block_purification, IngredientSorption.INPUT, Lists.newArrayList((Object[])new IIngredient[]{input})));
        }

        @ZenMethod
        public static void removeRecipeWithOutput(IIngredient output) {
            CraftTweakerAPI.apply((IAction)new CTRemoveRecipe(NCRecipes.radiation_block_purification, IngredientSorption.OUTPUT, Lists.newArrayList((Object[])new IIngredient[]{output})));
        }

        @ZenMethod
        public static void removeAllRecipes() {
            CraftTweakerAPI.apply((IAction)new CTClearRecipes(NCRecipes.radiation_block_purification));
        }
    }

    @ZenClass(value="mods.nuclearcraft.RadiationBlockMutation")
    @ZenRegister
    public static class RadiationBlockMutationMethods {
        @ZenMethod
        public static BasicRecipeHandler getRecipeHandler() {
            return NCRecipes.radiation_block_mutation;
        }

        @ZenMethod
        public static void addRecipe(IIngredient input, IIngredient output, double radiationThreshold) {
            CraftTweakerAPI.apply((IAction)new CTAddRecipe(NCRecipes.radiation_block_mutation, Lists.newArrayList((Object[])new Object[]{input, output, radiationThreshold})));
        }

        @ZenMethod
        public static void removeRecipeWithInput(IIngredient input) {
            CraftTweakerAPI.apply((IAction)new CTRemoveRecipe(NCRecipes.radiation_block_mutation, IngredientSorption.INPUT, Lists.newArrayList((Object[])new IIngredient[]{input})));
        }

        @ZenMethod
        public static void removeRecipeWithOutput(IIngredient output) {
            CraftTweakerAPI.apply((IAction)new CTRemoveRecipe(NCRecipes.radiation_block_mutation, IngredientSorption.OUTPUT, Lists.newArrayList((Object[])new IIngredient[]{output})));
        }

        @ZenMethod
        public static void removeAllRecipes() {
            CraftTweakerAPI.apply((IAction)new CTClearRecipes(NCRecipes.radiation_block_mutation));
        }
    }

    @ZenClass(value="mods.nuclearcraft.RadiationScrubber")
    @ZenRegister
    public static class RadiationScrubberMethods {
        @ZenMethod
        public static BasicRecipeHandler getRecipeHandler() {
            return NCRecipes.radiation_scrubber;
        }

        @ZenMethod
        public static void addRecipe(IIngredient input1, IIngredient input2, IIngredient output1, IIngredient output2, int processTime, int processPower, double processEfficiency) {
            CraftTweakerAPI.apply((IAction)new CTAddRecipe(NCRecipes.radiation_scrubber, Lists.newArrayList((Object[])new Object[]{input1, input2, output1, output2, processTime, processPower, processEfficiency})));
        }

        @ZenMethod
        public static void removeRecipeWithInput(IIngredient input1, IIngredient input2) {
            CraftTweakerAPI.apply((IAction)new CTRemoveRecipe(NCRecipes.radiation_scrubber, IngredientSorption.INPUT, Lists.newArrayList((Object[])new IIngredient[]{input1, input2})));
        }

        @ZenMethod
        public static void removeRecipeWithOutput(IIngredient output1, IIngredient output2) {
            CraftTweakerAPI.apply((IAction)new CTRemoveRecipe(NCRecipes.radiation_scrubber, IngredientSorption.OUTPUT, Lists.newArrayList((Object[])new IIngredient[]{output1, output2})));
        }

        @ZenMethod
        public static void removeAllRecipes() {
            CraftTweakerAPI.apply((IAction)new CTClearRecipes(NCRecipes.radiation_scrubber));
        }
    }

    @ZenClass(value="mods.nuclearcraft.Turbine")
    @ZenRegister
    public static class TurbineMethods {
        @ZenMethod
        public static BasicRecipeHandler getRecipeHandler() {
            return NCRecipes.turbine;
        }

        @ZenMethod
        public static void addRecipe(IIngredient input, IIngredient output, double powerPerMB, double expansionLevel, double spinUpMultiplier, @Optional(value="cloud") String particleEffect, @Optional(valueDouble=0.04310344827586207) double particleSpeedMultiplier) {
            CraftTweakerAPI.apply((IAction)new CTAddRecipe(NCRecipes.turbine, Lists.newArrayList((Object[])new Object[]{input, output, powerPerMB, expansionLevel, spinUpMultiplier, particleEffect, particleSpeedMultiplier})));
        }

        @ZenMethod
        public static void removeRecipeWithInput(IIngredient input) {
            CraftTweakerAPI.apply((IAction)new CTRemoveRecipe(NCRecipes.turbine, IngredientSorption.INPUT, Lists.newArrayList((Object[])new IIngredient[]{input})));
        }

        @ZenMethod
        public static void removeRecipeWithOutput(IIngredient output) {
            CraftTweakerAPI.apply((IAction)new CTRemoveRecipe(NCRecipes.turbine, IngredientSorption.OUTPUT, Lists.newArrayList((Object[])new IIngredient[]{output})));
        }

        @ZenMethod
        public static void removeAllRecipes() {
            CraftTweakerAPI.apply((IAction)new CTClearRecipes(NCRecipes.turbine));
        }
    }

    @ZenClass(value="mods.nuclearcraft.Condenser")
    @ZenRegister
    public static class CondenserMethods {
        @ZenMethod
        public static BasicRecipeHandler getRecipeHandler() {
            return NCRecipes.condenser;
        }

        @ZenMethod
        public static void addRecipe(IIngredient input, IIngredient output, int coolingRequired, int condensingTemperature) {
            CraftTweakerAPI.apply((IAction)new CTAddRecipe(NCRecipes.condenser, Lists.newArrayList((Object[])new Object[]{input, output, coolingRequired, condensingTemperature})));
        }

        @ZenMethod
        public static void removeRecipeWithInput(IIngredient input) {
            CraftTweakerAPI.apply((IAction)new CTRemoveRecipe(NCRecipes.condenser, IngredientSorption.INPUT, Lists.newArrayList((Object[])new IIngredient[]{input})));
        }

        @ZenMethod
        public static void removeRecipeWithOutput(IIngredient output) {
            CraftTweakerAPI.apply((IAction)new CTRemoveRecipe(NCRecipes.condenser, IngredientSorption.OUTPUT, Lists.newArrayList((Object[])new IIngredient[]{output})));
        }

        @ZenMethod
        public static void removeAllRecipes() {
            CraftTweakerAPI.apply((IAction)new CTClearRecipes(NCRecipes.condenser));
        }
    }

    @ZenClass(value="mods.nuclearcraft.HeatExchanger")
    @ZenRegister
    public static class HeatExchangerMethods {
        @ZenMethod
        public static BasicRecipeHandler getRecipeHandler() {
            return NCRecipes.heat_exchanger;
        }

        @ZenMethod
        public static void addRecipe(IIngredient input, IIngredient output, int heatRequired, int temperatureIn, int temperatureOut) {
            CraftTweakerAPI.apply((IAction)new CTAddRecipe(NCRecipes.heat_exchanger, Lists.newArrayList((Object[])new Object[]{input, output, heatRequired, temperatureIn, temperatureOut})));
        }

        @ZenMethod
        public static void removeRecipeWithInput(IIngredient input) {
            CraftTweakerAPI.apply((IAction)new CTRemoveRecipe(NCRecipes.heat_exchanger, IngredientSorption.INPUT, Lists.newArrayList((Object[])new IIngredient[]{input})));
        }

        @ZenMethod
        public static void removeRecipeWithOutput(IIngredient output) {
            CraftTweakerAPI.apply((IAction)new CTRemoveRecipe(NCRecipes.heat_exchanger, IngredientSorption.OUTPUT, Lists.newArrayList((Object[])new IIngredient[]{output})));
        }

        @ZenMethod
        public static void removeAllRecipes() {
            CraftTweakerAPI.apply((IAction)new CTClearRecipes(NCRecipes.heat_exchanger));
        }
    }

    @ZenClass(value="mods.nuclearcraft.Fusion")
    @ZenRegister
    public static class FusionMethods {
        @ZenMethod
        public static BasicRecipeHandler getRecipeHandler() {
            return NCRecipes.fusion;
        }

        @ZenMethod
        public static void addRecipe(IIngredient input1, IIngredient input2, IIngredient output1, IIngredient output2, IIngredient output3, IIngredient output4, int time, int power, int optimalTemp, double radiation) {
            CraftTweakerAPI.apply((IAction)new CTAddRecipe(NCRecipes.fusion, Lists.newArrayList((Object[])new Object[]{input1, input2, output1, output2, output3, output4, time, power, optimalTemp, radiation})));
        }

        @ZenMethod
        public static void removeRecipeWithInput(IIngredient input1, IIngredient input2) {
            CraftTweakerAPI.apply((IAction)new CTRemoveRecipe(NCRecipes.fusion, IngredientSorption.INPUT, Lists.newArrayList((Object[])new IIngredient[]{input1, input2})));
        }

        @ZenMethod
        public static void removeRecipeWithOutput(IIngredient output1, IIngredient output2, IIngredient output3, IIngredient output4) {
            CraftTweakerAPI.apply((IAction)new CTRemoveRecipe(NCRecipes.fusion, IngredientSorption.OUTPUT, Lists.newArrayList((Object[])new IIngredient[]{output1, output2, output3, output4})));
        }

        @ZenMethod
        public static void removeAllRecipes() {
            CraftTweakerAPI.apply((IAction)new CTClearRecipes(NCRecipes.fusion));
        }
    }

    @ZenClass(value="mods.nuclearcraft.FissionEmergencyCooling")
    @ZenRegister
    public static class FissionEmergencyCoolingMethods {
        @ZenMethod
        public static BasicRecipeHandler getRecipeHandler() {
            return NCRecipes.fission_emergency_cooling;
        }

        @ZenMethod
        public static void addRecipe(IIngredient input, IIngredient output, int coolingPerInputMB) {
            CraftTweakerAPI.apply((IAction)new CTAddRecipe(NCRecipes.fission_emergency_cooling, Lists.newArrayList((Object[])new Object[]{input, output, coolingPerInputMB})));
        }

        @ZenMethod
        public static void removeRecipeWithInput(IIngredient input) {
            CraftTweakerAPI.apply((IAction)new CTRemoveRecipe(NCRecipes.fission_emergency_cooling, IngredientSorption.INPUT, Lists.newArrayList((Object[])new IIngredient[]{input})));
        }

        @ZenMethod
        public static void removeRecipeWithOutput(IIngredient output) {
            CraftTweakerAPI.apply((IAction)new CTRemoveRecipe(NCRecipes.fission_emergency_cooling, IngredientSorption.OUTPUT, Lists.newArrayList((Object[])new IIngredient[]{output})));
        }

        @ZenMethod
        public static void removeAllRecipes() {
            CraftTweakerAPI.apply((IAction)new CTClearRecipes(NCRecipes.fission_emergency_cooling));
        }
    }

    @ZenClass(value="mods.nuclearcraft.SaltFission")
    @ZenRegister
    public static class SaltFissionMethods {
        @ZenMethod
        public static BasicRecipeHandler getRecipeHandler() {
            return NCRecipes.salt_fission;
        }

        @ZenMethod
        public static void addRecipe(IIngredient input, IIngredient output, double time, int heat, double efficiency, int criticality, double decayFactor, boolean selfPriming, double radiation) {
            CraftTweakerAPI.apply((IAction)new CTAddRecipe(NCRecipes.salt_fission, Lists.newArrayList((Object[])new Object[]{input, output, time, heat, efficiency, criticality, decayFactor, selfPriming, radiation})));
        }

        @ZenMethod
        public static void removeRecipeWithInput(IIngredient input) {
            CraftTweakerAPI.apply((IAction)new CTRemoveRecipe(NCRecipes.salt_fission, IngredientSorption.INPUT, Lists.newArrayList((Object[])new IIngredient[]{input})));
        }

        @ZenMethod
        public static void removeRecipeWithOutput(IIngredient output) {
            CraftTweakerAPI.apply((IAction)new CTRemoveRecipe(NCRecipes.salt_fission, IngredientSorption.OUTPUT, Lists.newArrayList((Object[])new IIngredient[]{output})));
        }

        @ZenMethod
        public static void removeAllRecipes() {
            CraftTweakerAPI.apply((IAction)new CTClearRecipes(NCRecipes.salt_fission));
        }
    }

    @ZenClass(value="mods.nuclearcraft.FissionHeating")
    @ZenRegister
    public static class FissionHeatingMethods {
        @ZenMethod
        public static BasicRecipeHandler getRecipeHandler() {
            return NCRecipes.fission_heating;
        }

        @ZenMethod
        public static void addRecipe(IIngredient input, IIngredient output, int heatPerInputMB) {
            CraftTweakerAPI.apply((IAction)new CTAddRecipe(NCRecipes.fission_heating, Lists.newArrayList((Object[])new Object[]{input, output, heatPerInputMB})));
        }

        @ZenMethod
        public static void removeRecipeWithInput(IIngredient input) {
            CraftTweakerAPI.apply((IAction)new CTRemoveRecipe(NCRecipes.fission_heating, IngredientSorption.INPUT, Lists.newArrayList((Object[])new IIngredient[]{input})));
        }

        @ZenMethod
        public static void removeRecipeWithOutput(IIngredient output) {
            CraftTweakerAPI.apply((IAction)new CTRemoveRecipe(NCRecipes.fission_heating, IngredientSorption.OUTPUT, Lists.newArrayList((Object[])new IIngredient[]{output})));
        }

        @ZenMethod
        public static void removeAllRecipes() {
            CraftTweakerAPI.apply((IAction)new CTClearRecipes(NCRecipes.fission_heating));
        }
    }

    @ZenClass(value="mods.nuclearcraft.SolidFission")
    @ZenRegister
    public static class SolidFissionMethods {
        @ZenMethod
        public static BasicRecipeHandler getRecipeHandler() {
            return NCRecipes.solid_fission;
        }

        @ZenMethod
        public static void addRecipe(IIngredient input, IIngredient output, int time, int heat, double efficiency, int criticality, double decayFactor, boolean selfPriming, double radiation) {
            CraftTweakerAPI.apply((IAction)new CTAddRecipe(NCRecipes.solid_fission, Lists.newArrayList((Object[])new Object[]{input, output, time, heat, efficiency, criticality, decayFactor, selfPriming, radiation})));
        }

        @ZenMethod
        public static void removeRecipeWithInput(IIngredient input) {
            CraftTweakerAPI.apply((IAction)new CTRemoveRecipe(NCRecipes.solid_fission, IngredientSorption.INPUT, Lists.newArrayList((Object[])new IIngredient[]{input})));
        }

        @ZenMethod
        public static void removeRecipeWithOutput(IIngredient output) {
            CraftTweakerAPI.apply((IAction)new CTRemoveRecipe(NCRecipes.solid_fission, IngredientSorption.OUTPUT, Lists.newArrayList((Object[])new IIngredient[]{output})));
        }

        @ZenMethod
        public static void removeAllRecipes() {
            CraftTweakerAPI.apply((IAction)new CTClearRecipes(NCRecipes.solid_fission));
        }
    }

    @ZenClass(value="mods.nuclearcraft.PebbleFission")
    @ZenRegister
    public static class PebbleFissionMethods {
        @ZenMethod
        public static BasicRecipeHandler getRecipeHandler() {
            return NCRecipes.pebble_fission;
        }

        @ZenMethod
        public static void addRecipe(IIngredient input, IIngredient output, int time, int heat, double efficiency, int criticality, double decayFactor, boolean selfPriming, double radiation) {
            CraftTweakerAPI.apply((IAction)new CTAddRecipe(NCRecipes.pebble_fission, Lists.newArrayList((Object[])new Object[]{input, output, time, heat, efficiency, criticality, decayFactor, selfPriming, radiation})));
        }

        @ZenMethod
        public static void removeRecipeWithInput(IIngredient input) {
            CraftTweakerAPI.apply((IAction)new CTRemoveRecipe(NCRecipes.pebble_fission, IngredientSorption.INPUT, Lists.newArrayList((Object[])new IIngredient[]{input})));
        }

        @ZenMethod
        public static void removeRecipeWithOutput(IIngredient output) {
            CraftTweakerAPI.apply((IAction)new CTRemoveRecipe(NCRecipes.pebble_fission, IngredientSorption.OUTPUT, Lists.newArrayList((Object[])new IIngredient[]{output})));
        }

        @ZenMethod
        public static void removeAllRecipes() {
            CraftTweakerAPI.apply((IAction)new CTClearRecipes(NCRecipes.pebble_fission));
        }
    }

    @ZenClass(value="mods.nuclearcraft.FissionIrradiator")
    @ZenRegister
    public static class FissionIrradiatorMethods {
        @ZenMethod
        public static BasicRecipeHandler getRecipeHandler() {
            return NCRecipes.fission_irradiator;
        }

        @ZenMethod
        public static void addRecipe(IIngredient input, IIngredient output, int fluxRequired, double heatPerFlux, double efficiency, double radiation) {
            CraftTweakerAPI.apply((IAction)new CTAddRecipe(NCRecipes.fission_irradiator, Lists.newArrayList((Object[])new Object[]{input, output, fluxRequired, heatPerFlux, efficiency, radiation})));
        }

        @ZenMethod
        public static void removeRecipeWithInput(IIngredient input) {
            CraftTweakerAPI.apply((IAction)new CTRemoveRecipe(NCRecipes.fission_irradiator, IngredientSorption.INPUT, Lists.newArrayList((Object[])new IIngredient[]{input})));
        }

        @ZenMethod
        public static void removeRecipeWithOutput(IIngredient output) {
            CraftTweakerAPI.apply((IAction)new CTRemoveRecipe(NCRecipes.fission_irradiator, IngredientSorption.OUTPUT, Lists.newArrayList((Object[])new IIngredient[]{output})));
        }

        @ZenMethod
        public static void removeAllRecipes() {
            CraftTweakerAPI.apply((IAction)new CTClearRecipes(NCRecipes.fission_irradiator));
        }
    }

    @ZenClass(value="mods.nuclearcraft.FissionReflector")
    @ZenRegister
    public static class FissionReflectorMethods {
        @ZenMethod
        public static BasicRecipeHandler getRecipeHandler() {
            return NCRecipes.fission_reflector;
        }

        @ZenMethod
        public static void add(IIngredient input, double efficiency, double reflectivity) {
            CraftTweakerAPI.apply((IAction)new CTAddRecipe(NCRecipes.fission_reflector, Lists.newArrayList((Object[])new Object[]{input, efficiency, reflectivity})));
        }

        @ZenMethod
        public static void remove(IIngredient input) {
            CraftTweakerAPI.apply((IAction)new CTRemoveRecipe(NCRecipes.fission_reflector, IngredientSorption.INPUT, Lists.newArrayList((Object[])new IIngredient[]{input})));
        }

        @ZenMethod
        public static void removeAll() {
            CraftTweakerAPI.apply((IAction)new CTClearRecipes(NCRecipes.fission_reflector));
        }
    }

    @ZenClass(value="mods.nuclearcraft.FissionModerator")
    @ZenRegister
    public static class FissionModeratorMethods {
        @ZenMethod
        public static BasicRecipeHandler getRecipeHandler() {
            return NCRecipes.fission_moderator;
        }

        @ZenMethod
        public static void add(IIngredient input, int fluxFactor, double efficiency) {
            CraftTweakerAPI.apply((IAction)new CTAddRecipe(NCRecipes.fission_moderator, Lists.newArrayList((Object[])new Object[]{input, fluxFactor, efficiency})));
        }

        @ZenMethod
        public static void remove(IIngredient input) {
            CraftTweakerAPI.apply((IAction)new CTRemoveRecipe(NCRecipes.fission_moderator, IngredientSorption.INPUT, Lists.newArrayList((Object[])new IIngredient[]{input})));
        }

        @ZenMethod
        public static void removeAll() {
            CraftTweakerAPI.apply((IAction)new CTClearRecipes(NCRecipes.fission_moderator));
        }
    }

    @ZenClass(value="mods.nuclearcraft.DecayGenerator")
    @ZenRegister
    public static class DecayGeneratorMethods {
        @ZenMethod
        public static BasicRecipeHandler getRecipeHandler() {
            return NCRecipes.decay_generator;
        }

        @ZenMethod
        public static void addRecipe(IIngredient input, IIngredient output, double meanLifetime, double power, double radiation) {
            CraftTweakerAPI.apply((IAction)new CTAddRecipe(NCRecipes.decay_generator, Lists.newArrayList((Object[])new Object[]{input, output, meanLifetime, power, radiation})));
        }

        @ZenMethod
        public static void removeRecipeWithInput(IIngredient input) {
            CraftTweakerAPI.apply((IAction)new CTRemoveRecipe(NCRecipes.decay_generator, IngredientSorption.INPUT, Lists.newArrayList((Object[])new IIngredient[]{input})));
        }

        @ZenMethod
        public static void removeRecipeWithOutput(IIngredient output) {
            CraftTweakerAPI.apply((IAction)new CTRemoveRecipe(NCRecipes.decay_generator, IngredientSorption.OUTPUT, Lists.newArrayList((Object[])new IIngredient[]{output})));
        }

        @ZenMethod
        public static void removeAllRecipes() {
            CraftTweakerAPI.apply((IAction)new CTClearRecipes(NCRecipes.decay_generator));
        }
    }

    @ZenClass(value="mods.nuclearcraft.RockCrusher")
    @ZenRegister
    public static class RockCrusherMethods {
        @ZenMethod
        public static BasicRecipeHandler getRecipeHandler() {
            return NCRecipes.rock_crusher;
        }

        @ZenMethod
        public static void addRecipe(IIngredient input, IIngredient output1, IIngredient output2, IIngredient output3, @Optional(valueDouble=1.0) double timeMultiplier, @Optional(valueDouble=1.0) double powerMultiplier, @Optional double processRadiation) {
            CraftTweakerAPI.apply((IAction)new CTAddRecipe(NCRecipes.rock_crusher, Lists.newArrayList((Object[])new Object[]{input, output1, output2, output3, timeMultiplier, powerMultiplier, processRadiation})));
        }

        @ZenMethod
        public static void removeRecipeWithInput(IIngredient input) {
            CraftTweakerAPI.apply((IAction)new CTRemoveRecipe(NCRecipes.rock_crusher, IngredientSorption.INPUT, Lists.newArrayList((Object[])new IIngredient[]{input})));
        }

        @ZenMethod
        public static void removeRecipeWithOutput(IIngredient output1, IIngredient output2, IIngredient output3) {
            CraftTweakerAPI.apply((IAction)new CTRemoveRecipe(NCRecipes.rock_crusher, IngredientSorption.OUTPUT, Lists.newArrayList((Object[])new IIngredient[]{output1, output2, output3})));
        }

        @ZenMethod
        public static void removeAllRecipes() {
            CraftTweakerAPI.apply((IAction)new CTClearRecipes(NCRecipes.rock_crusher));
        }
    }

    @ZenClass(value="mods.nuclearcraft.Centrifuge")
    @ZenRegister
    public static class CentrifugeMethods {
        @ZenMethod
        public static BasicRecipeHandler getRecipeHandler() {
            return NCRecipes.centrifuge;
        }

        @ZenMethod
        public static void addRecipe(IIngredient input, IIngredient output1, IIngredient output2, IIngredient output3, IIngredient output4, IIngredient output5, IIngredient output6, @Optional(valueDouble=1.0) double timeMultiplier, @Optional(valueDouble=1.0) double powerMultiplier, @Optional double processRadiation) {
            CraftTweakerAPI.apply((IAction)new CTAddRecipe(NCRecipes.centrifuge, Lists.newArrayList((Object[])new Object[]{input, output1, output2, output3, output4, output5, output6, timeMultiplier, powerMultiplier, processRadiation})));
        }

        @ZenMethod
        public static void removeRecipeWithInput(IIngredient input) {
            CraftTweakerAPI.apply((IAction)new CTRemoveRecipe(NCRecipes.centrifuge, IngredientSorption.INPUT, Lists.newArrayList((Object[])new IIngredient[]{input})));
        }

        @ZenMethod
        public static void removeRecipeWithOutput(IIngredient output1, IIngredient output2, IIngredient output3, IIngredient output4, IIngredient output5, IIngredient output6) {
            CraftTweakerAPI.apply((IAction)new CTRemoveRecipe(NCRecipes.centrifuge, IngredientSorption.OUTPUT, Lists.newArrayList((Object[])new IIngredient[]{output1, output2, output3, output4, output5, output6})));
        }

        @ZenMethod
        public static void removeAllRecipes() {
            CraftTweakerAPI.apply((IAction)new CTClearRecipes(NCRecipes.centrifuge));
        }
    }

    @ZenClass(value="mods.nuclearcraft.Extractor")
    @ZenRegister
    public static class ExtractorMethods {
        @ZenMethod
        public static BasicRecipeHandler getRecipeHandler() {
            return NCRecipes.extractor;
        }

        @ZenMethod
        public static void addRecipe(IIngredient input, IIngredient output1, IIngredient output2, @Optional(valueDouble=1.0) double timeMultiplier, @Optional(valueDouble=1.0) double powerMultiplier, @Optional double processRadiation) {
            CraftTweakerAPI.apply((IAction)new CTAddRecipe(NCRecipes.extractor, Lists.newArrayList((Object[])new Object[]{input, output1, output2, timeMultiplier, powerMultiplier, processRadiation})));
        }

        @ZenMethod
        public static void removeRecipeWithInput(IIngredient input) {
            CraftTweakerAPI.apply((IAction)new CTRemoveRecipe(NCRecipes.extractor, IngredientSorption.INPUT, Lists.newArrayList((Object[])new IIngredient[]{input})));
        }

        @ZenMethod
        public static void removeRecipeWithOutput(IIngredient output1, IIngredient output2) {
            CraftTweakerAPI.apply((IAction)new CTRemoveRecipe(NCRecipes.extractor, IngredientSorption.OUTPUT, Lists.newArrayList((Object[])new IIngredient[]{output1, output2})));
        }

        @ZenMethod
        public static void removeAllRecipes() {
            CraftTweakerAPI.apply((IAction)new CTClearRecipes(NCRecipes.extractor));
        }
    }

    @ZenClass(value="mods.nuclearcraft.Enricher")
    @ZenRegister
    public static class EnricherMethods {
        @ZenMethod
        public static BasicRecipeHandler getRecipeHandler() {
            return NCRecipes.enricher;
        }

        @ZenMethod
        public static void addRecipe(IIngredient input1, IIngredient input2, IIngredient output, @Optional(valueDouble=1.0) double timeMultiplier, @Optional(valueDouble=1.0) double powerMultiplier, @Optional double processRadiation) {
            CraftTweakerAPI.apply((IAction)new CTAddRecipe(NCRecipes.enricher, Lists.newArrayList((Object[])new Object[]{input1, input2, output, timeMultiplier, powerMultiplier, processRadiation})));
        }

        @ZenMethod
        public static void removeRecipeWithInput(IIngredient input1, IIngredient input2) {
            CraftTweakerAPI.apply((IAction)new CTRemoveRecipe(NCRecipes.enricher, IngredientSorption.INPUT, Lists.newArrayList((Object[])new IIngredient[]{input1, input2})));
        }

        @ZenMethod
        public static void removeRecipeWithOutput(IIngredient output) {
            CraftTweakerAPI.apply((IAction)new CTRemoveRecipe(NCRecipes.enricher, IngredientSorption.OUTPUT, Lists.newArrayList((Object[])new IIngredient[]{output})));
        }

        @ZenMethod
        public static void removeAllRecipes() {
            CraftTweakerAPI.apply((IAction)new CTClearRecipes(NCRecipes.enricher));
        }
    }

    @ZenClass(value="mods.nuclearcraft.Crystallizer")
    @ZenRegister
    public static class CrystallizerMethods {
        @ZenMethod
        public static BasicRecipeHandler getRecipeHandler() {
            return NCRecipes.crystallizer;
        }

        @ZenMethod
        public static void addRecipe(IIngredient input, IIngredient output, @Optional(valueDouble=1.0) double timeMultiplier, @Optional(valueDouble=1.0) double powerMultiplier, @Optional double processRadiation) {
            CraftTweakerAPI.apply((IAction)new CTAddRecipe(NCRecipes.crystallizer, Lists.newArrayList((Object[])new Object[]{input, output, timeMultiplier, powerMultiplier, processRadiation})));
        }

        @ZenMethod
        public static void removeRecipeWithInput(IIngredient input) {
            CraftTweakerAPI.apply((IAction)new CTRemoveRecipe(NCRecipes.crystallizer, IngredientSorption.INPUT, Lists.newArrayList((Object[])new IIngredient[]{input})));
        }

        @ZenMethod
        public static void removeRecipeWithOutput(IIngredient output) {
            CraftTweakerAPI.apply((IAction)new CTRemoveRecipe(NCRecipes.crystallizer, IngredientSorption.OUTPUT, Lists.newArrayList((Object[])new IIngredient[]{output})));
        }

        @ZenMethod
        public static void removeAllRecipes() {
            CraftTweakerAPI.apply((IAction)new CTClearRecipes(NCRecipes.crystallizer));
        }
    }

    @ZenClass(value="mods.nuclearcraft.SaltMixer")
    @ZenRegister
    public static class SaltMixerMethods {
        @ZenMethod
        public static BasicRecipeHandler getRecipeHandler() {
            return NCRecipes.salt_mixer;
        }

        @ZenMethod
        public static void addRecipe(IIngredient input1, IIngredient input2, IIngredient output, @Optional(valueDouble=1.0) double timeMultiplier, @Optional(valueDouble=1.0) double powerMultiplier, @Optional double processRadiation) {
            CraftTweakerAPI.apply((IAction)new CTAddRecipe(NCRecipes.salt_mixer, Lists.newArrayList((Object[])new Object[]{input1, input2, output, timeMultiplier, powerMultiplier, processRadiation})));
        }

        @ZenMethod
        public static void removeRecipeWithInput(IIngredient input1, IIngredient input2) {
            CraftTweakerAPI.apply((IAction)new CTRemoveRecipe(NCRecipes.salt_mixer, IngredientSorption.INPUT, Lists.newArrayList((Object[])new IIngredient[]{input1, input2})));
        }

        @ZenMethod
        public static void removeRecipeWithOutput(IIngredient output) {
            CraftTweakerAPI.apply((IAction)new CTRemoveRecipe(NCRecipes.salt_mixer, IngredientSorption.OUTPUT, Lists.newArrayList((Object[])new IIngredient[]{output})));
        }

        @ZenMethod
        public static void removeAllRecipes() {
            CraftTweakerAPI.apply((IAction)new CTClearRecipes(NCRecipes.salt_mixer));
        }
    }

    @ZenClass(value="mods.nuclearcraft.ChemicalReactor")
    @ZenRegister
    public static class ChemicalReactorMethods {
        @ZenMethod
        public static BasicRecipeHandler getRecipeHandler() {
            return NCRecipes.chemical_reactor;
        }

        @ZenMethod
        public static void addRecipe(IIngredient input1, IIngredient input2, IIngredient output1, IIngredient output2, @Optional(valueDouble=1.0) double timeMultiplier, @Optional(valueDouble=1.0) double powerMultiplier, @Optional double processRadiation) {
            CraftTweakerAPI.apply((IAction)new CTAddRecipe(NCRecipes.chemical_reactor, Lists.newArrayList((Object[])new Object[]{input1, input2, output1, output2, timeMultiplier, powerMultiplier, processRadiation})));
        }

        @ZenMethod
        public static void removeRecipeWithInput(IIngredient input1, IIngredient input2) {
            CraftTweakerAPI.apply((IAction)new CTRemoveRecipe(NCRecipes.chemical_reactor, IngredientSorption.INPUT, Lists.newArrayList((Object[])new IIngredient[]{input1, input2})));
        }

        @ZenMethod
        public static void removeRecipeWithOutput(IIngredient output1, IIngredient output2) {
            CraftTweakerAPI.apply((IAction)new CTRemoveRecipe(NCRecipes.chemical_reactor, IngredientSorption.OUTPUT, Lists.newArrayList((Object[])new IIngredient[]{output1, output2})));
        }

        @ZenMethod
        public static void removeAllRecipes() {
            CraftTweakerAPI.apply((IAction)new CTClearRecipes(NCRecipes.chemical_reactor));
        }
    }

    @ZenClass(value="mods.nuclearcraft.Pressurizer")
    @ZenRegister
    public static class PressurizerMethods {
        @ZenMethod
        public static BasicRecipeHandler getRecipeHandler() {
            return NCRecipes.pressurizer;
        }

        @ZenMethod
        public static void addRecipe(IIngredient input, IIngredient output, @Optional(valueDouble=1.0) double timeMultiplier, @Optional(valueDouble=1.0) double powerMultiplier, @Optional double processRadiation) {
            CraftTweakerAPI.apply((IAction)new CTAddRecipe(NCRecipes.pressurizer, Lists.newArrayList((Object[])new Object[]{input, output, timeMultiplier, powerMultiplier, processRadiation})));
        }

        @ZenMethod
        public static void removeRecipeWithInput(IIngredient input) {
            CraftTweakerAPI.apply((IAction)new CTRemoveRecipe(NCRecipes.pressurizer, IngredientSorption.INPUT, Lists.newArrayList((Object[])new IIngredient[]{input})));
        }

        @ZenMethod
        public static void removeRecipeWithOutput(IIngredient output) {
            CraftTweakerAPI.apply((IAction)new CTRemoveRecipe(NCRecipes.pressurizer, IngredientSorption.OUTPUT, Lists.newArrayList((Object[])new IIngredient[]{output})));
        }

        @ZenMethod
        public static void removeAllRecipes() {
            CraftTweakerAPI.apply((IAction)new CTClearRecipes(NCRecipes.pressurizer));
        }
    }

    @ZenClass(value="mods.nuclearcraft.IngotFormer")
    @ZenRegister
    public static class IngotFormerMethods {
        @ZenMethod
        public static BasicRecipeHandler getRecipeHandler() {
            return NCRecipes.ingot_former;
        }

        @ZenMethod
        public static void addRecipe(IIngredient input, IIngredient output, @Optional(valueDouble=1.0) double timeMultiplier, @Optional(valueDouble=1.0) double powerMultiplier, @Optional double processRadiation) {
            CraftTweakerAPI.apply((IAction)new CTAddRecipe(NCRecipes.ingot_former, Lists.newArrayList((Object[])new Object[]{input, output, timeMultiplier, powerMultiplier, processRadiation})));
        }

        @ZenMethod
        public static void removeRecipeWithInput(IIngredient input) {
            CraftTweakerAPI.apply((IAction)new CTRemoveRecipe(NCRecipes.ingot_former, IngredientSorption.INPUT, Lists.newArrayList((Object[])new IIngredient[]{input})));
        }

        @ZenMethod
        public static void removeRecipeWithOutput(IIngredient output) {
            CraftTweakerAPI.apply((IAction)new CTRemoveRecipe(NCRecipes.ingot_former, IngredientSorption.OUTPUT, Lists.newArrayList((Object[])new IIngredient[]{output})));
        }

        @ZenMethod
        public static void removeAllRecipes() {
            CraftTweakerAPI.apply((IAction)new CTClearRecipes(NCRecipes.ingot_former));
        }
    }

    @ZenClass(value="mods.nuclearcraft.Assembler")
    @ZenRegister
    public static class AssemblerMethods {
        @ZenMethod
        public static BasicRecipeHandler getRecipeHandler() {
            return NCRecipes.assembler;
        }

        @ZenMethod
        public static void addRecipe(IIngredient input1, IIngredient input2, IIngredient input3, IIngredient input4, IIngredient output, @Optional(valueDouble=1.0) double timeMultiplier, @Optional(valueDouble=1.0) double powerMultiplier, @Optional double processRadiation) {
            CraftTweakerAPI.apply((IAction)new CTAddRecipe(NCRecipes.assembler, Lists.newArrayList((Object[])new Object[]{input1, input2, input3, input4, output, timeMultiplier, powerMultiplier, processRadiation})));
        }

        @ZenMethod
        public static void removeRecipeWithInput(IIngredient input1, IIngredient input2, IIngredient input3, IIngredient input4) {
            CraftTweakerAPI.apply((IAction)new CTRemoveRecipe(NCRecipes.assembler, IngredientSorption.INPUT, Lists.newArrayList((Object[])new IIngredient[]{input1, input2, input3, input4})));
        }

        @ZenMethod
        public static void removeRecipeWithOutput(IIngredient output) {
            CraftTweakerAPI.apply((IAction)new CTRemoveRecipe(NCRecipes.assembler, IngredientSorption.OUTPUT, Lists.newArrayList((Object[])new IIngredient[]{output})));
        }

        @ZenMethod
        public static void removeAllRecipes() {
            CraftTweakerAPI.apply((IAction)new CTClearRecipes(NCRecipes.assembler));
        }
    }

    @ZenClass(value="mods.nuclearcraft.Electrolyzer")
    @ZenRegister
    public static class ElectrolyzerMethods {
        @ZenMethod
        public static BasicRecipeHandler getRecipeHandler() {
            return NCRecipes.electrolyzer;
        }

        @ZenMethod
        public static void addRecipe(IIngredient input, IIngredient output1, IIngredient output2, IIngredient output3, IIngredient output4, @Optional(valueDouble=1.0) double timeMultiplier, @Optional(valueDouble=1.0) double powerMultiplier, @Optional double processRadiation) {
            CraftTweakerAPI.apply((IAction)new CTAddRecipe(NCRecipes.electrolyzer, Lists.newArrayList((Object[])new Object[]{input, output1, output2, output3, output4, timeMultiplier, powerMultiplier, processRadiation})));
        }

        @ZenMethod
        public static void removeRecipeWithInput(IIngredient input) {
            CraftTweakerAPI.apply((IAction)new CTRemoveRecipe(NCRecipes.electrolyzer, IngredientSorption.INPUT, Lists.newArrayList((Object[])new IIngredient[]{input})));
        }

        @ZenMethod
        public static void removeRecipeWithOutput(IIngredient output1, IIngredient output2, IIngredient output3, IIngredient output4) {
            CraftTweakerAPI.apply((IAction)new CTRemoveRecipe(NCRecipes.electrolyzer, IngredientSorption.OUTPUT, Lists.newArrayList((Object[])new IIngredient[]{output1, output2, output3, output4})));
        }

        @ZenMethod
        public static void removeAllRecipes() {
            CraftTweakerAPI.apply((IAction)new CTClearRecipes(NCRecipes.electrolyzer));
        }
    }

    @ZenClass(value="mods.nuclearcraft.Supercooler")
    @ZenRegister
    public static class SupercoolerMethods {
        @ZenMethod
        public static BasicRecipeHandler getRecipeHandler() {
            return NCRecipes.supercooler;
        }

        @ZenMethod
        public static void addRecipe(IIngredient input, IIngredient output, @Optional(valueDouble=1.0) double timeMultiplier, @Optional(valueDouble=1.0) double powerMultiplier, @Optional double processRadiation) {
            CraftTweakerAPI.apply((IAction)new CTAddRecipe(NCRecipes.supercooler, Lists.newArrayList((Object[])new Object[]{input, output, timeMultiplier, powerMultiplier, processRadiation})));
        }

        @ZenMethod
        public static void removeRecipeWithInput(IIngredient input) {
            CraftTweakerAPI.apply((IAction)new CTRemoveRecipe(NCRecipes.supercooler, IngredientSorption.INPUT, Lists.newArrayList((Object[])new IIngredient[]{input})));
        }

        @ZenMethod
        public static void removeRecipeWithOutput(IIngredient output) {
            CraftTweakerAPI.apply((IAction)new CTRemoveRecipe(NCRecipes.supercooler, IngredientSorption.OUTPUT, Lists.newArrayList((Object[])new IIngredient[]{output})));
        }

        @ZenMethod
        public static void removeAllRecipes() {
            CraftTweakerAPI.apply((IAction)new CTClearRecipes(NCRecipes.supercooler));
        }
    }

    @ZenClass(value="mods.nuclearcraft.Melter")
    @ZenRegister
    public static class MelterMethods {
        @ZenMethod
        public static BasicRecipeHandler getRecipeHandler() {
            return NCRecipes.melter;
        }

        @ZenMethod
        public static void addRecipe(IIngredient input, IIngredient output, @Optional(valueDouble=1.0) double timeMultiplier, @Optional(valueDouble=1.0) double powerMultiplier, @Optional double processRadiation) {
            CraftTweakerAPI.apply((IAction)new CTAddRecipe(NCRecipes.melter, Lists.newArrayList((Object[])new Object[]{input, output, timeMultiplier, powerMultiplier, processRadiation})));
        }

        @ZenMethod
        public static void removeRecipeWithInput(IIngredient input) {
            CraftTweakerAPI.apply((IAction)new CTRemoveRecipe(NCRecipes.melter, IngredientSorption.INPUT, Lists.newArrayList((Object[])new IIngredient[]{input})));
        }

        @ZenMethod
        public static void removeRecipeWithOutput(IIngredient output) {
            CraftTweakerAPI.apply((IAction)new CTRemoveRecipe(NCRecipes.melter, IngredientSorption.OUTPUT, Lists.newArrayList((Object[])new IIngredient[]{output})));
        }

        @ZenMethod
        public static void removeAllRecipes() {
            CraftTweakerAPI.apply((IAction)new CTClearRecipes(NCRecipes.melter));
        }
    }

    @ZenClass(value="mods.nuclearcraft.Infuser")
    @ZenRegister
    public static class InfuserMethods {
        @ZenMethod
        public static BasicRecipeHandler getRecipeHandler() {
            return NCRecipes.infuser;
        }

        @ZenMethod
        public static void addRecipe(IIngredient input1, IIngredient input2, IIngredient output, @Optional(valueDouble=1.0) double timeMultiplier, @Optional(valueDouble=1.0) double powerMultiplier, @Optional double processRadiation) {
            CraftTweakerAPI.apply((IAction)new CTAddRecipe(NCRecipes.infuser, Lists.newArrayList((Object[])new Object[]{input1, input2, output, timeMultiplier, powerMultiplier, processRadiation})));
        }

        @ZenMethod
        public static void removeRecipeWithInput(IIngredient input1, IIngredient input2) {
            CraftTweakerAPI.apply((IAction)new CTRemoveRecipe(NCRecipes.infuser, IngredientSorption.INPUT, Lists.newArrayList((Object[])new IIngredient[]{input1, input2})));
        }

        @ZenMethod
        public static void removeRecipeWithOutput(IIngredient output) {
            CraftTweakerAPI.apply((IAction)new CTRemoveRecipe(NCRecipes.infuser, IngredientSorption.OUTPUT, Lists.newArrayList((Object[])new IIngredient[]{output})));
        }

        @ZenMethod
        public static void removeAllRecipes() {
            CraftTweakerAPI.apply((IAction)new CTClearRecipes(NCRecipes.infuser));
        }
    }

    @ZenClass(value="mods.nuclearcraft.AlloyFurnace")
    @ZenRegister
    public static class AlloyFurnaceMethods {
        @ZenMethod
        public static BasicRecipeHandler getRecipeHandler() {
            return NCRecipes.alloy_furnace;
        }

        @ZenMethod
        public static void addRecipe(IIngredient input1, IIngredient input2, IIngredient output, @Optional(valueDouble=1.0) double timeMultiplier, @Optional(valueDouble=1.0) double powerMultiplier, @Optional double processRadiation) {
            CraftTweakerAPI.apply((IAction)new CTAddRecipe(NCRecipes.alloy_furnace, Lists.newArrayList((Object[])new Object[]{input1, input2, output, timeMultiplier, powerMultiplier, processRadiation})));
        }

        @ZenMethod
        public static void removeRecipeWithInput(IIngredient input1, IIngredient input2) {
            CraftTweakerAPI.apply((IAction)new CTRemoveRecipe(NCRecipes.alloy_furnace, IngredientSorption.INPUT, Lists.newArrayList((Object[])new IIngredient[]{input1, input2})));
        }

        @ZenMethod
        public static void removeRecipeWithOutput(IIngredient output) {
            CraftTweakerAPI.apply((IAction)new CTRemoveRecipe(NCRecipes.alloy_furnace, IngredientSorption.OUTPUT, Lists.newArrayList((Object[])new IIngredient[]{output})));
        }

        @ZenMethod
        public static void removeAllRecipes() {
            CraftTweakerAPI.apply((IAction)new CTClearRecipes(NCRecipes.alloy_furnace));
        }
    }

    @ZenClass(value="mods.nuclearcraft.FuelReprocessor")
    @ZenRegister
    public static class FuelReprocessorMethods {
        @ZenMethod
        public static BasicRecipeHandler getRecipeHandler() {
            return NCRecipes.fuel_reprocessor;
        }

        @ZenMethod
        public static void addRecipe(IIngredient input, IIngredient output1, IIngredient output2, IIngredient output3, IIngredient output4, IIngredient output5, IIngredient output6, IIngredient output7, IIngredient output8, @Optional(valueDouble=1.0) double timeMultiplier, @Optional(valueDouble=1.0) double powerMultiplier, @Optional double processRadiation) {
            CraftTweakerAPI.apply((IAction)new CTAddRecipe(NCRecipes.fuel_reprocessor, Lists.newArrayList((Object[])new Object[]{input, output1, output2, output3, output4, output5, output6, output7, output8, timeMultiplier, powerMultiplier, processRadiation})));
        }

        @ZenMethod
        public static void removeRecipeWithInput(IIngredient input) {
            CraftTweakerAPI.apply((IAction)new CTRemoveRecipe(NCRecipes.fuel_reprocessor, IngredientSorption.INPUT, Lists.newArrayList((Object[])new IIngredient[]{input})));
        }

        @ZenMethod
        public static void removeRecipeWithOutput(IIngredient output1, IIngredient output2, IIngredient output3, IIngredient output4, IIngredient output5, IIngredient output6, IIngredient output7, IIngredient output8) {
            CraftTweakerAPI.apply((IAction)new CTRemoveRecipe(NCRecipes.fuel_reprocessor, IngredientSorption.OUTPUT, Lists.newArrayList((Object[])new IIngredient[]{output1, output2, output3, output4, output5, output6, output7, output8})));
        }

        @ZenMethod
        public static void removeAllRecipes() {
            CraftTweakerAPI.apply((IAction)new CTClearRecipes(NCRecipes.fuel_reprocessor));
        }
    }

    @ZenClass(value="mods.nuclearcraft.DecayHastener")
    @ZenRegister
    public static class DecayHastenerMethods {
        @ZenMethod
        public static BasicRecipeHandler getRecipeHandler() {
            return NCRecipes.decay_hastener;
        }

        @ZenMethod
        public static void addRecipe(IIngredient input, IIngredient output, @Optional(valueDouble=1.0) double timeMultiplier, @Optional(valueDouble=1.0) double powerMultiplier, @Optional double processRadiation) {
            CraftTweakerAPI.apply((IAction)new CTAddRecipe(NCRecipes.decay_hastener, Lists.newArrayList((Object[])new Object[]{input, output, timeMultiplier, powerMultiplier, processRadiation})));
        }

        @ZenMethod
        public static void removeRecipeWithInput(IIngredient input) {
            CraftTweakerAPI.apply((IAction)new CTRemoveRecipe(NCRecipes.decay_hastener, IngredientSorption.INPUT, Lists.newArrayList((Object[])new IIngredient[]{input})));
        }

        @ZenMethod
        public static void removeRecipeWithOutput(IIngredient output) {
            CraftTweakerAPI.apply((IAction)new CTRemoveRecipe(NCRecipes.decay_hastener, IngredientSorption.OUTPUT, Lists.newArrayList((Object[])new IIngredient[]{output})));
        }

        @ZenMethod
        public static void removeAllRecipes() {
            CraftTweakerAPI.apply((IAction)new CTClearRecipes(NCRecipes.decay_hastener));
        }
    }

    @ZenClass(value="mods.nuclearcraft.Separator")
    @ZenRegister
    public static class SeparatorMethods {
        @ZenMethod
        public static BasicRecipeHandler getRecipeHandler() {
            return NCRecipes.separator;
        }

        @ZenMethod
        public static void addRecipe(IIngredient input, IIngredient output1, IIngredient output2, @Optional(valueDouble=1.0) double timeMultiplier, @Optional(valueDouble=1.0) double powerMultiplier, @Optional double processRadiation) {
            CraftTweakerAPI.apply((IAction)new CTAddRecipe(NCRecipes.separator, Lists.newArrayList((Object[])new Object[]{input, output1, output2, timeMultiplier, powerMultiplier, processRadiation})));
        }

        @ZenMethod
        public static void removeRecipeWithInput(IIngredient input) {
            CraftTweakerAPI.apply((IAction)new CTRemoveRecipe(NCRecipes.separator, IngredientSorption.INPUT, Lists.newArrayList((Object[])new IIngredient[]{input})));
        }

        @ZenMethod
        public static void removeRecipeWithOutput(IIngredient output1, IIngredient output2) {
            CraftTweakerAPI.apply((IAction)new CTRemoveRecipe(NCRecipes.separator, IngredientSorption.OUTPUT, Lists.newArrayList((Object[])new IIngredient[]{output1, output2})));
        }

        @ZenMethod
        public static void removeAllRecipes() {
            CraftTweakerAPI.apply((IAction)new CTClearRecipes(NCRecipes.separator));
        }
    }

    @ZenClass(value="mods.nuclearcraft.Manufactory")
    @ZenRegister
    public static class ManufactoryMethods {
        @ZenMethod
        public static BasicRecipeHandler getRecipeHandler() {
            return NCRecipes.manufactory;
        }

        @ZenMethod
        public static void addRecipe(IIngredient input, IIngredient output, @Optional(valueDouble=1.0) double timeMultiplier, @Optional(valueDouble=1.0) double powerMultiplier, @Optional double processRadiation) {
            CraftTweakerAPI.apply((IAction)new CTAddRecipe(NCRecipes.manufactory, Lists.newArrayList((Object[])new Object[]{input, output, timeMultiplier, powerMultiplier, processRadiation})));
        }

        @ZenMethod
        public static void removeRecipeWithInput(IIngredient input) {
            CraftTweakerAPI.apply((IAction)new CTRemoveRecipe(NCRecipes.manufactory, IngredientSorption.INPUT, Lists.newArrayList((Object[])new IIngredient[]{input})));
        }

        @ZenMethod
        public static void removeRecipeWithOutput(IIngredient output) {
            CraftTweakerAPI.apply((IAction)new CTRemoveRecipe(NCRecipes.manufactory, IngredientSorption.OUTPUT, Lists.newArrayList((Object[])new IIngredient[]{output})));
        }

        @ZenMethod
        public static void removeAllRecipes() {
            CraftTweakerAPI.apply((IAction)new CTClearRecipes(NCRecipes.manufactory));
        }
    }
}

