/*
 * Decompiled with CFR 0.152.
 */
package nc.integration.crafttweaker;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.IAction;
import java.util.ArrayList;
import java.util.List;
import nc.integration.crafttweaker.CTHelper;
import nc.recipe.BasicRecipe;
import nc.recipe.BasicRecipeHandler;
import nc.recipe.IngredientSorption;
import nc.recipe.RecipeHelper;
import nc.recipe.ingredient.IFluidIngredient;
import nc.recipe.ingredient.IIngredient;
import nc.recipe.ingredient.IItemIngredient;
import net.minecraft.item.ItemStack;

public class CTRemoveRecipe
implements IAction {
    protected static boolean errored = false;
    protected final BasicRecipeHandler recipeHandler;
    protected final IngredientSorption type;
    protected BasicRecipe recipe;
    protected final List<IItemIngredient> itemIngredients = new ArrayList<IItemIngredient>();
    protected final List<IFluidIngredient> fluidIngredients = new ArrayList<IFluidIngredient>();
    protected boolean nullIngredient;
    protected boolean nullRecipe;
    protected boolean wrongSize;

    public CTRemoveRecipe(BasicRecipeHandler recipeHandler, IngredientSorption type, List<crafttweaker.api.item.IIngredient> ctIngredients) {
        IIngredient<ItemStack> ingredient;
        int i;
        this.recipeHandler = recipeHandler;
        this.type = type;
        int itemSize = type == IngredientSorption.INPUT ? recipeHandler.getItemInputSize() : recipeHandler.getItemOutputSize();
        int fluidSize = type == IngredientSorption.INPUT ? recipeHandler.getFluidInputSize() : recipeHandler.getFluidOutputSize();
        for (i = 0; i < itemSize; ++i) {
            ingredient = CTHelper.buildRemovalItemIngredient(ctIngredients.get(i));
            if (ingredient == null) {
                this.nullIngredient = true;
                return;
            }
            this.itemIngredients.add((IItemIngredient)ingredient);
        }
        for (i = itemSize; i < fluidSize; ++i) {
            ingredient = CTHelper.buildRemovalFluidIngredient(ctIngredients.get(i));
            if (ingredient == null) {
                this.nullIngredient = true;
                return;
            }
            this.fluidIngredients.add((IFluidIngredient)ingredient);
        }
        if (ctIngredients.size() != itemSize + fluidSize) {
            CraftTweakerAPI.logError((String)("A " + recipeHandler.getName() + " recipe removal had the wrong number of " + (type == IngredientSorption.INPUT ? "inputs" : "outputs") + ": " + RecipeHelper.getAllIngredientNamesConcat(this.itemIngredients, this.fluidIngredients)));
            this.wrongSize = true;
            return;
        }
        BasicRecipe basicRecipe = this.recipe = type == IngredientSorption.INPUT ? (BasicRecipe)recipeHandler.getRecipeFromIngredients(this.itemIngredients, this.fluidIngredients) : (BasicRecipe)recipeHandler.getRecipeFromProducts(this.itemIngredients, this.fluidIngredients);
        if (this.recipe == null) {
            this.nullRecipe = true;
        }
    }

    public void apply() {
        if (!this.isError()) {
            while (this.recipeHandler.removeRecipe(this.recipe)) {
                this.recipe = this.type == IngredientSorption.INPUT ? (BasicRecipe)this.recipeHandler.getRecipeFromIngredients(this.itemIngredients, this.fluidIngredients) : (BasicRecipe)this.recipeHandler.getRecipeFromProducts(this.itemIngredients, this.fluidIngredients);
            }
        }
    }

    public String describe() {
        if (!this.isError()) {
            if (this.type == IngredientSorption.INPUT) {
                return "Removing " + this.recipeHandler.getName() + " recipe: " + RecipeHelper.getRecipeString(this.recipe);
            }
            return "Removing " + this.recipeHandler.getName() + " recipes for: " + RecipeHelper.getAllIngredientNamesConcat(this.itemIngredients, this.fluidIngredients);
        }
        CTRemoveRecipe.callError();
        String out = "Failed to remove " + this.recipeHandler.getName() + " recipe with " + RecipeHelper.getAllIngredientNamesConcat(this.itemIngredients, this.fluidIngredients) + " as the " + (this.type == IngredientSorption.INPUT ? "input" : "output");
        if (this.nullIngredient) {
            return out + " as one or more " + (this.type == IngredientSorption.INPUT ? "ingredients" : "products") + " had no match";
        }
        if (this.nullRecipe) {
            return out + " as no matching recipe could be found";
        }
        return out;
    }

    protected boolean isError() {
        return this.nullIngredient || this.nullRecipe || this.wrongSize;
    }

    protected static void callError() {
        if (!errored) {
            errored = true;
            CraftTweakerAPI.logError((String)"At least one NuclearCraft recipe removal method has errored. Check the log for more details");
        }
    }
}

