/*
 * Decompiled with CFR 0.152.
 */
package nc.integration.jei;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IGuiFluidStackGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.ingredients.IIngredients;
import nc.integration.jei.JEIBasicRecipeWrapper;
import nc.integration.jei.NCJEI;
import nc.recipe.BasicRecipe;
import nc.recipe.BasicRecipeHandler;
import nc.recipe.IngredientSorption;
import nc.util.NCUtil;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class JEIHelper {
    public static List<JEIBasicRecipeWrapper> getJEIRecipes(IGuiHelper guiHelper, NCJEI.IJEIHandler jeiHandler, BasicRecipeHandler recipeHandler, Class<? extends JEIBasicRecipeWrapper> recipeWrapper) {
        ArrayList<JEIBasicRecipeWrapper> recipes = new ArrayList<JEIBasicRecipeWrapper>();
        if (recipeHandler != null) {
            for (BasicRecipe recipe : recipeHandler.getRecipeList()) {
                try {
                    recipes.add(recipeWrapper.getConstructor(IGuiHelper.class, NCJEI.IJEIHandler.class, BasicRecipeHandler.class, BasicRecipe.class).newInstance(guiHelper, jeiHandler, recipeHandler, recipe));
                }
                catch (Exception e) {
                    NCUtil.getLogger().catching((Throwable)e);
                }
            }
        }
        return recipes;
    }

    protected static class RecipeFluidMapping {
        public int slotPos;
        public int xPos;
        public int yPos;
        public int xSize;
        public int ySize;

        public RecipeFluidMapping(int slotPos, int xPos, int yPos, int xSize, int ySize) {
            this.slotPos = slotPos;
            this.xPos = xPos;
            this.yPos = yPos;
            this.xSize = xSize;
            this.ySize = ySize;
        }
    }

    protected static class RecipeItemMapping {
        public int slotPos;
        public int xPos;
        public int yPos;

        public RecipeItemMapping(int slotPos, int xPos, int yPos) {
            this.slotPos = slotPos;
            this.xPos = xPos;
            this.yPos = yPos;
        }
    }

    public static class RecipeFluidMapper {
        public Object2ObjectMap<IngredientSorption, Int2ObjectMap<RecipeFluidMapping>> map = new Object2ObjectOpenHashMap();

        public void map(IngredientSorption type, int recipePos, int slotPos, int xPos, int yPos, int xSize, int ySize) {
            this.map(type, recipePos, new RecipeFluidMapping(slotPos, xPos, yPos, xSize, ySize));
        }

        public void map(IngredientSorption type, int recipePos, RecipeFluidMapping mapping) {
            if (this.map.get((Object)type) == null) {
                this.map.put((Object)type, (Object)new Int2ObjectOpenHashMap());
            }
            ((Int2ObjectMap)this.map.get((Object)type)).put(recipePos, (Object)mapping);
        }

        public void mapFluidsTo(IGuiFluidStackGroup fluids, IIngredients ingredients) {
            for (Object2ObjectMap.Entry entry : this.map.object2ObjectEntrySet()) {
                List objects = entry.getKey() == IngredientSorption.INPUT ? ingredients.getInputs(FluidStack.class) : ingredients.getOutputs(FluidStack.class);
                for (Int2ObjectMap.Entry mapping : ((Int2ObjectMap)entry.getValue()).int2ObjectEntrySet()) {
                    RecipeFluidMapping recipe = (RecipeFluidMapping)mapping.getValue();
                    Object obj = objects.get(mapping.getIntKey());
                    if (obj instanceof List) {
                        List list = (List)obj;
                        FluidStack stack = list.isEmpty() ? null : (FluidStack)list.get(list.size() - 1);
                        fluids.init(recipe.slotPos, entry.getKey() == IngredientSorption.INPUT, recipe.xPos + 1, recipe.yPos + 1, recipe.xSize, recipe.ySize, stack == null ? 1000 : Math.max(1, stack.amount), true, null);
                        fluids.set(recipe.slotPos, stack == null ? null : (List)obj);
                        continue;
                    }
                    FluidStack stack = (FluidStack)obj;
                    fluids.init(recipe.slotPos, entry.getKey() == IngredientSorption.INPUT, recipe.xPos + 1, recipe.yPos + 1, recipe.xSize, recipe.ySize, stack == null ? 1000 : Math.max(1, stack.amount), true, null);
                    fluids.set(recipe.slotPos, stack);
                }
            }
        }
    }

    public static class RecipeItemMapper {
        public Object2ObjectMap<IngredientSorption, Int2ObjectMap<RecipeItemMapping>> map = new Object2ObjectOpenHashMap();

        public void map(IngredientSorption type, int recipePos, int slotPos, int xPos, int yPos) {
            this.map(type, recipePos, new RecipeItemMapping(slotPos, xPos, yPos));
        }

        public void map(IngredientSorption type, int recipePos, RecipeItemMapping mapping) {
            if (this.map.get((Object)type) == null) {
                this.map.put((Object)type, (Object)new Int2ObjectOpenHashMap());
            }
            ((Int2ObjectMap)this.map.get((Object)type)).put(recipePos, (Object)mapping);
        }

        public void mapItemsTo(IGuiItemStackGroup items, IIngredients ingredients) {
            for (Object2ObjectMap.Entry entry : this.map.object2ObjectEntrySet()) {
                List objects = entry.getKey() == IngredientSorption.INPUT ? ingredients.getInputs(ItemStack.class) : ingredients.getOutputs(ItemStack.class);
                for (Int2ObjectMap.Entry mapping : ((Int2ObjectMap)entry.getValue()).int2ObjectEntrySet()) {
                    RecipeItemMapping recipe = (RecipeItemMapping)mapping.getValue();
                    items.init(recipe.slotPos, entry.getKey() == IngredientSorption.INPUT, recipe.xPos, recipe.yPos);
                    Object obj = objects.get(mapping.getIntKey());
                    if (obj instanceof List) {
                        items.set(recipe.slotPos, (List)obj);
                        continue;
                    }
                    items.set(recipe.slotPos, (ItemStack)obj);
                }
            }
        }
    }
}

