/*
 * Decompiled with CFR 0.152.
 */
package nc.integration.jei;

import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import nc.integration.jei.JEIBasicCategory;
import nc.integration.jei.JEIBasicRecipeWrapper;
import nc.integration.jei.NCJEI;
import nc.recipe.ingredient.IChanceFluidIngredient;
import nc.recipe.ingredient.IChanceItemIngredient;
import nc.util.Lang;
import nc.util.NCMath;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;

public abstract class JEIMachineCategory<WRAPPER extends JEIBasicRecipeWrapper>
extends JEIBasicCategory<WRAPPER> {
    protected final IDrawable background;
    protected final String title;
    protected final int backPosX;
    protected final int backPosY;

    public JEIMachineCategory(IGuiHelper guiHelper, NCJEI.IJEIHandler handler, String blockName, int backX, int backY, int backWidth, int backHeight) {
        super(handler);
        ResourceLocation location = new ResourceLocation("nuclearcraft:textures/gui/container/" + handler.getTextureName() + ".png");
        this.background = guiHelper.createDrawable(location, backX, backY, backWidth, backHeight);
        this.title = Lang.localise("tile.nuclearcraft." + blockName + ".name");
        this.backPosX = backX + 1;
        this.backPosY = backY + 1;
    }

    public void drawExtras(Minecraft minecraft) {
    }

    public IDrawable getBackground() {
        return this.background;
    }

    @Override
    public void setRecipe(IRecipeLayout recipeLayout, WRAPPER recipeWrapper, IIngredients ingredients) {
        recipeLayout.getItemStacks().addTooltipCallback((slotIndex, input, ingredient, tooltip) -> {
            int outputIndex = slotIndex - recipeWrapper.recipeHandler.getItemInputSize();
            if (outputIndex >= 0 && outputIndex <= recipeWrapper.recipeHandler.getItemOutputSize() && recipeWrapper.recipe.getItemProducts().get(outputIndex) instanceof IChanceItemIngredient) {
                IChanceItemIngredient chanceIngredient = (IChanceItemIngredient)recipeWrapper.recipe.getItemProducts().get(outputIndex);
                tooltip.add(TextFormatting.WHITE + Lang.localise("jei.nuclearcraft.chance_output", chanceIngredient.getMinStackSize(), chanceIngredient.getMaxStackSize(0), NCMath.decimalPlaces(chanceIngredient.getMeanStackSize(), 2)));
            }
        });
        recipeLayout.getFluidStacks().addTooltipCallback((slotIndex, input, ingredient, tooltip) -> {
            int outputIndex = slotIndex - recipeWrapper.recipeHandler.getFluidInputSize();
            if (outputIndex >= 0 && outputIndex <= recipeWrapper.recipeHandler.getFluidOutputSize() && recipeWrapper.recipe.getFluidProducts().get(outputIndex) instanceof IChanceFluidIngredient) {
                IChanceFluidIngredient chanceIngredient = (IChanceFluidIngredient)recipeWrapper.recipe.getFluidProducts().get(outputIndex);
                tooltip.add(TextFormatting.WHITE + Lang.localise("jei.nuclearcraft.chance_output", chanceIngredient.getMinStackSize(), chanceIngredient.getMaxStackSize(0), NCMath.decimalPlaces(chanceIngredient.getMeanStackSize(), 2)));
            }
        });
    }

    public String getTitle() {
        return this.title;
    }
}

