/*
 * Decompiled with CFR 0.152.
 */
package nc.integration.jei.multiblock;

import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import nc.integration.jei.JEIHelper;
import nc.integration.jei.JEIMachineCategory;
import nc.integration.jei.JEIRecipeWrapper;
import nc.integration.jei.NCJEI;
import nc.recipe.IngredientSorption;
import nc.util.Lang;
import net.minecraft.util.text.TextFormatting;

public class HeatExchangerCategory
extends JEIMachineCategory<JEIRecipeWrapper.HeatExchanger> {
    private static final String TEMPERATURE = Lang.localise("jei.nuclearcraft.exchanger_fluid_temp");

    public HeatExchangerCategory(IGuiHelper guiHelper, NCJEI.IJEIHandler handler) {
        super(guiHelper, handler, "heat_exchanger_controller", 47, 30, 90, 26);
    }

    @Override
    public void setRecipe(IRecipeLayout recipeLayout, JEIRecipeWrapper.HeatExchanger recipeWrapper, IIngredients ingredients) {
        super.setRecipe(recipeLayout, recipeWrapper, ingredients);
        JEIHelper.RecipeFluidMapper fluidMapper = new JEIHelper.RecipeFluidMapper();
        fluidMapper.map(IngredientSorption.INPUT, 0, 0, 56 - this.backPosX, 35 - this.backPosY, 16, 16);
        fluidMapper.map(IngredientSorption.OUTPUT, 0, 1, 112 - this.backPosX, 31 - this.backPosY, 24, 24);
        fluidMapper.mapFluidsTo(recipeLayout.getFluidStacks(), ingredients);
        recipeLayout.getFluidStacks().addTooltipCallback((slotIndex, input, ingredient, tooltip) -> {
            boolean heating = recipeWrapper.recipe.getHeatExchangerIsHeating();
            if (slotIndex == 0) {
                tooltip.add((heating ? TextFormatting.AQUA : TextFormatting.RED) + TEMPERATURE + TextFormatting.WHITE + " " + recipeWrapper.recipe.getHeatExchangerInputTemperature() + "K");
            } else if (slotIndex == 1) {
                tooltip.add((heating ? TextFormatting.RED : TextFormatting.AQUA) + TEMPERATURE + TextFormatting.WHITE + " " + recipeWrapper.recipe.getHeatExchangerOutputTemperature() + "K");
            }
        });
    }

    @Override
    public String getTitle() {
        return Lang.localise("nuclearcraft.multiblock_gui.heat_exchanger.jei_name");
    }
}

