/*
 * Decompiled with CFR 0.152.
 */
package nc.integration.projecte;

import com.google.common.collect.Lists;
import java.util.List;
import moze_intel.projecte.api.ProjectEAPI;
import nc.init.NCBlocks;
import nc.util.OreDictHelper;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class NCProjectE {
    private static final List<String> BLOCK_BLACKLIST = Lists.newArrayList((Object[])new String[]{"Quartz", "NetherQuartz"});

    public static void addEMCValues() {
        NCProjectE.addIngotEMCValues("Iron", 256L);
        NCProjectE.addIngotEMCValues("Gold", 2048L);
        NCProjectE.addIngotEMCValues("Copper", 128L);
        NCProjectE.addIngotEMCValues("Tin", 256L);
        NCProjectE.addIngotEMCValues("Lead", 512L);
        NCProjectE.addIngotEMCValues("Thorium", 2048L);
        NCProjectE.addIngotEMCValues("Uranium", 4096L);
        NCProjectE.addIngotEMCValues("Boron", 512L);
        NCProjectE.addIngotEMCValues("Lithium", 512L);
        NCProjectE.addIngotEMCValues("Magnesium", 512L);
        NCProjectE.addIngotEMCValues("Graphite", 64L);
        NCProjectE.addIngotEMCValues("Beryllium", 128L);
        NCProjectE.addIngotEMCValues("Zirconium", 128L);
        NCProjectE.addIngotEMCValues("Manganese", 128L);
        NCProjectE.addIngotEMCValues("ManganeseOxide", 128L);
        NCProjectE.addIngotEMCValues("ManganeseDioxide", 128L);
        NCProjectE.addIngotEMCValues("Aluminum", 128L);
        NCProjectE.addIngotEMCValues("Silver", 512L);
        NCProjectE.addIngotEMCValues("Tough", 464L);
        NCProjectE.addIngotEMCValues("HardCarbon", 4160L);
        NCProjectE.addIngotEMCValues("MagnesiumDiboride", 512L);
        NCProjectE.addIngotEMCValues("LithiumManganeseDioxide", 320L);
        NCProjectE.addIngotEMCValues("Steel", 320L);
        NCProjectE.addIngotEMCValues("Ferroboron", 416L);
        NCProjectE.addIngotEMCValues("Shibuichi", 448L);
        NCProjectE.addIngotEMCValues("TinSilver", 640L);
        NCProjectE.addIngotEMCValues("LeadPlatinum", 2816L);
        NCProjectE.addIngotEMCValues("Extreme", 4624L);
        NCProjectE.addIngotEMCValues("Thermoconducting", 2600L);
        NCProjectE.addIngotEMCValues("Zircaloy", 144L);
        NCProjectE.addIngotEMCValues("SiliconCarbide", 32L);
        NCProjectE.addIngotEMCValues("HSLASteel", 246L);
        NCProjectE.addGemEMCValues("Diamond", 8192L);
        NCProjectE.addGemEMCValues("Rhodochrosite", 64L);
        NCProjectE.addGemEMCValues("Quartz", 256L);
        NCProjectE.addGemEMCValues("NetherQuartz", 256L);
        NCProjectE.addGemEMCValues("BoronNitride", 256L);
        NCProjectE.addGemEMCValues("Fluorite", 64L);
        NCProjectE.addGemEMCValues("Villiaumite", 64L);
        NCProjectE.addGemEMCValues("Carobbiite", 64L);
        NCProjectE.addGemEMCValues("Arsenic", 64L);
        NCProjectE.addGemEMCValues("BoronArsenide", 576L);
        NCProjectE.addCompoundEMCValues("CalciumSulfate", 96L);
        NCProjectE.addCompoundEMCValues("CrystalBinder", 344L);
        NCProjectE.addCompoundEMCValues("Energetic", 224L);
        NCProjectE.addCompoundEMCValues("SodiumFluoride", 64L);
        NCProjectE.addCompoundEMCValues("PotassiumFluoride", 64L);
        NCProjectE.addCompoundEMCValues("SodiumHydroxide", 64L);
        NCProjectE.addCompoundEMCValues("PotassiumHydroxide", 64L);
        NCProjectE.addCompoundEMCValues("Borax", 1152L);
        NCProjectE.addCompoundEMCValues("Dimensional", 32L);
        NCProjectE.addCompoundEMCValues("CarbonManganese", 96L);
        NCProjectE.addCompoundEMCValues("Alugentum", 1024L);
        ProjectEAPI.getEMCProxy().registerCustomEMC(new ItemStack(NCBlocks.wasteland_earth), 1);
        NCProjectE.addEMCValues("dustObsidian", 16L);
        NCProjectE.addEMCValues("dustEndstone", 1L);
        NCProjectE.addEMCValues("itemSilicon", 1L);
        NCProjectE.addEMCValues("ingotSilicon", 1L);
    }

    private static void addEMCValues(String type, long emc) {
        for (ItemStack stack : OreDictionary.getOres((String)type, (boolean)false)) {
            ProjectEAPI.getEMCProxy().registerCustomEMC(stack, emc);
        }
    }

    private static void addIngotEMCValues(String type, long emc) {
        for (String prefix : OreDictHelper.INGOT_VOLUME_TYPES) {
            NCProjectE.addEMCValues(prefix + type, emc);
        }
        if (!BLOCK_BLACKLIST.contains(type)) {
            for (String prefix : OreDictHelper.BLOCK_VOLUME_TYPES) {
                NCProjectE.addEMCValues(prefix + type, emc * 9L);
            }
        }
    }

    private static void addGemEMCValues(String type, long emc) {
        for (String prefix : OreDictHelper.GEM_VOLUME_TYPES) {
            NCProjectE.addEMCValues(prefix + type, emc);
        }
        if (!BLOCK_BLACKLIST.contains(type)) {
            for (String prefix : OreDictHelper.BLOCK_VOLUME_TYPES) {
                NCProjectE.addEMCValues(prefix + type, emc * 9L);
            }
        }
    }

    private static void addCompoundEMCValues(String type, long emc) {
        NCProjectE.addEMCValues("dust" + type, emc);
    }
}

