/*
 * Decompiled with CFR 0.152.
 */
package nc.item;

import java.util.LinkedList;
import java.util.List;
import nc.config.NCConfig;
import nc.item.NCItem;
import nc.tile.IMultitoolLogic;
import nc.util.Lang;
import nc.util.NCMath;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemMultitool
extends NCItem {
    public static final List<MultitoolRightClickLogic> MULTITOOL_RIGHT_CLICK_LOGIC = new LinkedList<MultitoolRightClickLogic>();

    public ItemMultitool(String ... tooltip) {
        super(tooltip);
        this.field_77777_bU = 1;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }

    public static boolean isMultitool(ItemStack stack) {
        return stack.func_190926_b() ? false : stack.func_77973_b() instanceof ItemMultitool;
    }

    protected static void clearNBT(ItemStack stack) {
        stack.func_77982_d(new NBTTagCompound());
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, EnumHand hand) {
        TileEntity tile;
        ItemStack stack = player.func_184586_b(hand);
        if (ItemMultitool.isMultitool(stack) && (tile = world.func_175625_s(pos)) instanceof IMultitoolLogic && !world.field_72995_K) {
            if (stack.func_77978_p() == null) {
                ItemMultitool.clearNBT(stack);
            }
            NBTTagCompound nbt = stack.func_77978_p();
            boolean multitoolUsed = ((IMultitoolLogic)tile).onUseMultitool(stack, player, world, facing, hitX, hitY, hitZ);
            nbt.func_74757_a("multitoolUsed", multitoolUsed);
            tile.func_70296_d();
            if (multitoolUsed) {
                return EnumActionResult.SUCCESS;
            }
        }
        return super.onItemUseFirst(player, world, pos, facing, hitX, hitY, hitZ, hand);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (ItemMultitool.isMultitool(stack) && !world.field_72995_K) {
            if (stack.func_77978_p() == null) {
                ItemMultitool.clearNBT(stack);
            }
            for (MultitoolRightClickLogic logic : MULTITOOL_RIGHT_CLICK_LOGIC) {
                ActionResult<ItemStack> result = logic.onRightClick(this, world, player, hand, stack);
                if (result == null) continue;
                return result;
            }
        }
        return super.func_77659_a(world, player, hand);
    }

    public boolean doesSneakBypassUse(ItemStack stack, IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return false;
    }

    public static void registerRightClickLogic() {
        MULTITOOL_RIGHT_CLICK_LOGIC.add(new MultitoolRightClickLogic(){

            @Override
            public ActionResult<ItemStack> onRightClick(ItemMultitool itemMultitool, World world, EntityPlayer player, EnumHand hand, ItemStack heldItem) {
                NBTTagCompound nbt = heldItem.func_77978_p();
                if (!player.func_70093_af() && nbt.func_74779_i("gateMode").equals("angle")) {
                    double angle = NCMath.roundTo((double)player.field_70177_z + 360.0, 360.0 / (double)NCConfig.quantum_angle_precision) % 360.0;
                    nbt.func_74780_a("gateAngle", angle);
                    player.func_145747_a((ITextComponent)new TextComponentString(Lang.localise("info.nuclearcraft.multitool.quantum_computer.tool_set_angle", NCMath.decimalPlaces(angle, 5))));
                    return itemMultitool.actionResult(true, heldItem);
                }
                return null;
            }
        });
        MULTITOOL_RIGHT_CLICK_LOGIC.add(new MultitoolRightClickLogic(){

            @Override
            public ActionResult<ItemStack> onRightClick(ItemMultitool itemMultitool, World world, EntityPlayer player, EnumHand hand, ItemStack heldItem) {
                NBTTagCompound nbt = heldItem.func_77978_p();
                if (player.func_70093_af() && !nbt.func_82582_d() && !nbt.func_74767_n("multitoolUsed")) {
                    RayTraceResult raytraceresult = itemMultitool.func_77621_a(world, player, false);
                    if (raytraceresult == null || raytraceresult.field_72313_a != RayTraceResult.Type.BLOCK) {
                        return itemMultitool.actionResult(false, heldItem);
                    }
                    BlockPos pos = raytraceresult.func_178782_a();
                    TileEntity tile = world.func_175625_s(pos);
                    if (!(tile instanceof IMultitoolLogic)) {
                        ItemMultitool.clearNBT(heldItem);
                        player.func_145747_a((ITextComponent)new TextComponentString(Lang.localise("info.nuclearcraft.multitool.clear_info")));
                        return itemMultitool.actionResult(true, heldItem);
                    }
                }
                return null;
            }
        });
        MULTITOOL_RIGHT_CLICK_LOGIC.add(new MultitoolRightClickLogic(){

            @Override
            public ActionResult<ItemStack> onRightClick(ItemMultitool itemMultitool, World world, EntityPlayer player, EnumHand hand, ItemStack heldItem) {
                heldItem.func_77978_p().func_82580_o("multitoolUsed");
                return null;
            }
        });
    }

    public static abstract class MultitoolRightClickLogic {
        public abstract ActionResult<ItemStack> onRightClick(ItemMultitool var1, World var2, EntityPlayer var3, EnumHand var4, ItemStack var5);
    }
}

