/*
 * Decompiled with CFR 0.152.
 */
package nc.item;

import java.util.List;
import javax.annotation.Nullable;
import nc.enumm.IMetaEnum;
import nc.item.IInfoItem;
import nc.util.InfoHelper;
import nc.util.StackHelper;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class NCItemMeta<T extends Enum<T> & IMetaEnum>
extends Item
implements IInfoItem {
    private final Class<T> enumm;
    public final T[] values;
    public final TextFormatting infoColor;
    private final String[][] tooltips;
    public String[][] info;

    public NCItemMeta(Class<T> enumm, TextFormatting infoColor, String[] ... tooltips) {
        this.func_77627_a(true);
        this.enumm = enumm;
        this.values = (Enum[])enumm.getEnumConstants();
        this.infoColor = infoColor;
        this.tooltips = tooltips;
    }

    public NCItemMeta(Class<T> enumm, String[] ... tooltips) {
        this(enumm, TextFormatting.AQUA, tooltips);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            for (int i = 0; i < this.values.length; ++i) {
                items.add((Object)new ItemStack((Item)this, 1, i));
            }
        }
    }

    public String func_77667_c(ItemStack stack) {
        for (int i = 0; i < this.values.length; ++i) {
            if (StackHelper.getMetadata(stack) != i) continue;
            return this.func_77658_a() + "." + ((IStringSerializable)this.values[i]).func_176610_l();
        }
        return this.func_77658_a() + "." + ((IStringSerializable)this.values[0]).func_176610_l();
    }

    @Override
    public void setInfo() {
        this.info = InfoHelper.buildInfo(this.func_77658_a(), this.enumm, this.tooltips);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        super.func_77624_a(stack, world, tooltip, flag);
        int meta = StackHelper.getMetadata(stack);
        if (this.info.length > meta) {
            InfoHelper.infoFull(tooltip, TextFormatting.RED, InfoHelper.EMPTY_ARRAY, this.infoColor, this.info[meta]);
        }
    }

    protected ActionResult<ItemStack> actionResult(boolean success, ItemStack stack) {
        return new ActionResult(success ? EnumActionResult.SUCCESS : EnumActionResult.FAIL, (Object)stack);
    }
}

