/*
 * Decompiled with CFR 0.152.
 */
package nc.item.bauble;

import baubles.api.BaubleType;
import baubles.api.IBauble;
import nc.capability.radiation.entity.IEntityRads;
import nc.config.NCConfig;
import nc.item.NCItem;
import nc.radiation.RadiationHandler;
import nc.radiation.RadiationHelper;
import nc.util.Lang;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;

@Optional.Interface(iface="baubles.api.IBauble", modid="baubles")
public class ItemGeigerCounter
extends NCItem
implements IBauble {
    private static final String RADIATION = Lang.localise("item.nuclearcraft.geiger_counter.rads");

    public ItemGeigerCounter(String ... tooltip) {
        super(tooltip);
        this.field_77777_bU = 1;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        IEntityRads playerRads;
        RayTraceResult rayTrace;
        if (worldIn.field_72995_K && ((rayTrace = Minecraft.func_71410_x().field_71476_x) == null || rayTrace.field_72313_a != RayTraceResult.Type.ENTITY) && (playerRads = RadiationHelper.getEntityRadiation((EntityLivingBase)playerIn)) != null) {
            playerIn.func_145747_a((ITextComponent)new TextComponentString(RadiationHelper.getRadsTextColor(playerRads) + RADIATION + " " + (playerRads.isTotalRadsNegligible() ? "0 Rad" : RadiationHelper.radsPrefix(playerRads.getTotalRads(), false)) + " [" + Math.round(playerRads.getRadsPercentage()) + "%], " + RadiationHelper.getRawRadiationTextColor(playerRads) + (playerRads.isRawRadiationNegligible() ? "0 Rad/t" : RadiationHelper.radsPrefix(playerRads.getRawRadiationLevel(), true))));
        }
        return new ActionResult(EnumActionResult.PASS, (Object)playerIn.func_184586_b(handIn));
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer player, EntityLivingBase entity, EnumHand hand) {
        IEntityRads entityRads;
        if (!entity.field_70170_p.field_72995_K && (entityRads = RadiationHelper.getEntityRadiation(entity)) != null) {
            player.func_145747_a((ITextComponent)new TextComponentString(RadiationHelper.getRadsTextColor(entityRads) + RADIATION + " " + (entityRads.isTotalRadsNegligible() ? "0 Rad" : RadiationHelper.radsPrefix(entityRads.getTotalRads(), false)) + " [" + Math.round(entityRads.getRadsPercentage()) + "%], " + RadiationHelper.getRadiationTextColor(entityRads) + (entityRads.isRadiationNegligible() ? "0 Rad/t" : RadiationHelper.radsPrefix(entityRads.getRadiationLevel(), true))));
        }
        return false;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (!(world.field_72995_K && NCConfig.radiation_require_counter && entity instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entity;
        if (this.isStackOnHotbar(stack, player)) {
            RadiationHandler.playGeigerSound(player);
        }
    }

    @Optional.Method(modid="baubles")
    public BaubleType getBaubleType(ItemStack stack) {
        return BaubleType.TRINKET;
    }
}

