/*
 * Decompiled with CFR 0.152.
 */
package nc.item.energy;

import nc.tile.internal.energy.EnergyConnection;
import nc.tile.internal.energy.EnergyStorage;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public interface IChargableItem {
    public static NBTTagCompound getEnergyStorageNBT(ItemStack stack) {
        if (!(stack.func_77973_b() instanceof IChargableItem)) {
            return null;
        }
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound nbt = stack.func_77978_p();
        IChargableItem item = (IChargableItem)stack.func_77973_b();
        if (!nbt.func_74764_b("energyStorage")) {
            new EnergyStorage(item.getMaxEnergyStored(stack), item.getMaxTransfer(stack), 0L).writeToNBT(nbt, "energyStorage");
        }
        return nbt.func_74775_l("energyStorage");
    }

    default public long getEnergyStored(ItemStack stack) {
        NBTTagCompound nbt = IChargableItem.getEnergyStorageNBT(stack);
        return nbt == null ? 0L : nbt.func_74763_f("energy");
    }

    default public void setEnergyStored(ItemStack stack, long energy) {
        NBTTagCompound nbt = IChargableItem.getEnergyStorageNBT(stack);
        if (nbt != null && nbt.func_74764_b("energy")) {
            nbt.func_74772_a("energy", energy);
        }
    }

    public long getMaxEnergyStored(ItemStack var1);

    public int getMaxTransfer(ItemStack var1);

    public boolean canReceive(ItemStack var1);

    public boolean canExtract(ItemStack var1);

    public EnergyConnection getEnergyConnection(ItemStack var1);

    public int getEnergyTier(ItemStack var1);
}

