/*
 * Decompiled with CFR 0.152.
 */
package nc.multiblock;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import nc.multiblock.MultiblockRegistry;
import nc.multiblock.MultiblockValidationError;
import nc.multiblock.WorldHelper;
import nc.multiblock.tile.ITileMultiblockPart;
import nc.multiblock.tile.TileBeefAbstract;
import nc.network.PacketHandler;
import nc.network.multiblock.MultiblockUpdatePacket;
import nc.tile.fluid.ITileFluid;
import nc.tile.internal.energy.EnergyStorage;
import nc.tile.internal.fluid.Tank;
import nc.tile.inventory.ITileInventory;
import nc.util.SuperMap;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.common.FMLLog;

public abstract class Multiblock<T extends ITileMultiblockPart, PACKET extends MultiblockUpdatePacket> {
    public static final short DIMENSION_UNBOUNDED = -1;
    public final World WORLD;
    public AssemblyState assemblyState;
    protected ObjectOpenHashSet<ITileMultiblockPart> connectedParts;
    public Random rand = new Random();
    private BlockPos referenceCoord;
    private BlockPos minimumCoord;
    private BlockPos maximumCoord;
    private boolean shouldCheckForDisconnections;
    private MultiblockValidationError lastValidationError;
    private boolean debugMode;
    protected Set<EntityPlayer> playersToUpdate;

    protected Multiblock(World world) {
        this.WORLD = world;
        this.connectedParts = new ObjectOpenHashSet();
        this.referenceCoord = null;
        this.assemblyState = AssemblyState.Disassembled;
        this.minimumCoord = null;
        this.maximumCoord = null;
        this.shouldCheckForDisconnections = true;
        this.lastValidationError = null;
        this.debugMode = false;
        this.playersToUpdate = new ObjectOpenHashSet();
    }

    public void setDebugMode(boolean active) {
        this.debugMode = active;
    }

    public boolean isDebugMode() {
        return this.debugMode;
    }

    public abstract void onAttachedPartWithMultiblockData(ITileMultiblockPart var1, NBTTagCompound var2);

    public void attachBlock(ITileMultiblockPart part) {
        int newZ;
        int newY;
        int newX;
        int partCoord;
        int curZ;
        int curY;
        int curX;
        TileEntity te;
        BlockPos coord = part.getTilePos();
        if (!this.connectedParts.add((Object)part)) {
            FMLLog.warning((String)"[%s] Multiblock %s is double-adding part %d @ %s. This is unusual. If you encounter odd behavior, please tear down the multiblock and rebuild it.", (Object[])new Object[]{this.WORLD.field_72995_K ? "CLIENT" : "SERVER", this.hashCode(), part.hashCode(), coord});
        }
        part.onAttached(this);
        this.onBlockAdded(part);
        if (part.hasMultiblockSaveData()) {
            NBTTagCompound savedData = part.getMultiblockSaveData();
            this.onAttachedPartWithMultiblockData(part, savedData);
            part.onMultiblockDataAssimilated();
        }
        TileEntity tileEntity = te = this.referenceCoord == null ? null : this.WORLD.func_175625_s(this.referenceCoord);
        if (!(te instanceof ITileMultiblockPart)) {
            this.referenceCoord = coord;
            part.becomeMultiblockSaveDelegate();
        } else if (coord.compareTo((Vec3i)this.referenceCoord) < 0) {
            ((ITileMultiblockPart)te).forfeitMultiblockSaveDelegate();
            this.referenceCoord = coord;
            part.becomeMultiblockSaveDelegate();
        } else {
            part.forfeitMultiblockSaveDelegate();
        }
        BlockPos partPos = part.getTilePos();
        if (this.minimumCoord != null) {
            curX = this.minimumCoord.func_177958_n();
            curY = this.minimumCoord.func_177956_o();
            curZ = this.minimumCoord.func_177952_p();
            partCoord = partPos.func_177958_n();
            newX = partCoord < curX ? partCoord : curX;
            partCoord = partPos.func_177956_o();
            newY = partCoord < curY ? partCoord : curY;
            partCoord = partPos.func_177952_p();
            int n = newZ = partCoord < curZ ? partCoord : curZ;
            if (newX != curX || newY != curY || newZ != curZ) {
                this.minimumCoord = new BlockPos(newX, newY, newZ);
            }
        }
        if (this.maximumCoord != null) {
            curX = this.maximumCoord.func_177958_n();
            curY = this.maximumCoord.func_177956_o();
            curZ = this.maximumCoord.func_177952_p();
            partCoord = partPos.func_177958_n();
            newX = partCoord > curX ? partCoord : curX;
            partCoord = partPos.func_177956_o();
            newY = partCoord > curY ? partCoord : curY;
            partCoord = partPos.func_177952_p();
            int n = newZ = partCoord > curZ ? partCoord : curZ;
            if (newX != curX || newY != curY || newZ != curZ) {
                this.maximumCoord = new BlockPos(newX, newY, newZ);
            }
        }
        MultiblockRegistry.INSTANCE.addDirtyMultiblock(this.WORLD, this);
    }

    protected abstract void onBlockAdded(ITileMultiblockPart var1);

    protected abstract void onBlockRemoved(ITileMultiblockPart var1);

    protected abstract void onMachineAssembled();

    protected abstract void onMachineRestored();

    protected abstract void onMachinePaused();

    protected abstract void onMachineDisassembled();

    private void onDetachBlock(ITileMultiblockPart part) {
        part.onDetached(this);
        this.onBlockRemoved(part);
        part.forfeitMultiblockSaveDelegate();
        this.maximumCoord = null;
        this.minimumCoord = null;
        if (this.referenceCoord != null && this.referenceCoord.equals((Object)part.getTilePos())) {
            this.referenceCoord = null;
        }
        this.shouldCheckForDisconnections = true;
    }

    public void detachBlock(ITileMultiblockPart part, boolean chunkUnloading) {
        if (chunkUnloading && this.assemblyState == AssemblyState.Assembled) {
            this.assemblyState = AssemblyState.Paused;
            this.onMachinePaused();
        }
        this.onDetachBlock(part);
        if (!this.connectedParts.remove((Object)part)) {
            BlockPos position = part.getTilePos();
            FMLLog.warning((String)"[%s] Double-removing part (%d) @ %d, %d, %d, this is unexpected and may cause problems. If you encounter anomalies, please tear down the multiblock and rebuild it.", (Object[])new Object[]{this.WORLD.field_72995_K ? "CLIENT" : "SERVER", part.hashCode(), position.func_177958_n(), position.func_177956_o(), position.func_177952_p()});
        }
        if (this.connectedParts.isEmpty()) {
            MultiblockRegistry.INSTANCE.addDeadMultiblock(this.WORLD, this);
            return;
        }
        MultiblockRegistry.INSTANCE.addDirtyMultiblock(this.WORLD, this);
        if (this.referenceCoord == null) {
            this.selectNewReferenceCoord();
        }
    }

    protected abstract int getMinimumNumberOfBlocksForAssembledMachine();

    protected abstract int getMaximumXSize();

    protected abstract int getMaximumZSize();

    protected abstract int getMaximumYSize();

    protected int getMinimumXSize() {
        return 1;
    }

    protected int getMinimumYSize() {
        return 1;
    }

    protected int getMinimumZSize() {
        return 1;
    }

    public MultiblockValidationError getLastError() {
        return this.lastValidationError;
    }

    public void setLastError(MultiblockValidationError error) {
        if (null == error) {
            throw new IllegalArgumentException("The validation error can't be null");
        }
        this.lastValidationError = error;
    }

    public void setLastError(String messageFormatStringResourceKey, BlockPos pos, Object ... messageParameters) {
        this.lastValidationError = new MultiblockValidationError(messageFormatStringResourceKey, pos, messageParameters);
    }

    protected abstract boolean isMachineWhole();

    public void checkIfMachineIsWhole() {
        AssemblyState oldState = this.assemblyState;
        this.lastValidationError = null;
        if (this.isMachineWhole()) {
            this.assembleMachine(oldState);
        } else if (oldState == AssemblyState.Assembled) {
            this.disassembleMachine();
        }
    }

    private void assembleMachine(AssemblyState oldState) {
        for (ITileMultiblockPart part : this.connectedParts) {
            part.onMachineAssembled(this);
        }
        this.assemblyState = AssemblyState.Assembled;
        if (oldState == AssemblyState.Paused) {
            this.onMachineRestored();
        } else {
            this.onMachineAssembled();
        }
    }

    private void disassembleMachine() {
        for (ITileMultiblockPart part : this.connectedParts) {
            part.onMachineBroken();
        }
        this.assemblyState = AssemblyState.Disassembled;
        this.onMachineDisassembled();
    }

    public void assimilate(Multiblock other) {
        BlockPos otherReferenceCoord = other.getReferenceCoord();
        if (otherReferenceCoord != null && this.getReferenceCoord().compareTo((Vec3i)otherReferenceCoord) >= 0) {
            throw new IllegalArgumentException("The multiblock with the lowest minimum-coord value must consume the one with the higher coords");
        }
        ObjectOpenHashSet partsToAcquire = new ObjectOpenHashSet(other.connectedParts);
        if (other.assemblyState == AssemblyState.Assembled) {
            other.disassembleMachine();
        }
        other._onAssimilated(this);
        for (ITileMultiblockPart acquiredPart : partsToAcquire) {
            if (acquiredPart.isPartInvalid()) continue;
            this.connectedParts.add((Object)acquiredPart);
            acquiredPart.onAssimilated(this);
            this.onBlockAdded(acquiredPart);
        }
        this.onAssimilate(other);
        other.onAssimilated(this);
    }

    private void _onAssimilated(Multiblock otherMultiblock) {
        if (this.referenceCoord != null) {
            TileEntity te;
            if (this.WORLD.func_175667_e(this.referenceCoord) && (te = this.WORLD.func_175625_s(this.referenceCoord)) instanceof ITileMultiblockPart) {
                ((ITileMultiblockPart)te).forfeitMultiblockSaveDelegate();
            }
            this.referenceCoord = null;
        }
        this.connectedParts.clear();
    }

    protected abstract void onAssimilate(Multiblock var1);

    protected abstract void onAssimilated(Multiblock var1);

    public final void updateMultiblockEntity() {
        if (this.connectedParts.isEmpty()) {
            MultiblockRegistry.INSTANCE.addDeadMultiblock(this.WORLD, this);
            return;
        }
        if (this.assemblyState != AssemblyState.Assembled) {
            return;
        }
        if (this.WORLD.field_72995_K) {
            this.updateClient();
        } else if (this.updateServer()) {
            this.markChunksDirty();
        }
    }

    public void markChunksDirty() {
        if (this.minimumCoord != null && this.maximumCoord != null && this.WORLD.func_175707_a(this.minimumCoord, this.maximumCoord)) {
            int minChunkX = WorldHelper.getChunkXFromBlock(this.minimumCoord);
            int minChunkZ = WorldHelper.getChunkZFromBlock(this.minimumCoord);
            int maxChunkX = WorldHelper.getChunkXFromBlock(this.maximumCoord);
            int maxChunkZ = WorldHelper.getChunkZFromBlock(this.maximumCoord);
            for (int x = minChunkX; x <= maxChunkX; ++x) {
                for (int z = minChunkZ; z <= maxChunkZ; ++z) {
                    Chunk chunkToSave = this.WORLD.func_72964_e(x, z);
                    chunkToSave.func_76630_e();
                }
            }
        }
    }

    protected abstract boolean updateServer();

    protected abstract void updateClient();

    public boolean standardLastError(BlockPos pos) {
        this.setLastError("nuclearcraft.multiblock_validation.invalid_block", pos, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), this.WORLD.func_180495_p(pos).func_177230_c().func_149732_F());
        return false;
    }

    protected boolean isBlockGoodForFrame(World world, BlockPos pos) {
        return this.standardLastError(pos);
    }

    protected boolean isBlockGoodForTop(World world, BlockPos pos) {
        return this.standardLastError(pos);
    }

    protected boolean isBlockGoodForBottom(World world, BlockPos pos) {
        return this.standardLastError(pos);
    }

    protected boolean isBlockGoodForSides(World world, BlockPos pos) {
        return this.standardLastError(pos);
    }

    protected abstract boolean isBlockGoodForInterior(World var1, BlockPos var2);

    public BlockPos getReferenceCoord() {
        if (this.referenceCoord == null) {
            this.selectNewReferenceCoord();
        }
        return this.referenceCoord;
    }

    public int getNumConnectedBlocks() {
        return this.connectedParts.size();
    }

    public abstract void syncDataFrom(NBTTagCompound var1, TileBeefAbstract.SyncReason var2);

    public abstract void syncDataTo(NBTTagCompound var1, TileBeefAbstract.SyncReason var2);

    public NBTTagCompound writeStacks(NonNullList<ItemStack> stacks, NBTTagCompound data) {
        ItemStackHelper.func_191282_a((NBTTagCompound)data, stacks);
        return data;
    }

    public void readStacks(NonNullList<ItemStack> stacks, NBTTagCompound data) {
        ItemStackHelper.func_191283_b((NBTTagCompound)data, stacks);
    }

    public NBTTagCompound writeTanks(List<Tank> tanks, NBTTagCompound data, String name) {
        for (int i = 0; i < tanks.size(); ++i) {
            tanks.get(i).writeToNBT(data, name + i);
        }
        return data;
    }

    public void readTanks(List<Tank> tanks, NBTTagCompound data, String name) {
        for (int i = 0; i < tanks.size(); ++i) {
            tanks.get(i).readFromNBT(data, name + i);
        }
    }

    public NBTTagCompound writeEnergy(EnergyStorage storage, NBTTagCompound data, String string) {
        storage.writeToNBT(data, string);
        return data;
    }

    public void readEnergy(EnergyStorage storage, NBTTagCompound data, String string) {
        storage.readFromNBT(data, string);
    }

    public void recalculateMinMaxCoords() {
        int minZ = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int minX = Integer.MAX_VALUE;
        int maxZ = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        int maxX = Integer.MIN_VALUE;
        for (ITileMultiblockPart part : this.connectedParts) {
            BlockPos partPos = part.getTilePos();
            int partCoord = partPos.func_177958_n();
            if (partCoord < minX) {
                minX = partCoord;
            }
            if (partCoord > maxX) {
                maxX = partCoord;
            }
            if ((partCoord = partPos.func_177956_o()) < minY) {
                minY = partCoord;
            }
            if (partCoord > maxY) {
                maxY = partCoord;
            }
            if ((partCoord = partPos.func_177952_p()) < minZ) {
                minZ = partCoord;
            }
            if (partCoord <= maxZ) continue;
            maxZ = partCoord;
        }
        this.minimumCoord = new BlockPos(minX, minY, minZ);
        this.maximumCoord = new BlockPos(maxX, maxY, maxZ);
    }

    public BlockPos getMinimumCoord() {
        if (this.minimumCoord == null) {
            this.recalculateMinMaxCoords();
        }
        return this.minimumCoord;
    }

    public BlockPos getMaximumCoord() {
        if (this.maximumCoord == null) {
            this.recalculateMinMaxCoords();
        }
        return this.maximumCoord;
    }

    public int getMinX() {
        return this.getMinimumCoord().func_177958_n();
    }

    public int getMinY() {
        return this.getMinimumCoord().func_177956_o();
    }

    public int getMinZ() {
        return this.getMinimumCoord().func_177952_p();
    }

    public int getMaxX() {
        return this.getMaximumCoord().func_177958_n();
    }

    public int getMaxY() {
        return this.getMaximumCoord().func_177956_o();
    }

    public int getMaxZ() {
        return this.getMaximumCoord().func_177952_p();
    }

    public BlockPos getExtremeCoord(boolean maxX, boolean maxY, boolean maxZ) {
        return new BlockPos(maxX ? this.getMaxX() : this.getMinX(), maxY ? this.getMaxY() : this.getMinY(), maxZ ? this.getMaxZ() : this.getMinZ());
    }

    public int getMiddleX() {
        return (int)(((long)this.getMinX() + (long)this.getMaxX()) / 2L);
    }

    public int getMiddleY() {
        return (int)(((long)this.getMinY() + (long)this.getMaxY()) / 2L);
    }

    public int getMiddleZ() {
        return (int)(((long)this.getMinZ() + (long)this.getMaxZ()) / 2L);
    }

    public BlockPos getMiddleCoord() {
        return new BlockPos(this.getMiddleX(), this.getMiddleY(), this.getMiddleZ());
    }

    public boolean isEmpty() {
        return this.connectedParts.isEmpty();
    }

    public boolean shouldConsume(Multiblock otherMultiblock) {
        if (!otherMultiblock.getClass().equals(this.getClass())) {
            throw new IllegalArgumentException("Attempting to merge two multiblocks with different master classes - this should never happen!");
        }
        if (otherMultiblock == this) {
            return false;
        }
        int res = this._shouldConsume(otherMultiblock);
        if (res < 0) {
            return true;
        }
        if (res > 0) {
            return false;
        }
        FMLLog.warning((String)"[%s] Encountered two multiblocks with the same reference coordinate. Auditing connected parts and retrying.", (Object[])new Object[]{this.WORLD.field_72995_K ? "CLIENT" : "SERVER"});
        this.auditParts();
        otherMultiblock.auditParts();
        res = this._shouldConsume(otherMultiblock);
        if (res < 0) {
            return true;
        }
        if (res > 0) {
            return false;
        }
        FMLLog.severe((String)"My Multiblock (%d): size (%d), parts: %s", (Object[])new Object[]{this.hashCode(), this.connectedParts.size(), this.getPartsListString()});
        FMLLog.severe((String)"Other Multiblock (%d): size (%d), coords: %s", (Object[])new Object[]{otherMultiblock.hashCode(), otherMultiblock.connectedParts.size(), otherMultiblock.getPartsListString()});
        throw new IllegalArgumentException("[" + (this.WORLD.field_72995_K ? "CLIENT" : "SERVER") + "] Two multiblocks with the same reference coord that somehow both have valid parts - this should never happen!");
    }

    private int _shouldConsume(Multiblock otherMultiblock) {
        BlockPos myCoord = this.getReferenceCoord();
        BlockPos theirCoord = otherMultiblock.getReferenceCoord();
        if (theirCoord == null) {
            return -1;
        }
        return myCoord.compareTo((Vec3i)theirCoord);
    }

    private String getPartsListString() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (ITileMultiblockPart part : this.connectedParts) {
            if (!first) {
                sb.append(", ");
            }
            BlockPos partPos = part.getTilePos();
            sb.append(String.format("(%d: %d, %d, %d)", part.hashCode(), partPos.func_177958_n(), partPos.func_177956_o(), partPos.func_177952_p()));
            first = false;
        }
        return sb.toString();
    }

    private void auditParts() {
        ObjectOpenHashSet deadParts = new ObjectOpenHashSet();
        for (ITileMultiblockPart part : this.connectedParts) {
            if (!part.isPartInvalid() && this.WORLD.func_175625_s(part.getTilePos()) == part) continue;
            this.onDetachBlock(part);
            deadParts.add((Object)part);
        }
        this.connectedParts.removeAll((Collection)deadParts);
        FMLLog.warning((String)"[%s] Multiblock found %d dead parts during an audit, %d parts remain attached", (Object[])new Object[]{this.WORLD.field_72995_K ? "CLIENT" : "SERVER", deadParts.size(), this.connectedParts.size()});
    }

    public Set<ITileMultiblockPart> checkForDisconnections() {
        if (!this.shouldCheckForDisconnections) {
            return null;
        }
        if (this.isEmpty()) {
            MultiblockRegistry.INSTANCE.addDeadMultiblock(this.WORLD, this);
            return null;
        }
        this.referenceCoord = null;
        ObjectOpenHashSet deadParts = new ObjectOpenHashSet();
        ITileMultiblockPart referencePart = null;
        int originalSize = this.connectedParts.size();
        for (ITileMultiblockPart part : this.connectedParts) {
            BlockPos position = part.getTilePos();
            if (!this.WORLD.func_175667_e(position) || part.isPartInvalid()) {
                deadParts.add(part);
                this.onDetachBlock(part);
                continue;
            }
            if (this.WORLD.func_175625_s(position) != part) {
                deadParts.add(part);
                this.onDetachBlock(part);
                continue;
            }
            part.setUnvisited();
            part.forfeitMultiblockSaveDelegate();
            if (this.referenceCoord == null) {
                this.referenceCoord = position;
                referencePart = part;
                continue;
            }
            if (position.compareTo((Vec3i)this.referenceCoord) >= 0) continue;
            this.referenceCoord = position;
            referencePart = part;
        }
        this.connectedParts.removeAll((Collection)deadParts);
        deadParts.clear();
        if (referencePart == null || this.isEmpty()) {
            this.shouldCheckForDisconnections = false;
            MultiblockRegistry.INSTANCE.addDeadMultiblock(this.WORLD, this);
            return null;
        }
        referencePart.becomeMultiblockSaveDelegate();
        LinkedList partsToCheck = new LinkedList();
        ITileMultiblockPart<MULTIBLOCK>[] nearbyParts = null;
        int visitedParts = 0;
        partsToCheck.add(referencePart);
        while (!partsToCheck.isEmpty()) {
            ITileMultiblockPart part = (ITileMultiblockPart)partsToCheck.removeFirst();
            part.setVisited();
            ++visitedParts;
            for (ITileMultiblockPart nearbyPart : nearbyParts = part.getNeighboringParts()) {
                if (nearbyPart.getMultiblock() != this || nearbyPart.isVisited()) continue;
                nearbyPart.setVisited();
                partsToCheck.add(nearbyPart);
            }
        }
        ObjectOpenHashSet removedParts = new ObjectOpenHashSet();
        for (ITileMultiblockPart orphanCandidate : this.connectedParts) {
            if (orphanCandidate.isVisited()) continue;
            deadParts.add(orphanCandidate);
            orphanCandidate.onOrphaned(this, originalSize, visitedParts);
            this.onDetachBlock(orphanCandidate);
            removedParts.add(orphanCandidate);
        }
        this.connectedParts.removeAll((Collection)deadParts);
        deadParts.clear();
        if (this.referenceCoord == null) {
            this.selectNewReferenceCoord();
        }
        this.shouldCheckForDisconnections = false;
        return removedParts;
    }

    public Set<ITileMultiblockPart> detachAllBlocks() {
        if (this.WORLD == null) {
            return new ObjectOpenHashSet();
        }
        for (ITileMultiblockPart part : this.connectedParts) {
            if (!this.WORLD.func_175667_e(part.getTilePos())) continue;
            this.onDetachBlock(part);
        }
        ObjectOpenHashSet<ITileMultiblockPart> detachedParts = this.connectedParts;
        this.connectedParts = new ObjectOpenHashSet();
        return detachedParts;
    }

    public boolean isAssembled() {
        return this.assemblyState == AssemblyState.Assembled;
    }

    private void selectNewReferenceCoord() {
        ITileMultiblockPart theChosenOne = null;
        this.referenceCoord = null;
        for (ITileMultiblockPart part : this.connectedParts) {
            BlockPos position = part.getTilePos();
            if (part.isPartInvalid() || !this.WORLD.func_175667_e(position) || this.referenceCoord != null && this.referenceCoord.compareTo((Vec3i)position) <= 0) continue;
            this.referenceCoord = position;
            theChosenOne = part;
        }
        if (theChosenOne != null) {
            theChosenOne.becomeMultiblockSaveDelegate();
        }
    }

    public void markReferenceCoordForUpdate() {
        BlockPos rc = this.getReferenceCoord();
        if (this.WORLD != null && rc != null) {
            IBlockState state = this.WORLD.func_180495_p(rc);
            this.WORLD.func_184138_a(rc, state, state, 3);
        }
    }

    public void markReferenceCoordDirty() {
        if (this.WORLD == null || this.WORLD.field_72995_K) {
            return;
        }
        BlockPos referenceCoord = this.getReferenceCoord();
        if (referenceCoord == null) {
            return;
        }
        TileEntity saveTe = this.WORLD.func_175625_s(referenceCoord);
        this.WORLD.func_175646_b(referenceCoord, saveTe);
    }

    public void markMultiblockForRenderUpdate() {
        this.WORLD.func_175704_b(this.getMinimumCoord(), this.getMaximumCoord());
    }

    protected abstract PACKET getUpdatePacket();

    public abstract void onPacket(PACKET var1);

    public void beginUpdatingPlayer(EntityPlayer playerToUpdate) {
        this.playersToUpdate.add(playerToUpdate);
        this.sendIndividualUpdate(playerToUpdate);
    }

    public void stopUpdatingPlayer(EntityPlayer playerToRemove) {
        this.playersToUpdate.remove(playerToRemove);
    }

    public void sendUpdateToListeningPlayers() {
        PACKET packet = this.getUpdatePacket();
        if (packet == null) {
            return;
        }
        for (EntityPlayer player : this.playersToUpdate) {
            PacketHandler.instance.sendTo(packet, (EntityPlayerMP)player);
        }
    }

    public void sendIndividualUpdate(EntityPlayer player) {
        if (this.WORLD.field_72995_K) {
            return;
        }
        PACKET packet = this.getUpdatePacket();
        if (packet == null) {
            return;
        }
        PacketHandler.instance.sendTo(packet, (EntityPlayerMP)player);
    }

    public void sendUpdateToAllPlayers() {
        if (this.WORLD.field_72995_K) {
            return;
        }
        PACKET packet = this.getUpdatePacket();
        if (packet == null) {
            return;
        }
        PacketHandler.instance.sendToAll(packet);
    }

    public abstract PartSuperMap<T> getPartSuperMap();

    public <TYPE extends T> Long2ObjectMap<TYPE> getPartMap(Class<TYPE> type) {
        return (Long2ObjectMap)this.getPartSuperMap().get(type);
    }

    public <TYPE extends T> int getPartCount(Class<TYPE> type) {
        return this.getPartMap(type).size();
    }

    public <TYPE extends T> Collection<TYPE> getParts(Class<TYPE> type) {
        return this.getPartMap(type).values();
    }

    public <TYPE extends T> Iterator<TYPE> getPartIterator(Class<TYPE> type) {
        return this.getParts(type).iterator();
    }

    public void onPartAdded(ITileMultiblockPart newPart) {
        for (Map.Entry superMapEntryRaw : this.getPartSuperMap().entrySet()) {
            this.addBlockForSuperMapEntry(new SuperMap.SuperMapEntry(superMapEntryRaw), newPart);
        }
    }

    public <TYPE extends T> void addBlockForSuperMapEntry(SuperMap.SuperMapEntry<Long, TYPE> superMapEntry, ITileMultiblockPart newPart) {
        if (superMapEntry.getKey().isInstance(newPart)) {
            superMapEntry.getValue().put(newPart.getTilePos().func_177986_g(), superMapEntry.getKey().cast(newPart));
        }
    }

    public void onPartRemoved(ITileMultiblockPart oldPart) {
        for (Map.Entry superMapEntryRaw : this.getPartSuperMap().entrySet()) {
            this.removeBlockForSuperMapEntry(new SuperMap.SuperMapEntry(superMapEntryRaw), oldPart);
        }
    }

    public <TYPE extends T> void removeBlockForSuperMapEntry(SuperMap.SuperMapEntry<Long, TYPE> superMapEntry, ITileMultiblockPart oldPart) {
        if (superMapEntry.getKey().isInstance(oldPart)) {
            superMapEntry.getValue().remove(oldPart.getTilePos().func_177986_g());
        }
    }

    public void clearAllMaterial() {
        for (Map.Entry superMapEntryRaw : this.getPartSuperMap().entrySet()) {
            for (ITileMultiblockPart tile : ((Long2ObjectMap)superMapEntryRaw.getValue()).values()) {
                if (tile instanceof ITileInventory) {
                    ((ITileInventory)((Object)tile)).clearAllSlots();
                }
                if (!(tile instanceof ITileFluid)) continue;
                ((ITileFluid)((Object)tile)).clearAllTanks();
            }
        }
    }

    public static class PartSuperMap<T extends ITileMultiblockPart>
    extends SuperMap<Long, T, Long2ObjectMap<? extends T>> {
        @Override
        public <TYPE extends T> Long2ObjectMap<? extends T> backup(Class<TYPE> clazz) {
            return new Long2ObjectOpenHashMap();
        }
    }

    public static enum AssemblyState {
        Disassembled,
        Assembled,
        Paused;

    }
}

