/*
 * Decompiled with CFR 0.152.
 */
package nc.multiblock;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.booleans.BooleanIterator;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Stack;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import nc.multiblock.fission.FissionPlacement;
import nc.multiblock.tile.ITileMultiblockPart;
import nc.multiblock.turbine.TurbinePlacement;
import nc.recipe.BasicRecipeHandler;
import nc.util.I18nHelper;
import nc.util.Lang;
import nc.util.PosHelper;
import nc.util.StringHelper;
import nc.util.Vertex;
import net.minecraft.util.EnumFacing;

public abstract class PlacementRule<T extends ITileMultiblockPart> {
    @Nullable
    protected final List<PlacementRule<T>> subRules;
    protected final List<String> dependencies;
    protected final boolean requiresRecheck;

    public PlacementRule(@Nullable List<PlacementRule<T>> subRules, List<String> dependencies, boolean requiresRecheck) {
        this.subRules = subRules;
        this.dependencies = dependencies;
        this.requiresRecheck = requiresRecheck;
    }

    @Nullable
    public List<PlacementRule<T>> getSubRules() {
        return this.subRules;
    }

    public List<String> getDependencies() {
        return this.dependencies;
    }

    public abstract void checkIsRuleAllowed(String var1);

    public void incrementMinimalAdjacencies(Int2IntMap adjacencyMap) {
    }

    public abstract boolean isCycle(Object2BooleanMap<String> var1);

    public boolean requiresRecheck() {
        return this.requiresRecheck;
    }

    public abstract boolean satisfied(T var1);

    public static void preInit() {
        FissionPlacement.preInit();
        TurbinePlacement.preInit();
    }

    public static void init() {
        FissionPlacement.init();
        TurbinePlacement.init();
    }

    public static void postInit() {
        FissionPlacement.postInit();
        TurbinePlacement.postInit();
    }

    public static void refreshRecipeCaches() {
        FissionPlacement.recipe_handler.refreshCache();
        TurbinePlacement.recipe_handler.refreshCache();
    }

    public static <T extends ITileMultiblockPart> PlacementRule<T> parse(String string, List<RuleParser<T>> parsers) {
        for (RuleParser<T> parser : parsers) {
            PlacementRule<T> rule = parser.parseRule(string);
            if (rule == null) continue;
            return rule;
        }
        throw new IllegalArgumentException("The placement rule string \"" + string + "\" could not be parsed!");
    }

    public static <T extends ITileMultiblockPart> List<String> concatDependencies(List<PlacementRule<T>> rules) {
        ObjectOpenHashSet dependencies = new ObjectOpenHashSet();
        for (PlacementRule<T> rule : rules) {
            dependencies.addAll(rule.getDependencies());
            if (rule.subRules == null) continue;
            dependencies.addAll(PlacementRule.concatDependencies(rule.subRules));
        }
        return new ArrayList<String>((Collection<String>)dependencies);
    }

    public static <T extends ITileMultiblockPart> boolean mergeRequiresRecheck(List<PlacementRule<T>> rules) {
        boolean requiresRecheck = false;
        for (PlacementRule<T> rule : rules) {
            if (rule.requiresRecheck) {
                requiresRecheck = true;
            }
            if (rule.subRules == null || !PlacementRule.mergeRequiresRecheck(rule.subRules)) continue;
            requiresRecheck = true;
        }
        return requiresRecheck;
    }

    public static class RecipeHandler
    extends BasicRecipeHandler {
        public RecipeHandler(String type) {
            super(type + "_placement_rules", 1, 0, 0, 0);
        }

        @Override
        public void addRecipes() {
        }

        @Override
        public List fixExtras(List extras) {
            ArrayList<String> fixed = new ArrayList<String>(1);
            fixed.add(extras.size() > 0 && extras.get(0) instanceof String ? (String)extras.get(0) : "");
            return fixed;
        }
    }

    public static class DefaultTooltipBuilder<T extends ITileMultiblockPart>
    extends TooltipBuilder<T> {
        protected List<String> p_patterns = null;
        protected List<String> l_patterns = null;
        protected List<String[]> p_splits = null;
        protected List<String[]> l_splits = null;
        protected List<boolean[]> p_invs = null;
        protected List<boolean[]> l_invs = null;

        @Override
        public String buildTooltip(PlacementRule<T> rule) {
            if (rule instanceof Adjacent) {
                return Lang.localise("nc.sf.placement_rule.and_or.adjacent4", Lang.localise("nc.sf.placement_rule.and_or.adjacent0", Lang.localise("nc.sf.placement_rule.adjacent.must_be_adjacent_to"), ((Adjacent)rule).buildSubTooltip()));
            }
            if (rule instanceof And || rule instanceof Or) {
                LinkedList<String> subTooltips = new LinkedList<String>();
                for (PlacementRule<T> r : rule.getSubRules()) {
                    subTooltips.add(r instanceof Adjacent ? ((Adjacent)r).buildSubTooltip() : "?");
                }
                return Lang.localise("nc.sf.placement_rule.and_or.adjacent4", Lang.localise("nc.sf.placement_rule.and_or.adjacent0", Lang.localise("nc.sf.placement_rule.adjacent.must_be_adjacent_to"), this.joinSubTooltips(subTooltips, Lang.localise("nc.sf." + (rule instanceof And ? "and" : "or")))));
            }
            return rule.getDependencies().toString();
        }

        protected String joinSubTooltips(LinkedList<String> subTooltips, String conj) {
            if (subTooltips.size() > 2) {
                return Lang.localise("nc.sf.placement_rule.and_or.adjacent1", subTooltips.removeFirst(), this.joinSubTooltips(subTooltips, conj));
            }
            if (subTooltips.size() == 2) {
                return Lang.localise("nc.sf.placement_rule.and_or.adjacent" + (this.hasPotentialAmbiguity(subTooltips.get(0), subTooltips.get(1)) ? 3 : 2), subTooltips.get(0), conj, subTooltips.get(1));
            }
            if (subTooltips.size() == 1) {
                return subTooltips.get(0);
            }
            return "?";
        }

        protected boolean hasPotentialAmbiguity(String prev, String last) {
            if (this.p_patterns == null) {
                this.setupAmbiguityChecks();
            }
            block0: for (int i = 0; i < this.p_patterns.size(); ++i) {
                int j;
                boolean p = false;
                String[] p_split = this.p_splits.get(i);
                boolean[] p_inv = this.p_invs.get(i);
                if (this.p_patterns.get(i) == null) {
                    p = true;
                } else if (this.p_patterns.get(i).equals("&&")) {
                    for (int j2 = 0; j2 < p_inv.length; ++j2) {
                        if (!(p_inv[j2] ^ prev.contains(p_split[j2]))) continue block0;
                    }
                    p = true;
                } else {
                    for (int j3 = 0; j3 < p_inv.length; ++j3) {
                        if (!(p_inv[j3] ^ prev.contains(p_split[j3]))) continue;
                        p = true;
                        break;
                    }
                    if (!p) continue;
                }
                String[] l_split = this.l_splits.get(i);
                boolean[] l_inv = this.l_invs.get(i);
                if (this.l_patterns.get(i) == null) {
                    return true;
                }
                if (this.l_patterns.get(i).equals("&&")) {
                    for (j = 0; j < l_inv.length; ++j) {
                        if (!(l_inv[j] ^ last.contains(l_split[j]))) continue block0;
                    }
                    return true;
                }
                for (j = 0; j < l_inv.length; ++j) {
                    if (!(l_inv[j] ^ last.contains(l_split[j]))) continue;
                    return true;
                }
            }
            return false;
        }

        protected void setupAmbiguityChecks() {
            this.p_patterns = new ArrayList<String>();
            this.l_patterns = new ArrayList<String>();
            this.p_splits = new ArrayList<String[]>();
            this.l_splits = new ArrayList<String[]>();
            this.p_invs = new ArrayList<boolean[]>();
            this.l_invs = new ArrayList<boolean[]>();
            int i = 0;
            String s = "nc.sf.placement_rule.adjacent.ambiguity";
            while (Lang.canLocalise(s + i + "prev") || Lang.canLocalise(s + i + "last")) {
                int j;
                if (Lang.canLocalise(s + i + "prev")) {
                    String p = Lang.localise(s + i + "prev");
                    this.p_patterns.add(p.contains("&&") ? "&&" : "||");
                    this.p_splits.add(p.split(Pattern.quote(this.p_patterns.get(i))));
                    String[] p_split = this.p_splits.get(i);
                    this.p_invs.add(new boolean[p_split.length]);
                    boolean[] p_inv = this.p_invs.get(i);
                    for (j = 0; j < p_inv.length; ++j) {
                        p_inv[j] = p_split[j].startsWith("!");
                        if (!p_inv[j]) continue;
                        p_split[j] = p_split[j].substring(1);
                    }
                } else {
                    this.p_patterns.add(null);
                    this.p_splits.add(null);
                    this.p_invs.add(null);
                }
                if (Lang.canLocalise(s + i + "last")) {
                    String l = Lang.localise(s + i + "last");
                    this.l_patterns.add(l.contains("&&") ? "&&" : "||");
                    this.l_splits.add(l.split(Pattern.quote(this.l_patterns.get(i))));
                    String[] l_split = this.l_splits.get(i);
                    this.l_invs.add(new boolean[l_split.length]);
                    boolean[] l_inv = this.l_invs.get(i);
                    for (j = 0; j < this.l_invs.get(i).length; ++j) {
                        l_inv[j] = l_split[j].startsWith("!");
                        if (!l_inv[j]) continue;
                        l_split[j] = l_split[j].substring(1);
                    }
                } else {
                    this.l_patterns.add(null);
                    this.l_splits.add(null);
                    this.l_invs.add(null);
                }
                ++i;
            }
        }
    }

    public static abstract class TooltipBuilder<T extends ITileMultiblockPart> {
        public abstract String buildTooltip(PlacementRule<T> var1);
    }

    public static class PlacementMap<T extends ITileMultiblockPart>
    extends Object2ObjectOpenHashMap<String, PlacementRule<T>> {
        public PlacementRule<T> put(String ruleID, PlacementRule<T> rule) {
            rule.checkIsRuleAllowed(ruleID);
            PlacementRule ret = (PlacementRule)super.put((Object)ruleID, rule);
            this.checkCycles(ruleID, rule);
            return ret;
        }

        public void checkCycles(String ruleID, PlacementRule<T> rule) {
            Object2BooleanMap boolMap;
            Object2ObjectOpenHashMap vertexMap = new Object2ObjectOpenHashMap();
            Object2ObjectOpenHashMap cycleMap = new Object2ObjectOpenHashMap();
            ObjectOpenHashSet finished = new ObjectOpenHashSet();
            Stack<Vertex> vertexStack = new Stack<Vertex>();
            vertexStack.push(new Vertex<String>(ruleID));
            while (!vertexStack.isEmpty()) {
                Vertex v = (Vertex)vertexStack.pop();
                if (v == null) continue;
                if (vertexMap.containsKey(v.data)) {
                    if (((Vertex)vertexMap.get(v.data)).parent != null) continue;
                    ((Vertex)vertexMap.get(v.data)).parent = v.parent;
                    continue;
                }
                vertexMap.put(v.data, (Object)v);
                Object2BooleanOpenHashMap boolMap2 = new Object2BooleanOpenHashMap();
                cycleMap.put(v.data, (Object)boolMap2);
                for (String string : ((PlacementRule)this.get(v.data)).getDependencies()) {
                    if (this.containsKey(string)) {
                        v.addChild(string);
                    } else {
                        finished.add((Object)string);
                    }
                    boolMap2.put((Object)string, !finished.contains((Object)string));
                }
                if (!((PlacementRule)this.get(v.data)).isCycle((Object2BooleanMap<String>)boolMap2)) {
                    String string;
                    Iterator<Object> iterator = v.getPath(false).iterator();
                    while (!(!iterator.hasNext() || cycleMap.containsKey((Object)(string = (String)iterator.next())) && ((PlacementRule)this.get(string)).isCycle((Object2BooleanMap<String>)((Object2BooleanMap)cycleMap.get((Object)string))))) {
                        finished.add((Object)string);
                    }
                }
                for (Vertex vertex : v.children) {
                    vertexStack.push(vertex);
                }
            }
            for (String k : cycleMap.keySet()) {
                boolMap = (Object2BooleanMap)cycleMap.get((Object)k);
                for (String s : boolMap.keySet()) {
                    boolMap.put((Object)s, false);
                }
            }
            Stack<String> stack = new Stack<String>();
            stack.push(ruleID);
            while (!stack.isEmpty()) {
                Vertex v = (Vertex)vertexMap.get(stack.pop());
                if (v == null) continue;
                boolMap = (Object2BooleanMap)cycleMap.get(v.data);
                if (v.parent != null && cycleMap.containsKey(v.parent.data)) {
                    ((Object2BooleanMap)cycleMap.get(v.parent.data)).put(v.data, !finished.contains(v.data));
                }
                if (boolMap != null && ((PlacementRule)this.get(v.data)).isCycle((Object2BooleanMap<String>)boolMap)) {
                    boolean bl;
                    boolean bl2 = false;
                    ArrayList<String> cycles = new ArrayList<String>();
                    for (Vertex child : v.children) {
                        boolean continueCycle = true;
                        Stack<String> traversedPath = new Stack<String>();
                        String cycle = "[";
                        for (String s : child.getPath(true)) {
                            traversedPath.push(s);
                            if (cycleMap.containsKey((Object)s) && ((PlacementRule)this.get(s)).isCycle((Object2BooleanMap<String>)((Object2BooleanMap)cycleMap.get((Object)s)))) {
                                cycle = cycle + "\"" + s + "\" -> ";
                                continue;
                            }
                            continueCycle = false;
                            break;
                        }
                        if (!continueCycle) {
                            String s;
                            while (!(traversedPath.isEmpty() || cycleMap.containsKey((Object)(s = (String)traversedPath.pop())) && ((PlacementRule)this.get(s)).isCycle((Object2BooleanMap<String>)((Object2BooleanMap)cycleMap.get((Object)s))))) {
                                finished.add((Object)s);
                            }
                            continue;
                        }
                        bl = true;
                        cycle = StringHelper.removeSuffix(cycle, 4) + " -> ...]";
                        cycles.add(cycle);
                    }
                    if (bl && v.partOfCycle()) {
                        String out;
                        if (cycles.size() == 1) {
                            out = (String)cycles.get(0);
                        } else {
                            out = "{";
                            for (String c : cycles) {
                                out = out + c + ", ";
                            }
                            out = StringHelper.removeSuffix(out, 2) + "}";
                        }
                        throw new IllegalArgumentException("The placement rule with ID \"" + ruleID + "\" contained the cyclic dependency " + out + "!");
                    }
                }
                for (Vertex child : v.children) {
                    if (finished.contains(child.data)) continue;
                    stack.push((String)child.data);
                }
            }
        }
    }

    public static enum CountType {
        AT_LEAST,
        EXACTLY,
        AT_MOST;


        public boolean requiresRecheck() {
            return this != AT_LEAST;
        }

        public String tooltipSubstring(int amount) {
            switch (this) {
                case AT_LEAST: {
                    return "at_least";
                }
                case EXACTLY: {
                    return "exactly";
                }
                case AT_MOST: {
                    return "at_most";
                }
            }
            return "";
        }
    }

    public static enum AdjacencyType {
        STANDARD,
        AXIAL,
        VERTEX,
        EDGE;


        public String tooltipSubstring(int amount) {
            switch (this) {
                case STANDARD: {
                    return "";
                }
                case AXIAL: {
                    return amount == 2 ? "_along_axis" : "_along_axes";
                }
                case VERTEX: {
                    return "_at_vertex";
                }
                case EDGE: {
                    return "_along_edge";
                }
            }
            return "";
        }
    }

    public static abstract class Adjacent<T extends ITileMultiblockPart>
    extends PlacementRule<T> {
        protected final int amount;
        protected final CountType countType;
        protected final AdjacencyType adjType;

        protected Adjacent(String dependency, int amount, CountType countType, AdjacencyType adjType) {
            super(null, Lists.newArrayList((Object[])new String[]{dependency}), countType.requiresRecheck());
            this.amount = amount;
            this.countType = countType;
            this.adjType = adjType;
        }

        @Override
        public void checkIsRuleAllowed(String ruleID) {
            if (this.amount > 6) {
                throw new IllegalArgumentException("Adjacency placement rule with ID \"" + ruleID + "\" can not require more than six adjacencies!");
            }
            if (this.amount < 0) {
                throw new IllegalArgumentException("Adjacency placement rule with ID \"" + ruleID + "\" can not require a negative number of adjacencies!");
            }
            if (this.countType != CountType.EXACTLY && this.amount == 0) {
                throw new IllegalArgumentException("Adjacency placement rule with ID \"" + ruleID + "\" can only require zero adjacencies if also an exact rule!");
            }
            if (this.adjType == AdjacencyType.AXIAL && (this.amount & 1) != 0) {
                throw new IllegalArgumentException("Axial adjacency placement rule with ID \"" + ruleID + "\" must require an even number of adjacencies!");
            }
            if (this.adjType == AdjacencyType.VERTEX) {
                if (this.amount != 3) {
                    throw new IllegalArgumentException("Vertex adjacency placement rule with ID \"" + ruleID + "\" must require three adjacencies!");
                }
                if (this.countType == CountType.AT_MOST) {
                    throw new IllegalArgumentException("Vertex adjacency placement rule with ID \"" + ruleID + "\" can not be an 'at most' rule!");
                }
            }
            if (this.adjType == AdjacencyType.EDGE) {
                if (this.amount != 2) {
                    throw new IllegalArgumentException("Edge adjacency placement rule with ID \"" + ruleID + "\" must require two adjacencies!");
                }
                if (this.countType == CountType.AT_MOST) {
                    throw new IllegalArgumentException("Edge adjacency placement rule with ID \"" + ruleID + "\" can not be an 'at most' rule!");
                }
            }
        }

        @Override
        public void incrementMinimalAdjacencies(Int2IntMap adjacencyMap) {
            adjacencyMap.put(1, adjacencyMap.get(1) + (this.countType == CountType.AT_MOST ? 0 : this.amount));
        }

        @Override
        public boolean isCycle(Object2BooleanMap<String> boolMap) {
            if (this.countType.requiresRecheck()) {
                for (Object2BooleanMap.Entry entry : boolMap.object2BooleanEntrySet()) {
                    if (!entry.getBooleanValue() || !this.dependencies.contains(entry.getKey())) continue;
                    return true;
                }
            }
            return false;
        }

        public String buildSubTooltip() {
            if (this.countType == CountType.EXACTLY && this.amount == 0) {
                return Lang.localise("nc.sf.placement_rule.adjacent.no", I18nHelper.getPluralForm("nc.sf." + (String)this.dependencies.get(0), 0, Lang.localise("nc.sf.no")));
            }
            return Lang.localise("nc.sf.placement_rule.adjacent." + this.countType.tooltipSubstring(this.amount) + this.adjType.tooltipSubstring(this.amount), I18nHelper.getPluralForm("nc.sf." + (String)this.dependencies.get(0), this.amount, Lang.localise("nc.sf." + (String)StringHelper.NUMBER_I2S_MAP.get(this.amount))));
        }

        @Override
        public boolean satisfied(T tile) {
            int count = 0;
            if (this.adjType == AdjacencyType.STANDARD) {
                for (EnumFacing dir : EnumFacing.field_82609_l) {
                    if (this.satisfied(tile, dir)) {
                        count = (byte)(count + 1);
                    }
                    if (this.countType == CountType.AT_LEAST) {
                        if (count < this.amount) continue;
                        return true;
                    }
                    if (count <= this.amount) continue;
                    return false;
                }
                return this.countType == CountType.AT_MOST || this.countType == CountType.EXACTLY && count == this.amount;
            }
            if (this.adjType == AdjacencyType.AXIAL) {
                if (this.countType == CountType.EXACTLY) {
                    boolean[] dirs = new boolean[]{false, false, false, false, false, false};
                    for (EnumFacing dir : EnumFacing.field_82609_l) {
                        if (!this.satisfied(tile, dir)) continue;
                        if ((count = (int)((byte)(count + 1))) > this.amount) {
                            return false;
                        }
                        dirs[dir.func_176745_a()] = true;
                    }
                    if (count != this.amount) {
                        return false;
                    }
                    count = 0;
                    if (dirs[0] && dirs[1]) {
                        count = (byte)(count + 1);
                    }
                    if (dirs[2] && dirs[3]) {
                        count = (byte)(count + 1);
                    }
                    if (dirs[4] && dirs[5]) {
                        count = (byte)(count + 1);
                    }
                    return count == this.amount / 2;
                }
                block2: for (EnumFacing[] axialDirs : PosHelper.axialDirsList()) {
                    for (EnumFacing dir : axialDirs) {
                        if (!this.satisfied(tile, dir)) continue block2;
                    }
                    count = (byte)(count + 1);
                    if (this.countType == CountType.AT_LEAST) {
                        if (count < this.amount / 2) continue;
                        return true;
                    }
                    if (count <= this.amount / 2) continue;
                    return false;
                }
                return this.countType == CountType.AT_MOST;
            }
            if (this.countType == CountType.EXACTLY) {
                boolean[] dirs = new boolean[]{false, false, false, false, false, false};
                for (EnumFacing dir : EnumFacing.field_82609_l) {
                    if (!this.satisfied(tile, dir)) continue;
                    if ((count = (int)((byte)(count + 1))) > this.amount) {
                        return false;
                    }
                    dirs[dir.func_176745_a()] = true;
                }
                if (count != this.amount) {
                    return false;
                }
                EnumFacing[] enumFacingArray = this.adjType == AdjacencyType.VERTEX ? PosHelper.VERTEX_DIRS : PosHelper.EDGE_DIRS;
                int n = enumFacingArray.length;
                block5: for (int dir = 0; dir < n; ++dir) {
                    EnumFacing typeDirs;
                    for (EnumFacing dir2 : typeDirs = enumFacingArray[dir]) {
                        if (!dirs[dir2.func_176745_a()]) continue block5;
                    }
                    return true;
                }
                return false;
            }
            EnumFacing[][] enumFacingArray = this.adjType == AdjacencyType.VERTEX ? PosHelper.VERTEX_DIRS : PosHelper.EDGE_DIRS;
            int n = enumFacingArray.length;
            block7: for (int i = 0; i < n; ++i) {
                EnumFacing[] typeDirs;
                for (EnumFacing dir : typeDirs = enumFacingArray[i]) {
                    if (!this.satisfied(tile, dir)) continue block7;
                }
                return true;
            }
            return false;
        }

        public abstract boolean satisfied(T var1, EnumFacing var2);
    }

    public static class Or<T extends ITileMultiblockPart>
    extends BasicCompoundRule<T> {
        public Or(List<PlacementRule<T>> rules) {
            super(rules);
        }

        @Override
        public boolean isCycle(Object2BooleanMap<String> boolMap) {
            for (PlacementRule rule : this.subRules) {
                if (!rule.isCycle(boolMap)) continue;
                return true;
            }
            if (boolMap.isEmpty()) {
                return false;
            }
            BooleanIterator booleanIterator = boolMap.values().iterator();
            while (booleanIterator.hasNext()) {
                boolean b = (Boolean)booleanIterator.next();
                if (b) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean satisfied(T tile) {
            for (PlacementRule rule : this.subRules) {
                if (!rule.satisfied(tile)) continue;
                return true;
            }
            return false;
        }
    }

    public static class And<T extends ITileMultiblockPart>
    extends BasicCompoundRule<T> {
        public And(List<PlacementRule<T>> rules) {
            super(rules);
        }

        @Override
        public boolean isCycle(Object2BooleanMap<String> boolMap) {
            BooleanIterator booleanIterator = boolMap.values().iterator();
            while (booleanIterator.hasNext()) {
                boolean b = (Boolean)booleanIterator.next();
                if (!b) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean satisfied(T tile) {
            for (PlacementRule rule : this.subRules) {
                if (rule.satisfied(tile)) continue;
                return false;
            }
            return true;
        }
    }

    public static abstract class BasicCompoundRule<T extends ITileMultiblockPart>
    extends PlacementRule<T> {
        public BasicCompoundRule(List<PlacementRule<T>> rules) {
            super(rules, BasicCompoundRule.concatDependencies(rules), BasicCompoundRule.mergeRequiresRecheck(rules));
        }

        @Override
        public void checkIsRuleAllowed(String ruleID) {
            Int2IntOpenHashMap adjacencyMap = new Int2IntOpenHashMap();
            if (this.subRules != null) {
                for (PlacementRule subRule : this.subRules) {
                    subRule.checkIsRuleAllowed(ruleID);
                    subRule.incrementMinimalAdjacencies((Int2IntMap)adjacencyMap);
                }
            }
            this.checkMinimalAdjacencies(ruleID, (Int2IntMap)adjacencyMap);
        }

        public void checkMinimalAdjacencies(String ruleID, Int2IntMap adjacencyMap) {
            IntIterator intIterator = adjacencyMap.values().iterator();
            while (intIterator.hasNext()) {
                int count = (Integer)intIterator.next();
                if (count <= 6) continue;
                throw new IllegalArgumentException("Adjacency placement rule with ID \"" + ruleID + "\" can not require more than six adjacencies!");
            }
        }
    }

    public static abstract class DefaultRuleParser<T extends ITileMultiblockPart>
    extends RuleParser<T> {
        @Override
        @Nullable
        protected PlacementRule<T> parseRule(String string) {
            string = string.toLowerCase(Locale.ROOT);
            ArrayList rules = new ArrayList();
            String pattern = string.contains("&&") ? "&&" : "||";
            for (String s : string.split(Pattern.quote(pattern))) {
                PlacementRule<T> rule = this.partialParse(s);
                if (rule == null) {
                    return null;
                }
                rules.add(rule);
            }
            return pattern.equals("&&") ? new And(rules) : new Or(rules);
        }

        @Nullable
        protected abstract PlacementRule<T> partialParse(String var1);
    }

    public static abstract class RuleParser<T extends ITileMultiblockPart> {
        @Nullable
        protected abstract PlacementRule<T> parseRule(String var1);
    }
}

