/*
 * Decompiled with CFR 0.152.
 */
package nc.multiblock.battery.block;

import nc.block.property.ISidedEnergy;
import nc.block.tile.IDynamicState;
import nc.block.tile.INBTDrop;
import nc.item.ItemMultitool;
import nc.multiblock.battery.BatteryMultiblock;
import nc.multiblock.battery.BatteryType;
import nc.multiblock.battery.tile.TileBattery;
import nc.multiblock.block.BlockMultiblockPart;
import nc.tab.NCTabs;
import nc.tile.internal.energy.EnergyConnection;
import nc.tile.internal.energy.EnergyStorage;
import nc.util.Lang;
import nc.util.NCMath;
import nc.util.UnitHelper;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockBattery
extends BlockMultiblockPart
implements IDynamicState,
ISidedEnergy,
INBTDrop {
    private final BatteryType type;

    public BlockBattery(BatteryType type) {
        super(Material.field_151573_f, NCTabs.MACHINE);
        this.type = type;
    }

    protected BlockStateContainer func_180661_e() {
        return this.createEnergyBlockState(this);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return this.type.getTile();
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.getActualEnergyState(state, world, pos);
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (player == null || hand != EnumHand.MAIN_HAND) {
            return false;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileBattery) {
            TileBattery battery = (TileBattery)tile;
            if (ItemMultitool.isMultitool(player.func_184586_b(hand))) {
                EnumFacing side = player.func_70093_af() ? facing.func_176734_d() : facing;
                battery.toggleEnergyConnection(side, EnergyConnection.Type.DEFAULT);
            } else if (!world.field_72995_K) {
                EnergyStorage storage = battery.getEnergyStorage();
                player.func_145747_a((ITextComponent)new TextComponentString(Lang.localise("gui.nc.container.energy_stored") + " " + UnitHelper.prefix(storage.getEnergyStoredLong(), storage.getMaxEnergyStoredLong(), 5, "RF")));
            }
            return true;
        }
        return this.rightClickOnPart(world, pos, player, hand, facing, false);
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        BatteryMultiblock multiblock;
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileBattery && (multiblock = (BatteryMultiblock)((TileBattery)tile).getMultiblock()) != null) {
            return multiblock.getComparatorStrength();
        }
        return 0;
    }

    @Override
    public ItemStack getNBTDrop(IBlockAccess world, BlockPos pos, IBlockState state) {
        ItemStack stack = new ItemStack((Block)this);
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileBattery) {
            NBTTagCompound nbt = new NBTTagCompound();
            TileBattery battery = (TileBattery)tile;
            BatteryMultiblock multiblock = (BatteryMultiblock)battery.getMultiblock();
            if (multiblock != null) {
                EnergyStorage storage = multiblock.getEnergyStorage();
                if (multiblock.getPartCount(TileBattery.class) < 2) {
                    storage.writeToNBT(nbt, "energyStorage");
                } else {
                    double fraction = (double)multiblock.getEnergyStorage().getEnergyStoredLong() / (double)multiblock.getEnergyStorage().getMaxEnergyStoredLong();
                    long energy = (long)(fraction * (double)battery.capacity);
                    new EnergyStorage(battery.capacity, NCMath.toInt(battery.capacity), energy).writeToNBT(nbt, "energyStorage");
                    storage.changeEnergyStored(-energy);
                }
            }
            battery.writeEnergyConnections(nbt);
            stack.func_77982_d(nbt);
        }
        return stack;
    }

    @Override
    public void readStackData(World world, BlockPos pos, EntityLivingBase player, ItemStack stack) {
        if (player == null || !stack.func_77942_o()) {
            return;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileBattery) {
            NBTTagCompound nbt = stack.func_77978_p();
            TileBattery battery = (TileBattery)tile;
            battery.waitingEnergy += new EnergyStorage(battery.capacity, NCMath.toInt(battery.capacity)).readFromNBT(nbt, "energyStorage").getEnergyStoredLong();
            if (player.func_70093_af()) {
                battery.readEnergyConnections(nbt);
            }
        }
    }
}

