/*
 * Decompiled with CFR 0.152.
 */
package nc.multiblock.battery.tile;

import gregtech.api.capability.GregtechCapabilities;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import nc.ModCheck;
import nc.config.NCConfig;
import nc.multiblock.battery.BatteryMultiblock;
import nc.multiblock.battery.BatteryType;
import nc.multiblock.tile.TileMultiblockPart;
import nc.tile.dummy.IInterfaceable;
import nc.tile.energy.ITileEnergy;
import nc.tile.internal.energy.EnergyConnection;
import nc.tile.internal.energy.EnergyStorage;
import nc.tile.internal.energy.EnergyTileWrapper;
import nc.tile.internal.energy.EnergyTileWrapperGT;
import nc.util.NCMath;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fml.common.Optional;

@Optional.InterfaceList(value={@Optional.Interface(iface="ic2.api.energy.tile.IEnergySink", modid="ic2"), @Optional.Interface(iface="ic2.api.energy.tile.IEnergySource", modid="ic2")})
public class TileBattery
extends TileMultiblockPart<BatteryMultiblock>
implements ITickable,
ITileEnergy,
IEnergySink,
IEnergySource,
IInterfaceable {
    protected final EnergyStorage backupStorage = new EnergyStorage(1L);
    @Nonnull
    protected final EnergyConnection[] energyConnections;
    protected boolean[] ignoreSide = new boolean[]{false, false, false, false, false, false};
    @Nonnull
    protected final EnergyTileWrapper[] energySides;
    @Nonnull
    protected final EnergyTileWrapperGT[] energySidesGT;
    protected boolean ic2reg = false;
    public long waitingEnergy = 0L;
    public long capacity;
    protected int energyTier;

    public TileBattery() {
        super(BatteryMultiblock.class);
        this.energyConnections = ITileEnergy.energyConnectionAll(EnergyConnection.IN);
        this.energySides = ITileEnergy.getDefaultEnergySides(this);
        this.energySidesGT = ITileEnergy.getDefaultEnergySidesGT(this);
    }

    public TileBattery(long capacity, int energyTier) {
        this();
        this.capacity = capacity;
        this.energyTier = energyTier;
    }

    protected TileBattery(BatteryType type) {
        this(type.getCapacity(), type.getEnergyTier());
    }

    protected boolean ignoreSide(EnumFacing side) {
        return side == null ? false : this.ignoreSide[side.func_176745_a()];
    }

    @Override
    public void onMachineAssembled(BatteryMultiblock controller) {
        this.doStandardNullControllerResponse(controller);
    }

    @Override
    public void onMachineBroken() {
    }

    @Override
    public BatteryMultiblock createNewMultiblock() {
        return new BatteryMultiblock(this.field_145850_b);
    }

    @Override
    public void onLoad() {
        super.onLoad();
        if (ModCheck.ic2Loaded()) {
            this.addTileToENet();
        }
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.waitingEnergy != 0L && this.getMultiblock() != null) {
                this.getEnergyStorage().changeEnergyStored(this.waitingEnergy);
                this.waitingEnergy = 0L;
            }
            this.pushEnergy();
        }
    }

    @Override
    public void pushEnergyToSide(@Nonnull EnumFacing side) {
        if (!this.ignoreSide(side)) {
            ITileEnergy.super.pushEnergyToSide(side);
        }
    }

    public void onMultiblockRefresh() {
        for (EnumFacing side : EnumFacing.field_82609_l) {
            this.ignoreSide[side.func_176745_a()] = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(side)) instanceof TileBattery;
        }
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        if (ModCheck.ic2Loaded()) {
            this.removeTileFromENet();
        }
    }

    @Override
    public void onChunkUnload() {
        super.onChunkUnload();
        if (ModCheck.ic2Loaded()) {
            this.removeTileFromENet();
        }
    }

    @Override
    public EnergyStorage getEnergyStorage() {
        return this.getMultiblock() != null ? ((BatteryMultiblock)this.getMultiblock()).getEnergyStorage() : this.backupStorage;
    }

    @Override
    public EnergyConnection[] getEnergyConnections() {
        return this.energyConnections;
    }

    @Override
    @Nonnull
    public EnergyTileWrapper[] getEnergySides() {
        return this.energySides;
    }

    @Override
    @Nonnull
    public EnergyTileWrapperGT[] getEnergySidesGT() {
        return this.energySidesGT;
    }

    @Override
    public boolean getIC2Reg() {
        return this.ic2reg;
    }

    @Override
    public void setIC2Reg(boolean ic2reg) {
        this.ic2reg = ic2reg;
    }

    @Override
    public int getSinkTier() {
        return this.energyTier;
    }

    @Override
    public int getSourceTier() {
        return this.energyTier;
    }

    @Override
    @Optional.Method(modid="ic2")
    public boolean acceptsEnergyFrom(IEnergyEmitter emitter, EnumFacing side) {
        return ITileEnergy.super.acceptsEnergyFrom(emitter, side);
    }

    @Override
    @Optional.Method(modid="ic2")
    public double getDemandedEnergy() {
        return ITileEnergy.super.getDemandedEnergy();
    }

    @Override
    @Optional.Method(modid="ic2")
    public double injectEnergy(EnumFacing directionFrom, double amount, double voltage) {
        return ITileEnergy.super.injectEnergy(directionFrom, amount, voltage);
    }

    @Override
    @Optional.Method(modid="ic2")
    public boolean emitsEnergyTo(IEnergyAcceptor receiver, EnumFacing side) {
        return ITileEnergy.super.emitsEnergyTo(receiver, side);
    }

    @Override
    @Optional.Method(modid="ic2")
    public double getOfferedEnergy() {
        return ITileEnergy.super.getOfferedEnergy();
    }

    @Override
    @Optional.Method(modid="ic2")
    public void drawEnergy(double amount) {
        ITileEnergy.super.drawEnergy(amount);
    }

    @Override
    public boolean hasConfigurableEnergyConnections() {
        return true;
    }

    @Override
    public NBTTagCompound writeAll(NBTTagCompound nbt) {
        super.writeAll(nbt);
        this.writeEnergyConnections(nbt);
        nbt.func_74772_a("waitingEnergy", this.waitingEnergy);
        nbt.func_74772_a("capacity", this.capacity);
        nbt.func_74768_a("energyTier", this.energyTier);
        nbt.func_74773_a("ignoreSide", NCMath.booleansToBytes(this.ignoreSide));
        return nbt;
    }

    @Override
    public void readAll(NBTTagCompound nbt) {
        boolean[] arr;
        super.readAll(nbt);
        this.readEnergyConnections(nbt);
        this.waitingEnergy = nbt.func_74763_f("waitingEnergy");
        if (nbt.func_74764_b("capacity")) {
            this.capacity = nbt.func_74763_f("capacity");
        }
        if (nbt.func_74764_b("energyTier")) {
            this.energyTier = nbt.func_74762_e("energyTier");
        }
        if ((arr = NCMath.bytesToBooleans(nbt.func_74770_j("ignoreSide"))).length == 6) {
            this.ignoreSide = arr;
        }
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing side) {
        if (!this.ignoreSide(side) && (capability == CapabilityEnergy.ENERGY || ModCheck.gregtechLoaded() && NCConfig.enable_gtce_eu && capability == GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER)) {
            return this.hasEnergySideCapability(side);
        }
        return super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing side) {
        if (!this.ignoreSide(side)) {
            if (capability == CapabilityEnergy.ENERGY) {
                if (this.hasEnergySideCapability(side)) {
                    return (T)this.getEnergySide(this.nonNullSide(side));
                }
                return null;
            }
            if (ModCheck.gregtechLoaded() && capability == GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER) {
                if (NCConfig.enable_gtce_eu && this.hasEnergySideCapability(side)) {
                    return (T)this.getEnergySideGT(this.nonNullSide(side));
                }
                return null;
            }
        }
        return super.getCapability(capability, side);
    }

    public static class LithiumIonBatteryElite
    extends TileBattery {
        public LithiumIonBatteryElite() {
            super(BatteryType.LITHIUM_ION_BATTERY_ELITE);
        }
    }

    public static class LithiumIonBatteryDU
    extends TileBattery {
        public LithiumIonBatteryDU() {
            super(BatteryType.LITHIUM_ION_BATTERY_DU);
        }
    }

    public static class LithiumIonBatteryAdvanced
    extends TileBattery {
        public LithiumIonBatteryAdvanced() {
            super(BatteryType.LITHIUM_ION_BATTERY_ADVANCED);
        }
    }

    public static class LithiumIonBatteryBasic
    extends TileBattery {
        public LithiumIonBatteryBasic() {
            super(BatteryType.LITHIUM_ION_BATTERY_BASIC);
        }
    }

    public static class VoltaicPileElite
    extends TileBattery {
        public VoltaicPileElite() {
            super(BatteryType.VOLTAIC_PILE_ELITE);
        }
    }

    public static class VoltaicPileDU
    extends TileBattery {
        public VoltaicPileDU() {
            super(BatteryType.VOLTAIC_PILE_DU);
        }
    }

    public static class VoltaicPileAdvanced
    extends TileBattery {
        public VoltaicPileAdvanced() {
            super(BatteryType.VOLTAIC_PILE_ADVANCED);
        }
    }

    public static class VoltaicPileBasic
    extends TileBattery {
        public VoltaicPileBasic() {
            super(BatteryType.VOLTAIC_PILE_BASIC);
        }
    }
}

