/*
 * Decompiled with CFR 0.152.
 */
package nc.multiblock.cuboidal;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import nc.multiblock.BlockFacing;
import nc.multiblock.Multiblock;
import nc.multiblock.cuboidal.CuboidalMultiblock;
import nc.multiblock.cuboidal.CuboidalPartPositionType;
import nc.multiblock.cuboidal.PartPosition;
import nc.multiblock.tile.TileMultiblockPart;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public abstract class TileCuboidalMultiblockPart<MULTIBLOCK extends CuboidalMultiblock>
extends TileMultiblockPart<MULTIBLOCK> {
    protected final CuboidalPartPositionType positionType;
    protected PartPosition position;
    protected BlockFacing outwardFacings;

    public TileCuboidalMultiblockPart(Class<MULTIBLOCK> tClass, CuboidalPartPositionType positionType) {
        super(tClass);
        this.positionType = positionType;
        this.position = PartPosition.Unknown;
        this.outwardFacings = BlockFacing.NONE;
    }

    public CuboidalPartPositionType getPartPositionType() {
        return this.positionType;
    }

    @Nonnull
    public PartPosition getPartPosition() {
        return this.position;
    }

    @Nonnull
    public BlockFacing getOutwardsDir() {
        return this.outwardFacings;
    }

    @Nullable
    public EnumFacing getOutwardFacing() {
        BlockFacing out;
        EnumFacing facing;
        EnumFacing enumFacing = facing = null != this.position ? this.position.getFacing() : null;
        if (null == facing && !(out = this.getOutwardsDir()).none() && 1 == out.countFacesIf(true)) {
            facing = out.firstIf(true);
        }
        return facing;
    }

    @Nullable
    public EnumFacing getOutwardFacingFromWorldPosition() {
        BlockFacing facings = null;
        CuboidalMultiblock multiblock = (CuboidalMultiblock)this.getMultiblock();
        if (null != multiblock) {
            BlockPos position = this.field_174879_c;
            BlockPos min = multiblock.getMinimumCoord();
            BlockPos max = multiblock.getMaximumCoord();
            int x = position.func_177958_n();
            int y = position.func_177956_o();
            int z = position.func_177952_p();
            facings = BlockFacing.from(min.func_177956_o() == y, max.func_177956_o() == y, min.func_177952_p() == z, max.func_177952_p() == z, min.func_177958_n() == x, max.func_177958_n() == x);
        }
        return null != facings && !facings.none() && 1 == facings.countFacesIf(true) ? facings.firstIf(true) : null;
    }

    @Override
    public void onAttached(MULTIBLOCK newMultiblock) {
        super.onAttached(newMultiblock);
        this.recalculateOutwardsDirection(((Multiblock)newMultiblock).getMinimumCoord(), ((Multiblock)newMultiblock).getMaximumCoord());
    }

    @Override
    public void onMachineAssembled(MULTIBLOCK multiblock) {
        this.recalculateOutwardsDirection(((Multiblock)multiblock).getMinimumCoord(), ((Multiblock)multiblock).getMaximumCoord());
    }

    @Override
    public void onMachineBroken() {
        this.position = PartPosition.Unknown;
        this.outwardFacings = BlockFacing.NONE;
    }

    public void recalculateOutwardsDirection(BlockPos minCoord, BlockPos maxCoord) {
        BlockPos myPosition = this.func_174877_v();
        int myX = myPosition.func_177958_n();
        int myY = myPosition.func_177956_o();
        int myZ = myPosition.func_177952_p();
        int facesMatching = 0;
        boolean downFacing = myY == minCoord.func_177956_o();
        boolean upFacing = myY == maxCoord.func_177956_o();
        boolean northFacing = myZ == minCoord.func_177952_p();
        boolean southFacing = myZ == maxCoord.func_177952_p();
        boolean westFacing = myX == minCoord.func_177958_n();
        boolean eastFacing = myX == maxCoord.func_177958_n();
        this.outwardFacings = BlockFacing.from(downFacing, upFacing, northFacing, southFacing, westFacing, eastFacing);
        if (eastFacing || westFacing) {
            ++facesMatching;
        }
        if (upFacing || downFacing) {
            ++facesMatching;
        }
        if (southFacing || northFacing) {
            ++facesMatching;
        }
        this.position = facesMatching <= 0 ? PartPosition.Interior : (facesMatching >= 3 ? PartPosition.FrameCorner : (facesMatching == 2 ? (!eastFacing && !westFacing ? PartPosition.FrameEastWest : (!southFacing && !northFacing ? PartPosition.FrameSouthNorth : PartPosition.FrameUpDown)) : (eastFacing ? PartPosition.EastFace : (westFacing ? PartPosition.WestFace : (southFacing ? PartPosition.SouthFace : (northFacing ? PartPosition.NorthFace : (upFacing ? PartPosition.TopFace : PartPosition.BottomFace)))))));
    }

    public boolean isGoodForFrame(Multiblock multiblock) {
        if (this.positionType.isGoodForFrame()) {
            return true;
        }
        this.setStandardLastError(multiblock);
        return false;
    }

    public boolean isGoodForSides(Multiblock multiblock) {
        if (this.positionType.isGoodForWall()) {
            return true;
        }
        this.setStandardLastError(multiblock);
        return false;
    }

    public boolean isGoodForTop(Multiblock multiblock) {
        if (this.positionType.isGoodForWall()) {
            return true;
        }
        this.setStandardLastError(multiblock);
        return false;
    }

    public boolean isGoodForBottom(Multiblock multiblock) {
        if (this.positionType.isGoodForWall()) {
            return true;
        }
        this.setStandardLastError(multiblock);
        return false;
    }

    public boolean isGoodForInterior(Multiblock multiblock) {
        if (this.positionType.isGoodForInterior()) {
            return true;
        }
        this.setStandardLastError(multiblock);
        return false;
    }
}

