/*
 * Decompiled with CFR 0.152.
 */
package nc.multiblock.fission;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.lang.reflect.Constructor;
import java.util.Iterator;
import javax.annotation.Nonnull;
import nc.multiblock.ILogicMultiblock;
import nc.multiblock.Multiblock;
import nc.multiblock.cuboidal.CuboidalMultiblock;
import nc.multiblock.fission.FissionCluster;
import nc.multiblock.fission.FissionReactorLogic;
import nc.multiblock.fission.tile.IFissionComponent;
import nc.multiblock.fission.tile.IFissionController;
import nc.multiblock.fission.tile.IFissionPart;
import nc.multiblock.fission.tile.TileFissionMonitor;
import nc.multiblock.tile.ITileMultiblockPart;
import nc.multiblock.tile.TileBeefAbstract;
import nc.network.multiblock.FissionUpdatePacket;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class FissionReactor
extends CuboidalMultiblock<IFissionPart, FissionUpdatePacket>
implements ILogicMultiblock<FissionReactorLogic, IFissionPart> {
    public static final ObjectSet<Class<? extends IFissionPart>> PART_CLASSES = new ObjectOpenHashSet();
    public static final Object2ObjectMap<String, Constructor<? extends FissionReactorLogic>> LOGIC_MAP = new Object2ObjectOpenHashMap();
    @Nonnull
    protected FissionReactorLogic logic = new FissionReactorLogic(this);
    protected final Multiblock.PartSuperMap<IFissionPart> partSuperMap = new Multiblock.PartSuperMap();
    protected final Int2ObjectMap<FissionCluster> clusterMap = new Int2ObjectOpenHashMap();
    public int clusterCount = 0;
    protected final ObjectSet<FissionCluster> clustersToRefresh = new ObjectOpenHashSet();
    public IFissionController controller;
    public final LongSet passiveModeratorCache = new LongOpenHashSet();
    public final LongSet activeModeratorCache = new LongOpenHashSet();
    public final LongSet activeReflectorCache = new LongOpenHashSet();
    public static final int BASE_MAX_HEAT = 25000;
    public static final int MAX_TEMP = 2400;
    public static final int BASE_TANK_CAPACITY = 4000;
    public boolean refreshFlag = true;
    public boolean isReactorOn = false;
    public int ambientTemp = 290;
    public int fuelComponentCount = 0;
    public long cooling = 0L;
    public long rawHeating = 0L;
    public long totalHeatMult = 0L;
    public long usefulPartCount = 0L;
    public double meanHeatMult = 0.0;
    public double totalEfficiency = 0.0;
    public double meanEfficiency = 0.0;
    public double sparsityEfficiencyMult = 0.0;

    public FissionReactor(World world) {
        super(world);
        for (Class clazz : PART_CLASSES) {
            this.partSuperMap.equip(clazz);
        }
    }

    @Override
    @Nonnull
    public FissionReactorLogic getLogic() {
        return this.logic;
    }

    @Override
    public void setLogic(String logicID) {
        if (logicID.equals(this.logic.getID())) {
            return;
        }
        this.logic = (FissionReactorLogic)this.getNewLogic((Constructor)LOGIC_MAP.get((Object)logicID));
    }

    @Override
    public Multiblock.PartSuperMap<IFissionPart> getPartSuperMap() {
        return this.partSuperMap;
    }

    public Int2ObjectMap<FissionCluster> getClusterMap() {
        return this.clusterMap;
    }

    public void resetStats() {
        this.logic.onResetStats();
        this.fuelComponentCount = 0;
        this.usefulPartCount = 0L;
        this.totalHeatMult = 0L;
        this.rawHeating = 0L;
        this.cooling = 0L;
        this.sparsityEfficiencyMult = 0.0;
        this.meanEfficiency = 0.0;
        this.totalEfficiency = 0.0;
        this.meanHeatMult = 0.0;
    }

    @Override
    protected int getMinimumInteriorLength() {
        return this.logic.getMinimumInteriorLength();
    }

    @Override
    protected int getMaximumInteriorLength() {
        return this.logic.getMaximumInteriorLength();
    }

    @Override
    public void onAttachedPartWithMultiblockData(ITileMultiblockPart part, NBTTagCompound data) {
        this.logic.onAttachedPartWithMultiblockData(part, data);
        this.syncDataFrom(data, TileBeefAbstract.SyncReason.FullSync);
    }

    @Override
    protected void onBlockAdded(ITileMultiblockPart newPart) {
        this.onPartAdded(newPart);
        this.logic.onBlockAdded(newPart);
    }

    @Override
    protected void onBlockRemoved(ITileMultiblockPart oldPart) {
        this.onPartRemoved(oldPart);
        this.logic.onBlockRemoved(oldPart);
    }

    @Override
    protected void onMachineAssembled() {
        this.logic.onMachineAssembled();
    }

    @Override
    protected void onMachineRestored() {
        this.logic.onMachineRestored();
    }

    @Override
    protected void onMachinePaused() {
        this.logic.onMachinePaused();
    }

    @Override
    protected void onMachineDisassembled() {
        this.logic.onMachineDisassembled();
    }

    @Override
    protected boolean isMachineWhole() {
        return this.setLogic(this) && super.isMachineWhole() && this.logic.isMachineWhole();
    }

    public boolean setLogic(Multiblock multiblock) {
        if (this.getPartMap(IFissionController.class).isEmpty()) {
            multiblock.setLastError("nuclearcraft.multiblock_validation.no_controller", null, new Object[0]);
            return false;
        }
        if (this.getPartCount(IFissionController.class) > 1) {
            multiblock.setLastError("nuclearcraft.multiblock_validation.too_many_controllers", null, new Object[0]);
            return false;
        }
        Iterator<IFissionController> iterator = this.getParts(IFissionController.class).iterator();
        while (iterator.hasNext()) {
            IFissionController contr;
            this.controller = contr = iterator.next();
        }
        this.setLogic(this.controller.getLogicID());
        return true;
    }

    @Override
    protected void onAssimilate(Multiblock assimilated) {
        this.logic.onAssimilate(assimilated);
    }

    @Override
    protected void onAssimilated(Multiblock assimilator) {
        this.logic.onAssimilated(assimilator);
    }

    public void addClusterToRefresh(FissionCluster cluster) {
        if (cluster != null) {
            this.clustersToRefresh.add((Object)cluster);
        }
    }

    protected void refreshCluster(FissionCluster cluster) {
        if (cluster != null && this.clusterMap.containsKey(cluster.getId())) {
            this.logic.refreshClusterStats(cluster);
        }
    }

    protected void sortClusters() {
        ObjectOpenHashSet uniqueClusterCache = new ObjectOpenHashSet();
        for (FissionCluster cluster : this.clusterMap.values()) {
            uniqueClusterCache.add((Object)cluster);
        }
        this.clusterMap.clear();
        int i = 0;
        for (FissionCluster cluster : uniqueClusterCache) {
            cluster.setId(i);
            this.clusterMap.put(i, (Object)cluster);
            ++i;
        }
        this.clusterCount = this.clusterMap.size();
    }

    public void mergeClusters(int assimilatorId, FissionCluster targetCluster) {
        if (assimilatorId == targetCluster.getId()) {
            return;
        }
        FissionCluster assimilatorCluster = (FissionCluster)this.clusterMap.get(assimilatorId);
        if (targetCluster.connectedToWall) {
            assimilatorCluster.connectedToWall = true;
        }
        for (IFissionComponent component : targetCluster.getComponentMap().values()) {
            component.setCluster(assimilatorCluster);
        }
        assimilatorCluster.heatBuffer.mergeHeatBuffers(targetCluster.heatBuffer);
        targetCluster.getComponentMap().clear();
        this.clusterMap.remove(targetCluster.getId());
    }

    @Override
    protected boolean updateServer() {
        boolean flag = this.refreshFlag;
        if (this.refreshFlag) {
            this.logic.refreshReactor();
            this.clustersToRefresh.clear();
        } else if (!this.clustersToRefresh.isEmpty()) {
            for (FissionCluster cluster : this.clustersToRefresh) {
                this.refreshCluster(cluster);
            }
            this.logic.refreshReactorStats();
            this.clustersToRefresh.clear();
        }
        this.updateActivity();
        if (this.logic.onUpdateServer()) {
            flag = true;
        }
        this.logic.updateRedstone();
        if (this.controller != null) {
            this.sendUpdateToListeningPlayers();
        }
        return flag;
    }

    public void updateActivity() {
        boolean wasReactorOn = this.isReactorOn;
        boolean bl = this.isReactorOn = this.isAssembled() && this.logic.isReactorOn();
        if (this.isReactorOn != wasReactorOn) {
            if (this.controller != null) {
                this.controller.setActivity(this.isReactorOn);
                this.sendUpdateToAllPlayers();
            }
            for (TileFissionMonitor monitor : this.getParts(TileFissionMonitor.class)) {
                monitor.setActivity(this.isReactorOn);
            }
        }
    }

    @Override
    protected void updateClient() {
        this.logic.onUpdateClient();
    }

    @Override
    public void syncDataTo(NBTTagCompound data, TileBeefAbstract.SyncReason syncReason) {
        data.func_74757_a("isReactorOn", this.isReactorOn);
        data.func_74768_a("clusterCount", this.clusterCount);
        data.func_74772_a("cooling", this.cooling);
        data.func_74772_a("rawHeating", this.rawHeating);
        data.func_74772_a("totalHeatMult", this.totalHeatMult);
        data.func_74780_a("meanHeatMult", this.meanHeatMult);
        data.func_74768_a("fuelComponentCount", this.fuelComponentCount);
        data.func_74772_a("usefulPartCount", this.usefulPartCount);
        data.func_74780_a("totalEfficiency", this.totalEfficiency);
        data.func_74780_a("meanEfficiency", this.meanEfficiency);
        data.func_74780_a("sparsityEfficiencyMult", this.sparsityEfficiencyMult);
        this.writeLogicNBT(data, syncReason);
    }

    @Override
    public void syncDataFrom(NBTTagCompound data, TileBeefAbstract.SyncReason syncReason) {
        this.isReactorOn = data.func_74767_n("isReactorOn");
        this.clusterCount = data.func_74762_e("clusterCount");
        this.cooling = data.func_74763_f("cooling");
        this.rawHeating = data.func_74763_f("rawHeating");
        this.totalHeatMult = data.func_74763_f("totalHeatMult");
        this.meanHeatMult = data.func_74769_h("meanHeatMult");
        this.fuelComponentCount = data.func_74762_e("fuelComponentCount");
        this.usefulPartCount = data.func_74763_f("usefulPartCount");
        this.totalEfficiency = data.func_74769_h("totalEfficiency");
        this.meanEfficiency = data.func_74769_h("meanEfficiency");
        this.sparsityEfficiencyMult = data.func_74769_h("sparsityEfficiencyMult");
        this.readLogicNBT(data, syncReason);
    }

    @Override
    protected FissionUpdatePacket getUpdatePacket() {
        return this.logic.getUpdatePacket();
    }

    @Override
    public void onPacket(FissionUpdatePacket message) {
        this.isReactorOn = message.isReactorOn;
        this.clusterCount = message.clusterCount;
        this.cooling = message.cooling;
        this.rawHeating = message.rawHeating;
        this.totalHeatMult = message.totalHeatMult;
        this.meanHeatMult = message.meanHeatMult;
        this.fuelComponentCount = message.fuelComponentCount;
        this.usefulPartCount = message.usefulPartCount;
        this.totalEfficiency = message.totalEfficiency;
        this.meanEfficiency = message.meanEfficiency;
        this.sparsityEfficiencyMult = message.sparsityEfficiencyMult;
        this.logic.onPacket(message);
    }

    @Override
    public void clearAllMaterial() {
        this.logic.clearAllMaterial();
        super.clearAllMaterial();
        if (!this.WORLD.field_72995_K) {
            this.logic.refreshReactor();
            this.updateActivity();
        }
    }

    @Override
    protected boolean isBlockGoodForInterior(World world, BlockPos pos) {
        return this.logic.isBlockGoodForInterior(world, pos);
    }
}

