/*
 * Decompiled with CFR 0.152.
 */
package nc.multiblock.fission;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import nc.block.property.BlockProperties;
import nc.config.NCConfig;
import nc.init.NCSounds;
import nc.multiblock.Multiblock;
import nc.multiblock.MultiblockLogic;
import nc.multiblock.MultiblockRegistry;
import nc.multiblock.fission.FissionCluster;
import nc.multiblock.fission.FissionReactor;
import nc.multiblock.fission.tile.IFissionComponent;
import nc.multiblock.fission.tile.IFissionController;
import nc.multiblock.fission.tile.IFissionCoolingComponent;
import nc.multiblock.fission.tile.IFissionFuelComponent;
import nc.multiblock.fission.tile.IFissionHeatingComponent;
import nc.multiblock.fission.tile.IFissionPart;
import nc.multiblock.fission.tile.IFissionSpecialComponent;
import nc.multiblock.fission.tile.TileFissionIrradiator;
import nc.multiblock.fission.tile.TileFissionShield;
import nc.multiblock.fission.tile.TileFissionSource;
import nc.multiblock.fission.tile.TileFissionVent;
import nc.multiblock.fission.tile.manager.TileFissionShieldManager;
import nc.multiblock.fission.tile.port.TileFissionIrradiatorPort;
import nc.multiblock.tile.TileBeefAbstract;
import nc.network.multiblock.FissionUpdatePacket;
import nc.tile.internal.energy.EnergyStorage;
import nc.tile.internal.fluid.Tank;
import nc.tile.internal.heat.HeatBuffer;
import nc.util.NCMath;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import org.apache.commons.lang3.tuple.Pair;

public class FissionReactorLogic
extends MultiblockLogic<FissionReactor, FissionReactorLogic, IFissionPart, FissionUpdatePacket> {
    public final HeatBuffer heatBuffer = new HeatBuffer(25000L);
    public final Long2ObjectMap<IFissionComponent> componentFailCache = new Long2ObjectOpenHashMap();
    public final Long2ObjectMap<IFissionComponent> assumedValidCache = new Long2ObjectOpenHashMap();

    public FissionReactorLogic(FissionReactor reactor) {
        super(reactor);
    }

    public FissionReactorLogic(FissionReactorLogic oldLogic) {
        super(oldLogic);
    }

    @Override
    public String getID() {
        return "";
    }

    protected FissionReactor getReactor() {
        return (FissionReactor)this.multiblock;
    }

    protected Int2ObjectMap<FissionCluster> getClusterMap() {
        return this.getReactor().getClusterMap();
    }

    public void onResetStats() {
    }

    @Override
    public int getMinimumInteriorLength() {
        return NCConfig.fission_min_size;
    }

    @Override
    public int getMaximumInteriorLength() {
        return NCConfig.fission_max_size;
    }

    @Override
    public void onMachineAssembled() {
        this.onReactorFormed();
    }

    @Override
    public void onMachineRestored() {
        this.onReactorFormed();
    }

    public void onReactorFormed() {
        Iterator<IFissionController> iterator = this.getParts(IFissionController.class).iterator();
        while (iterator.hasNext()) {
            IFissionController contr;
            this.getReactor().controller = contr = iterator.next();
        }
        this.heatBuffer.setHeatCapacity(25000 * this.getCapacityMultiplier());
        this.getReactor().ambientTemp = 273 + (int)(this.getWorld().func_180494_b(this.getReactor().getMiddleCoord()).func_180626_a(this.getReactor().getMiddleCoord()) * 20.0f);
        if (!this.getWorld().field_72995_K) {
            this.refreshConnections();
            this.refreshReactor();
            this.getReactor().updateActivity();
        }
    }

    public int getCapacityMultiplier() {
        return Math.max(this.getReactor().getExteriorSurfaceArea(), this.getReactor().getInteriorVolume());
    }

    @Override
    public void onMachinePaused() {
        this.onReactorBroken();
    }

    @Override
    public void onMachineDisassembled() {
        this.onReactorBroken();
    }

    public void onReactorBroken() {
        if (!this.getWorld().field_72995_K) {
            this.refreshConnections();
            this.getReactor().updateActivity();
        }
    }

    @Override
    public boolean isMachineWhole() {
        ((FissionReactor)this.multiblock).setLastError("zerocore.api.nc.multiblock.validation.invalid_logic", null, new Object[0]);
        return false;
    }

    @Override
    public List<Pair<Class<? extends IFissionPart>, String>> getPartBlacklist() {
        return new ArrayList<Pair<Class<? extends IFissionPart>, String>>();
    }

    @Override
    public void onAssimilate(Multiblock assimilated) {
        if (assimilated instanceof FissionReactor) {
            FissionReactor assimilatedReactor = (FissionReactor)assimilated;
            this.heatBuffer.mergeHeatBuffers(assimilatedReactor.getLogic().heatBuffer);
        }
    }

    @Override
    public void onAssimilated(Multiblock assimilator) {
    }

    public void refreshConnections() {
        this.refreshFilteredPorts(TileFissionIrradiatorPort.class, TileFissionIrradiator.class);
    }

    public void refreshReactor() {
        this.componentFailCache.clear();
        do {
            this.assumedValidCache.clear();
            this.refreshFlux();
            this.refreshClusters();
        } while (this.getReactor().refreshFlag);
        this.refreshReactorStats();
    }

    public void refreshManagers() {
        this.refreshManagers(TileFissionShieldManager.class);
    }

    public void refreshFlux() {
        Long2ObjectOpenHashMap primedFailCache = new Long2ObjectOpenHashMap();
        do {
            this.getReactor().refreshFlag = false;
            if (!this.getReactor().isAssembled()) {
                return;
            }
            ObjectOpenHashSet primedCache = new ObjectOpenHashSet();
            for (IFissionComponent component : this.getParts(IFissionComponent.class)) {
                if (component instanceof IFissionFuelComponent) {
                    IFissionFuelComponent fuelComponent = (IFissionFuelComponent)component;
                    fuelComponent.refreshIsProcessing(false);
                    if ((fuelComponent.isFunctional() || fuelComponent.isSelfPriming()) && !primedFailCache.containsKey(fuelComponent.getTilePos().func_177986_g())) {
                        fuelComponent.tryPriming(this.getReactor(), false);
                        if (fuelComponent.isPrimed()) {
                            fuelComponent.addToPrimedCache((ObjectSet<IFissionFuelComponent>)primedCache);
                        }
                    }
                }
                component.setCluster(null);
                component.resetStats();
            }
            for (FissionCluster cluster : this.getReactor().clusterMap.values()) {
                cluster.distributeHeatToComponents();
                cluster.getComponentMap().clear();
            }
            this.getReactor().clusterMap.clear();
            this.getReactor().clusterCount = 0;
            this.getReactor().passiveModeratorCache.clear();
            this.getReactor().activeModeratorCache.clear();
            this.getReactor().activeReflectorCache.clear();
            this.distributeFlux((ObjectSet<IFissionFuelComponent>)primedCache, (Long2ObjectMap<IFissionFuelComponent>)primedFailCache);
        } while (this.getReactor().refreshFlag);
    }

    public void distributeFlux(ObjectSet<IFissionFuelComponent> primedCache, Long2ObjectMap<IFissionFuelComponent> primedFailCache) {
        for (TileFissionSource source : this.getParts(TileFissionSource.class)) {
            IFissionFuelComponent fuelComponent;
            TileFissionSource.PrimingTargetInfo targetInfo;
            IBlockState state = this.getWorld().func_180495_p(source.func_174877_v());
            EnumFacing facing = source.getPartPosition().getFacing();
            source.refreshIsRedstonePowered(this.getWorld(), source.func_174877_v());
            this.getWorld().func_180501_a(source.func_174877_v(), state.func_177226_a((IProperty)BlockProperties.FACING_ALL, (Comparable)(facing != null ? facing : (EnumFacing)state.func_177229_b((IProperty)BlockProperties.FACING_ALL))).func_177226_a((IProperty)BlockProperties.ACTIVE, (Comparable)Boolean.valueOf(source.getIsRedstonePowered())), 3);
            if (!source.getIsRedstonePowered() || (targetInfo = source.getPrimingTarget(false)) == null || (fuelComponent = targetInfo.fuelComponent) == null || primedFailCache.containsKey(fuelComponent.getTilePos().func_177986_g())) continue;
            fuelComponent.tryPriming(this.getReactor(), true);
            if (!fuelComponent.isPrimed()) continue;
            fuelComponent.addToPrimedCache(primedCache);
        }
        for (IFissionFuelComponent primedComponent : primedCache) {
            this.iterateFluxSearch(primedComponent);
        }
        for (IFissionFuelComponent primedComponent : primedCache) {
            primedComponent.refreshIsProcessing(false);
            this.refreshFuelComponentLocal(primedComponent);
            primedComponent.unprime();
            if (primedComponent.isFunctional()) continue;
            primedFailCache.put(primedComponent.getTilePos().func_177986_g(), (Object)primedComponent);
            this.getReactor().refreshFlag = true;
        }
    }

    public void refreshClusters() {
        IFissionComponent component;
        this.refreshAllFuelComponentModerators();
        this.getReactor().passiveModeratorCache.removeAll((LongCollection)this.getReactor().activeModeratorCache);
        for (IFissionComponent component2 : this.getParts(IFissionComponent.class)) {
            if (component2 == null || !component2.isClusterRoot()) continue;
            this.iterateClusterSearch(component2);
        }
        Object object = this.getReactor().activeModeratorCache.iterator();
        while (object.hasNext()) {
            long posLong = (Long)object.next();
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                component = (IFissionComponent)this.getPartMap(IFissionComponent.class).get(BlockPos.func_177969_a((long)posLong).func_177972_a(dir).func_177986_g());
                if (component == null) continue;
                this.iterateClusterSearch(component);
            }
        }
        object = this.getReactor().activeReflectorCache.iterator();
        while (object.hasNext()) {
            long posLong = (Long)object.next();
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                component = (IFissionComponent)this.getPartMap(IFissionComponent.class).get(BlockPos.func_177969_a((long)posLong).func_177972_a(dir).func_177986_g());
                if (component == null) continue;
                this.iterateClusterSearch(component);
            }
        }
        for (IFissionComponent component3 : this.assumedValidCache.values()) {
            if (component3.isFunctional()) continue;
            this.componentFailCache.put(component3.getTilePos().func_177986_g(), (Object)component3);
            this.getReactor().refreshFlag = true;
        }
        if (this.getReactor().refreshFlag) {
            return;
        }
        for (IFissionSpecialComponent component4 : this.getParts(IFissionSpecialComponent.class)) {
            component4.postClusterSearch();
        }
        for (FissionCluster cluster : this.getReactor().clusterMap.values()) {
            this.refreshClusterStats(cluster);
            cluster.recoverHeatFromComponents();
        }
        this.getReactor().sortClusters();
    }

    public void refreshAllFuelComponentModerators() {
    }

    public void refreshClusterStats(FissionCluster cluster) {
        cluster.fuelComponentCount = 0;
        cluster.componentCount = 0;
        cluster.totalHeatMult = 0L;
        cluster.rawHeatingIgnoreCoolingPenalty = 0L;
        cluster.rawHeating = 0L;
        cluster.cooling = 0L;
        cluster.meanHeatingSpeedMultiplier = 0.0;
        cluster.undercoolingLifetimeFactor = 0.0;
        cluster.overcoolingEfficiencyFactor = 0.0;
        cluster.meanEfficiency = 0.0;
        cluster.totalEfficiencyIgnoreCoolingPenalty = 0.0;
        cluster.totalEfficiency = 0.0;
        cluster.meanHeatMult = 0.0;
        cluster.effectiveHeatingIgnoreCoolingPenalty = 0.0;
        cluster.effectiveHeating = 0.0;
        cluster.heatBuffer.setHeatCapacity(25000 * cluster.getComponentMap().size());
        this.incrementClusterStatsFromComponents(cluster);
        if (this.getReactor().refreshFlag) {
            return;
        }
        cluster.overcoolingEfficiencyFactor = cluster.cooling == 0L ? 1.0 : Math.min(1.0, (double)(cluster.rawHeating + (long)NCConfig.fission_cooling_efficiency_leniency) / (double)cluster.cooling);
        cluster.undercoolingLifetimeFactor = cluster.rawHeating == 0L ? 1.0 : Math.min(1.0, (double)(cluster.cooling + (long)NCConfig.fission_cooling_efficiency_leniency) / (double)cluster.rawHeating);
        cluster.effectiveHeating *= cluster.overcoolingEfficiencyFactor;
        cluster.totalEfficiency *= cluster.overcoolingEfficiencyFactor;
        cluster.rawHeating += cluster.rawHeatingIgnoreCoolingPenalty;
        cluster.effectiveHeating += cluster.effectiveHeatingIgnoreCoolingPenalty;
        cluster.totalEfficiency += cluster.totalEfficiencyIgnoreCoolingPenalty;
        cluster.meanHeatMult = cluster.fuelComponentCount == 0 ? 0.0 : (double)cluster.totalHeatMult / (double)cluster.fuelComponentCount;
        cluster.meanEfficiency = cluster.fuelComponentCount == 0 ? 0.0 : cluster.totalEfficiency / (double)cluster.fuelComponentCount;
        for (IFissionComponent component : cluster.getComponentMap().values()) {
            if (!(component instanceof IFissionFuelComponent)) continue;
            IFissionFuelComponent fuelComponent = (IFissionFuelComponent)component;
            fuelComponent.setUndercoolingLifetimeFactor(cluster.undercoolingLifetimeFactor);
        }
    }

    public void incrementClusterStatsFromComponents(FissionCluster cluster) {
        for (IFissionComponent component : cluster.getComponentMap().values()) {
            if (!component.isFunctional()) continue;
            ++cluster.componentCount;
            if (component instanceof IFissionHeatingComponent) {
                cluster.rawHeating += ((IFissionHeatingComponent)component).getRawHeating();
                cluster.rawHeatingIgnoreCoolingPenalty += ((IFissionHeatingComponent)component).getRawHeatingIgnoreCoolingPenalty();
                cluster.effectiveHeating += ((IFissionHeatingComponent)component).getEffectiveHeating();
                cluster.effectiveHeatingIgnoreCoolingPenalty += ((IFissionHeatingComponent)component).getEffectiveHeatingIgnoreCoolingPenalty();
                if (component instanceof IFissionFuelComponent) {
                    ++cluster.fuelComponentCount;
                    cluster.totalHeatMult += ((IFissionFuelComponent)component).getHeatMultiplier();
                    cluster.totalEfficiency += ((IFissionFuelComponent)component).getEfficiency();
                    cluster.totalEfficiencyIgnoreCoolingPenalty += ((IFissionFuelComponent)component).getEfficiencyIgnoreCoolingPenalty();
                }
            }
            if (!(component instanceof IFissionCoolingComponent)) continue;
            cluster.cooling += ((IFissionCoolingComponent)component).getCooling();
        }
    }

    public void iterateFluxSearch(IFissionFuelComponent rootFuelComponent) {
        ObjectOpenHashSet fluxSearchCache = new ObjectOpenHashSet();
        rootFuelComponent.fluxSearch((ObjectSet<IFissionFuelComponent>)fluxSearchCache, this.componentFailCache, this.assumedValidCache);
        do {
            ObjectIterator fluxSearchIterator = fluxSearchCache.iterator();
            ObjectOpenHashSet fluxSearchSubCache = new ObjectOpenHashSet();
            while (fluxSearchIterator.hasNext()) {
                IFissionFuelComponent fuelComponent = (IFissionFuelComponent)fluxSearchIterator.next();
                fluxSearchIterator.remove();
                fuelComponent.fluxSearch((ObjectSet<IFissionFuelComponent>)fluxSearchSubCache, this.componentFailCache, this.assumedValidCache);
            }
            fluxSearchCache.addAll((Collection)fluxSearchSubCache);
        } while (!fluxSearchCache.isEmpty());
    }

    public void iterateClusterSearch(IFissionComponent rootComponent) {
        Object2IntOpenHashMap clusterSearchCache = new Object2IntOpenHashMap();
        rootComponent.clusterSearch(null, (Object2IntMap<IFissionComponent>)clusterSearchCache, this.componentFailCache, this.assumedValidCache);
        do {
            ObjectIterator clusterSearchIterator = clusterSearchCache.keySet().iterator();
            Object2IntOpenHashMap clusterSearchSubCache = new Object2IntOpenHashMap();
            while (clusterSearchIterator.hasNext()) {
                IFissionComponent component = (IFissionComponent)clusterSearchIterator.next();
                Integer id = (Integer)clusterSearchCache.get((Object)component);
                clusterSearchIterator.remove();
                component.clusterSearch(id, (Object2IntMap<IFissionComponent>)clusterSearchSubCache, this.componentFailCache, this.assumedValidCache);
            }
            clusterSearchCache.putAll((Map)clusterSearchSubCache);
        } while (!clusterSearchCache.isEmpty());
    }

    public void refreshReactorStats() {
        this.getReactor().resetStats();
    }

    @Override
    public boolean onUpdateServer() {
        if (!this.getReactor().isReactorOn) {
            this.heatBuffer.changeHeatStored(-this.getHeatDissipation());
        }
        return false;
    }

    public boolean isReactorOn() {
        return this.getReactor().rawHeating > 0L;
    }

    public void updateRedstone() {
    }

    public void playFuelComponentSounds(Class<? extends IFissionFuelComponent> clazz) {
        Collection<? extends IFissionFuelComponent> fuelComponents = this.getParts(clazz);
        int i = fuelComponents.size();
        for (IFissionFuelComponent iFissionFuelComponent : fuelComponents) {
            if ((i <= 0 || this.rand.nextDouble() < 1.0 / (double)i) && this.playFissionSound(iFissionFuelComponent)) {
                return;
            }
            if (!iFissionFuelComponent.isFunctional()) continue;
            --i;
        }
    }

    public boolean playFissionSound(IFissionFuelComponent fuelComponent) {
        if (this.getReactor().fuelComponentCount <= 0) {
            return true;
        }
        double soundRate = Math.min(1.0, fuelComponent.getEfficiency() / (14.0 * (double)NCConfig.fission_max_size));
        if (this.rand.nextDouble() < soundRate) {
            this.getWorld().func_184148_a(null, (double)fuelComponent.getTilePos().func_177958_n(), (double)fuelComponent.getTilePos().func_177956_o(), (double)fuelComponent.getTilePos().func_177952_p(), NCSounds.geiger_tick, SoundCategory.BLOCKS, (float)(1.6 * Math.log1p(Math.sqrt(this.getReactor().fuelComponentCount)) * NCConfig.fission_sound_volume), 1.0f + 0.12f * (this.rand.nextFloat() - 0.5f));
            return true;
        }
        return false;
    }

    public void casingMeltdown() {
        Iterator<IFissionController> controllerIterator = this.getPartIterator(IFissionController.class);
        while (controllerIterator.hasNext()) {
            IFissionController controller = controllerIterator.next();
            controller.doMeltdown(controllerIterator);
        }
        if (this.getPartMap(TileFissionVent.class).isEmpty()) {
            // empty if block
        }
        MultiblockRegistry.INSTANCE.addDirtyMultiblock(this.getWorld(), this.getReactor());
    }

    public void clusterMeltdown(FissionCluster cluster) {
        MultiblockRegistry.INSTANCE.addDirtyMultiblock(this.getWorld(), this.getReactor());
    }

    public long getHeatDissipation() {
        return Math.max(1L, this.heatBuffer.getHeatStored() * (long)this.getReactor().getExteriorSurfaceArea() / ((long)NCMath.cube(6) * 672000L));
    }

    public int getTemperature() {
        return Math.round((float)this.getReactor().ambientTemp + (float)(2400 - this.getReactor().ambientTemp) * (float)this.heatBuffer.getHeatStored() / (float)this.heatBuffer.getHeatCapacity());
    }

    public float getBurnDamage() {
        return this.getTemperature() < 373 ? 0.0f : 1.0f + (float)(this.getTemperature() - 373) / 200.0f;
    }

    public void onSourceUpdated(TileFissionSource source) {
        TileFissionSource.PrimingTargetInfo targetInfo;
        if (source.getIsRedstonePowered() && (targetInfo = source.getPrimingTarget(false)) != null) {
            if (!targetInfo.fuelComponent.isFunctional()) {
                this.getReactor().refreshFlag = true;
            } else if (targetInfo.newSourceEfficiency) {
                this.getReactor().refreshCluster(targetInfo.fuelComponent.getCluster());
            }
        }
    }

    public void onShieldUpdated(TileFissionShield shield) {
        if (shield.inCompleteModeratorLine) {
            this.getReactor().refreshFlag = true;
        }
    }

    public void distributeFluxFromFuelComponent(IFissionFuelComponent fuelComponent, ObjectSet<IFissionFuelComponent> fluxSearchCache, Long2ObjectMap<IFissionComponent> componentFailCache, Long2ObjectMap<IFissionComponent> assumedValidCache) {
    }

    public IFissionFuelComponent getNextFuelComponent(IFissionFuelComponent fuelComponent, BlockPos pos) {
        IFissionComponent component = (IFissionComponent)this.getPartMap(IFissionComponent.class).get(pos.func_177986_g());
        return component instanceof IFissionFuelComponent ? (IFissionFuelComponent)component : null;
    }

    public void refreshFuelComponentLocal(IFissionFuelComponent fuelComponent) {
    }

    public void refreshFuelComponentModerators(IFissionFuelComponent fuelComponent, Long2ObjectMap<IFissionComponent> componentFailCache, Long2ObjectMap<IFissionComponent> assumedValidCache) {
    }

    public boolean isShieldActiveModerator(TileFissionShield shield, boolean activeModeratorPos) {
        return false;
    }

    public IFissionFuelComponent.ModeratorBlockInfo getShieldModeratorBlockInfo(TileFissionShield shield, boolean validActiveModerator) {
        return new IFissionFuelComponent.ModeratorBlockInfo(shield.func_174877_v(), shield, shield.isShielding, validActiveModerator, 0, shield.efficiency);
    }

    @Nonnull
    public EnergyStorage getPowerPortEnergyStorage(EnergyStorage backupStorage) {
        return backupStorage;
    }

    public int getPowerPortEUSourceTier() {
        return 1;
    }

    public int getPowerPortEUSinkTier() {
        return 1;
    }

    @Nonnull
    public List<Tank> getVentTanks(List<Tank> backupTanks) {
        return backupTanks;
    }

    @Override
    public void onUpdateClient() {
    }

    @Override
    public void writeToLogicTag(NBTTagCompound logicTag, TileBeefAbstract.SyncReason syncReason) {
        this.heatBuffer.writeToNBT(logicTag, "heatBuffer");
    }

    @Override
    public void readFromLogicTag(NBTTagCompound logicTag, TileBeefAbstract.SyncReason syncReason) {
        this.heatBuffer.readFromNBT(logicTag, "heatBuffer");
    }

    @Override
    public FissionUpdatePacket getUpdatePacket() {
        return null;
    }

    @Override
    public void onPacket(FissionUpdatePacket message) {
        this.heatBuffer.setHeatStored(message.heatStored);
        this.heatBuffer.setHeatCapacity(message.heatCapacity);
    }

    @Override
    public void clearAllMaterial() {
    }
}

