/*
 * Decompiled with CFR 0.152.
 */
package nc.multiblock.fission.block;

import nc.config.NCConfig;
import nc.multiblock.block.BlockMultiblockPart;
import nc.multiblock.fission.FissionReactor;
import nc.multiblock.fission.tile.IFissionComponent;
import nc.multiblock.fission.tile.TileFissionPart;
import nc.tab.NCTabs;
import nc.util.BlockHelper;
import nc.util.DamageSources;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class BlockFissionPart
extends BlockMultiblockPart {
    public BlockFissionPart() {
        super(Material.field_151573_f, NCTabs.MULTIBLOCK);
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return NCConfig.fission_heat_damage ? BlockHelper.REDUCED_BLOCK_AABB : super.func_180646_a(blockState, worldIn, pos);
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        BlockFissionPart.onEntityCollisionWithFissionReactor(world, pos, entity);
    }

    public static void onEntityCollisionWithFissionReactor(World world, BlockPos pos, Entity entity) {
        TileFissionPart part;
        FissionReactor reactor;
        TileEntity tile;
        if (NCConfig.fission_heat_damage && entity instanceof EntityLivingBase && (tile = world.func_175625_s(pos)) instanceof TileFissionPart && (reactor = (FissionReactor)(part = (TileFissionPart)tile).getMultiblock()) != null) {
            float damage = part instanceof IFissionComponent && ((IFissionComponent)((Object)part)).getCluster() != null ? ((IFissionComponent)((Object)part)).getCluster().getBurnDamage() : reactor.getLogic().getBurnDamage();
            if (damage > 0.0f) {
                entity.func_70097_a(DamageSources.FISSION_BURN, damage);
            }
            if (damage > 5.0f) {
                entity.func_70015_d((int)(damage - 4.0f));
            }
        }
    }

    public static abstract class Transparent
    extends BlockMultiblockPart.Transparent {
        public Transparent(boolean smartRender) {
            super(Material.field_151573_f, NCTabs.MULTIBLOCK, smartRender);
        }

        public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
            return NCConfig.fission_heat_damage ? BlockHelper.REDUCED_BLOCK_AABB : super.func_180646_a(blockState, worldIn, pos);
        }

        public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
            BlockFissionPart.onEntityCollisionWithFissionReactor(world, pos, entity);
        }
    }
}

