/*
 * Decompiled with CFR 0.152.
 */
package nc.multiblock.fission.block.port;

import nc.block.property.BlockProperties;
import nc.block.tile.IActivatable;
import nc.enumm.IBlockMetaEnum;
import nc.multiblock.fission.block.BlockFissionMetaPart;
import nc.multiblock.fission.tile.port.IFissionPortTarget;
import nc.multiblock.fission.tile.port.TileFissionPort;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BlockFissionMetaPort<PORT extends TileFissionPort<PORT, TARGET>, TARGET extends IFissionPortTarget<PORT, TARGET>, T extends Enum<T> & IBlockMetaEnum>
extends BlockFissionMetaPart<T>
implements IActivatable {
    protected final Class<PORT> portClass;

    public BlockFissionMetaPort(Class<PORT> portClass, Class<T> enumm, PropertyEnum<T> property) {
        super(enumm, property);
        this.portClass = portClass;
        this.func_180632_j(this.func_176223_P().func_177226_a(BlockProperties.AXIS_ALL, (Comparable)EnumFacing.Axis.Z).func_177226_a((IProperty)BlockProperties.ACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (this.portClass.isInstance(tile)) {
            TileFissionPort port = (TileFissionPort)tile;
            EnumFacing facing = port.getPartPosition().getFacing();
            return state.func_177226_a(BlockProperties.AXIS_ALL, (Comparable)(facing != null ? facing.func_176740_k() : port.axis)).func_177226_a((IProperty)BlockProperties.ACTIVE, (Comparable)Boolean.valueOf(this.getActualStateActive(port)));
        }
        return state;
    }

    public abstract boolean getActualStateActive(PORT var1);

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176203_a(meta).func_177226_a(BlockProperties.AXIS_ALL, (Comparable)EnumFacing.func_190914_a((BlockPos)pos, (EntityLivingBase)placer).func_176740_k());
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity tile = world.func_175625_s(pos);
        if (this.portClass.isInstance(tile)) {
            TileFissionPort port = (TileFissionPort)tile;
            port.axis = (EnumFacing.Axis)state.func_177229_b(BlockProperties.AXIS_ALL);
            world.func_180501_a(pos, state.func_177226_a(BlockProperties.AXIS_ALL, (Comparable)port.axis), 2);
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (player == null) {
            return false;
        }
        if (hand != EnumHand.MAIN_HAND || player.func_70093_af()) {
            return false;
        }
        return this.rightClickOnPart(world, pos, player, hand, facing);
    }
}

