/*
 * Decompiled with CFR 0.152.
 */
package nc.multiblock.fission.salt;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import nc.config.NCConfig;
import nc.multiblock.fission.FissionCluster;
import nc.multiblock.fission.FissionReactorLogic;
import nc.multiblock.fission.salt.SaltFissionVesselBunch;
import nc.multiblock.fission.salt.tile.TileSaltFissionHeater;
import nc.multiblock.fission.salt.tile.TileSaltFissionVessel;
import nc.multiblock.fission.solid.tile.TileSolidFissionCell;
import nc.multiblock.fission.solid.tile.TileSolidFissionSink;
import nc.multiblock.fission.tile.IFissionComponent;
import nc.multiblock.fission.tile.IFissionCoolingComponent;
import nc.multiblock.fission.tile.IFissionFuelComponent;
import nc.multiblock.fission.tile.IFissionHeatingComponent;
import nc.multiblock.fission.tile.IFissionPart;
import nc.multiblock.fission.tile.TileFissionShield;
import nc.multiblock.fission.tile.TileFissionVent;
import nc.multiblock.fission.tile.port.TileFissionHeaterPort;
import nc.multiblock.fission.tile.port.TileFissionVesselPort;
import nc.multiblock.tile.TileBeefAbstract;
import nc.network.multiblock.FissionUpdatePacket;
import nc.network.multiblock.SaltFissionUpdatePacket;
import nc.recipe.BasicRecipe;
import nc.recipe.NCRecipes;
import nc.recipe.RecipeInfo;
import nc.recipe.ingredient.IFluidIngredient;
import nc.tile.internal.fluid.Tank;
import nc.util.NCMath;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;

public class MoltenSaltFissionLogic
extends FissionReactorLogic {
    public final ObjectSet<SaltFissionVesselBunch> vesselBunches = new ObjectOpenHashSet();
    public final List<Tank> tanks = Lists.newArrayList((Object[])new Tank[]{new Tank(4000, NCRecipes.fission_emergency_cooling_valid_fluids.get(0)), new Tank(4000, null)});
    public RecipeInfo<BasicRecipe> emergencyCoolingRecipeInfo;
    public int heaterCount = 0;
    public double meanHeatingSpeedMultiplier = 0.0;
    public double totalHeatingSpeedMultiplier = 0.0;
    public static final List<Pair<Class<? extends IFissionPart>, String>> MOLTEN_SALT_PART_BLACKLIST = Lists.newArrayList((Object[])new Pair[]{Pair.of(TileSolidFissionCell.class, (Object)"nuclearcraft.multiblock_validation.fission_reactor.prohibit_cells"), Pair.of(TileSolidFissionSink.class, (Object)"nuclearcraft.multiblock_validation.fission_reactor.prohibit_sinks")});

    public MoltenSaltFissionLogic(FissionReactorLogic oldLogic) {
        super(oldLogic);
        if (oldLogic instanceof MoltenSaltFissionLogic) {
            MoltenSaltFissionLogic oldMoltenSaltLogic = (MoltenSaltFissionLogic)oldLogic;
            this.heaterCount = oldMoltenSaltLogic.heaterCount;
            this.meanHeatingSpeedMultiplier = oldMoltenSaltLogic.meanHeatingSpeedMultiplier;
            this.totalHeatingSpeedMultiplier = oldMoltenSaltLogic.totalHeatingSpeedMultiplier;
        }
    }

    @Override
    public String getID() {
        return "molten_salt";
    }

    @Override
    public void onResetStats() {
        this.heaterCount = 0;
        this.totalHeatingSpeedMultiplier = 0.0;
        this.meanHeatingSpeedMultiplier = 0.0;
    }

    @Override
    public void onReactorFormed() {
        this.tanks.get(0).setCapacity(4000 * this.getCapacityMultiplier());
        this.tanks.get(1).setCapacity(4000 * this.getCapacityMultiplier());
        super.onReactorFormed();
    }

    @Override
    public boolean isMachineWhole() {
        return !this.containsBlacklistedPart();
    }

    @Override
    public List<Pair<Class<? extends IFissionPart>, String>> getPartBlacklist() {
        return MOLTEN_SALT_PART_BLACKLIST;
    }

    @Override
    public void refreshConnections() {
        super.refreshConnections();
        this.refreshFilteredPorts(TileFissionVesselPort.class, TileSaltFissionVessel.class);
        this.refreshFilteredPorts(TileFissionHeaterPort.class, TileSaltFissionHeater.class);
        this.formVesselBunches();
    }

    public void formVesselBunches() {
        this.vesselBunches.clear();
        for (TileSaltFissionVessel vessel : this.getParts(TileSaltFissionVessel.class)) {
            vessel.setVesselBunch(null);
        }
        for (TileSaltFissionVessel vessel : this.getParts(TileSaltFissionVessel.class)) {
            boolean setBunch = false;
            SaltFissionVesselBunch bunch = null;
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                TileSaltFissionVessel other = (TileSaltFissionVessel)this.getPartMap(TileSaltFissionVessel.class).get(vessel.func_174877_v().func_177972_a(dir).func_177986_g());
                if (other == null || !vessel.getFilterKey().equals(other.getFilterKey())) continue;
                SaltFissionVesselBunch otherBunch = other.getVesselBunch();
                if (bunch == null) {
                    bunch = otherBunch;
                } else if (bunch != otherBunch) {
                    if (otherBunch != null) {
                        this.vesselBunches.remove((Object)otherBunch);
                        for (TileSaltFissionVessel otherBunchVessel : otherBunch.getPartMap().values()) {
                            otherBunchVessel.setVesselBunch(bunch);
                        }
                        otherBunch.getPartMap().clear();
                    } else {
                        other.setVesselBunch(bunch);
                    }
                }
                if (setBunch || bunch == null) continue;
                vessel.setVesselBunch(bunch);
                setBunch = true;
            }
            if (bunch != null) continue;
            bunch = new SaltFissionVesselBunch(this.getReactor());
            vessel.setVesselBunch(bunch);
            this.vesselBunches.add((Object)bunch);
        }
        for (SaltFissionVesselBunch bunch : this.vesselBunches) {
            bunch.init();
        }
    }

    @Override
    public void refreshAllFuelComponentModerators() {
        for (TileSaltFissionVessel vessel : this.getParts(TileSaltFissionVessel.class)) {
            this.refreshFuelComponentModerators(vessel, (Long2ObjectMap<IFissionComponent>)this.componentFailCache, (Long2ObjectMap<IFissionComponent>)this.assumedValidCache);
        }
    }

    @Override
    public void incrementClusterStatsFromComponents(FissionCluster cluster) {
        for (SaltFissionVesselBunch bunch : this.vesselBunches) {
            bunch.statsRetrieved = false;
        }
        for (IFissionComponent component : cluster.getComponentMap().values()) {
            if (!component.isFunctional()) continue;
            ++cluster.componentCount;
            if (component instanceof IFissionHeatingComponent) {
                if (component instanceof TileSaltFissionVessel) {
                    SaltFissionVesselBunch bunch = ((TileSaltFissionVessel)component).getVesselBunch();
                    ++cluster.fuelComponentCount;
                    if (!bunch.statsRetrieved) {
                        bunch.statsRetrieved = true;
                        cluster.rawHeating += bunch.getRawHeating();
                        cluster.rawHeatingIgnoreCoolingPenalty += bunch.getRawHeatingIgnoreCoolingPenalty();
                        cluster.effectiveHeating += bunch.getEffectiveHeating();
                        cluster.effectiveHeatingIgnoreCoolingPenalty += bunch.getEffectiveHeatingIgnoreCoolingPenalty();
                        cluster.totalHeatMult += bunch.getHeatMultiplier();
                        cluster.totalEfficiency += bunch.getEfficiency();
                        cluster.totalEfficiencyIgnoreCoolingPenalty += bunch.getEfficiencyIgnoreCoolingPenalty();
                    }
                } else {
                    cluster.rawHeating += ((IFissionHeatingComponent)component).getRawHeating();
                    cluster.effectiveHeating += ((IFissionHeatingComponent)component).getEffectiveHeating();
                }
            }
            if (!(component instanceof IFissionCoolingComponent)) continue;
            cluster.cooling += ((IFissionCoolingComponent)component).getCooling();
        }
    }

    @Override
    public void refreshReactorStats() {
        super.refreshReactorStats();
        for (FissionCluster cluster : this.getReactor().getClusterMap().values()) {
            this.getReactor().usefulPartCount += (long)cluster.componentCount;
            this.getReactor().fuelComponentCount += cluster.fuelComponentCount;
            this.getReactor().cooling += cluster.cooling;
            this.getReactor().rawHeating += cluster.rawHeating;
            this.getReactor().totalHeatMult += cluster.totalHeatMult;
            this.getReactor().totalEfficiency += cluster.totalEfficiency;
        }
        this.getReactor().usefulPartCount += (long)(this.getReactor().passiveModeratorCache.size() + this.getReactor().activeModeratorCache.size() + this.getReactor().activeReflectorCache.size());
        double usefulPartRatio = (double)this.getReactor().usefulPartCount / (double)this.getReactor().getInteriorVolume();
        this.getReactor().sparsityEfficiencyMult = usefulPartRatio >= NCConfig.fission_sparsity_penalty_params[1] ? 1.0 : (1.0 - NCConfig.fission_sparsity_penalty_params[0]) * Math.sin(usefulPartRatio * Math.PI / (2.0 * NCConfig.fission_sparsity_penalty_params[1])) + NCConfig.fission_sparsity_penalty_params[0];
        this.getReactor().totalEfficiency *= this.getReactor().sparsityEfficiencyMult;
        this.getReactor().meanHeatMult = this.getReactor().fuelComponentCount == 0 ? 0.0 : (double)this.getReactor().totalHeatMult / (double)this.getReactor().fuelComponentCount;
        this.getReactor().meanEfficiency = this.getReactor().fuelComponentCount == 0 ? 0.0 : this.getReactor().totalEfficiency / (double)this.getReactor().fuelComponentCount;
        for (FissionCluster cluster : this.getReactor().getClusterMap().values()) {
            cluster.totalHeatingSpeedMultiplier = 0.0;
            cluster.meanHeatingSpeedMultiplier = 0.0;
            int clusterHeaters = 0;
            for (IFissionComponent component : cluster.getComponentMap().values()) {
                if (!(component instanceof TileSaltFissionHeater)) continue;
                TileSaltFissionHeater heater = (TileSaltFissionHeater)component;
                heater.heatingSpeedMultiplier = cluster.meanEfficiency * this.getReactor().sparsityEfficiencyMult * (cluster.rawHeating >= cluster.cooling ? 1.0 : (double)cluster.rawHeating / (double)cluster.cooling);
                cluster.totalHeatingSpeedMultiplier += heater.heatingSpeedMultiplier;
                ++clusterHeaters;
            }
            cluster.meanHeatingSpeedMultiplier = clusterHeaters == 0 ? 0.0 : cluster.totalHeatingSpeedMultiplier / (double)clusterHeaters;
            this.totalHeatingSpeedMultiplier += cluster.meanHeatingSpeedMultiplier;
        }
        this.meanHeatingSpeedMultiplier = this.getReactor().getClusterMap().isEmpty() ? 0.0 : this.totalHeatingSpeedMultiplier / (double)this.getReactor().getClusterMap().size();
    }

    @Override
    public boolean onUpdateServer() {
        if (this.heatBuffer.isFull() && NCConfig.fission_overheat) {
            this.heatBuffer.setHeatStored(0L);
            this.casingMeltdown();
            return true;
        }
        for (FissionCluster cluster : this.getClusterMap().values()) {
            long netHeating = cluster.getNetHeating();
            if (netHeating > 0L && cluster.connectedToWall) {
                this.heatBuffer.changeHeatStored(netHeating);
            } else {
                cluster.heatBuffer.changeHeatStored(netHeating);
            }
            if (!cluster.heatBuffer.isFull() || !NCConfig.fission_overheat) continue;
            cluster.heatBuffer.setHeatStored(0L);
            this.clusterMeltdown(cluster);
            return true;
        }
        if (this.heatBuffer.getHeatStored() > 0L) {
            this.updateEmergencyCooling();
        }
        this.updateSounds();
        return super.onUpdateServer();
    }

    public void updateEmergencyCooling() {
        if (!this.getReactor().isReactorOn) {
            this.refreshRecipe();
            if (this.canProcessInputs()) {
                this.produceProducts();
                return;
            }
        }
    }

    public void updateSounds() {
        if (this.getReactor().isReactorOn) {
            this.playFuelComponentSounds(TileSaltFissionVessel.class);
        }
    }

    public void refreshRecipe() {
        this.emergencyCoolingRecipeInfo = NCRecipes.fission_emergency_cooling.getRecipeInfoFromInputs(new ArrayList<ItemStack>(), this.tanks.subList(0, 1));
    }

    public boolean canProcessInputs() {
        if (!this.setRecipeStats()) {
            return false;
        }
        return this.canProduceProducts();
    }

    public boolean setRecipeStats() {
        return this.emergencyCoolingRecipeInfo != null;
    }

    public boolean canProduceProducts() {
        BasicRecipe recipe = this.emergencyCoolingRecipeInfo.getRecipe();
        IFluidIngredient fluidProduct = recipe.getFluidProducts().get(0);
        int productSize = fluidProduct.getMaxStackSize(0);
        if (productSize <= 0 || fluidProduct.getStack() == null) {
            return false;
        }
        return this.tanks.get(1).isEmpty() || this.tanks.get(1).getFluid().isFluidEqual((FluidStack)fluidProduct.getStack());
    }

    public void produceProducts() {
        IFluidIngredient fluidProduct;
        BasicRecipe recipe = this.emergencyCoolingRecipeInfo.getRecipe();
        int usedInput = NCMath.toInt(Math.min((double)this.tanks.get(0).getFluidAmount() / recipe.getEmergencyCoolingHeatPerInputMB(), (double)Math.min(this.heatBuffer.getHeatStored(), (long)(4000 * this.getPartCount(TileFissionVent.class)))));
        this.tanks.get(0).changeFluidAmount(-usedInput);
        if (this.tanks.get(0).getFluidAmount() <= 0) {
            this.tanks.get(0).setFluidStored(null);
        }
        if ((fluidProduct = recipe.getFluidProducts().get(0)).getMaxStackSize(0) > 0) {
            if (this.tanks.get(1).isEmpty()) {
                this.tanks.get(1).setFluidStored(fluidProduct.getNextStack(0));
                this.tanks.get(1).setFluidAmount(usedInput);
            } else if (this.tanks.get(1).getFluid().isFluidEqual((FluidStack)fluidProduct.getStack())) {
                this.tanks.get(1).changeFluidAmount(usedInput);
            }
        }
        this.heatBuffer.changeHeatStored((long)((double)(-usedInput) * recipe.getEmergencyCoolingHeatPerInputMB()));
    }

    public long getNetClusterHeating() {
        return this.getReactor().rawHeating - this.getReactor().cooling;
    }

    @Override
    public void clusterMeltdown(FissionCluster cluster) {
        ObjectIterator componentIterator = cluster.getComponentMap().values().iterator();
        while (componentIterator.hasNext()) {
            IFissionComponent component = (IFissionComponent)componentIterator.next();
            component.onClusterMeltdown((Iterator<IFissionComponent>)componentIterator);
        }
        super.clusterMeltdown(cluster);
    }

    @Override
    public void distributeFluxFromFuelComponent(IFissionFuelComponent fuelComponent, ObjectSet<IFissionFuelComponent> fluxSearchCache, Long2ObjectMap<IFissionComponent> lineFailCache, Long2ObjectMap<IFissionComponent> assumedValidCache) {
        fuelComponent.defaultDistributeFlux(fluxSearchCache, lineFailCache, assumedValidCache);
    }

    @Override
    public IFissionFuelComponent getNextFuelComponent(IFissionFuelComponent fuelComponent, BlockPos pos) {
        return (IFissionFuelComponent)this.getPartMap(TileSaltFissionVessel.class).get(pos.func_177986_g());
    }

    @Override
    public void refreshFuelComponentLocal(IFissionFuelComponent fuelComponent) {
        fuelComponent.defaultRefreshLocal();
    }

    @Override
    public void refreshFuelComponentModerators(IFissionFuelComponent fuelComponent, Long2ObjectMap<IFissionComponent> componentFailCache, Long2ObjectMap<IFissionComponent> assumedValidCache) {
        fuelComponent.defaultRefreshModerators(componentFailCache, assumedValidCache);
    }

    @Override
    public boolean isShieldActiveModerator(TileFissionShield shield, boolean activeModeratorPos) {
        return super.isShieldActiveModerator(shield, activeModeratorPos);
    }

    @Override
    @Nonnull
    public List<Tank> getVentTanks(List<Tank> backupTanks) {
        return this.getReactor().isAssembled() ? this.tanks : backupTanks;
    }

    @Override
    public void onUpdateClient() {
        super.onUpdateClient();
    }

    @Override
    public void writeToLogicTag(NBTTagCompound logicTag, TileBeefAbstract.SyncReason syncReason) {
        super.writeToLogicTag(logicTag, syncReason);
        this.writeTanks(this.tanks, logicTag, "tanks");
        logicTag.func_74768_a("heaterCount", this.heaterCount);
        logicTag.func_74780_a("meanHeatingSpeedMultiplier", this.meanHeatingSpeedMultiplier);
        logicTag.func_74780_a("totalHeatingSpeedMultiplier", this.totalHeatingSpeedMultiplier);
    }

    @Override
    public void readFromLogicTag(NBTTagCompound logicTag, TileBeefAbstract.SyncReason syncReason) {
        super.readFromLogicTag(logicTag, syncReason);
        this.readTanks(this.tanks, logicTag, "tanks");
        this.heaterCount = logicTag.func_74762_e("heaterCount");
        this.meanHeatingSpeedMultiplier = logicTag.func_74769_h("meanHeatingSpeedMultiplier");
        this.totalHeatingSpeedMultiplier = logicTag.func_74769_h("totalHeatingSpeedMultiplier");
    }

    @Override
    public SaltFissionUpdatePacket getUpdatePacket() {
        return new SaltFissionUpdatePacket(this.getReactor().controller.getTilePos(), this.getReactor().isReactorOn, this.heatBuffer, this.getReactor().clusterCount, this.getReactor().cooling, this.getReactor().rawHeating, this.getReactor().totalHeatMult, this.getReactor().meanHeatMult, this.getReactor().fuelComponentCount, this.getReactor().usefulPartCount, this.getReactor().totalEfficiency, this.getReactor().meanEfficiency, this.getReactor().sparsityEfficiencyMult, this.meanHeatingSpeedMultiplier, this.totalHeatingSpeedMultiplier);
    }

    @Override
    public void onPacket(FissionUpdatePacket message) {
        super.onPacket(message);
        if (message instanceof SaltFissionUpdatePacket) {
            SaltFissionUpdatePacket packet = (SaltFissionUpdatePacket)message;
            this.meanHeatingSpeedMultiplier = packet.meanHeatingSpeedMultiplier;
            this.totalHeatingSpeedMultiplier = packet.totalHeatingSpeedMultiplier;
        }
    }

    @Override
    public void clearAllMaterial() {
        super.clearAllMaterial();
        for (Tank tank : this.tanks) {
            tank.setFluidStored(null);
        }
    }
}

