/*
 * Decompiled with CFR 0.152.
 */
package nc.multiblock.fission.salt;

import nc.multiblock.fission.FissionPartBunch;
import nc.multiblock.fission.FissionReactor;
import nc.multiblock.fission.salt.tile.TileSaltFissionVessel;
import net.minecraft.util.EnumFacing;

public class SaltFissionVesselBunch
extends FissionPartBunch<TileSaltFissionVessel> {
    public long sources = 0L;
    public long flux = 0L;
    public boolean primed = false;
    public boolean statsRetrieved = false;
    protected long openFaces = 0L;

    public SaltFissionVesselBunch(FissionReactor reactor) {
        super(reactor);
    }

    @Override
    protected void init() {
        if (!this.initialized) {
            for (TileSaltFissionVessel vessel : this.partMap.values()) {
                int i = 6;
                for (EnumFacing dir : EnumFacing.field_82609_l) {
                    if (!this.partMap.containsKey(vessel.func_174877_v().func_177972_a(dir).func_177986_g())) continue;
                    --i;
                }
                this.openFaces += (long)i;
            }
        }
        this.initialized = true;
    }

    public long getBunchingFactor() {
        return 6L * (long)this.partMap.size() / this.openFaces;
    }

    public long getSurfaceFactor() {
        return this.openFaces / 6L;
    }

    public long getCriticalityFactor(int criticalityFactor) {
        return this.getSurfaceFactor() * (long)criticalityFactor;
    }

    public long getRawHeating() {
        long rawHeating = 0L;
        for (TileSaltFissionVessel vessel : this.partMap.values()) {
            if (!vessel.isProcessing) continue;
            rawHeating += (long)(vessel.baseProcessHeat * vessel.heatMult);
        }
        return this.getBunchingFactor() * rawHeating;
    }

    public long getRawHeatingIgnoreCoolingPenalty() {
        long rawHeatingIgnoreCoolingPenalty = 0L;
        for (TileSaltFissionVessel vessel : this.partMap.values()) {
            if (vessel.isProcessing) continue;
            rawHeatingIgnoreCoolingPenalty += (long)vessel.getDecayHeating();
        }
        return this.getBunchingFactor() * rawHeatingIgnoreCoolingPenalty;
    }

    public double getEffectiveHeating() {
        double effectiveHeating = 0.0;
        for (TileSaltFissionVessel vessel : this.partMap.values()) {
            if (!vessel.isProcessing) continue;
            effectiveHeating += (double)(vessel.baseProcessHeat * vessel.heatMult) * vessel.baseProcessEfficiency * vessel.getSourceEfficiency() * vessel.getModeratorEfficiencyFactor() * this.getFluxEfficiencyFactor(vessel.getFloatingPointCriticality());
        }
        return (double)this.getBunchingFactor() * effectiveHeating;
    }

    public double getEffectiveHeatingIgnoreCoolingPenalty() {
        double effectiveHeatingIgnoreCoolingPenalty = 0.0;
        for (TileSaltFissionVessel vessel : this.partMap.values()) {
            if (vessel.isProcessing) continue;
            effectiveHeatingIgnoreCoolingPenalty += vessel.getFloatingPointDecayHeating();
        }
        return (double)this.getBunchingFactor() * effectiveHeatingIgnoreCoolingPenalty;
    }

    public long getHeatMultiplier() {
        long rawHeatMult = 0L;
        for (TileSaltFissionVessel vessel : this.partMap.values()) {
            if (!vessel.isProcessing) continue;
            rawHeatMult += (long)vessel.heatMult;
        }
        return this.getBunchingFactor() * rawHeatMult;
    }

    public double getFluxEfficiencyFactor(double floatingPointCriticalityFactor) {
        return (1.0 + Math.exp(-2.0 * floatingPointCriticalityFactor)) / (1.0 + Math.exp(2.0 * ((double)this.flux / (double)this.getSurfaceFactor() - 2.0 * floatingPointCriticalityFactor)));
    }

    public double getEfficiency() {
        double efficiency = 0.0;
        for (TileSaltFissionVessel vessel : this.partMap.values()) {
            if (!vessel.isProcessing) continue;
            efficiency += (double)vessel.heatMult * vessel.baseProcessEfficiency * vessel.getSourceEfficiency() * vessel.getModeratorEfficiencyFactor() * this.getFluxEfficiencyFactor(vessel.getFloatingPointCriticality());
        }
        return (double)this.getBunchingFactor() * efficiency;
    }

    public double getEfficiencyIgnoreCoolingPenalty() {
        double efficiencyIgnoreCoolingPenalty = 0.0;
        for (TileSaltFissionVessel vessel : this.partMap.values()) {
            if (vessel.isProcessing) continue;
            efficiencyIgnoreCoolingPenalty += 1.0;
        }
        return (double)this.getBunchingFactor() * efficiencyIgnoreCoolingPenalty;
    }
}

