/*
 * Decompiled with CFR 0.152.
 */
package nc.multiblock.fission.salt.tile;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import nc.ModCheck;
import nc.capability.radiation.source.IRadiationSource;
import nc.config.NCConfig;
import nc.multiblock.cuboidal.CuboidalPartPositionType;
import nc.multiblock.fission.FissionCluster;
import nc.multiblock.fission.FissionReactor;
import nc.multiblock.fission.salt.SaltFissionVesselBunch;
import nc.multiblock.fission.tile.IFissionComponent;
import nc.multiblock.fission.tile.IFissionFluxSink;
import nc.multiblock.fission.tile.IFissionFuelComponent;
import nc.multiblock.fission.tile.TileFissionPart;
import nc.multiblock.fission.tile.port.IFissionPortTarget;
import nc.multiblock.fission.tile.port.TileFissionVesselPort;
import nc.network.multiblock.SaltFissionVesselUpdatePacket;
import nc.radiation.RadiationHelper;
import nc.recipe.AbstractRecipeHandler;
import nc.recipe.BasicRecipe;
import nc.recipe.NCRecipes;
import nc.recipe.RecipeInfo;
import nc.recipe.ingredient.IFluidIngredient;
import nc.tile.ITileGui;
import nc.tile.fluid.ITileFilteredFluid;
import nc.tile.fluid.ITileFluid;
import nc.tile.generator.IFluidGenerator;
import nc.tile.internal.fluid.FluidConnection;
import nc.tile.internal.fluid.FluidTileWrapper;
import nc.tile.internal.fluid.GasTileWrapper;
import nc.tile.internal.fluid.Tank;
import nc.tile.internal.fluid.TankOutputSetting;
import nc.tile.internal.fluid.TankSorption;
import nc.util.CapabilityHelper;
import nc.util.NCMath;
import nc.util.PosHelper;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;

public class TileSaltFissionVessel
extends TileFissionPart
implements ITileFilteredFluid,
ITileGui<SaltFissionVesselUpdatePacket>,
IFluidGenerator,
IFissionFuelComponent,
IFissionPortTarget<TileFissionVesselPort, TileSaltFissionVessel> {
    @Nonnull
    protected final List<Tank> tanks = Lists.newArrayList((Object[])new Tank[]{new Tank(1296, NCRecipes.salt_fission_valid_fluids.get(0)), new Tank(1296, new ArrayList<String>())});
    @Nonnull
    protected final List<Tank> filterTanks = Lists.newArrayList((Object[])new Tank[]{new Tank(1000, NCRecipes.salt_fission_valid_fluids.get(0)), new Tank(1000, new ArrayList<String>())});
    @Nonnull
    protected final List<Tank> consumedTanks = Lists.newArrayList((Object[])new Tank[]{new Tank(1296, new ArrayList<String>())});
    @Nonnull
    protected FluidConnection[] fluidConnections = ITileFluid.fluidConnectionAll(Lists.newArrayList((Object[])new TankSorption[]{TankSorption.NON, TankSorption.NON}));
    @Nonnull
    protected FluidTileWrapper[] fluidSides;
    @Nonnull
    protected GasTileWrapper gasWrapper;
    protected final int fluidInputSize = 1;
    protected final int fluidOutputSize = 1;
    public double baseProcessTime = 1.0;
    public double baseProcessEfficiency = 0.0;
    public double baseProcessDecayFactor = 0.0;
    public double baseProcessRadiation = 0.0;
    public int baseProcessHeat = 0;
    public int baseProcessCriticality = 1;
    protected boolean selfPriming = false;
    public double time;
    public boolean isProcessing;
    public boolean hasConsumed;
    public boolean canProcessInputs;
    public double decayProcessHeat = 0.0;
    public double decayHeatFraction = 0.0;
    public double iodineFraction = 0.0;
    public double poisonFraction = 0.0;
    protected RecipeInfo<BasicRecipe> recipeInfo;
    protected Set<EntityPlayer> playersToUpdate;
    protected FissionCluster cluster = null;
    protected long heat = 0L;
    public long clusterHeatStored;
    public long clusterHeatCapacity;
    protected boolean fluxSearched = false;
    protected int flux = 0;
    public int heatMult = 0;
    protected double undercoolingLifetimeFactor = 1.0;
    protected Double sourceEfficiency = null;
    protected int[] moderatorLineFluxes = new int[]{0, 0, 0, 0, 0, 0};
    protected Double[] moderatorLineEfficiencies = new Double[]{null, null, null, null, null, null};
    protected IFissionFluxSink[] adjacentFluxSinks = new IFissionFluxSink[]{null, null, null, null, null, null};
    protected final LongSet[] passiveModeratorCaches = new LongSet[]{new LongOpenHashSet(), new LongOpenHashSet(), new LongOpenHashSet(), new LongOpenHashSet(), new LongOpenHashSet(), new LongOpenHashSet()};
    protected final LongSet[] activeModeratorCaches = new LongSet[]{new LongOpenHashSet(), new LongOpenHashSet(), new LongOpenHashSet(), new LongOpenHashSet(), new LongOpenHashSet(), new LongOpenHashSet()};
    protected final IFissionFuelComponent.ModeratorLine[] moderatorLineCaches = new IFissionFuelComponent.ModeratorLine[]{null, null, null, null, null, null};
    protected final LongSet[] passiveReflectorModeratorCaches = new LongSet[]{new LongOpenHashSet(), new LongOpenHashSet(), new LongOpenHashSet(), new LongOpenHashSet(), new LongOpenHashSet(), new LongOpenHashSet()};
    protected final LongSet[] activeReflectorModeratorCaches = new LongSet[]{new LongOpenHashSet(), new LongOpenHashSet(), new LongOpenHashSet(), new LongOpenHashSet(), new LongOpenHashSet(), new LongOpenHashSet()};
    protected final LongSet activeReflectorCache = new LongOpenHashSet();
    protected BlockPos masterPortPos = PosHelper.DEFAULT_NON;
    protected TileFissionVesselPort masterPort = null;
    protected SaltFissionVesselBunch vesselBunch = null;

    public TileSaltFissionVessel() {
        super(CuboidalPartPositionType.INTERIOR);
        this.fluidSides = ITileFluid.getDefaultFluidSides(this);
        this.gasWrapper = new GasTileWrapper(this);
        this.playersToUpdate = new ObjectOpenHashSet();
    }

    @Override
    public void onMachineAssembled(FissionReactor controller) {
        this.doStandardNullControllerResponse(controller);
        super.onMachineAssembled(controller);
    }

    @Override
    public void onMachineBroken() {
        super.onMachineBroken();
    }

    @Nullable
    public SaltFissionVesselBunch getVesselBunch() {
        return this.vesselBunch;
    }

    public void setVesselBunch(@Nullable SaltFissionVesselBunch vesselBunch) {
        this.vesselBunch = vesselBunch;
        if (vesselBunch != null) {
            vesselBunch.getPartMap().put(this.field_174879_c.func_177986_g(), (Object)this);
        }
    }

    public int getVesselBunchSize() {
        return this.vesselBunch.getPartMap().size();
    }

    @Override
    @Nullable
    public FissionCluster getCluster() {
        return this.cluster;
    }

    @Override
    public void setClusterInternal(@Nullable FissionCluster cluster) {
        this.cluster = cluster;
    }

    @Override
    public boolean isValidHeatConductor(Long2ObjectMap<IFissionComponent> componentFailCache, Long2ObjectMap<IFissionComponent> assumedValidCache) {
        return this.isProcessing || this.getDecayHeating() > 0;
    }

    @Override
    public boolean isFunctional() {
        return this.isProcessing || this.getDecayHeating() > 0;
    }

    @Override
    public void resetStats() {
        this.vesselBunch.flux = 0L;
        this.vesselBunch.sources = 0L;
        this.fluxSearched = false;
        this.heatMult = 0;
        this.flux = 0;
        this.undercoolingLifetimeFactor = 1.0;
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            this.moderatorLineFluxes[dir.func_176745_a()] = 0;
            this.moderatorLineEfficiencies[dir.func_176745_a()] = null;
            this.adjacentFluxSinks[dir.func_176745_a()] = null;
            this.passiveModeratorCaches[dir.func_176745_a()].clear();
            this.activeModeratorCaches[dir.func_176745_a()].clear();
            this.moderatorLineCaches[dir.func_176745_a()] = null;
            this.passiveReflectorModeratorCaches[dir.func_176745_a()].clear();
            this.activeReflectorModeratorCaches[dir.func_176745_a()].clear();
        }
        this.activeReflectorCache.clear();
        this.refreshRecipe();
        this.refreshActivity();
        this.refreshIsProcessing(true);
    }

    @Override
    public boolean isClusterRoot() {
        return true;
    }

    @Override
    public void clusterSearch(Integer id, Object2IntMap<IFissionComponent> clusterSearchCache, Long2ObjectMap<IFissionComponent> componentFailCache, Long2ObjectMap<IFissionComponent> assumedValidCache) {
        this.refreshRecipe();
        this.refreshActivity();
        this.refreshIsProcessing(false);
        IFissionFuelComponent.super.clusterSearch(id, clusterSearchCache, componentFailCache, assumedValidCache);
    }

    @Override
    public void tryPriming(FissionReactor sourceReactor, boolean fromSource) {
        if (this.getMultiblock() != sourceReactor) {
            return;
        }
        if (this.canProcessInputs) {
            if (fromSource) {
                ++this.vesselBunch.sources;
                if (this.vesselBunch.sources >= this.vesselBunch.getSurfaceFactor()) {
                    this.vesselBunch.primed = true;
                }
            } else {
                this.vesselBunch.primed = true;
            }
        }
    }

    @Override
    public boolean isPrimed() {
        return this.vesselBunch.primed;
    }

    @Override
    public void addToPrimedCache(ObjectSet<IFissionFuelComponent> primedCache) {
        for (TileSaltFissionVessel vessel : this.vesselBunch.getPartMap().values()) {
            primedCache.add((Object)vessel);
        }
    }

    @Override
    public void unprime() {
        this.vesselBunch.primed = false;
    }

    @Override
    public boolean isAcceptingFlux(EnumFacing side) {
        return this.canProcessInputs;
    }

    @Override
    public void refreshIsProcessing(boolean checkCluster) {
        this.isProcessing = this.isProcessing(checkCluster);
        this.hasConsumed = this.hasConsumed();
    }

    @Override
    public boolean isFluxSearched() {
        return this.fluxSearched;
    }

    @Override
    public void setFluxSearched(boolean fluxSearched) {
        this.fluxSearched = fluxSearched;
    }

    @Override
    public void incrementHeatMultiplier() {
        ++this.heatMult;
    }

    @Override
    public double getSourceEfficiency() {
        return this.sourceEfficiency == null ? 1.0 : this.sourceEfficiency;
    }

    @Override
    public void setSourceEfficiency(double sourceEfficiency, boolean maximize) {
        this.sourceEfficiency = this.sourceEfficiency != null && maximize ? Math.max(this.sourceEfficiency, sourceEfficiency) : sourceEfficiency;
    }

    @Override
    public void addFlux(int flux) {
        this.flux += flux;
        this.vesselBunch.flux += (long)flux;
    }

    @Override
    public int[] getModeratorLineFluxes() {
        return this.moderatorLineFluxes;
    }

    @Override
    public Double[] getModeratorLineEfficiencies() {
        return this.moderatorLineEfficiencies;
    }

    @Override
    public IFissionFluxSink[] getAdjacentFluxSinks() {
        return this.adjacentFluxSinks;
    }

    @Override
    public LongSet[] getPassiveModeratorCaches() {
        return this.passiveModeratorCaches;
    }

    @Override
    public LongSet[] getActiveModeratorCaches() {
        return this.activeModeratorCaches;
    }

    @Override
    public IFissionFuelComponent.ModeratorLine[] getModeratorLineCaches() {
        return this.moderatorLineCaches;
    }

    @Override
    public LongSet[] getPassiveReflectorModeratorCaches() {
        return this.passiveReflectorModeratorCaches;
    }

    @Override
    public LongSet[] getActiveReflectorModeratorCaches() {
        return this.activeReflectorModeratorCaches;
    }

    @Override
    public LongSet getActiveReflectorCache() {
        return this.activeReflectorCache;
    }

    @Override
    public long getRawHeating() {
        return this.isProcessing ? (long)this.baseProcessHeat * this.vesselBunch.getHeatMultiplier() / (long)this.getVesselBunchSize() : 0L;
    }

    @Override
    public long getRawHeatingIgnoreCoolingPenalty() {
        return this.isProcessing ? 0L : (long)this.getDecayHeating();
    }

    @Override
    public double getEffectiveHeating() {
        return this.isProcessing ? (double)this.baseProcessHeat * this.getEfficiency() : 0.0;
    }

    @Override
    public double getEffectiveHeatingIgnoreCoolingPenalty() {
        return this.isProcessing ? 0.0 : this.getFloatingPointDecayHeating();
    }

    @Override
    public long getHeatMultiplier() {
        return this.vesselBunch.getHeatMultiplier() / (long)this.getVesselBunchSize();
    }

    @Override
    public double getFluxEfficiencyFactor() {
        return this.vesselBunch.getFluxEfficiencyFactor(this.getFloatingPointCriticality());
    }

    @Override
    public double getEfficiency() {
        return this.isProcessing ? (double)this.vesselBunch.getHeatMultiplier() * this.baseProcessEfficiency * this.getSourceEfficiency() * this.getModeratorEfficiencyFactor() * this.getFluxEfficiencyFactor() / (double)this.getVesselBunchSize() : 0.0;
    }

    @Override
    public double getEfficiencyIgnoreCoolingPenalty() {
        return this.isProcessing ? 0.0 : 1.0;
    }

    @Override
    public void setUndercoolingLifetimeFactor(double undercoolingLifetimeFactor) {
        this.undercoolingLifetimeFactor = undercoolingLifetimeFactor;
    }

    @Override
    public int getCriticality() {
        return NCMath.toInt(this.getFloatingPointCriticality());
    }

    @Override
    public double getFloatingPointCriticality() {
        return (double)this.baseProcessCriticality * (1.0 - this.baseProcessDecayFactor + this.poisonFraction);
    }

    @Override
    public boolean isSelfPriming() {
        return this.selfPriming;
    }

    @Override
    public void defaultRefreshModerators(Long2ObjectMap<IFissionComponent> componentFailCache, Long2ObjectMap<IFissionComponent> assumedValidCache) {
        if (this.isProcessing) {
            this.defaultRefreshAdjacentActiveModerators(componentFailCache, assumedValidCache);
        } else if (this.getDecayHeating() > 0) {
            this.defaultForceAdjacentActiveModerators(componentFailCache, assumedValidCache);
        }
    }

    @Override
    public void onClusterMeltdown(Iterator<IFissionComponent> componentIterator) {
        IRadiationSource chunkSource = RadiationHelper.getRadiationSource((ICapabilityProvider)this.field_145850_b.func_175726_f(this.field_174879_c));
        if (chunkSource != null) {
            RadiationHelper.addToSourceRadiation(chunkSource, 8.0 * this.baseProcessRadiation * this.getSpeedMultiplier() * NCConfig.fission_meltdown_radiation_multiplier);
        }
        componentIterator.remove();
        this.field_145850_b.func_175713_t(this.field_174879_c);
        IBlockState corium = FluidRegistry.getFluid((String)"corium").getBlock().func_176223_P();
        this.field_145850_b.func_175656_a(this.field_174879_c, corium);
        if (this.getMultiblock() != null) {
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                BlockPos offPos = this.field_174879_c.func_177972_a(dir);
                if (!(((FissionReactor)this.getMultiblock()).rand.nextDouble() < 0.75)) continue;
                this.field_145850_b.func_175713_t(offPos);
                this.field_145850_b.func_175656_a(offPos, corium);
            }
        }
    }

    @Override
    public long getHeatStored() {
        return this.heat;
    }

    @Override
    public void setHeatStored(long heat) {
        this.heat = heat;
    }

    @Override
    public BlockPos getMasterPortPos() {
        return this.masterPortPos;
    }

    @Override
    public void setMasterPortPos(BlockPos pos) {
        this.masterPortPos = pos;
    }

    @Override
    public void clearMasterPort() {
        this.masterPort = null;
        this.masterPortPos = PosHelper.DEFAULT_NON;
    }

    @Override
    public void refreshMasterPort() {
        TileFissionVesselPort tileFissionVesselPort = this.masterPort = this.getMultiblock() == null ? null : (TileFissionVesselPort)((FissionReactor)this.getMultiblock()).getPartMap(TileFissionVesselPort.class).get(this.masterPortPos.func_177986_g());
        if (this.masterPort == null) {
            this.masterPortPos = PosHelper.DEFAULT_NON;
        }
    }

    @Override
    public boolean onPortRefresh() {
        this.refreshRecipe();
        this.refreshActivity();
        this.refreshIsProcessing(true);
        return this.isMultiblockAssembled() && ((FissionReactor)this.getMultiblock()).isReactorOn && !this.isProcessing && this.isProcessing(false);
    }

    @Override
    public void onLoad() {
        super.onLoad();
        if (!this.field_145850_b.field_72995_K) {
            this.refreshMasterPort();
            this.refreshRecipe();
            this.refreshActivity();
            this.refreshIsProcessing(true);
        }
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            boolean shouldUpdate;
            boolean wasProcessing = this.isProcessing;
            this.isProcessing = this.isProcessing(true);
            boolean shouldRefresh = this.isMultiblockAssembled() && ((FissionReactor)this.getMultiblock()).isReactorOn && !this.isProcessing && this.isProcessing(false);
            boolean bl = shouldUpdate = wasProcessing != this.isProcessing;
            if (this.isProcessing) {
                this.process();
            } else {
                this.getRadiationSource().setRadiationLevel(0.0);
            }
            this.updateDecayFractions();
            if (shouldRefresh) {
                ((FissionReactor)this.getMultiblock()).refreshFlag = true;
            }
            this.sendUpdateToListeningPlayers();
            if (shouldUpdate) {
                this.func_70296_d();
            }
        }
    }

    public void updateDecayFractions() {
        if (!NCConfig.fission_decay_mechanics) {
            this.poisonFraction = 0.0;
            this.iodineFraction = 0.0;
            this.decayHeatFraction = 0.0;
            return;
        }
        int oldCriticality = this.getCriticality();
        boolean oldHasEnoughFlux = this.hasEnoughFlux();
        int oldDecayHeating = this.getDecayHeating();
        boolean decayHeatReduce = true;
        boolean iodineReduce = true;
        boolean poisonReduce = true;
        double decayHeatEquilibrium = NCConfig.fission_decay_equilibrium_factors[0] * this.baseProcessDecayFactor;
        double iodineEquilibrium = NCConfig.fission_decay_equilibrium_factors[1] * this.baseProcessDecayFactor;
        double poisonEquilibrium = NCConfig.fission_decay_equilibrium_factors[2] * this.baseProcessDecayFactor;
        if (this.isProcessing) {
            if (this.decayHeatFraction <= decayHeatEquilibrium) {
                this.decayHeatFraction = MathHelper.func_151237_a((double)(this.decayHeatFraction + (NCConfig.fission_decay_term_multipliers[0] * (decayHeatEquilibrium - this.decayHeatFraction) + NCConfig.fission_decay_term_multipliers[1] * decayHeatEquilibrium) / NCConfig.fission_decay_build_up_times[0]), (double)0.0, (double)decayHeatEquilibrium);
                decayHeatReduce = false;
            }
            if (this.iodineFraction <= iodineEquilibrium) {
                this.iodineFraction = MathHelper.func_151237_a((double)(this.iodineFraction + (NCConfig.fission_decay_term_multipliers[0] * (iodineEquilibrium - this.iodineFraction) + NCConfig.fission_decay_term_multipliers[1] * iodineEquilibrium) / NCConfig.fission_decay_build_up_times[1]), (double)0.0, (double)iodineEquilibrium);
                iodineReduce = false;
            }
            if (this.poisonFraction <= poisonEquilibrium) {
                this.poisonFraction = MathHelper.func_151237_a((double)(this.poisonFraction + (NCConfig.fission_decay_term_multipliers[0] * (poisonEquilibrium - this.poisonFraction) + NCConfig.fission_decay_term_multipliers[1] * poisonEquilibrium) / NCConfig.fission_decay_build_up_times[2]), (double)0.0, (double)poisonEquilibrium);
                poisonReduce = false;
            }
        }
        double decayHeatFractionReduction = 0.0;
        if (decayHeatReduce) {
            decayHeatFractionReduction = Math.min(this.decayHeatFraction, (NCConfig.fission_decay_term_multipliers[0] * this.decayHeatFraction + NCConfig.fission_decay_term_multipliers[1] * decayHeatEquilibrium) / NCConfig.fission_decay_lifetimes[0]);
            this.decayHeatFraction = Math.max(0.0, this.decayHeatFraction - decayHeatFractionReduction);
        }
        double poisonParentFractionReduction = 0.0;
        if (iodineReduce) {
            poisonParentFractionReduction = Math.min(this.iodineFraction, (NCConfig.fission_decay_term_multipliers[0] * this.iodineFraction + NCConfig.fission_decay_term_multipliers[1] * iodineEquilibrium) / NCConfig.fission_decay_lifetimes[1]);
            this.iodineFraction = Math.max(0.0, this.iodineFraction - poisonParentFractionReduction + NCConfig.fission_decay_daughter_multipliers[0] * decayHeatFractionReduction);
        }
        double poisonFractionReduction = 0.0;
        if (poisonReduce) {
            poisonFractionReduction = Math.min(this.poisonFraction, (NCConfig.fission_decay_term_multipliers[0] * this.poisonFraction + NCConfig.fission_decay_term_multipliers[1] * poisonEquilibrium) / NCConfig.fission_decay_lifetimes[2]);
            this.poisonFraction = Math.max(0.0, this.poisonFraction - poisonFractionReduction + NCConfig.fission_decay_daughter_multipliers[1] * poisonParentFractionReduction);
        }
        boolean refreshReactor = false;
        boolean refreshCluster = false;
        if (oldCriticality != this.getCriticality()) {
            if (this.isProcessing) {
                if (oldHasEnoughFlux && !this.hasEnoughFlux()) {
                    refreshReactor = true;
                } else {
                    refreshCluster = true;
                }
            } else if (oldCriticality > this.baseProcessCriticality && this.getCriticality() <= this.baseProcessCriticality) {
                refreshReactor = true;
            }
        }
        if (!this.isProcessing && oldDecayHeating != this.getDecayHeating()) {
            if (this.getDecayHeating() == 0) {
                refreshReactor = true;
            } else {
                refreshCluster = true;
            }
        }
        if (refreshReactor) {
            ((FissionReactor)this.getMultiblock()).refreshFlag = true;
        } else if (refreshCluster) {
            ((FissionReactor)this.getMultiblock()).addClusterToRefresh(this.cluster);
        }
    }

    public int getDecayHeating() {
        return NCMath.toInt(this.getFloatingPointDecayHeating());
    }

    public double getFloatingPointDecayHeating() {
        return this.decayProcessHeat * this.decayHeatFraction;
    }

    @Override
    public void refreshRecipe() {
        this.recipeInfo = NCRecipes.salt_fission.getRecipeInfoFromInputs(new ArrayList<ItemStack>(), this.getFluidInputs(this.hasConsumed));
        this.consumeInputs();
    }

    @Override
    public void refreshActivity() {
        boolean wasReady = this.readyToProcess(false);
        this.canProcessInputs = this.canProcessInputs();
        if (this.getMultiblock() != null && !wasReady && this.readyToProcess(false)) {
            ((FissionReactor)this.getMultiblock()).refreshFlag = true;
        }
    }

    @Override
    public void refreshActivityOnProduction() {
        this.canProcessInputs = this.canProcessInputs();
    }

    public double getSpeedMultiplier() {
        return 1.0 / this.undercoolingLifetimeFactor;
    }

    public boolean setRecipeStats() {
        if (this.recipeInfo == null) {
            this.baseProcessTime = 1.0;
            this.baseProcessHeat = 0;
            this.baseProcessEfficiency = 0.0;
            this.baseProcessCriticality = 1;
            this.selfPriming = false;
            this.baseProcessRadiation = 0.0;
            return false;
        }
        this.baseProcessTime = this.recipeInfo.getRecipe().getSaltFissionFuelTime();
        this.baseProcessHeat = this.recipeInfo.getRecipe().getFissionFuelHeat();
        this.decayProcessHeat = this.baseProcessHeat;
        this.baseProcessEfficiency = this.recipeInfo.getRecipe().getFissionFuelEfficiency();
        this.baseProcessCriticality = this.recipeInfo.getRecipe().getFissionFuelCriticality();
        this.baseProcessDecayFactor = this.recipeInfo.getRecipe().getFissionFuelDecayFactor();
        this.selfPriming = this.recipeInfo.getRecipe().getFissionFuelSelfPriming();
        this.baseProcessRadiation = this.recipeInfo.getRecipe().getFissionFuelRadiation();
        return true;
    }

    public boolean isProcessing(boolean checkCluster) {
        return this.readyToProcess(checkCluster) && this.hasEnoughFlux();
    }

    public boolean readyToProcess(boolean checkCluster) {
        return this.canProcessInputs && this.hasConsumed && this.isMultiblockAssembled() && (!checkCluster || this.cluster != null);
    }

    public boolean hasEnoughFlux() {
        return this.vesselBunch != null && this.vesselBunch.flux >= this.vesselBunch.getCriticalityFactor(this.getCriticality());
    }

    public boolean hasConsumed() {
        if (this.field_145850_b.field_72995_K) {
            return this.hasConsumed;
        }
        for (int i = 0; i < 1; ++i) {
            if (this.consumedTanks.get(i).isEmpty()) continue;
            return true;
        }
        return false;
    }

    public boolean canProcessInputs() {
        boolean canProcess;
        boolean validRecipe = this.setRecipeStats();
        boolean bl = canProcess = validRecipe && this.canProduceProducts();
        if (this.hasConsumed && !validRecipe) {
            for (Tank tank : this.getFluidInputs(true)) {
                tank.setFluidStored(null);
            }
            this.hasConsumed = false;
        }
        if (!canProcess) {
            this.time = MathHelper.func_151237_a((double)this.time, (double)0.0, (double)(this.baseProcessTime - 1.0));
        }
        return canProcess;
    }

    public boolean canProduceProducts() {
        for (int j = 0; j < 1; ++j) {
            IFluidIngredient fluidProduct = this.getFluidProducts().get(j);
            if (fluidProduct.getMaxStackSize(0) <= 0) continue;
            if (fluidProduct.getStack() == null) {
                return false;
            }
            if (this.getTanks().get(j + 1).isEmpty()) continue;
            if (!this.getTanks().get(j + 1).getFluid().isFluidEqual((FluidStack)fluidProduct.getStack())) {
                return false;
            }
            if (this.getTanks().get(j + 1).getFluidAmount() + fluidProduct.getMaxStackSize(0) <= this.getTanks().get(j + 1).getCapacity()) continue;
            return false;
        }
        return true;
    }

    public void consumeInputs() {
        int i;
        if (this.hasConsumed || this.recipeInfo == null) {
            return;
        }
        IntList fluidInputOrder = this.recipeInfo.getFluidInputOrder();
        if (fluidInputOrder == AbstractRecipeHandler.INVALID) {
            return;
        }
        for (i = 0; i < 1; ++i) {
            if (this.consumedTanks.get(i).isEmpty()) continue;
            this.consumedTanks.get(i).setFluid(null);
        }
        for (i = 0; i < 1; ++i) {
            int maxStackSize = this.getFluidIngredients().get((Integer)fluidInputOrder.get(i)).getMaxStackSize((Integer)this.recipeInfo.getFluidIngredientNumbers().get(i));
            if (maxStackSize > 0) {
                this.consumedTanks.get(i).setFluidStored(new FluidStack(this.getTanks().get(i).getFluid(), maxStackSize));
                this.getTanks().get(i).changeFluidAmount(-maxStackSize);
            }
            if (!this.getTanks().get(i).isEmpty()) continue;
            this.getTanks().get(i).setFluid(null);
        }
        this.hasConsumed = true;
    }

    public void process() {
        this.time += this.getSpeedMultiplier();
        this.getRadiationSource().setRadiationLevel(this.baseProcessRadiation * this.getSpeedMultiplier());
        while (this.time >= this.baseProcessTime) {
            this.finishProcess();
        }
    }

    public void finishProcess() {
        double oldProcessTime = this.baseProcessTime;
        double oldProcessEfficiency = this.baseProcessEfficiency;
        double oldProcessDecayFactor = this.baseProcessDecayFactor;
        int oldProcessHeat = this.baseProcessHeat;
        int oldCriticality = this.getCriticality();
        this.produceProducts();
        this.refreshRecipe();
        this.time = Math.max(0.0, this.time - oldProcessTime);
        this.refreshActivityOnProduction();
        if (!this.canProcessInputs) {
            this.time = 0.0;
        }
        if (this.getMultiblock() != null) {
            if (this.canProcessInputs) {
                if (oldProcessHeat != this.baseProcessHeat || oldProcessEfficiency != this.baseProcessEfficiency || oldProcessDecayFactor != this.baseProcessDecayFactor || oldCriticality != this.getCriticality()) {
                    if (!this.hasEnoughFlux()) {
                        ((FissionReactor)this.getMultiblock()).refreshFlag = true;
                    } else {
                        ((FissionReactor)this.getMultiblock()).addClusterToRefresh(this.cluster);
                    }
                }
            } else {
                this.sourceEfficiency = null;
                ((FissionReactor)this.getMultiblock()).refreshFlag = true;
            }
        }
    }

    public void produceProducts() {
        for (int i = 0; i < 1; ++i) {
            this.consumedTanks.get(i).setFluid(null);
        }
        if (!this.hasConsumed || this.recipeInfo == null) {
            return;
        }
        for (int j = 0; j < 1; ++j) {
            IFluidIngredient fluidProduct = this.getFluidProducts().get(j);
            if (fluidProduct.getNextStackSize(0) <= 0) continue;
            if (this.getTanks().get(j + 1).isEmpty()) {
                this.getTanks().get(j + 1).setFluidStored(fluidProduct.getNextStack(0));
                continue;
            }
            if (!this.getTanks().get(j + 1).getFluid().isFluidEqual((FluidStack)fluidProduct.getStack())) continue;
            this.getTanks().get(j + 1).changeFluidAmount(fluidProduct.getNextStackSize(0));
        }
        this.hasConsumed = false;
    }

    @Override
    public int getFluidInputSize() {
        return 1;
    }

    @Override
    public int getFluidOutputputSize() {
        return 1;
    }

    @Override
    public int getOtherSlotsSize() {
        return 0;
    }

    @Override
    public List<Tank> getFluidInputs(boolean consumed) {
        return consumed ? this.consumedTanks : this.getTanks().subList(0, 1);
    }

    @Override
    public List<IFluidIngredient> getFluidIngredients() {
        return this.recipeInfo.getRecipe().getFluidIngredients();
    }

    @Override
    public List<IFluidIngredient> getFluidProducts() {
        return this.recipeInfo.getRecipe().getFluidProducts();
    }

    @Override
    @Nonnull
    public List<Tank> getTanks() {
        return !PosHelper.DEFAULT_NON.equals((Object)this.masterPortPos) ? this.masterPort.getTanks() : this.tanks;
    }

    @Override
    @Nonnull
    public FluidConnection[] getFluidConnections() {
        return this.fluidConnections;
    }

    @Override
    public void setFluidConnections(@Nonnull FluidConnection[] connections) {
        this.fluidConnections = connections;
    }

    @Override
    @Nonnull
    public FluidTileWrapper[] getFluidSides() {
        return !PosHelper.DEFAULT_NON.equals((Object)this.masterPortPos) ? this.masterPort.getFluidSides() : this.fluidSides;
    }

    @Override
    @Nonnull
    public GasTileWrapper getGasWrapper() {
        return !PosHelper.DEFAULT_NON.equals((Object)this.masterPortPos) ? this.masterPort.getGasWrapper() : this.gasWrapper;
    }

    @Override
    public boolean getInputTanksSeparated() {
        return false;
    }

    @Override
    public void setInputTanksSeparated(boolean separated) {
    }

    @Override
    public boolean getVoidUnusableFluidInput(int tankNumber) {
        return false;
    }

    @Override
    public void setVoidUnusableFluidInput(int tankNumber, boolean voidUnusableFluidInput) {
    }

    @Override
    public TankOutputSetting getTankOutputSetting(int tankNumber) {
        return TankOutputSetting.DEFAULT;
    }

    @Override
    public void setTankOutputSetting(int tankNumber, TankOutputSetting setting) {
    }

    @Override
    public boolean hasConfigurableFluidConnections() {
        return false;
    }

    @Override
    public void clearAllTanks() {
        IFluidGenerator.super.clearAllTanks();
        for (Tank tank : this.consumedTanks) {
            tank.setFluidStored(null);
        }
        this.hasConsumed = false;
        this.refreshRecipe();
        this.refreshActivity();
        this.refreshIsProcessing(true);
    }

    @Override
    @Nonnull
    public List<Tank> getTanksInternal() {
        return this.tanks;
    }

    @Override
    @Nonnull
    public List<Tank> getFilterTanks() {
        return !PosHelper.DEFAULT_NON.equals((Object)this.masterPortPos) ? this.masterPort.getFilterTanks() : this.filterTanks;
    }

    @Override
    public boolean canModifyFilter(int tank) {
        return this.getMultiblock() != null ? !((FissionReactor)this.getMultiblock()).isAssembled() : true;
    }

    @Override
    public void onFilterChanged(int slot) {
        this.func_70296_d();
    }

    @Override
    public Object getFilterKey() {
        return this.getFilterTanks().get(0).getFluidName();
    }

    @Override
    public int getGuiID() {
        return 202;
    }

    @Override
    public Set<EntityPlayer> getPlayersToUpdate() {
        return this.playersToUpdate;
    }

    @Override
    public SaltFissionVesselUpdatePacket getGuiUpdatePacket() {
        return new SaltFissionVesselUpdatePacket(this.field_174879_c, this.masterPortPos, this.getTanks(), this.getFilterTanks(), this.cluster, this.isProcessing, this.time, this.baseProcessTime);
    }

    @Override
    public void onGuiPacket(SaltFissionVesselUpdatePacket message) {
        int i;
        this.masterPortPos = message.masterPortPos;
        if (PosHelper.DEFAULT_NON.equals((Object)this.masterPortPos) ^ this.masterPort == null) {
            this.refreshMasterPort();
        }
        for (i = 0; i < this.getTanks().size(); ++i) {
            this.getTanks().get(i).readInfo(message.tanksInfo.get(i));
        }
        for (i = 0; i < this.getFilterTanks().size(); ++i) {
            this.getFilterTanks().get(i).readInfo(message.filterTanksInfo.get(i));
        }
        this.clusterHeatStored = message.clusterHeatStored;
        this.clusterHeatCapacity = message.clusterHeatCapacity;
        this.isProcessing = message.isProcessing;
        this.time = message.time;
        this.baseProcessTime = message.baseProcessTime;
    }

    @Override
    public NBTTagCompound writeAll(NBTTagCompound nbt) {
        super.writeAll(nbt);
        this.writeTanks(nbt);
        nbt.func_74780_a("baseProcessTime", this.baseProcessTime);
        nbt.func_74768_a("baseProcessHeat", this.baseProcessHeat);
        nbt.func_74780_a("baseProcessEfficiency", this.baseProcessEfficiency);
        nbt.func_74768_a("baseProcessCriticality", this.baseProcessCriticality);
        nbt.func_74780_a("baseProcessDecayFactor", this.baseProcessDecayFactor);
        nbt.func_74757_a("selfPriming", this.selfPriming);
        nbt.func_74780_a("time", this.time);
        nbt.func_74757_a("isProcessing", this.isProcessing);
        nbt.func_74757_a("hasConsumed", this.hasConsumed);
        nbt.func_74757_a("canProcessInputs", this.canProcessInputs);
        nbt.func_74780_a("decayProcessHeat", this.decayProcessHeat);
        nbt.func_74780_a("decayHeatFraction", this.decayHeatFraction);
        nbt.func_74780_a("iodineFraction", this.iodineFraction);
        nbt.func_74780_a("poisonFraction", this.poisonFraction);
        nbt.func_74768_a("flux", this.flux);
        nbt.func_74772_a("clusterHeat", this.heat);
        return nbt;
    }

    @Override
    public void readAll(NBTTagCompound nbt) {
        super.readAll(nbt);
        this.readTanks(nbt);
        this.baseProcessTime = nbt.func_74769_h("baseProcessTime");
        this.baseProcessHeat = nbt.func_74762_e("baseProcessHeat");
        this.baseProcessEfficiency = nbt.func_74769_h("baseProcessEfficiency");
        this.baseProcessCriticality = nbt.func_74762_e("baseProcessCriticality");
        this.baseProcessDecayFactor = nbt.func_74769_h("baseProcessDecayFactor");
        this.selfPriming = nbt.func_74767_n("selfPriming");
        this.time = nbt.func_74769_h("time");
        this.isProcessing = nbt.func_74767_n("isProcessing");
        this.hasConsumed = nbt.func_74767_n("hasConsumed");
        this.canProcessInputs = nbt.func_74767_n("canProcessInputs");
        this.decayProcessHeat = nbt.func_74769_h("decayProcessHeat");
        this.decayHeatFraction = nbt.func_74769_h("decayHeatFraction");
        this.iodineFraction = nbt.func_74769_h("iodineFraction");
        this.poisonFraction = nbt.func_74769_h("poisonFraction");
        this.flux = nbt.func_74762_e("flux");
        this.heat = nbt.func_74763_f("clusterHeat");
    }

    @Override
    public NBTTagCompound writeTanks(NBTTagCompound nbt) {
        int i;
        for (i = 0; i < this.tanks.size(); ++i) {
            this.tanks.get(i).writeToNBT(nbt, "tanks" + i);
        }
        for (i = 0; i < this.filterTanks.size(); ++i) {
            this.filterTanks.get(i).writeToNBT(nbt, "filterTanks" + i);
        }
        for (i = 0; i < this.consumedTanks.size(); ++i) {
            this.consumedTanks.get(i).writeToNBT(nbt, "consumedTanks" + i);
        }
        return nbt;
    }

    @Override
    public void readTanks(NBTTagCompound nbt) {
        int i;
        for (i = 0; i < this.tanks.size(); ++i) {
            this.tanks.get(i).readFromNBT(nbt, "tanks" + i);
        }
        for (i = 0; i < this.filterTanks.size(); ++i) {
            this.filterTanks.get(i).readFromNBT(nbt, "filterTanks" + i);
        }
        for (i = 0; i < this.consumedTanks.size(); ++i) {
            this.consumedTanks.get(i).readFromNBT(nbt, "consumedTanks" + i);
        }
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing side) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || ModCheck.mekanismLoaded() && NCConfig.enable_mek_gas && capability == CapabilityHelper.GAS_HANDLER_CAPABILITY) {
            return !this.getTanks().isEmpty() && this.hasFluidSideCapability(side);
        }
        return super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing side) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            if (!this.getTanks().isEmpty() && this.hasFluidSideCapability(side)) {
                return (T)this.getFluidSide(this.nonNullSide(side));
            }
            return null;
        }
        if (ModCheck.mekanismLoaded() && capability == CapabilityHelper.GAS_HANDLER_CAPABILITY) {
            if (NCConfig.enable_mek_gas && !this.getTanks().isEmpty() && this.hasFluidSideCapability(side)) {
                return (T)this.getGasWrapper();
            }
            return null;
        }
        return super.getCapability(capability, side);
    }
}

