/*
 * Decompiled with CFR 0.152.
 */
package nc.multiblock.fission.solid;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import nc.config.NCConfig;
import nc.multiblock.fission.FissionCluster;
import nc.multiblock.fission.FissionReactorLogic;
import nc.multiblock.fission.salt.tile.TileSaltFissionHeater;
import nc.multiblock.fission.salt.tile.TileSaltFissionVessel;
import nc.multiblock.fission.solid.tile.TileSolidFissionCell;
import nc.multiblock.fission.tile.IFissionComponent;
import nc.multiblock.fission.tile.IFissionFuelComponent;
import nc.multiblock.fission.tile.IFissionPart;
import nc.multiblock.fission.tile.port.TileFissionCellPort;
import nc.multiblock.tile.TileBeefAbstract;
import nc.network.multiblock.FissionUpdatePacket;
import nc.network.multiblock.SolidFissionUpdatePacket;
import nc.recipe.BasicRecipe;
import nc.recipe.NCRecipes;
import nc.recipe.RecipeInfo;
import nc.recipe.ingredient.IFluidIngredient;
import nc.tile.internal.fluid.Tank;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;

public class SolidFuelFissionLogic
extends FissionReactorLogic {
    public List<Tank> tanks = Lists.newArrayList((Object[])new Tank[]{new Tank(4000, NCRecipes.fission_heating_valid_fluids.get(0)), new Tank(4000, null)});
    public RecipeInfo<BasicRecipe> heatingRecipeInfo;
    public int heatingOutputRate = 0;
    public double effectiveHeating = 0.0;
    public double reservedEffectiveHeat = 0.0;
    public double heatingRecipeRate = 0.0;
    public double heatingOutputRateFP = 0.0;
    public static final List<Pair<Class<? extends IFissionPart>, String>> SOLID_FUEL_PART_BLACKLIST = Lists.newArrayList((Object[])new Pair[]{Pair.of(TileSaltFissionVessel.class, (Object)"nuclearcraft.multiblock_validation.fission_reactor.prohibit_vessels"), Pair.of(TileSaltFissionHeater.class, (Object)"nuclearcraft.multiblock_validation.fission_reactor.prohibit_heaters")});

    public SolidFuelFissionLogic(FissionReactorLogic oldLogic) {
        super(oldLogic);
        if (oldLogic instanceof SolidFuelFissionLogic) {
            SolidFuelFissionLogic oldSolidFuelLogic = (SolidFuelFissionLogic)oldLogic;
            this.heatingOutputRate = oldSolidFuelLogic.heatingOutputRate;
            this.effectiveHeating = oldSolidFuelLogic.effectiveHeating;
            this.reservedEffectiveHeat = oldSolidFuelLogic.reservedEffectiveHeat;
            this.heatingRecipeRate = oldSolidFuelLogic.heatingRecipeRate;
            this.heatingOutputRateFP = oldSolidFuelLogic.heatingOutputRateFP;
        }
    }

    @Override
    public String getID() {
        return "solid_fuel";
    }

    @Override
    public void onResetStats() {
        this.heatingOutputRate = 0;
        this.heatingOutputRateFP = 0.0;
        this.heatingRecipeRate = 0.0;
        this.effectiveHeating = 0.0;
    }

    @Override
    public void onReactorFormed() {
        this.tanks.get(0).setCapacity(4000 * this.getCapacityMultiplier());
        this.tanks.get(1).setCapacity(4000 * this.getCapacityMultiplier());
        super.onReactorFormed();
    }

    @Override
    public boolean isMachineWhole() {
        return !this.containsBlacklistedPart();
    }

    @Override
    public List<Pair<Class<? extends IFissionPart>, String>> getPartBlacklist() {
        return SOLID_FUEL_PART_BLACKLIST;
    }

    @Override
    public void refreshConnections() {
        super.refreshConnections();
        this.refreshFilteredPorts(TileFissionCellPort.class, TileSolidFissionCell.class);
    }

    @Override
    public void refreshAllFuelComponentModerators() {
        for (TileSolidFissionCell cell : this.getParts(TileSolidFissionCell.class)) {
            this.refreshFuelComponentModerators(cell, (Long2ObjectMap<IFissionComponent>)this.componentFailCache, (Long2ObjectMap<IFissionComponent>)this.assumedValidCache);
        }
    }

    @Override
    public void refreshReactorStats() {
        super.refreshReactorStats();
        for (FissionCluster cluster : this.getReactor().getClusterMap().values()) {
            if (!cluster.connectedToWall) continue;
            this.getReactor().usefulPartCount += (long)cluster.componentCount;
            this.getReactor().fuelComponentCount += cluster.fuelComponentCount;
            this.getReactor().cooling += cluster.cooling;
            this.getReactor().rawHeating += cluster.rawHeating;
            this.effectiveHeating += cluster.effectiveHeating;
            this.getReactor().totalHeatMult += cluster.totalHeatMult;
            this.getReactor().totalEfficiency += cluster.totalEfficiency;
        }
        this.getReactor().usefulPartCount += (long)(this.getReactor().passiveModeratorCache.size() + this.getReactor().activeModeratorCache.size() + this.getReactor().activeReflectorCache.size());
        double usefulPartRatio = (double)this.getReactor().usefulPartCount / (double)this.getReactor().getInteriorVolume();
        this.getReactor().sparsityEfficiencyMult = usefulPartRatio >= NCConfig.fission_sparsity_penalty_params[1] ? 1.0 : (1.0 - NCConfig.fission_sparsity_penalty_params[0]) * Math.sin(usefulPartRatio * Math.PI / (2.0 * NCConfig.fission_sparsity_penalty_params[1])) + NCConfig.fission_sparsity_penalty_params[0];
        this.effectiveHeating *= this.getReactor().sparsityEfficiencyMult;
        this.getReactor().totalEfficiency *= this.getReactor().sparsityEfficiencyMult;
        this.getReactor().meanHeatMult = this.getReactor().fuelComponentCount == 0 ? 0.0 : (double)this.getReactor().totalHeatMult / (double)this.getReactor().fuelComponentCount;
        this.getReactor().meanEfficiency = this.getReactor().fuelComponentCount == 0 ? 0.0 : this.getReactor().totalEfficiency / (double)this.getReactor().fuelComponentCount;
    }

    @Override
    public boolean onUpdateServer() {
        this.heatBuffer.changeHeatStored(this.getReactor().rawHeating);
        if (this.heatBuffer.isFull() && NCConfig.fission_overheat) {
            this.heatBuffer.setHeatStored(0L);
            this.reservedEffectiveHeat = 0.0;
            this.casingMeltdown();
            return true;
        }
        for (FissionCluster cluster : this.getClusterMap().values()) {
            cluster.heatBuffer.changeHeatStored(cluster.getNetHeating());
            if (!cluster.heatBuffer.isFull() || !NCConfig.fission_overheat) continue;
            cluster.heatBuffer.setHeatStored(0L);
            this.clusterMeltdown(cluster);
            return true;
        }
        if (this.getEffectiveHeat() > 0.0) {
            this.updateFluidHeating();
        }
        this.updateSounds();
        return super.onUpdateServer();
    }

    public void updateFluidHeating() {
        if (this.getReactor().isReactorOn) {
            this.refreshRecipe();
            if (this.canProcessInputs()) {
                this.produceProducts();
                return;
            }
        }
        this.heatingOutputRate = 0;
        this.heatingOutputRateFP = 0.0;
        this.heatingRecipeRate = 0.0;
    }

    public void updateSounds() {
        if (this.getReactor().isReactorOn) {
            this.playFuelComponentSounds(TileSolidFissionCell.class);
        }
    }

    public void refreshRecipe() {
        this.heatingRecipeInfo = NCRecipes.fission_heating.getRecipeInfoFromInputs(new ArrayList<ItemStack>(), this.tanks.subList(0, 1));
    }

    public boolean canProcessInputs() {
        if (!this.setRecipeStats()) {
            return false;
        }
        return this.canProduceProducts();
    }

    public boolean setRecipeStats() {
        if (this.heatingRecipeInfo == null) {
            this.heatingOutputRate = 0;
            this.heatingOutputRateFP = 0.0;
            this.heatingRecipeRate = 0.0;
            return false;
        }
        return true;
    }

    public boolean canProduceProducts() {
        BasicRecipe recipe = this.heatingRecipeInfo.getRecipe();
        IFluidIngredient fluidProduct = recipe.getFluidProducts().get(0);
        int productSize = fluidProduct.getMaxStackSize(0);
        if (productSize <= 0 || fluidProduct.getStack() == null) {
            return false;
        }
        int heatPerMB = recipe.getFissionHeatingHeatPerInputMB();
        int inputSize = recipe.getFluidIngredients().get(0).getMaxStackSize((Integer)this.heatingRecipeInfo.getFluidIngredientNumbers().get(0));
        double usedInput = Math.min((double)this.tanks.get(0).getFluidAmount(), this.getEffectiveHeat() / (double)heatPerMB);
        this.heatingRecipeRate = this.heatingOutputRateFP = Math.min(2.147483647E9, Math.min((double)((this.tanks.get(1).getCapacity() - this.tanks.get(1).getFluidAmount()) / productSize), usedInput / (double)inputSize));
        this.reservedEffectiveHeat += (this.heatingRecipeRate - (double)((int)this.heatingRecipeRate)) * (double)inputSize * (double)heatPerMB;
        int extraRecipeRate = (int)Math.min(2.147483647E9 - this.heatingRecipeRate, this.reservedEffectiveHeat / (double)(heatPerMB * inputSize));
        this.heatingRecipeRate += (double)extraRecipeRate;
        this.reservedEffectiveHeat -= (double)(extraRecipeRate * inputSize * heatPerMB);
        return this.tanks.get(1).isEmpty() || this.tanks.get(1).getFluid().isFluidEqual((FluidStack)fluidProduct.getStack());
    }

    public void produceProducts() {
        IFluidIngredient fluidProduct;
        int heatingRecipeRateInt = (int)this.heatingRecipeRate;
        BasicRecipe recipe = this.heatingRecipeInfo.getRecipe();
        int inputSize = recipe.getFluidIngredients().get(0).getMaxStackSize((Integer)this.heatingRecipeInfo.getFluidIngredientNumbers().get(0));
        if (heatingRecipeRateInt * inputSize > 0) {
            this.tanks.get(0).changeFluidAmount(-heatingRecipeRateInt * inputSize);
        }
        if (this.tanks.get(0).getFluidAmount() <= 0) {
            this.tanks.get(0).setFluidStored(null);
        }
        if ((fluidProduct = recipe.getFluidProducts().get(0)).getMaxStackSize(0) > 0) {
            int stackSize = 0;
            if (this.tanks.get(1).isEmpty()) {
                this.tanks.get(1).setFluidStored(fluidProduct.getNextStack(0));
                stackSize = this.tanks.get(1).getFluidAmount();
                this.heatingOutputRate = heatingRecipeRateInt * stackSize;
                this.tanks.get(1).setFluidAmount(this.heatingOutputRate);
            } else if (this.tanks.get(1).getFluid().isFluidEqual((FluidStack)fluidProduct.getStack())) {
                stackSize = fluidProduct.getNextStackSize(0);
                this.heatingOutputRate = heatingRecipeRateInt * stackSize;
                this.tanks.get(1).changeFluidAmount(this.heatingOutputRate);
            }
            this.heatingOutputRateFP *= (double)stackSize;
            if (this.heatingOutputRateFP > (double)stackSize) {
                this.heatingOutputRateFP = Math.round(this.heatingOutputRateFP);
            }
        }
        long heatRemoval = (long)((double)this.getReactor().rawHeating / this.effectiveHeating * this.heatingRecipeRate * (double)inputSize * (double)recipe.getFissionHeatingHeatPerInputMB());
        this.heatBuffer.changeHeatStored(-heatRemoval);
    }

    public double getEffectiveHeat() {
        return this.getReactor().rawHeating == 0L ? 0.0 : this.effectiveHeating / (double)this.getReactor().rawHeating * (double)this.heatBuffer.getHeatStored();
    }

    public long getNetClusterHeating() {
        return this.getReactor().rawHeating - this.getReactor().cooling;
    }

    @Override
    public void clusterMeltdown(FissionCluster cluster) {
        ObjectIterator componentIterator = cluster.getComponentMap().values().iterator();
        while (componentIterator.hasNext()) {
            IFissionComponent component = (IFissionComponent)componentIterator.next();
            component.onClusterMeltdown((Iterator<IFissionComponent>)componentIterator);
        }
        super.clusterMeltdown(cluster);
    }

    @Override
    public void distributeFluxFromFuelComponent(IFissionFuelComponent fuelComponent, ObjectSet<IFissionFuelComponent> fluxSearchCache, Long2ObjectMap<IFissionComponent> lineFailCache, Long2ObjectMap<IFissionComponent> assumedValidCache) {
        fuelComponent.defaultDistributeFlux(fluxSearchCache, lineFailCache, assumedValidCache);
    }

    @Override
    public IFissionFuelComponent getNextFuelComponent(IFissionFuelComponent fuelComponent, BlockPos pos) {
        return (IFissionFuelComponent)this.getPartMap(TileSolidFissionCell.class).get(pos.func_177986_g());
    }

    @Override
    public void refreshFuelComponentLocal(IFissionFuelComponent fuelComponent) {
        fuelComponent.defaultRefreshLocal();
    }

    @Override
    public void refreshFuelComponentModerators(IFissionFuelComponent fuelComponent, Long2ObjectMap<IFissionComponent> componentFailCache, Long2ObjectMap<IFissionComponent> assumedValidCache) {
        fuelComponent.defaultRefreshModerators(componentFailCache, assumedValidCache);
    }

    @Override
    @Nonnull
    public List<Tank> getVentTanks(List<Tank> backupTanks) {
        return this.getReactor().isAssembled() ? this.tanks : backupTanks;
    }

    @Override
    public void onUpdateClient() {
        super.onUpdateClient();
    }

    @Override
    public void writeToLogicTag(NBTTagCompound logicTag, TileBeefAbstract.SyncReason syncReason) {
        super.writeToLogicTag(logicTag, syncReason);
        this.writeTanks(this.tanks, logicTag, "tanks");
        logicTag.func_74768_a("heatingOutputRate", this.heatingOutputRate);
        logicTag.func_74780_a("effectiveHeating", this.effectiveHeating);
        logicTag.func_74780_a("reservedEffectiveHeat", this.reservedEffectiveHeat);
        logicTag.func_74780_a("heatingOutputRateFP", this.heatingOutputRateFP);
    }

    @Override
    public void readFromLogicTag(NBTTagCompound logicTag, TileBeefAbstract.SyncReason syncReason) {
        super.readFromLogicTag(logicTag, syncReason);
        this.readTanks(this.tanks, logicTag, "tanks");
        this.heatingOutputRate = logicTag.func_74762_e("heatingOutputRate");
        this.effectiveHeating = logicTag.func_74769_h("effectiveHeating");
        this.reservedEffectiveHeat = logicTag.func_74769_h("reservedEffectiveHeat");
        this.heatingOutputRateFP = logicTag.func_74769_h("heatingOutputRateFP");
    }

    @Override
    public SolidFissionUpdatePacket getUpdatePacket() {
        return new SolidFissionUpdatePacket(this.getReactor().controller.getTilePos(), this.getReactor().isReactorOn, this.heatBuffer, this.getReactor().clusterCount, this.getReactor().cooling, this.getReactor().rawHeating, this.getReactor().totalHeatMult, this.getReactor().meanHeatMult, this.getReactor().fuelComponentCount, this.getReactor().usefulPartCount, this.getReactor().totalEfficiency, this.getReactor().meanEfficiency, this.getReactor().sparsityEfficiencyMult, this.effectiveHeating, this.heatingOutputRateFP, this.reservedEffectiveHeat);
    }

    @Override
    public void onPacket(FissionUpdatePacket message) {
        super.onPacket(message);
        if (message instanceof SolidFissionUpdatePacket) {
            SolidFissionUpdatePacket packet = (SolidFissionUpdatePacket)message;
            this.effectiveHeating = packet.effectiveHeating;
            this.heatingOutputRateFP = packet.heatingOutputRateFP;
            this.reservedEffectiveHeat = packet.reservedEffectiveHeat;
        }
    }

    @Override
    public void clearAllMaterial() {
        super.clearAllMaterial();
        for (Tank tank : this.tanks) {
            tank.setFluidStored(null);
        }
    }
}

