/*
 * Decompiled with CFR 0.152.
 */
package nc.multiblock.fission.tile;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.SimpleComponent;
import nc.multiblock.cuboidal.CuboidalPartPositionType;
import nc.multiblock.fission.FissionCluster;
import nc.multiblock.fission.FissionReactor;
import nc.multiblock.fission.FissionReactorLogic;
import nc.multiblock.fission.salt.tile.TileSaltFissionHeater;
import nc.multiblock.fission.salt.tile.TileSaltFissionVessel;
import nc.multiblock.fission.solid.tile.TileSolidFissionCell;
import nc.multiblock.fission.solid.tile.TileSolidFissionSink;
import nc.multiblock.fission.tile.IFissionComponent;
import nc.multiblock.fission.tile.TileFissionPart;
import nc.multiblock.fission.tile.TileFissionShield;
import nc.util.StackHelper;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Optional;

@Optional.Interface(iface="li.cil.oc.api.network.SimpleComponent", modid="opencomputers")
public class TileFissionComputerPort
extends TileFissionPart
implements SimpleComponent {
    public TileFissionComputerPort() {
        super(CuboidalPartPositionType.WALL);
    }

    @Override
    public void onMachineAssembled(FissionReactor controller) {
        this.doStandardNullControllerResponse(controller);
        super.onMachineAssembled(controller);
    }

    @Override
    public void onMachineBroken() {
        super.onMachineBroken();
    }

    @Optional.Method(modid="opencomputers")
    public String getComponentName() {
        return "nc_salt_fission_reactor";
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] isComplete(Context context, Arguments args) {
        return new Object[]{this.isMultiblockAssembled()};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] isReactorOn(Context context, Arguments args) {
        return new Object[]{this.isMultiblockAssembled() ? ((FissionReactor)this.getMultiblock()).isReactorOn : false};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getLengthX(Context context, Arguments args) {
        return new Object[]{this.isMultiblockAssembled() ? ((FissionReactor)this.getMultiblock()).getInteriorLengthX() : 0};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getLengthY(Context context, Arguments args) {
        return new Object[]{this.isMultiblockAssembled() ? ((FissionReactor)this.getMultiblock()).getInteriorLengthY() : 0};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getLengthZ(Context context, Arguments args) {
        return new Object[]{this.isMultiblockAssembled() ? ((FissionReactor)this.getMultiblock()).getInteriorLengthZ() : 0};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getHeatStored(Context context, Arguments args) {
        return new Object[]{this.isMultiblockAssembled() ? ((FissionReactor)this.getMultiblock()).getLogic().heatBuffer.getHeatStored() : 0L};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getHeatCapacity(Context context, Arguments args) {
        return new Object[]{this.isMultiblockAssembled() ? ((FissionReactor)this.getMultiblock()).getLogic().heatBuffer.getHeatCapacity() : 0L};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getCoolingRate(Context context, Arguments args) {
        return new Object[]{this.isMultiblockAssembled() ? (double)((FissionReactor)this.getMultiblock()).cooling : 0.0};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getRawHeatingRate(Context context, Arguments args) {
        return new Object[]{this.isMultiblockAssembled() ? (double)((FissionReactor)this.getMultiblock()).rawHeating : 0.0};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getNumberOfCells(Context context, Arguments args) {
        return new Object[]{this.isMultiblockAssembled() ? ((FissionReactor)this.getMultiblock()).getPartMap(TileSolidFissionCell.class).size() : 0};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getNumberOfVessels(Context context, Arguments args) {
        return new Object[]{this.isMultiblockAssembled() ? ((FissionReactor)this.getMultiblock()).getPartMap(TileSaltFissionVessel.class).size() : 0};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getNumberOfHeaters(Context context, Arguments args) {
        return new Object[]{this.isMultiblockAssembled() ? ((FissionReactor)this.getMultiblock()).getPartMap(TileSaltFissionHeater.class).size() : 0};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getNumberOfShields(Context context, Arguments args) {
        return new Object[]{this.isMultiblockAssembled() ? ((FissionReactor)this.getMultiblock()).getPartMap(TileFissionShield.class).size() : 0};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getNumberOfClusters(Context context, Arguments args) {
        return new Object[]{this.isMultiblockAssembled() ? ((FissionReactor)this.getMultiblock()).clusterCount : 0};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getCellStats(Context context, Arguments args) {
        ArrayList<Object2ObjectLinkedOpenHashMap> cellData = new ArrayList<Object2ObjectLinkedOpenHashMap>();
        if (this.isMultiblockAssembled()) {
            Collection<TileSolidFissionCell> cells = ((FissionReactor)this.getMultiblock()).getParts(TileSolidFissionCell.class);
            for (TileSolidFissionCell cell : cells) {
                Object2ObjectLinkedOpenHashMap entry = new Object2ObjectLinkedOpenHashMap();
                ItemStack fuel = (ItemStack)cell.getInventoryStacks().get(0);
                if (fuel.func_190926_b()) {
                    entry.put((Object)"fuel", (Object)new Object[]{0, "null"});
                } else {
                    entry.put((Object)"fuel", (Object)new Object[]{fuel.func_190916_E(), StackHelper.stackName(fuel)});
                }
                entry.put((Object)"effective_heating", (Object)cell.getEffectiveHeating());
                entry.put((Object)"heat_multiplier", (Object)cell.getHeatMultiplier());
                entry.put((Object)"is_processing", (Object)cell.isProcessing);
                entry.put((Object)"time", (Object)cell.time);
                entry.put((Object)"base_process_time", (Object)cell.baseProcessTime);
                FissionCluster cluster = cell.getCluster();
                entry.put((Object)"cluster_heat_capacity", (Object)(cluster == null ? 0L : cluster.heatBuffer.getHeatCapacity()));
                entry.put((Object)"cluster_heat_stored", (Object)(cluster == null ? 0L : cluster.heatBuffer.getHeatStored()));
                entry.put((Object)"cluster_cooling", (Object)(cluster == null ? 0L : cluster.cooling));
                entry.put((Object)"base_process_criticality", (Object)cell.baseProcessCriticality);
                entry.put((Object)"base_process_efficiency", (Object)cell.baseProcessEfficiency);
                entry.put((Object)"is_primed", (Object)cell.isPrimed());
                entry.put((Object)"efficiency", (Object)cell.getEfficiency());
                cellData.add(entry);
            }
        }
        return new Object[]{cellData.toArray()};
    }

    @Optional.Method(modid="opencomputers")
    public Object[] updateShieldState(Context context, Arguments args) {
        boolean activated = false;
        if (this.isMultiblockAssembled()) {
            Long2ObjectMap<TileFissionShield> shieldMap = ((FissionReactor)this.getMultiblock()).getPartMap(TileFissionShield.class);
            if (shieldMap.size() == 0) {
                return new Object[]{"No neutron shields found!"};
            }
            int shieldId = args.checkInteger(0);
            boolean shieldState = args.checkBoolean(1);
            if (shieldId >= shieldMap.size()) {
                return new Object[]{"Incorrect neutron shield ID!"};
            }
            int i = 0;
            for (TileFissionShield shield : shieldMap.values()) {
                if (shieldId != i) continue;
                shield.isShielding = shieldState;
                shield.setActivity(shield.isShielding);
                shield.resetStats();
                ((FissionReactorLogic)this.getLogic()).onShieldUpdated(shield);
                this.func_70296_d();
                ((FissionReactor)this.getMultiblock()).refreshFlag = true;
                activated = shield.isShielding;
                break;
            }
        }
        return new Object[]{activated};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] getClusterComponents(Context context, Arguments args) {
        ArrayList<Object2ObjectOpenHashMap> componentsData = new ArrayList<Object2ObjectOpenHashMap>();
        if (this.isMultiblockAssembled()) {
            if (((FissionReactor)this.getMultiblock()).clusterCount == 0) {
                return new Object[]{"No clusters found!"};
            }
            int clusterID = args.checkInteger(0);
            if (clusterID >= ((FissionReactor)this.getMultiblock()).clusterCount) {
                return new Object[]{"Invalid cluster ID!"};
            }
            FissionCluster cluster = (FissionCluster)((FissionReactor)this.getMultiblock()).getClusterMap().get(clusterID);
            for (IFissionComponent component : cluster.getComponentMap().values()) {
                Object2ObjectOpenHashMap componentMap = new Object2ObjectOpenHashMap();
                if (component instanceof TileSolidFissionSink) {
                    TileSolidFissionSink sink = (TileSolidFissionSink)component;
                    componentMap.put((Object)sink.ruleID, (Object)new Object[]{sink.getHeatStored(), sink.coolingRate});
                }
                if (component instanceof TileFissionShield) {
                    TileFissionShield shield = (TileFissionShield)component;
                    componentMap.put((Object)shield.getClass().getName().toString(), (Object)new Object[]{shield.flux, shield.heatPerFlux, shield.isShielding, shield.heat, shield.efficiency});
                }
                componentsData.add(componentMap);
            }
        }
        return new Object[]{componentsData.toArray()};
    }

    @Callback
    @Optional.Method(modid="opencomputers")
    public Object[] clearAllMaterial(Context context, Arguments args) {
        if (this.isMultiblockAssembled()) {
            ((FissionReactor)this.getMultiblock()).clearAllMaterial();
        }
        return new Object[0];
    }
}

