/*
 * Decompiled with CFR 0.152.
 */
package nc.multiblock.fission.tile;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import nc.config.NCConfig;
import nc.multiblock.cuboidal.CuboidalPartPositionType;
import nc.multiblock.fission.FissionCluster;
import nc.multiblock.fission.FissionReactor;
import nc.multiblock.fission.tile.IFissionComponent;
import nc.multiblock.fission.tile.IFissionFluxSink;
import nc.multiblock.fission.tile.IFissionHeatingComponent;
import nc.multiblock.fission.tile.TileFissionPart;
import nc.multiblock.fission.tile.port.IFissionPortTarget;
import nc.multiblock.fission.tile.port.TileFissionIrradiatorPort;
import nc.network.multiblock.FissionIrradiatorUpdatePacket;
import nc.recipe.AbstractRecipeHandler;
import nc.recipe.BasicRecipe;
import nc.recipe.NCRecipes;
import nc.recipe.RecipeInfo;
import nc.recipe.RecipeStats;
import nc.recipe.ingredient.IItemIngredient;
import nc.tile.ITileGui;
import nc.tile.generator.IItemGenerator;
import nc.tile.internal.fluid.Tank;
import nc.tile.internal.inventory.InventoryConnection;
import nc.tile.internal.inventory.ItemOutputSetting;
import nc.tile.internal.inventory.ItemSorption;
import nc.tile.inventory.ITileFilteredInventory;
import nc.tile.inventory.ITileInventory;
import nc.util.NBTHelper;
import nc.util.PosHelper;
import nc.util.StackHelper;
import net.minecraft.client.util.RecipeItemHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TileFissionIrradiator
extends TileFissionPart
implements ITileFilteredInventory,
ITileGui<FissionIrradiatorUpdatePacket>,
IItemGenerator,
IFissionHeatingComponent,
IFissionFluxSink,
IFissionPortTarget<TileFissionIrradiatorPort, TileFissionIrradiator> {
    @Nonnull
    protected final String inventoryName = "nuclearcraft.container.fission_irradiator";
    @Nonnull
    protected final NonNullList<ItemStack> inventoryStacks = NonNullList.func_191197_a((int)2, (Object)ItemStack.field_190927_a);
    @Nonnull
    protected final NonNullList<ItemStack> filterStacks = NonNullList.func_191197_a((int)2, (Object)ItemStack.field_190927_a);
    @Nonnull
    protected final NonNullList<ItemStack> consumedStacks = NonNullList.func_191197_a((int)1, (Object)ItemStack.field_190927_a);
    @Nonnull
    protected InventoryConnection[] inventoryConnections = ITileInventory.inventoryConnectionAll(Lists.newArrayList((Object[])new ItemSorption[]{ItemSorption.NON, ItemSorption.NON}));
    protected final int itemInputSize = 1;
    protected final int itemOutputSize = 1;
    public double baseProcessTime = 1.0;
    public double baseProcessHeatPerFlux = 0.0;
    public double baseProcessEfficiency = 0.0;
    public double baseProcessRadiation = 0.0;
    public double time;
    public boolean isProcessing;
    public boolean hasConsumed;
    public boolean canProcessInputs;
    protected RecipeInfo<BasicRecipe> recipeInfo;
    protected Set<EntityPlayer> playersToUpdate;
    protected FissionCluster cluster = null;
    protected long heat = 0L;
    public long clusterHeatStored;
    public long clusterHeatCapacity;
    protected int flux = 0;
    protected BlockPos masterPortPos = PosHelper.DEFAULT_NON;
    protected TileFissionIrradiatorPort masterPort = null;

    public TileFissionIrradiator() {
        super(CuboidalPartPositionType.INTERIOR);
        this.playersToUpdate = new ObjectOpenHashSet();
    }

    @Override
    public void onMachineAssembled(FissionReactor controller) {
        this.doStandardNullControllerResponse(controller);
        super.onMachineAssembled(controller);
    }

    @Override
    public void onMachineBroken() {
        super.onMachineBroken();
    }

    @Override
    @Nullable
    public FissionCluster getCluster() {
        return this.cluster;
    }

    @Override
    public void setClusterInternal(@Nullable FissionCluster cluster) {
        this.cluster = cluster;
    }

    @Override
    public boolean isValidHeatConductor(Long2ObjectMap<IFissionComponent> componentFailCache, Long2ObjectMap<IFissionComponent> assumedValidCache) {
        return this.isProcessing;
    }

    @Override
    public boolean isFunctional() {
        return this.isProcessing;
    }

    @Override
    public void resetStats() {
        this.flux = 0;
        this.refreshRecipe();
        this.refreshActivity();
        this.refreshIsProcessing(true);
    }

    @Override
    public boolean isClusterRoot() {
        return true;
    }

    @Override
    public void clusterSearch(Integer id, Object2IntMap<IFissionComponent> clusterSearchCache, Long2ObjectMap<IFissionComponent> componentFailCache, Long2ObjectMap<IFissionComponent> assumedValidCache) {
        this.refreshRecipe();
        this.refreshActivity();
        this.refreshIsProcessing(false);
        IFissionFluxSink.super.clusterSearch(id, clusterSearchCache, componentFailCache, assumedValidCache);
    }

    @Override
    public void refreshIsProcessing(boolean checkCluster) {
        this.isProcessing = this.isProcessing(checkCluster);
        this.hasConsumed = this.hasConsumed();
    }

    @Override
    public void onClusterMeltdown(Iterator<IFissionComponent> componentIterator) {
    }

    @Override
    public boolean isAcceptingFlux(EnumFacing side) {
        return this.canProcessInputs;
    }

    @Override
    public boolean isNullifyingSources(EnumFacing side) {
        return this.canProcessInputs;
    }

    @Override
    public double moderatorLineEfficiencyFactor() {
        return this.baseProcessEfficiency;
    }

    @Override
    public void addFlux(int flux) {
        this.flux += flux;
    }

    @Override
    public long getRawHeating() {
        return (long)Math.min(9.223372036854776E18, Math.floor((double)this.flux * this.baseProcessHeatPerFlux));
    }

    @Override
    public long getRawHeatingIgnoreCoolingPenalty() {
        return 0L;
    }

    @Override
    public double getEffectiveHeating() {
        return (double)this.flux * this.baseProcessHeatPerFlux * this.baseProcessEfficiency;
    }

    @Override
    public double getEffectiveHeatingIgnoreCoolingPenalty() {
        return 0.0;
    }

    @Override
    public long getHeatStored() {
        return this.heat;
    }

    @Override
    public void setHeatStored(long heat) {
        this.heat = heat;
    }

    @Override
    public BlockPos getMasterPortPos() {
        return this.masterPortPos;
    }

    @Override
    public void setMasterPortPos(BlockPos pos) {
        this.masterPortPos = pos;
    }

    @Override
    public void clearMasterPort() {
        this.masterPort = null;
        this.masterPortPos = PosHelper.DEFAULT_NON;
    }

    @Override
    public void refreshMasterPort() {
        TileFissionIrradiatorPort tileFissionIrradiatorPort = this.masterPort = this.getMultiblock() == null ? null : (TileFissionIrradiatorPort)((FissionReactor)this.getMultiblock()).getPartMap(TileFissionIrradiatorPort.class).get(this.masterPortPos.func_177986_g());
        if (this.masterPort == null) {
            this.masterPortPos = PosHelper.DEFAULT_NON;
        }
    }

    @Override
    public boolean onPortRefresh() {
        this.refreshRecipe();
        this.refreshActivity();
        this.refreshIsProcessing(true);
        return this.isMultiblockAssembled() && ((FissionReactor)this.getMultiblock()).isReactorOn && !this.isProcessing && this.isProcessing(false);
    }

    @Override
    public void onLoad() {
        super.onLoad();
        if (!this.field_145850_b.field_72995_K) {
            this.refreshMasterPort();
            this.refreshRecipe();
            this.refreshActivity();
            this.refreshIsProcessing(true);
        }
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            boolean shouldUpdate;
            boolean wasProcessing = this.isProcessing;
            this.isProcessing = this.isProcessing(true);
            boolean shouldRefresh = this.isMultiblockAssembled() && ((FissionReactor)this.getMultiblock()).isReactorOn && !this.isProcessing && this.isProcessing(false);
            boolean bl = shouldUpdate = wasProcessing != this.isProcessing;
            if (this.isProcessing) {
                this.process();
            } else {
                this.getRadiationSource().setRadiationLevel(0.0);
            }
            if (shouldRefresh) {
                ((FissionReactor)this.getMultiblock()).refreshFlag = true;
            }
            this.sendUpdateToListeningPlayers();
            if (shouldUpdate) {
                this.func_70296_d();
            }
        }
    }

    @Override
    public void refreshRecipe() {
        this.recipeInfo = NCRecipes.fission_irradiator.getRecipeInfoFromInputs(this.getItemInputs(this.hasConsumed), new ArrayList<Tank>());
        this.consumeInputs();
    }

    @Override
    public void refreshActivity() {
        boolean wasReady = this.readyToProcess(false);
        this.canProcessInputs = this.canProcessInputs();
        if (this.getMultiblock() != null && !wasReady && this.readyToProcess(false)) {
            ((FissionReactor)this.getMultiblock()).refreshFlag = true;
        }
    }

    @Override
    public void refreshActivityOnProduction() {
        this.canProcessInputs = this.canProcessInputs();
    }

    public double getSpeedMultiplier() {
        return this.flux;
    }

    public boolean setRecipeStats() {
        if (this.recipeInfo == null) {
            this.baseProcessTime = 1.0;
            this.baseProcessHeatPerFlux = 0.0;
            this.baseProcessEfficiency = 0.0;
            this.baseProcessRadiation = 0.0;
            return false;
        }
        this.baseProcessTime = this.recipeInfo.getRecipe().getIrradiatorFluxRequired();
        this.baseProcessHeatPerFlux = this.recipeInfo.getRecipe().getIrradiatorHeatPerFlux();
        this.baseProcessEfficiency = this.recipeInfo.getRecipe().getIrradiatorProcessEfficiency();
        this.baseProcessRadiation = this.recipeInfo.getRecipe().getIrradiatorBaseProcessRadiation();
        return true;
    }

    public boolean isProcessing(boolean checkCluster) {
        return this.readyToProcess(checkCluster) && this.flux > 0;
    }

    public boolean readyToProcess(boolean checkCluster) {
        return this.canProcessInputs && this.hasConsumed && this.isMultiblockAssembled() && (!checkCluster || this.cluster != null);
    }

    public boolean hasConsumed() {
        if (this.field_145850_b.field_72995_K) {
            return this.hasConsumed;
        }
        for (int i = 0; i < 1; ++i) {
            if (((ItemStack)this.consumedStacks.get(i)).func_190926_b()) continue;
            return true;
        }
        return false;
    }

    public boolean canProcessInputs() {
        boolean canProcess;
        boolean validRecipe = this.setRecipeStats();
        boolean bl = canProcess = validRecipe && this.canProduceProducts();
        if (this.hasConsumed && !validRecipe) {
            for (int i = 0; i < 1; ++i) {
                this.getItemInputs(true).set(i, ItemStack.field_190927_a);
            }
            this.hasConsumed = false;
        }
        if (!canProcess) {
            this.time = MathHelper.func_151237_a((double)this.time, (double)0.0, (double)(this.baseProcessTime - 1.0));
        }
        return canProcess;
    }

    public boolean canProduceProducts() {
        for (int j = 0; j < 1; ++j) {
            IItemIngredient itemProduct = this.getItemProducts().get(j);
            if (itemProduct.getMaxStackSize(0) <= 0) continue;
            if (itemProduct.getStack() == null || ((ItemStack)itemProduct.getStack()).func_190926_b()) {
                return false;
            }
            if (((ItemStack)this.getInventoryStacks().get(j + 1)).func_190926_b()) continue;
            if (!((ItemStack)this.getInventoryStacks().get(j + 1)).func_77969_a((ItemStack)itemProduct.getStack())) {
                return false;
            }
            if (((ItemStack)this.getInventoryStacks().get(j + 1)).func_190916_E() + itemProduct.getMaxStackSize(0) <= ((ItemStack)this.getInventoryStacks().get(j + 1)).func_77976_d()) continue;
            return false;
        }
        return true;
    }

    public void consumeInputs() {
        int i;
        if (this.hasConsumed || this.recipeInfo == null) {
            return;
        }
        IntList itemInputOrder = this.recipeInfo.getItemInputOrder();
        if (itemInputOrder == AbstractRecipeHandler.INVALID) {
            return;
        }
        for (i = 0; i < 1; ++i) {
            if (((ItemStack)this.consumedStacks.get(i)).func_190926_b()) continue;
            this.consumedStacks.set(i, (Object)ItemStack.field_190927_a);
        }
        for (i = 0; i < 1; ++i) {
            int maxStackSize = this.getItemIngredients().get((Integer)itemInputOrder.get(i)).getMaxStackSize((Integer)this.recipeInfo.getItemIngredientNumbers().get(i));
            if (maxStackSize > 0) {
                this.consumedStacks.set(i, (Object)new ItemStack(((ItemStack)this.getInventoryStacks().get(i)).func_77973_b(), maxStackSize, StackHelper.getMetadata((ItemStack)this.getInventoryStacks().get(i))));
                ((ItemStack)this.getInventoryStacks().get(i)).func_190918_g(maxStackSize);
            }
            if (((ItemStack)this.getInventoryStacks().get(i)).func_190916_E() > 0) continue;
            this.getInventoryStacks().set(i, (Object)ItemStack.field_190927_a);
        }
        this.hasConsumed = true;
    }

    public void process() {
        this.time += this.getSpeedMultiplier();
        this.getRadiationSource().setRadiationLevel(this.baseProcessRadiation * this.getSpeedMultiplier() / (double)RecipeStats.getFissionMaxModeratorLineFlux());
        while (this.time >= this.baseProcessTime) {
            this.finishProcess();
        }
    }

    public void finishProcess() {
        double oldProcessTime = this.baseProcessTime;
        double oldProcessHeat = this.baseProcessHeatPerFlux;
        double oldProcessEfficiency = this.baseProcessEfficiency;
        this.produceProducts();
        this.refreshRecipe();
        this.time = Math.max(0.0, this.time - oldProcessTime);
        this.refreshActivityOnProduction();
        if (!this.canProcessInputs) {
            this.time = 0.0;
        }
        if (this.getMultiblock() != null) {
            if (this.canProcessInputs) {
                if (oldProcessHeat != this.baseProcessHeatPerFlux || oldProcessEfficiency != this.baseProcessEfficiency) {
                    ((FissionReactor)this.getMultiblock()).addClusterToRefresh(this.cluster);
                }
            } else {
                ((FissionReactor)this.getMultiblock()).refreshFlag = true;
            }
        }
    }

    public void produceProducts() {
        for (int i = 0; i < 1; ++i) {
            this.consumedStacks.set(i, (Object)ItemStack.field_190927_a);
        }
        if (!this.hasConsumed || this.recipeInfo == null) {
            return;
        }
        for (int j = 0; j < 1; ++j) {
            IItemIngredient itemProduct = this.getItemProducts().get(j);
            if (itemProduct.getNextStackSize(0) <= 0) continue;
            if (((ItemStack)this.getInventoryStacks().get(j + 1)).func_190926_b()) {
                this.getInventoryStacks().set(j + 1, (Object)itemProduct.getNextStack(0));
                continue;
            }
            if (!((ItemStack)this.getInventoryStacks().get(j + 1)).func_77969_a((ItemStack)itemProduct.getStack())) continue;
            int count = Math.min(this.func_70297_j_(), ((ItemStack)this.getInventoryStacks().get(j + 1)).func_190916_E() + itemProduct.getNextStackSize(0));
            ((ItemStack)this.getInventoryStacks().get(j + 1)).func_190920_e(count);
        }
        this.hasConsumed = false;
    }

    @Override
    public int getItemInputSize() {
        return 1;
    }

    @Override
    public int getItemOutputSize() {
        return 1;
    }

    @Override
    public int getOtherSlotsSize() {
        return 0;
    }

    @Override
    public List<ItemStack> getItemInputs(boolean consumed) {
        return consumed ? this.consumedStacks : this.getInventoryStacks().subList(0, 1);
    }

    @Override
    public List<IItemIngredient> getItemIngredients() {
        return this.recipeInfo.getRecipe().getItemIngredients();
    }

    @Override
    public List<IItemIngredient> getItemProducts() {
        return this.recipeInfo.getRecipe().getItemProducts();
    }

    @Override
    public String func_70005_c_() {
        return "nuclearcraft.container.fission_irradiator";
    }

    @Override
    @Nonnull
    public NonNullList<ItemStack> getInventoryStacks() {
        return !PosHelper.DEFAULT_NON.equals((Object)this.masterPortPos) ? this.masterPort.getInventoryStacks() : this.inventoryStacks;
    }

    @Override
    @Nonnull
    public NonNullList<ItemStack> getInventoryStacksInternal() {
        return this.inventoryStacks;
    }

    @Nonnull
    public NonNullList<ItemStack> getConsumedStacksInternal() {
        return this.consumedStacks;
    }

    @Override
    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack stack = ITileFilteredInventory.super.func_70298_a(slot, amount);
        if (!this.field_145850_b.field_72995_K) {
            if (slot < 1) {
                this.refreshRecipe();
                this.refreshActivity();
            } else if (slot < 2) {
                this.refreshActivity();
            }
        }
        return stack;
    }

    @Override
    public void func_70299_a(int slot, ItemStack stack) {
        ITileFilteredInventory.super.func_70299_a(slot, stack);
        if (!this.field_145850_b.field_72995_K) {
            if (slot < 1) {
                this.refreshRecipe();
                this.refreshActivity();
            } else if (slot < 2) {
                this.refreshActivity();
            }
        }
    }

    @Override
    public void func_70296_d() {
        this.refreshRecipe();
        this.refreshActivity();
        super.func_70296_d();
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        if (stack.func_190926_b() || slot >= 1) {
            return false;
        }
        ItemStack filter = (ItemStack)this.getFilterStacks().get(slot);
        if (!filter.func_190926_b() && !stack.func_77969_a(filter)) {
            return false;
        }
        return this.isItemValidForSlotInternal(slot, stack);
    }

    @Override
    public boolean isItemValidForSlotInternal(int slot, ItemStack stack) {
        if (stack.func_190926_b() || slot >= 1) {
            return false;
        }
        return NCConfig.smart_processor_input ? NCRecipes.fission_irradiator.isValidItemInput(stack, (ItemStack)this.getInventoryStacks().get(slot), this.inputItemStacksExcludingSlot(slot)) : NCRecipes.fission_irradiator.isValidItemInput(stack);
    }

    public List<ItemStack> inputItemStacksExcludingSlot(int slot) {
        ArrayList<ItemStack> inputItemsExcludingSlot = new ArrayList<ItemStack>(this.getItemInputs(false));
        inputItemsExcludingSlot.remove(slot);
        return inputItemsExcludingSlot;
    }

    @Override
    public boolean func_180462_a(int slot, ItemStack stack, EnumFacing side) {
        return ITileFilteredInventory.super.func_180462_a(slot, stack, side) && this.func_94041_b(slot, stack);
    }

    @Override
    public boolean hasConfigurableInventoryConnections() {
        return false;
    }

    @Override
    public void clearAllSlots() {
        ITileFilteredInventory.super.clearAllSlots();
        for (int i = 0; i < this.consumedStacks.size(); ++i) {
            this.consumedStacks.set(i, (Object)ItemStack.field_190927_a);
        }
        this.hasConsumed = false;
        this.refreshRecipe();
        this.refreshActivity();
        this.refreshIsProcessing(true);
    }

    @Override
    @Nonnull
    public InventoryConnection[] getInventoryConnections() {
        return this.inventoryConnections;
    }

    @Override
    public void setInventoryConnections(@Nonnull InventoryConnection[] connections) {
        this.inventoryConnections = connections;
    }

    @Override
    public ItemOutputSetting getItemOutputSetting(int slot) {
        return ItemOutputSetting.DEFAULT;
    }

    @Override
    public void setItemOutputSetting(int slot, ItemOutputSetting setting) {
    }

    @Override
    @Nonnull
    public NonNullList<ItemStack> getFilterStacks() {
        return !PosHelper.DEFAULT_NON.equals((Object)this.masterPortPos) ? this.masterPort.getFilterStacks() : this.filterStacks;
    }

    @Override
    public boolean canModifyFilter(int slot) {
        return this.getMultiblock() != null ? !((FissionReactor)this.getMultiblock()).isAssembled() : true;
    }

    @Override
    public void onFilterChanged(int slot) {
        this.func_70296_d();
    }

    @Override
    public Object getFilterKey() {
        return ((ItemStack)this.getFilterStacks().get(0)).func_190926_b() ? 0 : RecipeItemHelper.func_194113_b((ItemStack)((ItemStack)this.getFilterStacks().get(0)));
    }

    @Override
    public int getGuiID() {
        return 200;
    }

    @Override
    public Set<EntityPlayer> getPlayersToUpdate() {
        return this.playersToUpdate;
    }

    @Override
    public FissionIrradiatorUpdatePacket getGuiUpdatePacket() {
        return new FissionIrradiatorUpdatePacket(this.field_174879_c, this.masterPortPos, this.getFilterStacks(), this.cluster, this.isProcessing, this.time, this.baseProcessTime);
    }

    @Override
    public void onGuiPacket(FissionIrradiatorUpdatePacket message) {
        this.masterPortPos = message.masterPortPos;
        if (PosHelper.DEFAULT_NON.equals((Object)this.masterPortPos) ^ this.masterPort == null) {
            this.refreshMasterPort();
        }
        this.getFilterStacks().set(0, (Object)message.filterStack);
        this.clusterHeatStored = message.clusterHeatStored;
        this.clusterHeatCapacity = message.clusterHeatCapacity;
        this.isProcessing = message.isProcessing;
        this.time = message.time;
        this.baseProcessTime = message.baseProcessTime;
    }

    @Override
    public NBTTagCompound writeAll(NBTTagCompound nbt) {
        super.writeAll(nbt);
        this.writeInventory(nbt);
        this.writeInventoryConnections(nbt);
        nbt.func_74780_a("baseProcessTime", this.baseProcessTime);
        nbt.func_74780_a("baseProcessHeatPerFlux", this.baseProcessHeatPerFlux);
        nbt.func_74780_a("baseProcessEfficiency", this.baseProcessEfficiency);
        nbt.func_74780_a("time", this.time);
        nbt.func_74757_a("isProcessing", this.isProcessing);
        nbt.func_74757_a("hasConsumed", this.hasConsumed);
        nbt.func_74757_a("canProcessInputs", this.canProcessInputs);
        nbt.func_74768_a("flux", this.flux);
        nbt.func_74772_a("clusterHeat", this.heat);
        return nbt;
    }

    @Override
    public void readAll(NBTTagCompound nbt) {
        super.readAll(nbt);
        this.readInventory(nbt);
        this.readInventoryConnections(nbt);
        this.baseProcessTime = nbt.func_74769_h("baseProcessTime");
        this.baseProcessHeatPerFlux = nbt.func_74769_h("baseProcessHeatPerFlux");
        this.baseProcessEfficiency = nbt.func_74769_h("baseProcessEfficiency");
        this.time = nbt.func_74769_h("time");
        this.isProcessing = nbt.func_74767_n("isProcessing");
        this.hasConsumed = nbt.func_74767_n("hasConsumed");
        this.canProcessInputs = nbt.func_74767_n("canProcessInputs");
        this.flux = nbt.func_74762_e("flux");
        this.heat = nbt.func_74763_f("clusterHeat");
    }

    @Override
    public NBTTagCompound writeInventory(NBTTagCompound nbt) {
        NBTHelper.writeAllItems(nbt, new List[]{this.inventoryStacks, this.filterStacks, this.consumedStacks});
        return nbt;
    }

    @Override
    public void readInventory(NBTTagCompound nbt) {
        NBTHelper.readAllItems(nbt, new List[]{this.inventoryStacks, this.filterStacks, this.consumedStacks});
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing side) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return !this.getInventoryStacks().isEmpty() && this.hasInventorySideCapability(side);
        }
        return super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing side) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (!this.getInventoryStacks().isEmpty() && this.hasInventorySideCapability(side)) {
                return (T)this.getItemHandler(side);
            }
            return null;
        }
        return super.getCapability(capability, side);
    }

    @Override
    public IItemHandler getItemHandler(@Nullable EnumFacing side) {
        return ITileFilteredInventory.super.getItemHandler(side);
    }
}

