/*
 * Decompiled with CFR 0.152.
 */
package nc.multiblock.fission.tile;

import gregtech.api.capability.GregtechCapabilities;
import ic2.api.energy.tile.IEnergyAcceptor;
import ic2.api.energy.tile.IEnergyEmitter;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import nc.ModCheck;
import nc.block.property.BlockProperties;
import nc.config.NCConfig;
import nc.multiblock.cuboidal.CuboidalPartPositionType;
import nc.multiblock.fission.FissionReactor;
import nc.multiblock.fission.FissionReactorLogic;
import nc.multiblock.fission.tile.TileFissionPart;
import nc.tile.energy.ITileEnergy;
import nc.tile.internal.energy.EnergyConnection;
import nc.tile.internal.energy.EnergyStorage;
import nc.tile.internal.energy.EnergyTileWrapper;
import nc.tile.internal.energy.EnergyTileWrapperGT;
import nc.util.Lang;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fml.common.Optional;

@Optional.InterfaceList(value={@Optional.Interface(iface="ic2.api.energy.tile.IEnergySink", modid="ic2"), @Optional.Interface(iface="ic2.api.energy.tile.IEnergySource", modid="ic2")})
public class TileFissionPowerPort
extends TileFissionPart
implements ITickable,
ITileEnergy,
IEnergySink,
IEnergySource {
    protected final EnergyStorage backupStorage = new EnergyStorage(1L);
    protected final EnergyConnection[] energyConnections = ITileEnergy.energyConnectionAll(EnergyConnection.OUT);
    protected final EnergyTileWrapper[] energySides = ITileEnergy.getDefaultEnergySides(this);
    protected final EnergyTileWrapperGT[] energySidesGT = ITileEnergy.getDefaultEnergySidesGT(this);
    protected boolean ic2reg = false;

    public TileFissionPowerPort() {
        super(CuboidalPartPositionType.WALL);
    }

    @Override
    public void onMachineAssembled(FissionReactor controller) {
        this.doStandardNullControllerResponse(controller);
        super.onMachineAssembled(controller);
        if (!this.func_145831_w().field_72995_K && this.getPartPosition().getFacing() != null) {
            this.func_145831_w().func_180501_a(this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()).func_177226_a((IProperty)BlockProperties.FACING_ALL, (Comparable)this.getPartPosition().getFacing()), 2);
        }
    }

    @Override
    public void onMachineBroken() {
        super.onMachineBroken();
    }

    public void func_73660_a() {
        EnumFacing facing = this.getPartPosition().getFacing();
        if (!this.field_145850_b.field_72995_K && facing != null && this.getEnergyStored() > 0 && this.getEnergyConnection(facing).canExtract()) {
            this.pushEnergyToSide(facing);
        }
    }

    @Override
    public void onLoad() {
        super.onLoad();
        if (ModCheck.ic2Loaded()) {
            this.addTileToENet();
        }
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        if (ModCheck.ic2Loaded()) {
            this.removeTileFromENet();
        }
    }

    @Override
    public void onChunkUnload() {
        super.onChunkUnload();
        if (ModCheck.ic2Loaded()) {
            this.removeTileFromENet();
        }
    }

    @Override
    public EnergyStorage getEnergyStorage() {
        return this.getMultiblock() != null ? ((FissionReactorLogic)this.getLogic()).getPowerPortEnergyStorage(this.backupStorage) : this.backupStorage;
    }

    @Override
    public EnergyConnection[] getEnergyConnections() {
        return this.energyConnections;
    }

    @Override
    @Nonnull
    public EnergyTileWrapper[] getEnergySides() {
        return this.energySides;
    }

    @Override
    @Nonnull
    public EnergyTileWrapperGT[] getEnergySidesGT() {
        return this.energySidesGT;
    }

    @Override
    public boolean getIC2Reg() {
        return this.ic2reg;
    }

    @Override
    public void setIC2Reg(boolean ic2reg) {
        this.ic2reg = ic2reg;
    }

    @Override
    public int getSinkTier() {
        return this.getMultiblock() != null ? ((FissionReactorLogic)this.getLogic()).getPowerPortEUSinkTier() : 1;
    }

    @Override
    public int getSourceTier() {
        return this.getMultiblock() != null ? ((FissionReactorLogic)this.getLogic()).getPowerPortEUSourceTier() : 1;
    }

    @Override
    @Optional.Method(modid="ic2")
    public boolean acceptsEnergyFrom(IEnergyEmitter emitter, EnumFacing side) {
        return ITileEnergy.super.acceptsEnergyFrom(emitter, side);
    }

    @Override
    @Optional.Method(modid="ic2")
    public double getDemandedEnergy() {
        return ITileEnergy.super.getDemandedEnergy();
    }

    @Override
    @Optional.Method(modid="ic2")
    public double injectEnergy(EnumFacing directionFrom, double amount, double voltage) {
        return ITileEnergy.super.injectEnergy(directionFrom, amount, voltage);
    }

    @Override
    @Optional.Method(modid="ic2")
    public boolean emitsEnergyTo(IEnergyAcceptor receiver, EnumFacing side) {
        return ITileEnergy.super.emitsEnergyTo(receiver, side);
    }

    @Override
    @Optional.Method(modid="ic2")
    public double getOfferedEnergy() {
        return ITileEnergy.super.getOfferedEnergy();
    }

    @Override
    @Optional.Method(modid="ic2")
    public void drawEnergy(double amount) {
        ITileEnergy.super.drawEnergy(amount);
    }

    @Override
    public boolean hasConfigurableEnergyConnections() {
        return true;
    }

    @Override
    public boolean onUseMultitool(ItemStack multitoolStack, EntityPlayer player, World world, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!player.func_70093_af() && this.getMultiblock() != null) {
            if (this.getEnergyConnection(facing) != EnergyConnection.OUT) {
                for (EnumFacing side : EnumFacing.field_82609_l) {
                    this.setEnergyConnection(EnergyConnection.OUT, side);
                }
                this.setActivity(false);
                player.func_145747_a((ITextComponent)new TextComponentString(Lang.localise("nc.block.port_toggle") + " " + TextFormatting.GOLD + Lang.localise("nc.block.fission_port_mode.output") + " " + TextFormatting.WHITE + Lang.localise("nc.block.port_toggle.mode")));
            } else {
                for (EnumFacing side : EnumFacing.field_82609_l) {
                    this.setEnergyConnection(EnergyConnection.IN, side);
                }
                this.setActivity(true);
                player.func_145747_a((ITextComponent)new TextComponentString(Lang.localise("nc.block.port_toggle") + " " + TextFormatting.DARK_AQUA + Lang.localise("nc.block.fission_port_mode.input") + " " + TextFormatting.WHITE + Lang.localise("nc.block.port_toggle.mode")));
            }
            this.markDirtyAndNotify(true);
            return true;
        }
        return super.onUseMultitool(multitoolStack, player, world, facing, hitX, hitY, hitZ);
    }

    @Override
    public NBTTagCompound writeAll(NBTTagCompound nbt) {
        super.writeAll(nbt);
        this.writeEnergyConnections(nbt);
        return nbt;
    }

    @Override
    public void readAll(NBTTagCompound nbt) {
        super.readAll(nbt);
        this.readEnergyConnections(nbt);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing side) {
        if (capability == CapabilityEnergy.ENERGY || ModCheck.gregtechLoaded() && NCConfig.enable_gtce_eu && capability == GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER) {
            return this.hasEnergySideCapability(side);
        }
        return super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing side) {
        if (capability == CapabilityEnergy.ENERGY) {
            if (this.hasEnergySideCapability(side)) {
                return (T)this.getEnergySide(this.nonNullSide(side));
            }
            return null;
        }
        if (ModCheck.gregtechLoaded() && capability == GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER) {
            if (NCConfig.enable_gtce_eu && this.hasEnergySideCapability(side)) {
                return (T)this.getEnergySideGT(this.nonNullSide(side));
            }
            return null;
        }
        return super.getCapability(capability, side);
    }
}

