/*
 * Decompiled with CFR 0.152.
 */
package nc.multiblock.fission.tile;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Iterator;
import javax.annotation.Nullable;
import nc.enumm.MetaEnums;
import nc.multiblock.cuboidal.CuboidalPartPositionType;
import nc.multiblock.fission.FissionCluster;
import nc.multiblock.fission.FissionReactor;
import nc.multiblock.fission.FissionReactorLogic;
import nc.multiblock.fission.tile.IFissionComponent;
import nc.multiblock.fission.tile.IFissionFuelComponent;
import nc.multiblock.fission.tile.IFissionHeatingComponent;
import nc.multiblock.fission.tile.TileFissionPart;
import nc.multiblock.fission.tile.manager.IFissionManagerListener;
import nc.multiblock.fission.tile.manager.TileFissionShieldManager;
import nc.util.PosHelper;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TileFissionShield
extends TileFissionPart
implements IFissionHeatingComponent,
IFissionManagerListener<TileFissionShieldManager, TileFissionShield> {
    public double heatPerFlux;
    public double efficiency;
    public boolean isShielding = false;
    public boolean inCompleteModeratorLine = false;
    public boolean activeModerator = false;
    protected boolean[] validActiveModeratorPos = new boolean[]{false, false, false, false, false, false};
    protected FissionCluster cluster = null;
    protected long heat = 0L;
    protected int flux = 0;
    protected IFissionFuelComponent.ModeratorLine[] activeModeratorLines = new IFissionFuelComponent.ModeratorLine[]{null, null, null};
    protected BlockPos managerPos = PosHelper.DEFAULT_NON;
    protected TileFissionShieldManager manager = null;

    public TileFissionShield() {
        super(CuboidalPartPositionType.INTERIOR);
    }

    public TileFissionShield(double heatPerFlux, double efficiency) {
        this();
        this.heatPerFlux = heatPerFlux;
        this.efficiency = efficiency;
    }

    @Override
    public void onMachineAssembled(FissionReactor controller) {
        this.doStandardNullControllerResponse(controller);
        super.onMachineAssembled(controller);
    }

    @Override
    @Nullable
    public FissionCluster getCluster() {
        return this.cluster;
    }

    @Override
    public void setClusterInternal(@Nullable FissionCluster cluster) {
        this.cluster = cluster;
    }

    @Override
    public boolean isValidHeatConductor(Long2ObjectMap<IFissionComponent> componentFailCache, Long2ObjectMap<IFissionComponent> assumedValidCache) {
        return this.inCompleteModeratorLine;
    }

    @Override
    public boolean isFunctional() {
        return this.inCompleteModeratorLine;
    }

    @Override
    public boolean isActiveModerator() {
        return this.activeModerator;
    }

    @Override
    public void resetStats() {
        this.activeModerator = false;
        this.inCompleteModeratorLine = false;
        for (EnumFacing enumFacing : EnumFacing.field_82609_l) {
            this.validActiveModeratorPos[enumFacing.func_176745_a()] = false;
        }
        this.flux = 0;
        for (EnumFacing enumFacing : PosHelper.AXES) {
            this.activeModeratorLines[PosHelper.getAxisIndex((EnumFacing.Axis)enumFacing)] = null;
        }
    }

    @Override
    public boolean isClusterRoot() {
        return true;
    }

    @Override
    public void clusterSearch(Integer id, Object2IntMap<IFissionComponent> clusterSearchCache, Long2ObjectMap<IFissionComponent> componentFailCache, Long2ObjectMap<IFissionComponent> assumedValidCache) {
        IFissionHeatingComponent.super.clusterSearch(id, clusterSearchCache, componentFailCache, assumedValidCache);
    }

    @Override
    public void onClusterMeltdown(Iterator<IFissionComponent> componentIterator) {
    }

    @Override
    public boolean isNullifyingSources(EnumFacing side) {
        return this.isShielding;
    }

    @Override
    public long getHeatStored() {
        return this.heat;
    }

    @Override
    public void setHeatStored(long heat) {
        this.heat = heat;
    }

    @Override
    public long getRawHeating() {
        return this.isFunctional() ? (long)Math.min(9.223372036854776E18, Math.floor((double)this.flux * this.heatPerFlux)) : 0L;
    }

    @Override
    public long getRawHeatingIgnoreCoolingPenalty() {
        return 0L;
    }

    @Override
    public double getEffectiveHeating() {
        return this.isFunctional() ? (double)this.flux * this.heatPerFlux * this.efficiency : 0.0;
    }

    @Override
    public double getEffectiveHeatingIgnoreCoolingPenalty() {
        return 0.0;
    }

    @Override
    public IFissionFuelComponent.ModeratorBlockInfo getModeratorBlockInfo(EnumFacing dir, boolean validActiveModeratorPos) {
        this.validActiveModeratorPos[dir.func_176745_a()] = this.getMultiblock() == null ? false : ((FissionReactorLogic)this.getLogic()).isShieldActiveModerator(this, validActiveModeratorPos);
        return this.getMultiblock() != null ? ((FissionReactorLogic)this.getLogic()).getShieldModeratorBlockInfo(this, this.validActiveModeratorPos[dir.func_176745_a()]) : null;
    }

    @Override
    public void onAddedToModeratorCache(IFissionFuelComponent.ModeratorBlockInfo thisInfo) {
    }

    @Override
    public void onModeratorLineComplete(IFissionFuelComponent.ModeratorLine line, IFissionFuelComponent.ModeratorBlockInfo thisInfo, EnumFacing dir) {
        int index;
        this.inCompleteModeratorLine = true;
        if (this.validActiveModeratorPos[dir.func_176745_a()]) {
            this.activeModerator = true;
        }
        if (this.activeModeratorLines[index = PosHelper.getAxisIndex(dir.func_176740_k())] == null) {
            this.flux += this.getLineFluxContribution(line, thisInfo);
            this.activeModeratorLines[index] = line;
        }
    }

    protected int getLineFluxContribution(IFissionFuelComponent.ModeratorLine line, IFissionFuelComponent.ModeratorBlockInfo thisInfo) {
        int innerFlux = 0;
        int outerFlux = 0;
        boolean inner = true;
        for (IFissionFuelComponent.ModeratorBlockInfo info : line.info) {
            if (info == thisInfo) {
                inner = false;
            }
            if (inner) {
                innerFlux += info.fluxFactor;
                continue;
            }
            outerFlux += info.fluxFactor;
        }
        if (line.fluxSink != null) {
            if (line.fluxSink instanceof IFissionFuelComponent) {
                return innerFlux + outerFlux;
            }
            return innerFlux;
        }
        if (line.reflectorRecipe != null) {
            return (int)Math.floor((double)(innerFlux + outerFlux) * (1.0 + line.reflectorRecipe.getFissionReflectorReflectivity()));
        }
        return innerFlux;
    }

    @Override
    public BlockPos getManagerPos() {
        return this.managerPos;
    }

    @Override
    public void setManagerPos(BlockPos pos) {
        this.managerPos = pos;
    }

    @Override
    public void clearManager() {
        this.manager = null;
        this.managerPos = PosHelper.DEFAULT_NON;
    }

    @Override
    public void refreshManager() {
        TileFissionShieldManager tileFissionShieldManager = this.manager = this.getMultiblock() == null ? null : (TileFissionShieldManager)((FissionReactor)this.getMultiblock()).getPartMap(TileFissionShieldManager.class).get(this.managerPos.func_177986_g());
        if (this.manager == null) {
            this.managerPos = PosHelper.DEFAULT_NON;
        }
    }

    @Override
    public boolean onManagerRefresh(TileFissionShieldManager manager) {
        this.manager = manager;
        this.managerPos = manager.func_174877_v();
        boolean wasShielding = this.isShielding;
        this.isShielding = manager.isShieldingActive();
        if (wasShielding != this.isShielding) {
            if (!this.field_145850_b.field_72995_K) {
                this.setActivity(this.isShielding);
            }
            return true;
        }
        return false;
    }

    @Override
    public void onBlockNeighborChanged(IBlockState state, World world, BlockPos pos, BlockPos fromPos) {
        boolean wasShielding = this.isShielding;
        super.onBlockNeighborChanged(state, world, pos, fromPos);
        this.setActivity(this.isShielding);
        if (!world.field_72995_K && wasShielding != this.isShielding) {
            ((FissionReactorLogic)this.getLogic()).onShieldUpdated(this);
        }
    }

    @Override
    public NBTTagCompound writeAll(NBTTagCompound nbt) {
        super.writeAll(nbt);
        nbt.func_74780_a("heatPerFlux", this.heatPerFlux);
        nbt.func_74780_a("efficiency", this.efficiency);
        nbt.func_74757_a("isShielding", this.isShielding);
        nbt.func_74757_a("inCompleteModeratorLine", this.inCompleteModeratorLine);
        nbt.func_74757_a("activeModerator", this.activeModerator);
        nbt.func_74768_a("flux", this.flux);
        nbt.func_74772_a("clusterHeat", this.heat);
        nbt.func_74772_a("managerPos", this.managerPos.func_177986_g());
        return nbt;
    }

    @Override
    public void readAll(NBTTagCompound nbt) {
        super.readAll(nbt);
        if (nbt.func_74764_b("heatPerFlux")) {
            this.heatPerFlux = nbt.func_74769_h("heatPerFlux");
        }
        if (nbt.func_74764_b("efficiency")) {
            this.efficiency = nbt.func_74769_h("efficiency");
        }
        this.isShielding = nbt.func_74767_n("isShielding");
        this.inCompleteModeratorLine = nbt.func_74767_n("inCompleteModeratorLine");
        this.activeModerator = nbt.func_74767_n("activeModerator");
        this.flux = nbt.func_74762_e("flux");
        this.heat = nbt.func_74763_f("clusterHeat");
        this.managerPos = BlockPos.func_177969_a((long)nbt.func_74763_f("managerPos"));
    }

    public static class BoronSilver
    extends Meta {
        public BoronSilver() {
            super(MetaEnums.NeutronShieldType.BORON_SILVER);
        }
    }

    protected static class Meta
    extends TileFissionShield {
        protected Meta(MetaEnums.NeutronShieldType type) {
            super(type.getHeatPerFlux(), type.getEfficiency());
        }

        @Override
        public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
            return oldState.func_177230_c() != newState.func_177230_c() || oldState.func_177230_c().func_176201_c(oldState) != newState.func_177230_c().func_176201_c(newState);
        }
    }
}

