/*
 * Decompiled with CFR 0.152.
 */
package nc.multiblock.fission.tile;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import nc.ModCheck;
import nc.block.property.BlockProperties;
import nc.config.NCConfig;
import nc.multiblock.cuboidal.CuboidalPartPositionType;
import nc.multiblock.fission.FissionReactor;
import nc.multiblock.fission.FissionReactorLogic;
import nc.multiblock.fission.tile.TileFissionPart;
import nc.tile.fluid.ITileFluid;
import nc.tile.internal.fluid.FluidConnection;
import nc.tile.internal.fluid.FluidTileWrapper;
import nc.tile.internal.fluid.GasTileWrapper;
import nc.tile.internal.fluid.Tank;
import nc.tile.internal.fluid.TankOutputSetting;
import nc.tile.internal.fluid.TankSorption;
import nc.tile.passive.ITilePassive;
import nc.util.CapabilityHelper;
import nc.util.Lang;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TileFissionVent
extends TileFissionPart
implements ITickable,
ITileFluid {
    @Nonnull
    private final List<Tank> backupTanks = Lists.newArrayList((Object[])new Tank[]{new Tank(1, new ArrayList<String>()), new Tank(1, new ArrayList<String>())});
    @Nonnull
    private FluidConnection[] fluidConnections = ITileFluid.fluidConnectionAll(Lists.newArrayList((Object[])new TankSorption[]{TankSorption.IN, TankSorption.NON}));
    @Nonnull
    private final FluidTileWrapper[] fluidSides = ITileFluid.getDefaultFluidSides(this);
    @Nonnull
    private final GasTileWrapper gasWrapper = new GasTileWrapper(this);

    public TileFissionVent() {
        super(CuboidalPartPositionType.WALL);
    }

    @Override
    public void onMachineAssembled(FissionReactor controller) {
        this.doStandardNullControllerResponse(controller);
        super.onMachineAssembled(controller);
        if (!this.func_145831_w().field_72995_K && this.getPartPosition().getFacing() != null) {
            this.func_145831_w().func_180501_a(this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()).func_177226_a((IProperty)BlockProperties.FACING_ALL, (Comparable)this.getPartPosition().getFacing()), 2);
        }
    }

    @Override
    public void onMachineBroken() {
        super.onMachineBroken();
    }

    public void func_73660_a() {
        EnumFacing facing = this.getPartPosition().getFacing();
        if (!this.field_145850_b.field_72995_K && facing != null && !this.getTanks().get(1).isEmpty() && this.getTankSorption(facing, 1).canDrain()) {
            this.pushFluidToSide(facing);
        }
    }

    @Override
    @Nonnull
    public List<Tank> getTanks() {
        return this.getMultiblock() != null ? ((FissionReactorLogic)this.getLogic()).getVentTanks(this.backupTanks) : this.backupTanks;
    }

    @Override
    @Nonnull
    public FluidConnection[] getFluidConnections() {
        return this.fluidConnections;
    }

    @Override
    public void setFluidConnections(@Nonnull FluidConnection[] connections) {
        this.fluidConnections = connections;
    }

    @Override
    @Nonnull
    public FluidTileWrapper[] getFluidSides() {
        return this.fluidSides;
    }

    @Override
    @Nonnull
    public GasTileWrapper getGasWrapper() {
        return this.gasWrapper;
    }

    @Override
    public void pushFluidToSide(@Nonnull EnumFacing side) {
        TileEntity tile = this.getTileWorld().func_175625_s(this.getTilePos().func_177972_a(side));
        if (tile == null || tile instanceof TileFissionVent) {
            return;
        }
        if (tile instanceof ITilePassive && !((ITilePassive)tile).canPushFluidsTo()) {
            return;
        }
        IFluidHandler adjStorage = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side.func_176734_d());
        if (adjStorage == null) {
            return;
        }
        for (int i = 0; i < this.getTanks().size(); ++i) {
            if (this.getTanks().get(i).getFluid() == null || !this.getTankSorption(side, i).canDrain()) continue;
            this.getTanks().get(i).drain(adjStorage.fill(this.getTanks().get(i).drain(this.getTanks().get(i).getCapacity(), false), true), true);
        }
    }

    @Override
    public boolean getInputTanksSeparated() {
        return false;
    }

    @Override
    public void setInputTanksSeparated(boolean separated) {
    }

    @Override
    public boolean getVoidUnusableFluidInput(int tankNumber) {
        return false;
    }

    @Override
    public void setVoidUnusableFluidInput(int tankNumber, boolean voidUnusableFluidInput) {
    }

    @Override
    public TankOutputSetting getTankOutputSetting(int tankNumber) {
        return TankOutputSetting.DEFAULT;
    }

    @Override
    public void setTankOutputSetting(int tankNumber, TankOutputSetting setting) {
    }

    @Override
    public boolean hasConfigurableFluidConnections() {
        return true;
    }

    @Override
    public boolean onUseMultitool(ItemStack multitoolStack, EntityPlayer player, World world, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!player.func_70093_af() && this.getMultiblock() != null) {
            if (this.getTankSorption(facing, 0) != TankSorption.IN) {
                for (EnumFacing side : EnumFacing.field_82609_l) {
                    this.setTankSorption(side, 0, TankSorption.IN);
                    this.setTankSorption(side, 1, TankSorption.NON);
                }
                this.setActivity(false);
                player.func_145747_a((ITextComponent)new TextComponentString(Lang.localise("nc.block.vent_toggle") + " " + TextFormatting.DARK_AQUA + Lang.localise("nc.block.fission_vent_mode.input") + " " + TextFormatting.WHITE + Lang.localise("nc.block.vent_toggle.mode")));
            } else {
                for (EnumFacing side : EnumFacing.field_82609_l) {
                    this.setTankSorption(side, 0, TankSorption.NON);
                    this.setTankSorption(side, 1, TankSorption.OUT);
                }
                this.setActivity(true);
                player.func_145747_a((ITextComponent)new TextComponentString(Lang.localise("nc.block.vent_toggle") + " " + TextFormatting.RED + Lang.localise("nc.block.fission_vent_mode.output") + " " + TextFormatting.WHITE + Lang.localise("nc.block.vent_toggle.mode")));
            }
            this.markDirtyAndNotify(true);
            return true;
        }
        return super.onUseMultitool(multitoolStack, player, world, facing, hitX, hitY, hitZ);
    }

    @Override
    public NBTTagCompound writeAll(NBTTagCompound nbt) {
        super.writeAll(nbt);
        this.writeFluidConnections(nbt);
        return nbt;
    }

    @Override
    public void readAll(NBTTagCompound nbt) {
        super.readAll(nbt);
        this.readFluidConnections(nbt);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing side) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || ModCheck.mekanismLoaded() && NCConfig.enable_mek_gas && capability == CapabilityHelper.GAS_HANDLER_CAPABILITY) {
            return !this.getTanks().isEmpty() && this.hasFluidSideCapability(side);
        }
        return super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing side) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            if (!this.getTanks().isEmpty() && this.hasFluidSideCapability(side)) {
                return (T)this.getFluidSide(this.nonNullSide(side));
            }
            return null;
        }
        if (ModCheck.mekanismLoaded() && capability == CapabilityHelper.GAS_HANDLER_CAPABILITY) {
            if (NCConfig.enable_mek_gas && !this.getTanks().isEmpty() && this.hasFluidSideCapability(side)) {
                return (T)this.getGasWrapper();
            }
            return null;
        }
        return super.getCapability(capability, side);
    }
}

