/*
 * Decompiled with CFR 0.152.
 */
package nc.multiblock.fission.tile.port;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import nc.ModCheck;
import nc.config.NCConfig;
import nc.multiblock.fission.FissionReactor;
import nc.multiblock.fission.tile.port.IFissionPortTarget;
import nc.multiblock.fission.tile.port.TileFissionPort;
import nc.recipe.BasicRecipeHandler;
import nc.tile.fluid.ITileFilteredFluid;
import nc.tile.fluid.ITileFluid;
import nc.tile.internal.fluid.FluidConnection;
import nc.tile.internal.fluid.FluidTileWrapper;
import nc.tile.internal.fluid.GasTileWrapper;
import nc.tile.internal.fluid.Tank;
import nc.tile.internal.fluid.TankOutputSetting;
import nc.tile.internal.fluid.TankSorption;
import nc.util.CapabilityHelper;
import nc.util.Lang;
import nc.util.PosHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;

public abstract class TileFissionFluidPort<PORT extends TileFissionFluidPort<PORT, TARGET>, TARGET extends IFissionPortTarget<PORT, TARGET> & ITileFilteredFluid>
extends TileFissionPort<PORT, TARGET>
implements ITileFilteredFluid {
    @Nonnull
    protected final List<Tank> tanks;
    @Nonnull
    protected final List<Tank> filterTanks;
    protected final int capacity;
    @Nonnull
    protected FluidConnection[] fluidConnections = ITileFluid.fluidConnectionAll(Lists.newArrayList((Object[])new TankSorption[]{TankSorption.IN, TankSorption.OUT}));
    @Nonnull
    protected FluidTileWrapper[] fluidSides;
    @Nonnull
    protected GasTileWrapper gasWrapper;
    protected final BasicRecipeHandler recipeHandler;

    public TileFissionFluidPort(Class<PORT> portClass, int capacity, List<String> validFluids, BasicRecipeHandler recipeHandler) {
        super(portClass);
        this.tanks = Lists.newArrayList((Object[])new Tank[]{new Tank(capacity, validFluids), new Tank(capacity, new ArrayList<String>())});
        this.filterTanks = Lists.newArrayList((Object[])new Tank[]{new Tank(1000, validFluids), new Tank(1000, new ArrayList<String>())});
        this.capacity = capacity;
        this.fluidSides = ITileFluid.getDefaultFluidSides(this);
        this.gasWrapper = new GasTileWrapper(this);
        this.recipeHandler = recipeHandler;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        EnumFacing facing = this.getPartPosition().getFacing();
        if (!this.field_145850_b.field_72995_K && facing != null && !this.getTanks().get(1).isEmpty() && this.getTankSorption(facing, 1).canDrain()) {
            this.pushFluidToSide(facing);
        }
    }

    @Override
    public void setInventoryStackLimit(int stackLimit) {
    }

    @Override
    public int getTankBaseCapacity() {
        return this.capacity;
    }

    @Override
    public void setTankCapacity(int capacity) {
        this.tanks.get(0).setCapacity(capacity);
        this.tanks.get(1).setCapacity(capacity);
    }

    @Override
    public boolean canModifyFilter(int tank) {
        return this.getMultiblock() != null ? !((FissionReactor)this.getMultiblock()).isAssembled() : true;
    }

    @Override
    public void onFilterChanged(int tank) {
        this.func_70296_d();
    }

    @Override
    @Nonnull
    public List<Tank> getTanks() {
        return !PosHelper.DEFAULT_NON.equals((Object)this.masterPortPos) ? ((TileFissionFluidPort)this.masterPort).getTanks() : this.tanks;
    }

    @Override
    @Nonnull
    public List<Tank> getTanksInternal() {
        return this.tanks;
    }

    @Override
    @Nonnull
    public List<Tank> getFilterTanks() {
        return !PosHelper.DEFAULT_NON.equals((Object)this.masterPortPos) ? ((TileFissionFluidPort)this.masterPort).getFilterTanks() : this.filterTanks;
    }

    @Override
    @Nonnull
    public FluidConnection[] getFluidConnections() {
        return this.fluidConnections;
    }

    @Override
    public void setFluidConnections(@Nonnull FluidConnection[] connections) {
        this.fluidConnections = connections;
    }

    @Override
    @Nonnull
    public FluidTileWrapper[] getFluidSides() {
        return this.fluidSides;
    }

    @Override
    @Nonnull
    public GasTileWrapper getGasWrapper() {
        return this.gasWrapper;
    }

    @Override
    public boolean getInputTanksSeparated() {
        return false;
    }

    @Override
    public void setInputTanksSeparated(boolean separated) {
    }

    @Override
    public boolean getVoidUnusableFluidInput(int tankNumber) {
        return false;
    }

    @Override
    public void setVoidUnusableFluidInput(int tankNumber, boolean voidUnusableFluidInput) {
    }

    @Override
    public TankOutputSetting getTankOutputSetting(int tankNumber) {
        return TankOutputSetting.DEFAULT;
    }

    @Override
    public void setTankOutputSetting(int tankNumber, TankOutputSetting setting) {
    }

    @Override
    public boolean hasConfigurableFluidConnections() {
        return true;
    }

    @Override
    public boolean onUseMultitool(ItemStack multitoolStack, EntityPlayer player, World world, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!player.func_70093_af() && this.getMultiblock() != null) {
            if (this.getTankSorption(facing, 0) != TankSorption.IN) {
                for (EnumFacing side : EnumFacing.field_82609_l) {
                    this.setTankSorption(side, 0, TankSorption.IN);
                    this.setTankSorption(side, 1, TankSorption.NON);
                }
                this.setActivity(false);
                player.func_145747_a((ITextComponent)new TextComponentString(Lang.localise("nc.block.port_toggle") + " " + TextFormatting.DARK_AQUA + Lang.localise("nc.block.fission_port_mode.input") + " " + TextFormatting.WHITE + Lang.localise("nc.block.port_toggle.mode")));
            } else {
                for (EnumFacing side : EnumFacing.field_82609_l) {
                    this.setTankSorption(side, 0, TankSorption.NON);
                    this.setTankSorption(side, 1, TankSorption.OUT);
                }
                this.setActivity(true);
                player.func_145747_a((ITextComponent)new TextComponentString(Lang.localise("nc.block.port_toggle") + " " + TextFormatting.RED + Lang.localise("nc.block.fission_port_mode.output") + " " + TextFormatting.WHITE + Lang.localise("nc.block.port_toggle.mode")));
            }
            this.markDirtyAndNotify(true);
            return true;
        }
        return super.onUseMultitool(multitoolStack, player, world, facing, hitX, hitY, hitZ);
    }

    @Override
    public NBTTagCompound writeAll(NBTTagCompound nbt) {
        super.writeAll(nbt);
        this.writeTanks(nbt);
        this.writeFluidConnections(nbt);
        this.writeTankSettings(nbt);
        return nbt;
    }

    @Override
    public void readAll(NBTTagCompound nbt) {
        super.readAll(nbt);
        this.readTanks(nbt);
        this.readFluidConnections(nbt);
        this.readTankSettings(nbt);
    }

    @Override
    public NBTTagCompound writeTanks(NBTTagCompound nbt) {
        ITileFilteredFluid.super.writeTanks(nbt);
        for (int i = 0; i < this.filterTanks.size(); ++i) {
            this.getTanks().get(i).writeToNBT(nbt, "filterTanks" + i + this.filterTanks.size());
        }
        return nbt;
    }

    @Override
    public void readTanks(NBTTagCompound nbt) {
        ITileFilteredFluid.super.readTanks(nbt);
        for (int i = 0; i < this.filterTanks.size(); ++i) {
            this.getTanks().get(i).readFromNBT(nbt, "filterTanks" + i + this.filterTanks.size());
        }
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing side) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || ModCheck.mekanismLoaded() && NCConfig.enable_mek_gas && capability == CapabilityHelper.GAS_HANDLER_CAPABILITY) {
            return !this.getTanks().isEmpty() && this.hasFluidSideCapability(side);
        }
        return super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing side) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            if (!this.getTanks().isEmpty() && this.hasFluidSideCapability(side)) {
                return (T)this.getFluidSide(this.nonNullSide(side));
            }
            return null;
        }
        if (ModCheck.mekanismLoaded() && capability == CapabilityHelper.GAS_HANDLER_CAPABILITY) {
            if (NCConfig.enable_mek_gas && !this.getTanks().isEmpty() && this.hasFluidSideCapability(side)) {
                return (T)this.getGasWrapper();
            }
            return null;
        }
        return super.getCapability(capability, side);
    }
}

