/*
 * Decompiled with CFR 0.152.
 */
package nc.multiblock.fission.tile.port;

import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Set;
import nc.init.NCCoolantFluids;
import nc.multiblock.fission.salt.tile.TileSaltFissionHeater;
import nc.multiblock.fission.tile.port.TileFissionFluidPort;
import nc.network.multiblock.FissionHeaterPortUpdatePacket;
import nc.recipe.NCRecipes;
import nc.tile.ITileGui;
import nc.tile.internal.fluid.Tank;
import nc.util.PosHelper;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TileFissionHeaterPort
extends TileFissionFluidPort<TileFissionHeaterPort, TileSaltFissionHeater>
implements ITileGui<FissionHeaterPortUpdatePacket> {
    protected String heaterType;
    protected String coolantName;
    protected final Set<EntityPlayer> playersToUpdate = new ObjectOpenHashSet();

    public TileFissionHeaterPort() {
        super(TileFissionHeaterPort.class, 1296, null, NCRecipes.coolant_heater);
    }

    public TileFissionHeaterPort(String heaterType, String coolantName) {
        this();
        this.heaterType = heaterType;
        this.coolantName = coolantName;
        ((Tank)((Object)this.tanks.get(0))).setAllowedFluids(Lists.newArrayList((Object[])new String[]{coolantName}));
    }

    @Override
    public int getTankCapacityPerConnection() {
        return 36;
    }

    @Override
    public Object getFilterKey() {
        return this.heaterType;
    }

    @Override
    public boolean hasConfigurableFluidConnections() {
        return true;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            this.sendUpdateToListeningPlayers();
        }
    }

    @Override
    public int getGuiID() {
        return 303;
    }

    @Override
    public Set<EntityPlayer> getPlayersToUpdate() {
        return this.playersToUpdate;
    }

    @Override
    public FissionHeaterPortUpdatePacket getGuiUpdatePacket() {
        return new FissionHeaterPortUpdatePacket(this.field_174879_c, this.masterPortPos, this.getTanks(), this.getFilterTanks());
    }

    @Override
    public void onGuiPacket(FissionHeaterPortUpdatePacket message) {
        int i;
        this.masterPortPos = message.masterPortPos;
        if (PosHelper.DEFAULT_NON.equals((Object)this.masterPortPos) ^ this.masterPort == null) {
            this.refreshMasterPort();
        }
        for (i = 0; i < this.getTanks().size(); ++i) {
            this.getTanks().get(i).readInfo(message.tanksInfo.get(i));
        }
        for (i = 0; i < this.getFilterTanks().size(); ++i) {
            this.getFilterTanks().get(i).readInfo(message.filterTanksInfo.get(i));
        }
    }

    @Override
    public NBTTagCompound writeAll(NBTTagCompound nbt) {
        super.writeAll(nbt);
        if (this.heaterType != null) {
            nbt.func_74778_a("heaterName", this.heaterType);
        }
        nbt.func_74778_a("coolantName", this.coolantName);
        return nbt;
    }

    @Override
    public void readAll(NBTTagCompound nbt) {
        super.readAll(nbt);
        if (nbt.func_74764_b("heaterName")) {
            this.heaterType = nbt.func_74779_i("heaterName");
        }
        if (nbt.func_74764_b("coolantName")) {
            this.coolantName = nbt.func_74779_i("coolantName");
            ((Tank)((Object)this.tanks.get(0))).setAllowedFluids(Lists.newArrayList((Object[])new String[]{this.coolantName}));
        }
    }

    public static class Cryotheum
    extends Meta {
        public Cryotheum() {
            super(31);
        }
    }

    public static class Enderium
    extends Meta {
        public Enderium() {
            super(30);
        }
    }

    public static class LiquidHelium
    extends Meta {
        public LiquidHelium() {
            super(29);
        }
    }

    public static class LiquidNitrogen
    extends Meta {
        public LiquidNitrogen() {
            super(28);
        }
    }

    public static class Arsenic
    extends Meta {
        public Arsenic() {
            super(27);
        }
    }

    public static class Carobbiite
    extends Meta {
        public Carobbiite() {
            super(26);
        }
    }

    public static class Villiaumite
    extends Meta {
        public Villiaumite() {
            super(25);
        }
    }

    public static class Fluorite
    extends Meta {
        public Fluorite() {
            super(24);
        }
    }

    public static class Silver
    extends Meta {
        public Silver() {
            super(23);
        }
    }

    public static class Aluminum
    extends Meta {
        public Aluminum() {
            super(22);
        }
    }

    public static class Manganese
    extends Meta {
        public Manganese() {
            super(21);
        }
    }

    public static class Magnesium
    extends Meta {
        public Magnesium() {
            super(20);
        }
    }

    public static class Lithium
    extends Meta {
        public Lithium() {
            super(19);
        }
    }

    public static class Boron
    extends Meta {
        public Boron() {
            super(18);
        }
    }

    public static class Lead
    extends Meta {
        public Lead() {
            super(17);
        }
    }

    public static class Tin
    extends Meta {
        public Tin() {
            super(16);
        }
    }

    public static class Copper
    extends Meta {
        public Copper() {
            super(15);
        }
    }

    public static class Emerald
    extends Meta {
        public Emerald() {
            super(14);
        }
    }

    public static class Diamond
    extends Meta {
        public Diamond() {
            super(13);
        }
    }

    public static class Purpur
    extends Meta {
        public Purpur() {
            super(12);
        }
    }

    public static class EndStone
    extends Meta {
        public EndStone() {
            super(11);
        }
    }

    public static class Slime
    extends Meta {
        public Slime() {
            super(10);
        }
    }

    public static class Prismarine
    extends Meta {
        public Prismarine() {
            super(9);
        }
    }

    public static class Gold
    extends Meta {
        public Gold() {
            super(8);
        }
    }

    public static class Lapis
    extends Meta {
        public Lapis() {
            super(7);
        }
    }

    public static class Glowstone
    extends Meta {
        public Glowstone() {
            super(6);
        }
    }

    public static class NetherBrick
    extends Meta {
        public NetherBrick() {
            super(5);
        }
    }

    public static class Obsidian
    extends Meta {
        public Obsidian() {
            super(4);
        }
    }

    public static class Quartz
    extends Meta {
        public Quartz() {
            super(3);
        }
    }

    public static class Redstone
    extends Meta {
        public Redstone() {
            super(2);
        }
    }

    public static class Iron
    extends Meta {
        public Iron() {
            super(1);
        }
    }

    public static class Standard
    extends Meta {
        public Standard() {
            super("standard", "nak");
        }
    }

    protected static class Meta
    extends TileFissionHeaterPort {
        protected Meta(String heaterType, String coolantName) {
            super(heaterType, coolantName);
        }

        protected Meta(int coolantID) {
            super(NCCoolantFluids.COOLANTS.get(coolantID), NCCoolantFluids.COOLANTS.get(coolantID) + "_nak");
        }

        @Override
        public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
            return oldState.func_177230_c() != newState.func_177230_c() || oldState.func_177230_c().func_176201_c(oldState) != newState.func_177230_c().func_176201_c(newState);
        }
    }
}

