/*
 * Decompiled with CFR 0.152.
 */
package nc.multiblock.fission.tile.port;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import nc.block.property.BlockProperties;
import nc.multiblock.cuboidal.CuboidalPartPositionType;
import nc.multiblock.cuboidal.PartPosition;
import nc.multiblock.fission.FissionReactor;
import nc.multiblock.fission.tile.TileFissionPart;
import nc.multiblock.fission.tile.port.IFissionPort;
import nc.multiblock.fission.tile.port.IFissionPortTarget;
import nc.util.PosHelper;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;

public abstract class TileFissionPort<PORT extends TileFissionPort<PORT, TARGET>, TARGET extends IFissionPortTarget<PORT, TARGET>>
extends TileFissionPart
implements ITickable,
IFissionPort<PORT, TARGET> {
    protected final Class<PORT> portClass;
    protected BlockPos masterPortPos = PosHelper.DEFAULT_NON;
    protected PORT masterPort = null;
    protected ObjectSet<TARGET> targets = new ObjectOpenHashSet();
    public boolean refreshTargetsFlag = false;
    public EnumFacing.Axis axis = EnumFacing.Axis.Z;

    public TileFissionPort(Class<PORT> portClass) {
        super(CuboidalPartPositionType.WALL);
        this.portClass = portClass;
    }

    @Override
    public void onMachineAssembled(FissionReactor controller) {
        this.doStandardNullControllerResponse(controller);
        super.onMachineAssembled(controller);
        if (!this.func_145831_w().field_72995_K && this.getPartPosition().getFacing() != null) {
            this.func_145831_w().func_180501_a(this.func_174877_v(), this.func_145831_w().func_180495_p(this.func_174877_v()).func_177226_a(BlockProperties.AXIS_ALL, (Comparable)this.getPartPosition().getFacing().func_176740_k()), 2);
        }
    }

    @Override
    public void onMachineBroken() {
        super.onMachineBroken();
    }

    @Override
    @Nonnull
    public PartPosition getPartPosition() {
        PartPosition partPos = super.getPartPosition();
        if (partPos.getFacing() != null) {
            this.axis = partPos.getFacing().func_176740_k();
        }
        return partPos;
    }

    @Override
    public ObjectSet<TARGET> getTargets() {
        return !PosHelper.DEFAULT_NON.equals((Object)this.masterPortPos) ? ((TileFissionPort)this.masterPort).getTargets() : this.targets;
    }

    @Override
    public BlockPos getMasterPortPos() {
        return this.masterPortPos;
    }

    @Override
    public void setMasterPortPos(BlockPos pos) {
        this.masterPortPos = pos;
    }

    @Override
    public void clearMasterPort() {
        this.masterPort = null;
        this.masterPortPos = PosHelper.DEFAULT_NON;
    }

    @Override
    public void refreshMasterPort() {
        TileFissionPort<PORT, TARGET> tileFissionPort = this.masterPort = this.getMultiblock() == null ? null : (TileFissionPort)((FissionReactor)this.getMultiblock()).getPartMap(this.portClass).get(this.masterPortPos.func_177986_g());
        if (this.masterPort == null) {
            this.masterPortPos = PosHelper.DEFAULT_NON;
        }
    }

    @Override
    public void refreshTargets() {
        this.refreshTargetsFlag = false;
        if (this.isMultiblockAssembled()) {
            boolean refresh = false;
            for (IFissionPortTarget part : this.getTargets()) {
                if (!part.onPortRefresh()) continue;
                refresh = true;
            }
            if (refresh) {
                ((FissionReactor)this.getMultiblock()).refreshFlag = true;
            }
        }
    }

    @Override
    public void setRefreshTargetsFlag(boolean refreshTargetsFlag) {
        this.refreshTargetsFlag = refreshTargetsFlag;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.refreshTargetsFlag) {
            this.refreshTargets();
        }
    }

    @Override
    public void func_70296_d() {
        this.refreshTargetsFlag = true;
        super.func_70296_d();
    }

    @Override
    public NBTTagCompound writeAll(NBTTagCompound nbt) {
        super.writeAll(nbt);
        nbt.func_74778_a("axis", this.axis.func_176610_l());
        return nbt;
    }

    @Override
    public void readAll(NBTTagCompound nbt) {
        super.readAll(nbt);
        EnumFacing.Axis axis = EnumFacing.Axis.func_176717_a((String)nbt.func_74779_i("axis"));
        this.axis = axis == null ? EnumFacing.Axis.Z : axis;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing side) {
        return super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing side) {
        return super.getCapability(capability, side);
    }
}

