/*
 * Decompiled with CFR 0.152.
 */
package nc.multiblock.gui;

import java.util.ArrayList;
import java.util.List;
import nc.multiblock.gui.GuiMultiblock;
import nc.multiblock.gui.element.MultiblockButton;
import nc.multiblock.heatExchanger.HeatExchanger;
import nc.multiblock.heatExchanger.tile.IHeatExchangerController;
import nc.network.PacketHandler;
import nc.network.multiblock.ClearAllMaterialPacket;
import nc.util.Lang;
import nc.util.NCMath;
import nc.util.NCUtil;
import nc.util.StringHelper;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiHeatExchangerController
extends GuiMultiblock<HeatExchanger, IHeatExchangerController> {
    protected final ResourceLocation gui_texture = new ResourceLocation("nuclearcraft:textures/gui/container/heat_exchanger_controller.png");

    public GuiHeatExchangerController(EntityPlayer player, IHeatExchangerController controller) {
        super(player, controller);
        this.field_146999_f = 176;
        this.field_147000_g = 68;
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return this.gui_texture;
    }

    @Override
    public void renderTooltips(int mouseX, int mouseY) {
        if (NCUtil.isModifierKeyDown()) {
            this.drawTooltip(this.clearAllInfo(), mouseX, mouseY, 153, 35, 18, 18);
        }
        this.drawEfficiencyTooltip(mouseX, mouseY, 6, 57, 164, 6);
    }

    public List<String> efficiencyInfo() {
        ArrayList<String> info = new ArrayList<String>();
        info.add(TextFormatting.LIGHT_PURPLE + Lang.localise("gui.nc.container.heat_exchanger_controller.active_percent") + " " + TextFormatting.WHITE + NCMath.decimalPlaces(((HeatExchanger)this.multiblock).fractionOfTubesActive * 100.0, 1) + "%");
        info.add(TextFormatting.AQUA + Lang.localise("gui.nc.container.heat_exchanger_controller.efficiency" + (NCUtil.isModifierKeyDown() ? "_max" : "")) + " " + TextFormatting.WHITE + NCMath.decimalPlaces((NCUtil.isModifierKeyDown() ? ((HeatExchanger)this.multiblock).maxEfficiency : ((HeatExchanger)this.multiblock).efficiency) * 100.0, 1) + "%");
        return info;
    }

    public void drawEfficiencyTooltip(int mouseX, int mouseY, int x, int y, int width, int height) {
        this.drawTooltip(this.efficiencyInfo(), mouseX, mouseY, x, y, width, height);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        int fontColor = ((HeatExchanger)this.multiblock).isHeatExchangerOn ? 0x404040 : 0xEE5500;
        String title = ((HeatExchanger)this.multiblock).getInteriorLengthX() + "*" + ((HeatExchanger)this.multiblock).getInteriorLengthY() + "*" + ((HeatExchanger)this.multiblock).getInteriorLengthZ() + " " + Lang.localise("gui.nc.container.heat_exchanger_controller.heat_exchanger");
        this.field_146289_q.func_78276_b(title, this.field_146999_f / 2 - this.width(title) / 2, 6, fontColor);
        String underline = StringHelper.charLine('-', MathHelper.func_76143_f((double)((double)this.width(title) / (double)this.width("-"))));
        this.field_146289_q.func_78276_b(underline, this.field_146999_f / 2 - this.width(underline) / 2, 12, fontColor);
        String tubes = Lang.localise("gui.nc.container.heat_exchanger_controller.tubes") + " " + (((HeatExchanger)this.multiblock).getTubes().size() + ((HeatExchanger)this.multiblock).getCondenserTubes().size());
        this.field_146289_q.func_78276_b(tubes, this.field_146999_f / 2 - this.width(tubes) / 2, 24, fontColor);
        String efficiency = Lang.localise("gui.nc.container.heat_exchanger_controller.efficiency") + " " + (int)(((HeatExchanger)this.multiblock).efficiency * 100.0) + "%";
        this.field_146289_q.func_78276_b(efficiency, this.field_146999_f / 2 - this.width(efficiency) / 2, 40, fontColor);
    }

    @Override
    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        super.func_146976_a(partialTicks, mouseX, mouseY);
        int f = (int)Math.round(((HeatExchanger)this.multiblock).fractionOfTubesActive * 164.0);
        this.func_73729_b(this.field_147003_i + 6, this.field_147009_r + 56, 3, 68, f, 6);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.add(new MultiblockButton.ClearAllMaterial(0, this.field_147003_i + 153, this.field_147009_r + 35));
    }

    protected void func_146284_a(GuiButton guiButton) {
        if (((HeatExchanger)this.multiblock).WORLD.field_72995_K && guiButton.field_146127_k == 0 && NCUtil.isModifierKeyDown()) {
            PacketHandler.instance.sendToServer((IMessage)new ClearAllMaterialPacket(((IHeatExchangerController)this.tile).getTilePos()));
        }
    }
}

